/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.CompoundParseNode;
import org.apache.phoenix.parse.InListParseNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.ParseNodeRewriter;
import org.apache.phoenix.parse.SelectStatement;

public class SelectStatementRewriter
extends ParseNodeRewriter {
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    private final Set<ParseNode> removeNodes;

    public static SelectStatement removeFromWhereClause(SelectStatement statement, Set<ParseNode> removeNodes) throws SQLException {
        if (removeNodes.isEmpty()) {
            return statement;
        }
        ParseNode where = statement.getWhere();
        SelectStatementRewriter rewriter = new SelectStatementRewriter(removeNodes);
        where = where.accept(rewriter);
        return NODE_FACTORY.select(statement, where, statement.getHaving());
    }

    public static SelectStatement moveFromHavingToWhereClause(SelectStatement statement, Set<ParseNode> moveNodes) throws SQLException {
        if (moveNodes.isEmpty()) {
            return statement;
        }
        AndParseNode andNode = NODE_FACTORY.and(new ArrayList<ParseNode>(moveNodes));
        ParseNode having = statement.getHaving();
        SelectStatementRewriter rewriter = new SelectStatementRewriter(moveNodes);
        having = having.accept(rewriter);
        ParseNode where = statement.getWhere();
        where = where == null ? andNode : NODE_FACTORY.and(Arrays.asList(where, andNode));
        return NODE_FACTORY.select(statement, where, having);
    }

    private SelectStatementRewriter(Set<ParseNode> removeNodes) {
        this.removeNodes = removeNodes;
    }

    private boolean enterCompoundNode(ParseNode node) {
        return !this.removeNodes.contains(node);
    }

    private ParseNode leaveCompoundNode(CompoundParseNode node, List<ParseNode> children, CompoundNodeFactory factory) {
        int oldSize;
        int newSize = children.size();
        if (newSize == (oldSize = node.getChildren().size())) {
            return node;
        }
        if (newSize > 1) {
            return factory.createNode(children);
        }
        if (newSize == 1) {
            return children.get(0);
        }
        return null;
    }

    @Override
    public boolean visitEnter(AndParseNode node) throws SQLException {
        return this.enterCompoundNode(node);
    }

    @Override
    public ParseNode visitLeave(AndParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.and(children);
            }
        });
    }

    @Override
    public boolean visitEnter(OrParseNode node) throws SQLException {
        return this.enterCompoundNode(node);
    }

    @Override
    public ParseNode visitLeave(OrParseNode node, List<ParseNode> nodes) throws SQLException {
        return this.leaveCompoundNode(node, nodes, new CompoundNodeFactory(){

            @Override
            public ParseNode createNode(List<ParseNode> children) {
                return NODE_FACTORY.or(children);
            }
        });
    }

    @Override
    public boolean visitEnter(ComparisonParseNode node) throws SQLException {
        return !this.removeNodes.contains(node);
    }

    @Override
    public ParseNode visitLeave(ComparisonParseNode node, List<ParseNode> c) throws SQLException {
        return c.isEmpty() ? null : node;
    }

    @Override
    public boolean visitEnter(LikeParseNode node) throws SQLException {
        return !this.removeNodes.contains(node);
    }

    @Override
    public ParseNode visitLeave(LikeParseNode node, List<ParseNode> c) throws SQLException {
        return c.isEmpty() ? null : node;
    }

    @Override
    public boolean visitEnter(InListParseNode node) throws SQLException {
        return !this.removeNodes.contains(node);
    }

    @Override
    public ParseNode visitLeave(InListParseNode node, List<ParseNode> c) throws SQLException {
        return c.isEmpty() ? null : node;
    }

    private static interface CompoundNodeFactory {
        public ParseNode createNode(List<ParseNode> var1);
    }
}

