/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.util.SchemaUtil;

public class TableName {
    private final String tableName;
    private final String schemaName;

    public static TableName createNormalized(String schemaName, String tableName) {
        schemaName = schemaName == null ? null : SchemaUtil.normalizeIdentifier(schemaName);
        tableName = SchemaUtil.normalizeIdentifier(tableName);
        return new TableName(schemaName, tableName);
    }

    public static TableName create(String schemaName, String tableName) {
        return new TableName(schemaName, tableName);
    }

    private TableName(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String toString() {
        return (this.schemaName == null ? "" : this.schemaName + ".") + this.tableName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableName other = (TableName)obj;
        if (this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }
}

