/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import java.text.Format;
import java.util.List;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionArgumentType;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ToCharFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.schema.PDataType;

public class ToCharParseNode
extends FunctionParseNode {
    public ToCharParseNode(String name, List<ParseNode> children, FunctionParseNode.BuiltInFunctionInfo info) {
        super(name, children, info);
    }

    @Override
    public FunctionExpression create(List<Expression> children, StatementContext context) throws SQLException {
        FunctionArgumentType type;
        Format formatter;
        PDataType dataType = children.get(0).getDataType();
        String formatString = (String)((LiteralExpression)children.get(1)).getValue();
        if (dataType.isCoercibleTo(PDataType.TIMESTAMP)) {
            if (formatString == null) {
                formatString = context.getDateFormat();
                formatter = context.getDateFormatter();
            } else {
                formatter = FunctionArgumentType.TEMPORAL.getFormatter(formatString);
            }
            type = FunctionArgumentType.TEMPORAL;
        } else if (dataType.isCoercibleTo(PDataType.DECIMAL)) {
            if (formatString == null) {
                formatString = context.getNumberFormat();
            }
            formatter = FunctionArgumentType.NUMERIC.getFormatter(formatString);
            type = FunctionArgumentType.NUMERIC;
        } else {
            throw new SQLException((Object)((Object)dataType) + " type is unsupported for TO_CHAR().  Numeric and temporal types are supported.");
        }
        return new ToCharFunction(children, type, formatString, formatter);
    }
}

