/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.phoenix.pig.PhoenixPigConfiguration;
import org.apache.phoenix.pig.hadoop.PhoenixOutputFormat;
import org.apache.phoenix.pig.hadoop.PhoenixRecord;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;

public class PhoenixHBaseStorage
implements StoreFuncInterface {
    private PhoenixPigConfiguration config;
    private String tableName;
    private RecordWriter<NullWritable, PhoenixRecord> writer;
    private String contextSignature = null;
    private ResourceSchema schema;
    private long batchSize;
    private final PhoenixOutputFormat outputFormat = new PhoenixOutputFormat();
    private static final Options validOptions = new Options();
    private static final CommandLineParser parser = new GnuParser();
    private static final String SCHEMA = "_schema";
    private final CommandLine configuredOptions;
    private final String server;

    public PhoenixHBaseStorage(String server) throws ParseException {
        this(server, null);
    }

    public PhoenixHBaseStorage(String server, String optString) throws ParseException {
        PhoenixHBaseStorage.populateValidOptions();
        this.server = server;
        String[] optsArr = optString == null ? new String[]{} : optString.split(" ");
        try {
            this.configuredOptions = parser.parse(validOptions, optsArr);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("[-batchSize]", validOptions);
            throw e;
        }
        this.batchSize = Long.parseLong(this.configuredOptions.getOptionValue("batchSize"));
    }

    private static void populateValidOptions() {
        validOptions.addOption("batchSize", true, "Specify upsert batch size");
    }

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(this.getClass(), new String[]{this.contextSignature});
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        String prefix = "hbase://";
        if (location.startsWith(prefix)) {
            this.tableName = location.substring(prefix.length());
        }
        this.config = new PhoenixPigConfiguration(job.getConfiguration());
        this.config.configure(this.server, this.tableName, this.batchSize);
        String serializedSchema = this.getUDFProperties().getProperty(this.contextSignature + SCHEMA);
        if (serializedSchema != null) {
            this.schema = (ResourceSchema)ObjectSerializer.deserialize((String)serializedSchema);
        }
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
    }

    public void putNext(Tuple t) throws IOException {
        ResourceSchema.ResourceFieldSchema[] fieldSchemas = this.schema == null ? null : this.schema.getFields();
        PhoenixRecord record = new PhoenixRecord(fieldSchemas);
        for (int i = 0; i < t.size(); ++i) {
            record.add(t.get(i));
        }
        try {
            this.writer.write(null, record);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public OutputFormat getOutputFormat() throws IOException {
        return this.outputFormat;
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        this.schema = s;
        this.getUDFProperties().setProperty(this.contextSignature + SCHEMA, ObjectSerializer.serialize((Serializable)this.schema));
    }
}

