/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.QueryUtil;

public class PhoenixPigConfiguration {
    private static final Log LOG = LogFactory.getLog(PhoenixPigConfiguration.class);
    public static final String MAP_SPECULATIVE_EXEC = "mapred.map.tasks.speculative.execution";
    public static final String REDUCE_SPECULATIVE_EXEC = "mapred.reduce.tasks.speculative.execution";
    public static final String SERVER_NAME = "phoenix.hbase.server.name";
    public static final String TABLE_NAME = "phoenix.hbase.table.name";
    public static final String UPSERT_STATEMENT = "phoenix.upsert.stmt";
    public static final String UPSERT_BATCH_SIZE = "phoenix.upsert.batch.size";
    public static final long DEFAULT_UPSERT_BATCH_SIZE = 1000L;
    private final Configuration conf;
    private Connection conn;
    private List<ColumnInfo> columnMetadataList;

    public PhoenixPigConfiguration(Configuration conf) {
        this.conf = conf;
    }

    public void configure(String server, String tableName, long batchSize) {
        this.conf.set(SERVER_NAME, server);
        this.conf.set(TABLE_NAME, tableName);
        this.conf.setLong(UPSERT_BATCH_SIZE, batchSize);
        this.conf.setBoolean(MAP_SPECULATIVE_EXEC, false);
        this.conf.setBoolean(REDUCE_SPECULATIVE_EXEC, false);
    }

    public Connection getConnection() throws SQLException {
        Properties props = new Properties();
        this.conn = DriverManager.getConnection(QueryUtil.getUrl(this.conf.get(SERVER_NAME)), props).unwrap(PhoenixConnection.class);
        this.conn.setAutoCommit(false);
        this.setup(this.conn);
        return this.conn;
    }

    public void setup(Connection conn) throws SQLException {
        long batchSize = this.getBatchSize() <= 0L ? (long)((PhoenixConnection)conn).getMutateBatchSize() : this.getBatchSize();
        this.conf.setLong(UPSERT_BATCH_SIZE, batchSize);
        if (this.columnMetadataList == null) {
            this.columnMetadataList = new ArrayList<ColumnInfo>();
            String[] tableMetadata = this.getTableMetadata(this.getTableName());
            ResultSet rs = conn.getMetaData().getColumns(null, tableMetadata[0], tableMetadata[1], null);
            while (rs.next()) {
                this.columnMetadataList.add(new ColumnInfo(rs.getString(4), rs.getInt(5)));
            }
        }
        String upsertStmt = QueryUtil.constructGenericUpsertStatement(this.getTableName(), this.columnMetadataList.size());
        LOG.info("Phoenix Upsert Statement: " + upsertStmt);
        this.conf.set(UPSERT_STATEMENT, upsertStmt);
    }

    public String getUpsertStatement() {
        return this.conf.get(UPSERT_STATEMENT);
    }

    public long getBatchSize() {
        return this.conf.getLong(UPSERT_BATCH_SIZE, 1000L);
    }

    public String getServer() {
        return this.conf.get(SERVER_NAME);
    }

    public List<ColumnInfo> getColumnMetadataList() {
        return this.columnMetadataList;
    }

    public String getTableName() {
        return this.conf.get(TABLE_NAME);
    }

    private String[] getTableMetadata(String table) {
        String[] schemaAndTable = table.split("\\.");
        assert (schemaAndTable.length >= 1);
        if (schemaAndTable.length == 1) {
            return new String[]{"", schemaAndTable[0]};
        }
        return new String[]{schemaAndTable[0], schemaAndTable[1]};
    }

    public Configuration getConfiguration() {
        return this.conf;
    }
}

