/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig;

import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.phoenix.schema.PDataType;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.joda.time.DateTime;

public class TypeUtil {
    private static final Utf8StorageConverter utf8Converter = new Utf8StorageConverter();

    public static PDataType getType(Object obj, byte type) {
        PDataType sqlType;
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 50: {
                sqlType = PDataType.VARBINARY;
                break;
            }
            case 55: {
                sqlType = PDataType.VARCHAR;
                break;
            }
            case 25: {
                sqlType = PDataType.DOUBLE;
                break;
            }
            case 20: {
                sqlType = PDataType.FLOAT;
                break;
            }
            case 10: {
                sqlType = PDataType.INTEGER;
                break;
            }
            case 15: {
                sqlType = PDataType.LONG;
                break;
            }
            case 5: {
                sqlType = PDataType.BOOLEAN;
                break;
            }
            case 30: {
                sqlType = PDataType.DATE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown type " + obj.getClass().getName() + " passed to PhoenixHBaseStorage");
            }
        }
        return sqlType;
    }

    public static Object castPigTypeToPhoenix(Object o, byte objectType, PDataType targetPhoenixType) {
        PDataType inferredPType = TypeUtil.getType(o, objectType);
        if (inferredPType == null) {
            return null;
        }
        if (inferredPType == PDataType.VARBINARY && targetPhoenixType != PDataType.VARBINARY) {
            try {
                o = TypeUtil.castBytes(o, targetPhoenixType);
                inferredPType = TypeUtil.getType(o, DataType.findType((Object)o));
            }
            catch (IOException e) {
                throw new RuntimeException("Error while casting bytes for object " + o);
            }
        }
        if (inferredPType == PDataType.DATE) {
            int inferredSqlType = targetPhoenixType.getSqlType();
            if (inferredSqlType == 91) {
                return new Date(((DateTime)o).getMillis());
            }
            if (inferredSqlType == 92) {
                return new Time(((DateTime)o).getMillis());
            }
            if (inferredSqlType == 93) {
                return new Timestamp(((DateTime)o).getMillis());
            }
        }
        if (targetPhoenixType == inferredPType || inferredPType.isCoercibleTo(targetPhoenixType)) {
            return inferredPType.toObject(o, targetPhoenixType);
        }
        throw new RuntimeException(o.getClass().getName() + " cannot be coerced to " + targetPhoenixType.toString());
    }

    public static Object castBytes(Object o, PDataType targetPhoenixType) throws IOException {
        byte[] bytes = ((DataByteArray)o).get();
        switch (targetPhoenixType) {
            case CHAR: 
            case VARCHAR: {
                return utf8Converter.bytesToCharArray(bytes);
            }
            case UNSIGNED_SMALLINT: 
            case SMALLINT: {
                return utf8Converter.bytesToInteger(bytes).shortValue();
            }
            case UNSIGNED_TINYINT: 
            case TINYINT: {
                return utf8Converter.bytesToInteger(bytes).byteValue();
            }
            case UNSIGNED_INT: 
            case INTEGER: {
                return utf8Converter.bytesToInteger(bytes);
            }
            case BOOLEAN: {
                return utf8Converter.bytesToBoolean(bytes);
            }
            case DECIMAL: {
                return utf8Converter.bytesToBigDecimal(bytes);
            }
            case FLOAT: 
            case UNSIGNED_FLOAT: {
                return utf8Converter.bytesToFloat(bytes);
            }
            case DOUBLE: 
            case UNSIGNED_DOUBLE: {
                return utf8Converter.bytesToDouble(bytes);
            }
            case UNSIGNED_LONG: 
            case LONG: {
                return utf8Converter.bytesToLong(bytes);
            }
            case TIME: 
            case TIMESTAMP: 
            case DATE: 
            case UNSIGNED_TIME: 
            case UNSIGNED_TIMESTAMP: 
            case UNSIGNED_DATE: {
                return utf8Converter.bytesToDateTime(bytes);
            }
        }
        return o;
    }
}

