/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.hadoop;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.phoenix.pig.hadoop.PhoenixOutputFormat;

public class PhoenixOutputCommitter
extends OutputCommitter {
    private final Log LOG = LogFactory.getLog(PhoenixOutputCommitter.class);
    private final PhoenixOutputFormat outputFormat;

    public PhoenixOutputCommitter(PhoenixOutputFormat outputFormat) {
        if (outputFormat == null) {
            throw new IllegalArgumentException("PhoenixOutputFormat must not be null.");
        }
        this.outputFormat = outputFormat;
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        this.commit(this.outputFormat.getConnection(context.getConfiguration()));
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return true;
    }

    @Override
    public void setupJob(JobContext jobContext) throws IOException {
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
    }

    private void commit(Connection connection) throws IOException {
        try {
            if (connection == null || connection.isClosed()) {
                throw new IOException("Trying to commit a connection that is null or closed: " + connection);
            }
        }
        catch (SQLException e) {
            throw new IOException("Exception calling isClosed on connection", e);
        }
        try {
            this.LOG.debug("Commit called on task completion");
            connection.commit();
        }
        catch (SQLException e) {
            throw new IOException("Exception while trying to commit a connection. ", e);
        }
        finally {
            try {
                this.LOG.debug("Closing connection to database on task completion");
                connection.close();
            }
            catch (SQLException e) {
                this.LOG.warn("Exception while trying to close database connection", e);
            }
        }
    }
}

