/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.hadoop;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.phoenix.pig.PhoenixPigConfiguration;
import org.apache.phoenix.pig.hadoop.PhoenixOutputCommitter;
import org.apache.phoenix.pig.hadoop.PhoenixRecord;
import org.apache.phoenix.pig.hadoop.PhoenixRecordWriter;

public class PhoenixOutputFormat
extends OutputFormat<NullWritable, PhoenixRecord> {
    private static final Log LOG = LogFactory.getLog(PhoenixOutputFormat.class);
    private Connection connection;
    private PhoenixPigConfiguration config;

    @Override
    public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
    }

    @Override
    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new PhoenixOutputCommitter(this);
    }

    @Override
    public RecordWriter<NullWritable, PhoenixRecord> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        try {
            return new PhoenixRecordWriter(this.getConnection(context.getConfiguration()), this.config);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    synchronized Connection getConnection(Configuration configuration) throws IOException {
        if (this.connection != null) {
            return this.connection;
        }
        this.config = new PhoenixPigConfiguration(configuration);
        try {
            LOG.info("Initializing new Phoenix connection...");
            this.connection = this.config.getConnection();
            LOG.info("Initialized Phoenix connection, autoCommit=" + this.connection.getAutoCommit());
            return this.connection;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

