/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.phoenix.pig.TypeUtil;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataType;

public class PhoenixRecord
implements Writable {
    private final List<Object> values = new ArrayList<Object>();
    private final ResourceSchema.ResourceFieldSchema[] fieldSchemas;

    public PhoenixRecord(ResourceSchema.ResourceFieldSchema[] fieldSchemas) {
        this.fieldSchemas = fieldSchemas;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    public void write(PreparedStatement statement, List<ColumnInfo> columnMetadataList) throws SQLException {
        for (int i = 0; i < columnMetadataList.size(); ++i) {
            byte type;
            Object o = this.values.get(i);
            Object upsertValue = this.convertTypeSpecificValue(o, type = this.fieldSchemas == null ? DataType.findType((Object)o) : this.fieldSchemas[i].getType(), columnMetadataList.get(i).getSqlType());
            if (upsertValue != null) {
                statement.setObject(i + 1, upsertValue, columnMetadataList.get(i).getSqlType());
                continue;
            }
            statement.setNull(i + 1, columnMetadataList.get(i).getSqlType());
        }
        statement.execute();
    }

    public void add(Object value) {
        this.values.add(value);
    }

    private Object convertTypeSpecificValue(Object o, byte type, Integer sqlType) {
        PDataType pDataType = PDataType.fromTypeId(sqlType);
        return TypeUtil.castPigTypeToPhoenix(o, type, pDataType);
    }
}

