/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pig.hadoop;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.phoenix.pig.PhoenixPigConfiguration;
import org.apache.phoenix.pig.hadoop.PhoenixRecord;

public class PhoenixRecordWriter
extends RecordWriter<NullWritable, PhoenixRecord> {
    private static final Log LOG = LogFactory.getLog(PhoenixRecordWriter.class);
    private long numRecords = 0L;
    private final Connection conn;
    private final PreparedStatement statement;
    private final PhoenixPigConfiguration config;
    private final long batchSize;

    public PhoenixRecordWriter(Connection conn, PhoenixPigConfiguration config) throws SQLException {
        this.conn = conn;
        this.config = config;
        this.batchSize = config.getBatchSize();
        this.statement = this.conn.prepareStatement(config.getUpsertStatement());
    }

    @Override
    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
    }

    @Override
    public void write(NullWritable n, PhoenixRecord record) throws IOException, InterruptedException {
        try {
            record.write(this.statement, this.config.getColumnMetadataList());
            ++this.numRecords;
            if (this.numRecords % this.batchSize == 0L) {
                LOG.debug("commit called on a batch of size : " + this.batchSize);
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw new IOException("Exception while committing to database.", e);
        }
    }
}

