/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.protobuf.HBaseZeroCopyByteString;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.coprocessor.ScanRegionObserver;
import org.apache.phoenix.coprocessor.SequenceRegionObserver;
import org.apache.phoenix.coprocessor.ServerCachingEndpointImpl;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.PhoenixIndexBuilder;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.ChildQueryServices;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.StatsManager;
import org.apache.phoenix.query.StatsManagerImpl;
import org.apache.phoenix.schema.EmptySequenceCacheException;
import org.apache.phoenix.schema.MetaDataSplitPolicy;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ConfigUtil;
import org.apache.phoenix.util.JDBCUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionQueryServicesImpl
extends DelegateQueryServices
implements ConnectionQueryServices {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionQueryServicesImpl.class);
    private static final int INITIAL_CHILD_SERVICES_CAPACITY = 100;
    private static final int DEFAULT_OUT_OF_ORDER_MUTATIONS_WAIT_TIME_MS = 1000;
    private static final String OLD_DEFAULT_COLUMN_FAMILY = "_0";
    private static final byte[] OLD_DEFAULT_COLUMN_FAMILY_BYTES = Bytes.toBytes("_0");
    private static final String OLD_SYSTEM_SCHEMA_NAME = "SYSTEM";
    private static final String OLD_SYSTEM_TABLE_NAME = "TABLE";
    private static final byte[] OLD_SYSTEM_TABLE_NAME_BYTES = SchemaUtil.getTableNameAsBytes("SYSTEM", "TABLE");
    private static final String OLD_SYSTEM_TABLE_AS_VIEW_NAME = SchemaUtil.getTableName("META", "\"TABLE\"");
    public static final String UPGRADE_TO_3_0 = "UpgradeTo30";
    public static final String UPGRADE_TO_2_2 = "UpgradeTo22";
    protected final Configuration config;
    private final ReadOnlyProps props;
    private final ConcurrentHashMap<ImmutableBytesWritable, ConnectionQueryServices> childServices;
    private final StatsManager statsManager;
    private volatile PMetaData latestMetaData;
    private final Object latestMetaDataLock = new Object();
    private int lowestClusterHBaseVersion = Integer.MAX_VALUE;
    private boolean hasInvalidIndexConfiguration = false;
    private int connectionCount = 0;
    private WhiteList upgradeWhiteList = null;
    private HConnection connection;
    private volatile boolean initialized;
    private volatile boolean closed;
    private volatile SQLException initializationException;
    private ConcurrentMap<SequenceKey, Sequence> sequenceMap = Maps.newConcurrentMap();
    private KeyValueBuilder kvBuilder;
    private static final String OLD_PACKAGE = "com.salesforce.";
    private static final String NEW_PACKAGE = "org.apache.";
    private static final String OLD_INDEXER_CLASS_NAME = "com.salesforce.hbase.index.Indexer";
    private static final String TRUE_BYTES_AS_STRING = Bytes.toString(PDataType.TRUE_BYTES);
    private static final Integer DEFAULT_PRECISION = 38;
    private static final Integer DEFAULT_SCALE = 0;

    private PMetaData newEmptyMetaData() {
        long maxSizeBytes = this.props.getLong("phoenix.client.maxMetaDataCacheSize", 0xA00000L);
        return new PMetaDataImpl(100, maxSizeBytes);
    }

    public ConnectionQueryServicesImpl(QueryServices services, PhoenixEmbeddedDriver.ConnectionInfo connectionInfo) {
        super(services);
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        for (Map.Entry<String, String> entry : services.getProps()) {
            config.set(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : connectionInfo.asProps()) {
            config.set(entry.getKey(), entry.getValue());
        }
        this.config = HBaseConfiguration.create(config);
        ConfigUtil.setReplicationConfigIfAbsent(this.config);
        this.props = new ReadOnlyProps(this.config.iterator());
        this.latestMetaData = this.newEmptyMetaData();
        this.childServices = new ConcurrentHashMap(100);
        int statsUpdateFrequencyMs = this.getProps().getInt("phoenix.query.statsUpdateFrequency", 900000);
        int maxStatsAgeMs = this.getProps().getInt("phoenix.query.maxStatsAge", 86400000);
        this.statsManager = new StatsManagerImpl(this, statsUpdateFrequencyMs, maxStatsAgeMs);
        String hbaseVersion = VersionInfo.getVersion();
        this.kvBuilder = KeyValueBuilder.get(hbaseVersion);
    }

    private void openConnection() throws SQLException {
        try {
            this.connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(this.config);
        }
        catch (IOException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).setRootCause(e).build().buildException();
        }
        if (this.connection.isClosed()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION).build().buildException();
        }
    }

    @Override
    public StatsManager getStatsManager() {
        return this.statsManager;
    }

    @Override
    public HTableInterface getTable(byte[] tableName) throws SQLException {
        try {
            return HBaseFactoryProvider.getHTableFactory().getTable(tableName, this.connection, this.getExecutor());
        }
        catch (org.apache.hadoop.hbase.TableNotFoundException e) {
            byte[][] schemaAndTableName = new byte[2][];
            SchemaUtil.getVarChars(tableName, schemaAndTableName);
            throw new TableNotFoundException(Bytes.toString(schemaAndTableName[0]), Bytes.toString(schemaAndTableName[1]));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public HTableDescriptor getTableDescriptor(byte[] tableName) throws SQLException {
        HTableInterface htable = this.getTable(tableName);
        try {
            HTableDescriptor hTableDescriptor = htable.getTableDescriptor();
            return hTableDescriptor;
        }
        catch (IOException e) {
            if (e instanceof org.apache.hadoop.hbase.TableNotFoundException || e.getCause() instanceof org.apache.hadoop.hbase.TableNotFoundException) {
                byte[][] schemaAndTableName = new byte[2][];
                SchemaUtil.getVarChars(tableName, schemaAndTableName);
                throw new TableNotFoundException(Bytes.toString(schemaAndTableName[0]), Bytes.toString(schemaAndTableName[1]));
            }
            throw new RuntimeException(e);
        }
        finally {
            Closeables.closeQuietly(htable);
        }
    }

    @Override
    public ReadOnlyProps getProps() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        ConnectionQueryServicesImpl connectionQueryServicesImpl = this;
        synchronized (connectionQueryServicesImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            SQLException sqlE = null;
            try {
                if (this.connection == null) return;
                this.returnAllSequences(this.sequenceMap);
            }
            catch (SQLException e) {
                sqlE = e;
            }
            finally {
                try {
                    this.statsManager.clearStats();
                }
                catch (SQLException e) {
                    if (sqlE == null) {
                        sqlE = e;
                    }
                    sqlE.setNextException(e);
                }
                finally {
                    try {
                        this.childServices.clear();
                        this.latestMetaData = null;
                        if (this.connection != null) {
                            this.connection.close();
                        }
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    finally {
                        try {
                            super.close();
                        }
                        catch (SQLException e) {
                            if (sqlE == null) {
                                sqlE = e;
                            }
                            sqlE.setNextException(e);
                        }
                        finally {
                            if (sqlE == null) return;
                            throw sqlE;
                        }
                    }
                }
            }
            return;
        }
    }

    protected ConnectionQueryServices newChildQueryService() {
        return new ChildQueryServices(this);
    }

    @Override
    public ConnectionQueryServices getChildQueryServices(ImmutableBytesWritable tenantId) {
        ConnectionQueryServices childQueryService = this.childServices.get(tenantId);
        if (childQueryService == null) {
            childQueryService = this.newChildQueryService();
            ConnectionQueryServices prevQueryService = this.childServices.putIfAbsent(tenantId, childQueryService);
            return prevQueryService == null ? childQueryService : prevQueryService;
        }
        return childQueryService;
    }

    @Override
    public void clearTableRegionCache(byte[] tableName) throws SQLException {
        this.connection.clearRegionCache(TableName.valueOf(tableName));
    }

    @Override
    public List<HRegionLocation> getAllTableRegions(byte[] tableName) throws SQLException {
        int retryCount = 0;
        int maxRetryCount = 1;
        boolean reload = false;
        while (true) {
            try {
                HRegionLocation regionLocation;
                ArrayList<HRegionLocation> locations = Lists.newArrayList();
                byte[] currentKey = HConstants.EMPTY_START_ROW;
                do {
                    regionLocation = this.connection.getRegionLocation(TableName.valueOf(tableName), currentKey, reload);
                    locations.add(regionLocation);
                } while (!Bytes.equals(currentKey = regionLocation.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW));
                return locations;
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                String fullName = Bytes.toString(tableName);
                throw new TableNotFoundException(SchemaUtil.getSchemaNameFromFullName(fullName), SchemaUtil.getTableNameFromFullName(fullName));
            }
            catch (IOException e) {
                if (retryCount++ < maxRetryCount) {
                    reload = true;
                    continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.GET_TABLE_REGIONS_FAIL).setRootCause(e).build().buildException();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PMetaData addTable(PTable table) throws SQLException {
        try {
            PTable existingTable = this.latestMetaData.getTable(new PTableKey(table.getTenantId(), table.getName().getString()));
            if (existingTable.getTimeStamp() >= table.getTimeStamp()) {
                return this.latestMetaData;
            }
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.latestMetaData = this.latestMetaData.addTable(table);
            this.latestMetaDataLock.notifyAll();
            return this.latestMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PMetaData metaDataMutated(PName tenantId, String tableName, long tableSeqNum, Mutator mutator) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            PMetaData metaData = this.latestMetaData;
            long endTime = System.currentTimeMillis() + 1000L;
            try {
                while (true) {
                    long waitTime;
                    block11: {
                        try {
                            PTable table = metaData.getTable(new PTableKey(tenantId, tableName));
                            if (table.getSequenceNumber() + 1L == tableSeqNum) {
                                metaData = mutator.mutate(metaData);
                                break;
                            }
                            if (table.getSequenceNumber() < tableSeqNum) break block11;
                            logger.warn("Attempt to cache older version of " + tableName + ": current= " + table.getSequenceNumber() + ", new=" + tableSeqNum);
                            break;
                        }
                        catch (TableNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if ((waitTime = endTime - System.currentTimeMillis()) <= 0L) {
                        logger.warn("Unable to update meta data repo within 1 seconds for " + tableName);
                        metaData = metaData.removeTable(tenantId, tableName);
                        break;
                    }
                    this.latestMetaDataLock.wait(waitTime);
                }
            }
            catch (InterruptedException e) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            this.latestMetaData = metaData;
            this.latestMetaDataLock.notifyAll();
            return metaData;
        }
    }

    @Override
    public PMetaData addColumn(final PName tenantId, final String tableName, final List<PColumn> columns, final long tableTimeStamp, final long tableSeqNum, final boolean isImmutableRows) throws SQLException {
        return this.metaDataMutated(tenantId, tableName, tableSeqNum, new Mutator(){

            @Override
            public PMetaData mutate(PMetaData metaData) throws SQLException {
                try {
                    return metaData.addColumn(tenantId, tableName, columns, tableTimeStamp, tableSeqNum, isImmutableRows);
                }
                catch (TableNotFoundException e) {
                    return metaData;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PMetaData removeTable(PName tenantId, String tableName) throws SQLException {
        Object object = this.latestMetaDataLock;
        synchronized (object) {
            this.latestMetaData = this.latestMetaData.removeTable(tenantId, tableName);
            this.latestMetaDataLock.notifyAll();
            return this.latestMetaData;
        }
    }

    @Override
    public PMetaData removeColumn(final PName tenantId, final String tableName, final String familyName, final String columnName, final long tableTimeStamp, final long tableSeqNum) throws SQLException {
        return this.metaDataMutated(tenantId, tableName, tableSeqNum, new Mutator(){

            @Override
            public PMetaData mutate(PMetaData metaData) throws SQLException {
                try {
                    return metaData.removeColumn(tenantId, tableName, familyName, columnName, tableTimeStamp, tableSeqNum);
                }
                catch (TableNotFoundException e) {
                    return metaData;
                }
            }
        });
    }

    @Override
    public PhoenixConnection connect(String url, Properties info) throws SQLException {
        return new PhoenixConnection(this, url, info, this.latestMetaData);
    }

    private HColumnDescriptor generateColumnFamilyDescriptor(Pair<byte[], Map<String, Object>> family, PTableType tableType) throws SQLException {
        HColumnDescriptor columnDesc = new HColumnDescriptor(family.getFirst());
        if (tableType != PTableType.VIEW) {
            columnDesc.setKeepDeletedCells(true);
            columnDesc.setDataBlockEncoding(SchemaUtil.DEFAULT_DATA_BLOCK_ENCODING);
            for (Map.Entry<String, Object> entry : family.getSecond().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                columnDesc.setValue(key, value == null ? null : value.toString());
            }
        }
        return columnDesc;
    }

    private void modifyColumnFamilyDescriptor(HColumnDescriptor hcd, Pair<byte[], Map<String, Object>> family) throws SQLException {
        for (Map.Entry<String, Object> entry : family.getSecond().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            hcd.setValue(key, value == null ? null : value.toString());
        }
    }

    private HTableDescriptor generateTableDescriptor(byte[] tableName, HTableDescriptor existingDesc, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits) throws SQLException {
        String defaultFamilyName = (String)tableProps.remove("DEFAULT_COLUMN_FAMILY");
        HTableDescriptor descriptor = existingDesc != null ? new HTableDescriptor(existingDesc) : new HTableDescriptor(TableName.valueOf(tableName));
        for (Map.Entry<String, Object> entry : tableProps.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            descriptor.setValue(key, value == null ? null : value.toString());
        }
        if (families.isEmpty()) {
            if (tableType != PTableType.VIEW) {
                byte[] defaultFamilyByes = defaultFamilyName == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : Bytes.toBytes(defaultFamilyName);
                HColumnDescriptor hColumnDescriptor = this.generateColumnFamilyDescriptor(new Pair<byte[], Map<String, Object>>(defaultFamilyByes, Collections.emptyMap()), tableType);
                descriptor.addFamily(hColumnDescriptor);
            }
        } else {
            for (Pair pair : families) {
                byte[] familyByte = (byte[])pair.getFirst();
                if (descriptor.getFamily(familyByte) == null) {
                    if (tableType == PTableType.VIEW) {
                        String fullTableName = Bytes.toString(tableName);
                        throw new ReadOnlyTableException("The HBase column families for a read-only table must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName), Bytes.toString(familyByte));
                    }
                    HColumnDescriptor columnDescriptor = this.generateColumnFamilyDescriptor(pair, tableType);
                    descriptor.addFamily(columnDescriptor);
                    continue;
                }
                if (tableType == PTableType.VIEW) continue;
                this.modifyColumnFamilyDescriptor(descriptor.getFamily(familyByte), pair);
            }
        }
        this.addCoprocessors(tableName, descriptor, tableType);
        return descriptor;
    }

    private void addCoprocessors(byte[] tableName, HTableDescriptor descriptor, PTableType tableType) throws SQLException {
        try {
            boolean isOldSysTable;
            boolean bl = isOldSysTable = Bytes.compareTo(OLD_SYSTEM_TABLE_NAME_BYTES, tableName) == 0;
            if (!descriptor.hasCoprocessor(ScanRegionObserver.class.getName())) {
                if (!isOldSysTable) {
                    descriptor.removeCoprocessor(ScanRegionObserver.class.getName().replace(NEW_PACKAGE, OLD_PACKAGE));
                }
                descriptor.addCoprocessor(ScanRegionObserver.class.getName(), null, 1, null);
            }
            if (!descriptor.hasCoprocessor(UngroupedAggregateRegionObserver.class.getName())) {
                if (!isOldSysTable) {
                    descriptor.removeCoprocessor(UngroupedAggregateRegionObserver.class.getName().replace(NEW_PACKAGE, OLD_PACKAGE));
                }
                descriptor.addCoprocessor(UngroupedAggregateRegionObserver.class.getName(), null, 1, null);
            }
            if (!descriptor.hasCoprocessor(GroupedAggregateRegionObserver.class.getName())) {
                if (!isOldSysTable) {
                    descriptor.removeCoprocessor(GroupedAggregateRegionObserver.class.getName().replace(NEW_PACKAGE, OLD_PACKAGE));
                }
                descriptor.addCoprocessor(GroupedAggregateRegionObserver.class.getName(), null, 1, null);
            }
            if (!descriptor.hasCoprocessor(ServerCachingEndpointImpl.class.getName())) {
                if (!isOldSysTable) {
                    descriptor.removeCoprocessor(ServerCachingEndpointImpl.class.getName().replace(NEW_PACKAGE, OLD_PACKAGE));
                }
                descriptor.addCoprocessor(ServerCachingEndpointImpl.class.getName(), null, 1, null);
            }
            descriptor.removeCoprocessor("com.salesforce.phoenix.join.HashJoiningRegionObserver");
            if (!(tableType != PTableType.INDEX && tableType != PTableType.VIEW || isOldSysTable)) {
                descriptor.removeCoprocessor(Indexer.class.getName());
                descriptor.removeCoprocessor(OLD_INDEXER_CLASS_NAME);
            }
            if (tableType != PTableType.INDEX && tableType != PTableType.VIEW && !SchemaUtil.isMetaTable(tableName) && !descriptor.hasCoprocessor(Indexer.class.getName())) {
                if (!isOldSysTable) {
                    descriptor.removeCoprocessor(OLD_INDEXER_CLASS_NAME);
                }
                HashMap<String, String> opts = Maps.newHashMapWithExpectedSize(1);
                opts.put("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
                Indexer.enableIndexing(descriptor, PhoenixIndexBuilder.class, opts);
            }
            if (SchemaUtil.isMetaTable(tableName)) {
                descriptor.setValue(UPGRADE_TO_3_0, Boolean.TRUE.toString());
                if (!descriptor.hasCoprocessor(MetaDataEndpointImpl.class.getName())) {
                    descriptor.removeCoprocessor(MetaDataEndpointImpl.class.getName().replace(NEW_PACKAGE, OLD_PACKAGE));
                    descriptor.addCoprocessor(MetaDataEndpointImpl.class.getName(), null, 1, null);
                }
                if (!descriptor.hasCoprocessor(MetaDataRegionObserver.class.getName())) {
                    descriptor.removeCoprocessor(MetaDataRegionObserver.class.getName().replace(NEW_PACKAGE, OLD_PACKAGE));
                    descriptor.addCoprocessor(MetaDataRegionObserver.class.getName(), null, 2, null);
                }
            } else if (SchemaUtil.isSequenceTable(tableName) && !descriptor.hasCoprocessor(SequenceRegionObserver.class.getName())) {
                descriptor.addCoprocessor(SequenceRegionObserver.class.getName(), null, 1, null);
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ensureFamilyCreated(byte[] tableName, PTableType tableType, Pair<byte[], Map<String, Object>> family) throws SQLException {
        HBaseAdmin admin = null;
        SQLException sqlE = null;
        try {
            HColumnDescriptor columnDescriptor;
            HColumnDescriptor oldDescriptor;
            admin = new HBaseAdmin(this.config);
            try {
                HTableDescriptor existingDesc = admin.getTableDescriptor(tableName);
                oldDescriptor = existingDesc.getFamily(family.getFirst());
                columnDescriptor = null;
                if (oldDescriptor == null) {
                    if (tableType == PTableType.VIEW) {
                        String fullTableName = Bytes.toString(tableName);
                        throw new ReadOnlyTableException("The HBase column families for a VIEW must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName), Bytes.toString(family.getFirst()));
                    }
                    columnDescriptor = this.generateColumnFamilyDescriptor(family, tableType);
                } else {
                    columnDescriptor = new HColumnDescriptor(oldDescriptor);
                    if (tableType == PTableType.VIEW) {
                        return;
                    }
                    this.modifyColumnFamilyDescriptor(columnDescriptor, family);
                }
                if (columnDescriptor.equals(oldDescriptor)) {
                    return;
                }
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.TABLE_UNDEFINED).setRootCause(e).build().buildException();
                return;
            }
            {
                admin.disableTable(tableName);
                if (oldDescriptor == null) {
                    admin.addColumn(tableName, columnDescriptor);
                } else {
                    admin.modifyColumn(tableName, columnDescriptor);
                }
                admin.enableTable(tableName);
                return;
            }
        }
        catch (IOException e) {
            sqlE = ServerUtil.parseServerException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (IOException e) {
                if (sqlE == null) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                sqlE.setNextException(ServerUtil.parseServerException(e));
            }
            finally {
                if (sqlE == null) return;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HTableDescriptor ensureTableCreated(byte[] tableName, PTableType tableType, Map<String, Object> props, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, boolean modifyExistingMetaData) throws SQLException {
        HBaseAdmin admin = null;
        SQLException sqlE = null;
        HTableDescriptor existingDesc = null;
        boolean isMetaTable = SchemaUtil.isMetaTable(tableName);
        boolean tableExist = true;
        try {
            block50: {
                logger.info("Found quorum: " + ZKConfig.getZKQuorumServersString(this.config));
                admin = new HBaseAdmin(this.config);
                try {
                    existingDesc = admin.getTableDescriptor(tableName);
                }
                catch (org.apache.hadoop.hbase.TableNotFoundException e) {
                    tableExist = false;
                    if (tableType != PTableType.VIEW) break block50;
                    String fullTableName = Bytes.toString(tableName);
                    throw new ReadOnlyTableException("An HBase table for a VIEW must already exist", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName));
                }
            }
            HTableDescriptor newDesc = this.generateTableDescriptor(tableName, existingDesc, tableType, props, families, splits);
            if (!tableExist) {
                if (isMetaTable) {
                    newDesc.remove("SPLIT_POLICY");
                }
                try {
                    if (splits == null) {
                        admin.createTable(newDesc);
                    } else {
                        admin.createTable(newDesc, splits);
                    }
                }
                catch (TableExistsException e) {
                    HTableDescriptor hTableDescriptor = null;
                    try {
                        if (admin == null) return hTableDescriptor;
                        admin.close();
                        return hTableDescriptor;
                    }
                    catch (IOException e2) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e2);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e2));
                    }
                    finally {
                        if (sqlE == null) return hTableDescriptor;
                        throw sqlE;
                    }
                }
                if (isMetaTable) {
                    this.checkClientServerCompatibility();
                    newDesc.setValue("SPLIT_POLICY", MetaDataSplitPolicy.class.getName());
                    admin.disableTable(tableName);
                    admin.modifyTable(tableName, newDesc);
                    admin.enableTable(tableName);
                    this.upgradeWhiteList = this.upgradeCoprocessorsTo3_0(admin, false);
                }
                HTableDescriptor hTableDescriptor = null;
                return hTableDescriptor;
            }
            if (!modifyExistingMetaData || existingDesc.equals(newDesc)) {
                if (isMetaTable) {
                    this.checkClientServerCompatibility();
                }
                HTableDescriptor hTableDescriptor = existingDesc;
                return hTableDescriptor;
            }
            if (isMetaTable) {
                this.checkClientServerCompatibility();
                if (!Boolean.TRUE.toString().equals(existingDesc.getValue(UPGRADE_TO_3_0))) {
                    this.upgradeWhiteList = this.upgradeCoprocessorsTo3_0(admin, true);
                }
            }
            admin.disableTable(tableName);
            admin.modifyTable(tableName, newDesc);
            admin.enableTable(tableName);
            HTableDescriptor hTableDescriptor = newDesc;
            return hTableDescriptor;
        }
        catch (IOException e) {
            sqlE = ServerUtil.parseServerException(e);
            return sqlE;
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (IOException e) {
                if (sqlE == null) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                sqlE.setNextException(ServerUtil.parseServerException(e));
            }
            finally {
                if (sqlE == null) return null;
                throw sqlE;
            }
        }
    }

    private static boolean isInvalidMutableIndexConfig(Long serverVersion) {
        if (serverVersion == null) {
            return false;
        }
        return !MetaDataUtil.decodeMutableIndexConfiguredProperly(serverVersion);
    }

    private static boolean isCompatible(Long serverVersion) {
        if (serverVersion == null) {
            return false;
        }
        return MetaDataUtil.areClientAndServerCompatible(serverVersion);
    }

    private void checkClientServerCompatibility() throws SQLException {
        StringBuilder buf = new StringBuilder("The following servers require an updated phoenix.jar to be put in the classpath of HBase: ");
        boolean isIncompatible = false;
        int minHBaseVersion = Integer.MAX_VALUE;
        try {
            List<HRegionLocation> locations = this.getAllTableRegions(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            HashSet<HRegionLocation> serverMap = Sets.newHashSetWithExpectedSize(locations.size());
            TreeMap<byte[], HRegionLocation> regionMap = Maps.newTreeMap(Bytes.BYTES_COMPARATOR);
            ArrayList<byte[]> regionKeys = Lists.newArrayListWithExpectedSize(locations.size());
            for (HRegionLocation entry : locations) {
                if (serverMap.contains(entry)) continue;
                regionKeys.add(entry.getRegionInfo().getStartKey());
                regionMap.put(entry.getRegionInfo().getRegionName(), entry);
                serverMap.add(entry);
            }
            HTableInterface ht = this.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            Map<byte[], Long> results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, null, null, new Batch.Call<MetaDataProtos.MetaDataService, Long>(){

                @Override
                public Long call(MetaDataProtos.MetaDataService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback<MetaDataProtos.GetVersionResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.GetVersionResponse>();
                    MetaDataProtos.GetVersionRequest.Builder builder = MetaDataProtos.GetVersionRequest.newBuilder();
                    instance.getVersion(controller, builder.build(), rpcCallback);
                    if (controller.getFailedOn() != null) {
                        throw controller.getFailedOn();
                    }
                    return rpcCallback.get().getVersion();
                }
            });
            for (Map.Entry<byte[], Long> result : results.entrySet()) {
                if (!ConnectionQueryServicesImpl.isCompatible(result.getValue())) {
                    isIncompatible = true;
                    HRegionLocation name = (HRegionLocation)regionMap.get(result.getKey());
                    buf.append(name);
                    buf.append(';');
                }
                this.hasInvalidIndexConfiguration |= ConnectionQueryServicesImpl.isInvalidMutableIndexConfig(result.getValue());
                if (minHBaseVersion <= MetaDataUtil.decodeHBaseVersion(result.getValue())) continue;
                minHBaseVersion = MetaDataUtil.decodeHBaseVersion(result.getValue());
            }
            this.lowestClusterHBaseVersion = minHBaseVersion;
        }
        catch (Throwable t) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCOMPATIBLE_CLIENT_SERVER_JAR).setRootCause(t).setMessage("Ensure that phoenix.jar is put on the classpath of HBase in every region server: " + t.getMessage()).build().buildException();
        }
        if (isIncompatible) {
            buf.setLength(buf.length() - 1);
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.OUTDATED_JARS).setMessage(buf.toString()).build().buildException();
        }
    }

    private MetaDataProtocol.MetaDataMutationResult metaDataCoprocessorExec(byte[] tableKey, Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable) throws SQLException {
        try {
            MetaDataProtos.MetaDataResponse result;
            boolean retried = false;
            while (true) {
                if (retried) {
                    this.connection.relocateRegion(TableName.valueOf(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES), tableKey);
                }
                HTableInterface ht = this.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
                Map<byte[], MetaDataProtos.MetaDataResponse> results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, tableKey, tableKey, callable);
                assert (results.size() == 1);
                result = results.values().iterator().next();
                if (result.getReturnCode() != MetaDataProtos.MutationCode.TABLE_NOT_IN_REGION) break;
                if (retried) {
                    return MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
                }
                retried = true;
            }
            return MetaDataProtocol.MetaDataMutationResult.constructFromProto(result);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        catch (Throwable t) {
            throw new SQLException(t);
        }
    }

    private void ensureViewIndexTableCreated(byte[] physicalTableName, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits, long timestamp) throws SQLException {
        Long maxFileSize = (Long)tableProps.get("MAX_FILESIZE");
        if (maxFileSize == null) {
            maxFileSize = this.config.getLong("hbase.hregion.max.filesize", 0x280000000L);
        }
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        Integer indexMaxFileSizePercProp = (Integer)tableProps.remove("phoenix.index.maxDataFileSizePerc");
        int indexMaxFileSizePerc = indexMaxFileSizePercProp == null ? this.config.getInt("phoenix.index.maxDataFileSizePerc", 50) : indexMaxFileSizePercProp.intValue();
        long indexMaxFileSize = maxFileSize * (long)indexMaxFileSizePerc / 100L;
        tableProps.put("MAX_FILESIZE", indexMaxFileSize);
        tableProps.put("IS_VIEW_INDEX_TABLE", TRUE_BYTES_AS_STRING);
        HTableDescriptor desc = this.ensureTableCreated(physicalIndexName, PTableType.TABLE, tableProps, families, splits, false);
        if (desc != null && !Boolean.TRUE.equals(PDataType.BOOLEAN.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES)))) {
            String fullTableName = Bytes.toString(physicalIndexName);
            throw new TableAlreadyExistsException("Unable to create shared physical table for indexes on views.", SchemaUtil.getSchemaNameFromFullName(fullTableName), SchemaUtil.getTableNameFromFullName(fullTableName));
        }
    }

    private boolean ensureViewIndexTableDropped(byte[] physicalTableName, long timestamp) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(physicalTableName);
        HTableDescriptor desc = null;
        HBaseAdmin admin = null;
        boolean wasDeleted = false;
        try {
            admin = new HBaseAdmin(this.config);
            try {
                ReadOnlyProps props;
                boolean dropMetadata;
                desc = admin.getTableDescriptor(physicalIndexName);
                if (Boolean.TRUE.equals(PDataType.BOOLEAN.toObject(desc.getValue(MetaDataUtil.IS_VIEW_INDEX_TABLE_PROP_BYTES))) && (dropMetadata = (props = this.getProps()).getBoolean("phoenix.schema.dropMetaData", true))) {
                    admin.disableTable(physicalIndexName);
                    admin.deleteTable(physicalIndexName);
                    wasDeleted = true;
                }
            }
            catch (org.apache.hadoop.hbase.TableNotFoundException ignore) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (IOException e) {
                logger.warn("", e);
            }
        }
        return wasDeleted;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createTable(final List<Mutation> tableMetaData, byte[] physicalTableName, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits) throws SQLException {
        byte[] tableName;
        byte[][] rowKeyMetadata = new byte[3][];
        Mutation m = MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData);
        byte[] key = m.getRow();
        SchemaUtil.getVarChars(key, rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] byArray = tableName = physicalTableName != null ? physicalTableName : SchemaUtil.getTableNameAsBytes(schemaBytes, tableBytes);
        if (tableType == PTableType.VIEW && physicalTableName != null || tableType != PTableType.VIEW && physicalTableName == null) {
            this.ensureTableCreated(tableName, tableType, tableProps, families, splits, true);
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (tableType == PTableType.INDEX && physicalTableName != null) {
            if (!MetaDataUtil.isMultiTenant(m, this.kvBuilder, ptr)) {
                this.ensureViewIndexTableCreated(tenantIdBytes.length == 0 ? null : PNameFactory.newName(tenantIdBytes), physicalTableName, MetaDataUtil.getClientTimeStamp(m));
            }
        } else if (tableType == PTableType.TABLE && MetaDataUtil.isMultiTenant(m, this.kvBuilder, ptr)) {
            ptr.set(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.DEFAULT_COLUMN_FAMILY_NAME_BYTES, this.kvBuilder, ptr);
            List<Pair<byte[], Map<String, Object>>> familiesPlusDefault = null;
            for (Pair<byte[], Map<String, Object>> family : families) {
                byte[] cf = family.getFirst();
                if (Bytes.compareTo(cf, 0, cf.length, ptr.get(), ptr.getOffset(), ptr.getLength()) != 0) continue;
                familiesPlusDefault = families;
                break;
            }
            if (familiesPlusDefault == null) {
                byte[] defaultCF = ByteUtil.copyKeyBytesIfNecessary(ptr);
                familiesPlusDefault = Lists.newArrayList(families);
                familiesPlusDefault.add(new Pair(defaultCF, Collections.emptyMap()));
            }
            this.ensureViewIndexTableCreated(tableName, tableProps, familiesPlusDefault, MetaDataUtil.isSalted(m, this.kvBuilder, ptr) ? splits : (byte[][])null, MetaDataUtil.getClientTimeStamp(m));
        }
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.CreateTableRequest.Builder builder = MetaDataProtos.CreateTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.createTable(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
        return result;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getTable(PName tenantId, final byte[] schemaBytes, final byte[] tableBytes, final long tableTimestamp, final long clientTimestamp) throws SQLException {
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.GetTableRequest.Builder builder = MetaDataProtos.GetTableRequest.newBuilder();
                builder.setTenantId(HBaseZeroCopyByteString.wrap(tenantIdBytes));
                builder.setSchemaName(HBaseZeroCopyByteString.wrap(schemaBytes));
                builder.setTableName(HBaseZeroCopyByteString.wrap(tableBytes));
                builder.setTableTimestamp(tableTimestamp);
                builder.setClientTimestamp(clientTimestamp);
                instance.getTable(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropTable(final List<Mutation> tableMetaData, final PTableType tableType) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.DropTableRequest.Builder builder = MetaDataProtos.DropTableRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                builder.setTableType(tableType.getSerializedValue());
                instance.dropTable(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (dropMetadata) {
                    this.dropTables(result.getTableNamesToDelete());
                }
                if (tableType != PTableType.TABLE) break;
                byte[] physicalTableName = SchemaUtil.getTableNameAsBytes(schemaBytes, tableBytes);
                long timestamp = MetaDataUtil.getClientTimeStamp(tableMetaData);
                this.ensureViewIndexTableDropped(physicalTableName, timestamp);
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dropTables(List<byte[]> tableNamesToDelete) throws SQLException {
        HBaseAdmin admin = null;
        SQLException sqlE = null;
        try {
            admin = new HBaseAdmin(this.config);
            if (tableNamesToDelete == null) return;
            for (byte[] tableName : tableNamesToDelete) {
                if (!admin.tableExists(tableName)) continue;
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
            }
            return;
        }
        catch (IOException e) {
            sqlE = ServerUtil.parseServerException(e);
        }
        finally {
            try {
                if (admin != null) {
                    admin.close();
                }
            }
            catch (IOException e) {
                if (sqlE == null) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                sqlE.setNextException(ServerUtil.parseServerException(e));
            }
            finally {
                if (sqlE == null) return;
                throw sqlE;
            }
        }
    }

    private static Map<String, Object> createPropertiesMap(Map<ImmutableBytesWritable, ImmutableBytesWritable> htableProps) {
        HashMap<String, Object> props = Maps.newHashMapWithExpectedSize(htableProps.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : htableProps.entrySet()) {
            ImmutableBytesWritable key = entry.getKey();
            ImmutableBytesWritable value = entry.getValue();
            props.put(Bytes.toString(key.get(), key.getOffset(), key.getLength()), Bytes.toString(value.get(), value.getOffset(), value.getLength()));
        }
        return props;
    }

    private void ensureViewIndexTableCreated(PName tenantId, byte[] physicalIndexTableName, long timestamp) throws SQLException {
        PTable table;
        block3: {
            String name = Bytes.toString(physicalIndexTableName, MetaDataUtil.VIEW_INDEX_TABLE_PREFIX_BYTES.length, physicalIndexTableName.length - MetaDataUtil.VIEW_INDEX_TABLE_PREFIX_BYTES.length);
            try {
                table = this.latestMetaData.getTable(new PTableKey(tenantId, name));
                if (table.getTimeStamp() >= timestamp) {
                    throw new TableNotFoundException(table.getSchemaName().getString(), table.getTableName().getString());
                }
            }
            catch (TableNotFoundException e) {
                byte[] schemaName = Bytes.toBytes(SchemaUtil.getSchemaNameFromFullName(name));
                byte[] tableName = Bytes.toBytes(SchemaUtil.getTableNameFromFullName(name));
                MetaDataProtocol.MetaDataMutationResult result = this.getTable(null, schemaName, tableName, Long.MAX_VALUE, timestamp);
                table = result.getTable();
                if (table != null) break block3;
                throw e;
            }
        }
        this.ensureViewIndexTableCreated(table, timestamp);
    }

    private void ensureViewIndexTableCreated(PTable table, long timestamp) throws SQLException {
        byte[] physicalTableName = table.getPhysicalName().getBytes();
        HTableDescriptor htableDesc = this.getTableDescriptor(physicalTableName);
        Map<String, Object> tableProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getValues());
        ArrayList<Pair<byte[], Map<String, Object>>> families = Lists.newArrayListWithExpectedSize(Math.max(1, table.getColumnFamilies().size() + 1));
        if (families.isEmpty()) {
            byte[] familyName = SchemaUtil.getEmptyColumnFamily(table);
            Map<String, Object> familyProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getFamily(familyName).getValues());
            families.add(new Pair<byte[], Map<String, Object>>(familyName, familyProps));
        } else {
            for (PColumnFamily family : table.getColumnFamilies()) {
                byte[] familyName = family.getName().getBytes();
                Map<String, Object> familyProps = ConnectionQueryServicesImpl.createPropertiesMap(htableDesc.getFamily(familyName).getValues());
                families.add(new Pair<byte[], Map<String, Object>>(familyName, familyProps));
            }
            families.add(new Pair(table.getDefaultFamilyName().getBytes(), Collections.emptyMap()));
        }
        byte[][] splits = null;
        if (table.getBucketNum() != null) {
            splits = SaltingUtil.getSalteByteSplitPoints(table.getBucketNum());
        }
        this.ensureViewIndexTableCreated(physicalTableName, tableProps, families, splits, timestamp);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult addColumn(final List<Mutation> tableMetaData, List<Pair<byte[], Map<String, Object>>> families, PTable table) throws SQLException {
        byte[][] rowKeyMetaData = new byte[3][];
        PTableType tableType = table.getType();
        Mutation m = tableMetaData.get(0);
        byte[] rowKey = m.getRow();
        SchemaUtil.getVarChars(rowKey, rowKeyMetaData);
        byte[] tenantIdBytes = rowKeyMetaData[0];
        byte[] schemaBytes = rowKeyMetaData[1];
        byte[] tableBytes = rowKeyMetaData[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        for (Pair<byte[], Map<String, Object>> family : families) {
            this.ensureFamilyCreated(table.getPhysicalName().getBytes(), tableType, family);
        }
        if (tableMetaData.size() == 1 && tableMetaData.get(0).isEmpty()) {
            return null;
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.AddColumnRequest.Builder builder = MetaDataProtos.AddColumnRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.addColumn(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
        if (result.getMutationCode() == MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND) {
            if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.DISABLE_WAL_BYTES, this.kvBuilder, ptr) && Boolean.FALSE.equals(PDataType.BOOLEAN.toObject(ptr))) {
                this.flushTable(table.getPhysicalName().getBytes());
            }
            if (tableType == PTableType.TABLE && MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, this.kvBuilder, ptr)) {
                long timestamp = MetaDataUtil.getClientTimeStamp(m);
                if (Boolean.TRUE.equals(PDataType.BOOLEAN.toObject(ptr.get(), ptr.getOffset(), ptr.getLength()))) {
                    this.ensureViewIndexTableCreated(table, timestamp);
                } else {
                    this.ensureViewIndexTableDropped(table.getPhysicalName().getBytes(), timestamp);
                }
            }
        }
        return result;
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropColumn(final List<Mutation> tableMetaData, PTableType tableType) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        byte[] schemaBytes = rowKeyMetadata[1];
        byte[] tableBytes = rowKeyMetadata[2];
        byte[] tableKey = SchemaUtil.getTableKey(tenantIdBytes, schemaBytes, tableBytes);
        MetaDataProtocol.MetaDataMutationResult result = this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.DropColumnRequest.Builder builder = MetaDataProtos.DropColumnRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.dropColumn(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
        MetaDataProtocol.MutationCode code = result.getMutationCode();
        switch (code) {
            case TABLE_ALREADY_EXISTS: {
                ReadOnlyProps props = this.getProps();
                boolean dropMetadata = props.getBoolean("phoenix.schema.dropMetaData", true);
                if (!dropMetadata) break;
                this.dropTables(result.getTableNamesToDelete());
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PhoenixConnection addColumnsIfNotExists(PhoenixConnection oldMetaConnection, long timestamp, String columns) throws SQLException {
        PhoenixConnection metaConnection;
        block12: {
            Properties props = new Properties(oldMetaConnection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(timestamp));
            metaConnection = new PhoenixConnection(this, oldMetaConnection.getURL(), props, oldMetaConnection.getMetaDataCache());
            SQLException sqlE = null;
            try {
                metaConnection.createStatement().executeUpdate("ALTER TABLE SYSTEM.\"CATALOG\" ADD IF NOT EXISTS " + columns);
            }
            catch (SQLException e) {
                sqlE = e;
                return sqlE;
            }
            finally {
                try {
                    oldMetaConnection.close();
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    }
                    sqlE = e;
                }
                if (sqlE == null) break block12;
                throw sqlE;
            }
        }
        return metaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(String url, Properties props) throws SQLException {
        if (this.initialized) {
            if (this.initializationException == null) return;
            throw this.initializationException;
        }
        ConnectionQueryServicesImpl connectionQueryServicesImpl = this;
        synchronized (connectionQueryServicesImpl) {
            if (this.initialized) {
                if (this.initializationException == null) return;
                throw this.initializationException;
            }
            if (this.closed) {
                throw new SQLException("The connection to the cluster has been closed.");
            }
            SQLException sqlE = null;
            PhoenixConnection metaConnection = null;
            try {
                this.openConnection();
                Properties scnProps = PropertiesUtil.deepCopy(props);
                scnProps.setProperty("CurrentSCN", Long.toString(1L));
                scnProps.remove("TenantId");
                metaConnection = new PhoenixConnection(this, url, scnProps, this.newEmptyMetaData());
                try {
                    metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_TABLE_METADATA);
                }
                catch (NewerTableAlreadyExistsException ignore) {
                    // empty catch block
                }
                try {
                    metaConnection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS SYSTEM.\"SEQUENCE\"(\nTENANT_ID VARCHAR NULL,SEQUENCE_SCHEMA VARCHAR NULL, \nSEQUENCE_NAME VARCHAR NOT NULL, \nSTART_WITH BIGINT NOT NULL, \nCURRENT_VALUE BIGINT NOT NULL, \nINCREMENT_BY BIGINT NOT NULL, \nCACHE_SIZE BIGINT NOT NULL \n CONSTRAINT pk PRIMARY KEY (TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME))\nVERSIONS=1000\n");
                }
                catch (NewerTableAlreadyExistsException ignore) {
                    // empty catch block
                }
                this.upgradeMetaDataTo3_0(url, props);
            }
            catch (SQLException e) {
                sqlE = e;
            }
            finally {
                try {
                    if (metaConnection != null) {
                        metaConnection.close();
                    }
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    } else {
                        sqlE = e;
                    }
                }
                finally {
                    try {
                        if (sqlE != null) {
                            this.initializationException = sqlE;
                            throw sqlE;
                        }
                    }
                    finally {
                        this.initialized = true;
                    }
                }
            }
            return;
        }
    }

    @Override
    public MutationState updateData(MutationPlan plan) throws SQLException {
        return plan.execute();
    }

    @Override
    public int getLowestClusterHBaseVersion() {
        return this.lowestClusterHBaseVersion;
    }

    @Override
    public boolean hasInvalidIndexConfiguration() {
        return this.hasInvalidIndexConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void clearCache() throws SQLException {
        try {
            SQLException sqlE = null;
            HTableInterface htable = this.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
            try {
                htable.coprocessorService(MetaDataProtos.MetaDataService.class, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.ClearCacheResponse>(){

                    @Override
                    public MetaDataProtos.ClearCacheResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                        ServerRpcController controller = new ServerRpcController();
                        BlockingRpcCallback<MetaDataProtos.ClearCacheResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.ClearCacheResponse>();
                        MetaDataProtos.ClearCacheRequest.Builder builder = MetaDataProtos.ClearCacheRequest.newBuilder();
                        instance.clearCache(controller, builder.build(), rpcCallback);
                        if (controller.getFailedOn() != null) {
                            throw controller.getFailedOn();
                        }
                        return rpcCallback.get();
                    }
                });
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
            catch (Throwable e) {
                sqlE = new SQLException(e);
            }
            finally {
                try {
                    htable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                finally {
                    if (sqlE == null) return;
                    throw sqlE;
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(ServerUtil.parseServerException(e));
        }
    }

    private void flushTable(byte[] tableName) throws SQLException {
        HBaseAdmin admin = this.getAdmin();
        try {
            admin.flush(tableName);
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
        catch (InterruptedException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
        }
        finally {
            Closeables.closeQuietly(admin);
        }
    }

    @Override
    public HBaseAdmin getAdmin() throws SQLException {
        try {
            return new HBaseAdmin(this.config);
        }
        catch (IOException e) {
            throw new PhoenixIOException(e);
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(final List<Mutation> tableMetaData, String parentTableName) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetaData.get(0).getRow(), rowKeyMetadata);
        byte[] tableKey = SchemaUtil.getTableKey(ByteUtil.EMPTY_BYTE_ARRAY, rowKeyMetadata[1], rowKeyMetadata[2]);
        return this.metaDataCoprocessorExec(tableKey, new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            @Override
            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback<MetaDataProtos.MetaDataResponse> rpcCallback = new BlockingRpcCallback<MetaDataProtos.MetaDataResponse>();
                MetaDataProtos.UpdateIndexStateRequest.Builder builder = MetaDataProtos.UpdateIndexStateRequest.newBuilder();
                for (Mutation m : tableMetaData) {
                    ClientProtos.MutationProto mp = ProtobufUtil.toProto(m);
                    builder.addTableMetadataMutations(mp.toByteString());
                }
                instance.updateIndexState(controller, builder.build(), rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return rpcCallback.get();
            }
        });
    }

    @Override
    public long createSequence(String tenantId, String schemaName, String sequenceName, long startWith, long incrementBy, long cacheSize, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.createSequence(startWith, incrementBy, cacheSize, timestamp);
            HTableInterface htable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_TABLE_NAME_BYTES);
            try {
                Result result = htable.append(append);
                long l = sequence.createSequence(result);
                return l;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public long dropSequence(String tenantId, String schemaName, String sequenceName, long timestamp) throws SQLException {
        SequenceKey sequenceKey = new SequenceKey(tenantId, schemaName, sequenceName);
        Sequence newSequences = new Sequence(sequenceKey);
        Sequence sequence = this.sequenceMap.putIfAbsent(sequenceKey, newSequences);
        if (sequence == null) {
            sequence = newSequences;
        }
        try {
            sequence.getLock().lock();
            Append append = sequence.dropSequence(timestamp);
            HTableInterface htable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_TABLE_NAME_BYTES);
            try {
                Result result = htable.append(append);
                long l = sequence.dropSequence(result);
                return l;
            }
            catch (IOException e) {
                throw ServerUtil.parseServerException(e);
            }
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public long currentSequenceValue(SequenceKey sequenceKey, long timestamp) throws SQLException {
        Sequence sequence = (Sequence)this.sequenceMap.get(sequenceKey);
        if (sequence == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        sequence.getLock().lock();
        try {
            long l = sequence.currentValue(timestamp);
            return l;
        }
        catch (EmptySequenceCacheException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        finally {
            sequence.getLock().unlock();
        }
    }

    @Override
    public void validateSequences(List<SequenceKey> sequenceKeys, long timestamp, long[] values, SQLException[] exceptions, Sequence.Action action) throws SQLException {
        this.incrementSequenceValues(sequenceKeys, timestamp, values, exceptions, 0, action);
    }

    @Override
    public void incrementSequences(List<SequenceKey> sequenceKeys, long timestamp, long[] values, SQLException[] exceptions) throws SQLException {
        this.incrementSequenceValues(sequenceKeys, timestamp, values, exceptions, 1, Sequence.Action.RESERVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSequenceValues(List<SequenceKey> keys, long timestamp, long[] values, SQLException[] exceptions, int factor, Sequence.Action action) throws SQLException {
        ArrayList<Sequence> sequences = Lists.newArrayListWithExpectedSize(keys.size());
        for (SequenceKey key : keys) {
            Sequence newSequences;
            Sequence sequence = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence == null) {
                sequence = newSequences;
            }
            sequences.add(sequence);
        }
        try {
            Object[] resultObjects;
            ArrayList<Sequence> toIncrementList;
            block31: {
                for (Sequence sequence : sequences) {
                    sequence.getLock().lock();
                }
                ArrayList<Increment> incrementBatch = Lists.newArrayListWithExpectedSize(sequences.size());
                toIncrementList = Lists.newArrayListWithExpectedSize(sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence sequence = (Sequence)sequences.get(i);
                    try {
                        values[i] = sequence.incrementValue(timestamp, factor, action);
                        continue;
                    }
                    catch (EmptySequenceCacheException e) {
                        indexes[toIncrementList.size()] = i;
                        toIncrementList.add(sequence);
                        Increment inc = sequence.newIncrement(timestamp, action);
                        incrementBatch.add(inc);
                    }
                }
                if (toIncrementList.isEmpty()) {
                    return;
                }
                HTableInterface hTable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_TABLE_NAME_BYTES);
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    resultObjects = hTable.batch(incrementBatch);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block31;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence = (Sequence)toIncrementList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    values[indexes[i]] = sequence.incrementValue(result, factor);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnSequences(List<SequenceKey> keys, long timestamp, SQLException[] exceptions) throws SQLException {
        ArrayList<Sequence> sequences = Lists.newArrayListWithExpectedSize(keys.size());
        for (SequenceKey key : keys) {
            Sequence newSequences;
            Sequence sequence = this.sequenceMap.putIfAbsent(key, newSequences = new Sequence(key));
            if (sequence == null) {
                sequence = newSequences;
            }
            sequences.add(sequence);
        }
        try {
            Object[] resultObjects;
            ArrayList<Sequence> toReturnList;
            block31: {
                for (Sequence sequence : sequences) {
                    sequence.getLock().lock();
                }
                ArrayList<Append> mutations = Lists.newArrayListWithExpectedSize(sequences.size());
                toReturnList = Lists.newArrayListWithExpectedSize(sequences.size());
                int[] indexes = new int[sequences.size()];
                for (int i = 0; i < sequences.size(); ++i) {
                    Sequence sequence = (Sequence)sequences.get(i);
                    try {
                        Append append = sequence.newReturn(timestamp);
                        toReturnList.add(sequence);
                        mutations.add(append);
                        continue;
                    }
                    catch (EmptySequenceCacheException ignore) {
                        // empty catch block
                    }
                }
                if (toReturnList.isEmpty()) {
                    return;
                }
                HTableInterface hTable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_TABLE_NAME_BYTES);
                resultObjects = null;
                SQLException sqlE = null;
                try {
                    resultObjects = hTable.batch(mutations);
                }
                catch (IOException e) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                catch (InterruptedException e) {
                    sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
                }
                finally {
                    try {
                        hTable.close();
                    }
                    catch (IOException e) {
                        if (sqlE == null) {
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        sqlE.setNextException(ServerUtil.parseServerException(e));
                    }
                    if (sqlE == null) break block31;
                    throw sqlE;
                }
            }
            for (int i = 0; i < resultObjects.length; ++i) {
                Sequence sequence = (Sequence)toReturnList.get(i);
                Result result = (Result)resultObjects[i];
                try {
                    sequence.returnValue(result);
                    continue;
                }
                catch (SQLException e) {
                    exceptions[indexes[i]] = e;
                }
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.getLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnAllSequences(ConcurrentMap<SequenceKey, Sequence> sequenceMap) throws SQLException {
        block18: {
            ArrayList<Append> mutations = Lists.newArrayListWithExpectedSize(sequenceMap.size());
            for (Sequence sequence : sequenceMap.values()) {
                mutations.addAll(sequence.newReturns());
            }
            if (mutations.isEmpty()) {
                return;
            }
            HTableInterface hTable = this.getTable(PhoenixDatabaseMetaData.SEQUENCE_TABLE_NAME_BYTES);
            SQLException sqlE = null;
            try {
                hTable.batch(mutations);
            }
            catch (IOException e) {
                sqlE = ServerUtil.parseServerException(e);
            }
            catch (InterruptedException e) {
                sqlE = new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause(e).build().buildException();
            }
            finally {
                try {
                    hTable.close();
                }
                catch (IOException e) {
                    if (sqlE == null) {
                        sqlE = ServerUtil.parseServerException(e);
                    }
                    sqlE.setNextException(ServerUtil.parseServerException(e));
                }
                if (sqlE == null) break block18;
                throw sqlE;
            }
        }
    }

    @Override
    public synchronized void addConnection(PhoenixConnection connection) throws SQLException {
        ++this.connectionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(PhoenixConnection connection) throws SQLException {
        ConcurrentMap<SequenceKey, Sequence> formerSequenceMap = null;
        ConnectionQueryServicesImpl connectionQueryServicesImpl = this;
        synchronized (connectionQueryServicesImpl) {
            if (--this.connectionCount == 0 && !this.sequenceMap.isEmpty()) {
                formerSequenceMap = this.sequenceMap;
                this.sequenceMap = Maps.newConcurrentMap();
            }
        }
        if (formerSequenceMap != null) {
            this.returnAllSequences(formerSequenceMap);
        }
    }

    @Override
    public KeyValueBuilder getKeyValueBuilder() {
        return this.kvBuilder;
    }

    @Override
    public boolean supportsFeature(ConnectionQueryServices.Feature feature) {
        return false;
    }

    private static void addViewForSystemTable(Connection conn) throws SQLException {
        conn.createStatement().execute("CREATE VIEW IF NOT EXISTS " + OLD_SYSTEM_TABLE_AS_VIEW_NAME + "(\n" + "TABLE_SCHEM VARCHAR NULL,\n" + "TABLE_NAME VARCHAR NOT NULL,\n" + "COLUMN_NAME VARCHAR NULL,\n" + "TABLE_CAT VARCHAR NULL,\n" + "TABLE_TYPE CHAR(1),\n" + "TABLE_SEQ_NUM BIGINT,\n" + "PK_NAME VARCHAR,\n" + "COLUMN_COUNT INTEGER,\n" + "SALT_BUCKETS INTEGER,\n" + "DATA_TABLE_NAME VARCHAR,\n" + "INDEX_STATE CHAR(1),\n" + "IMMUTABLE_ROWS BOOLEAN,\n" + "VIEW_STATEMENT VARCHAR,\n" + "DEFAULT_COLUMN_FAMILY VARCHAR,\n" + "DISABLE_WAL BOOLEAN,\n" + "MULTI_TENANT BOOLEAN,\n" + "VIEW_TYPE UNSIGNED_TINYINT,\n" + "VIEW_INDEX_ID SMALLINT,\n" + "DATA_TYPE INTEGER,\n" + "COLUMN_SIZE INTEGER,\n" + "DECIMAL_DIGITS INTEGER,\n" + "NULLABLE INTEGER,\n" + "ORDINAL_POSITION INTEGER,\n" + "COLUMN_MODIFIER INTEGER,\n" + "CONSTRAINT pk PRIMARY KEY (TABLE_SCHEM,TABLE_NAME,COLUMN_NAME, TABLE_CAT))\n" + "AS SELECT * FROM SYSTEM.\"TABLE\" DEFAULT_COLUMN_FAMILY='_0'");
    }

    private static void addWhereClauseForUpgrade3_0(WhiteList whiteList, StringBuilder buf) {
        if (whiteList.neverMatches()) {
            buf.append(" WHERE FALSE\n");
        } else {
            buf.append(" WHERE ");
            if (whiteList.alwaysMatches()) {
                buf.append("NOT (");
                buf.append("TABLE_SCHEM = 'SYSTEM' AND ");
                buf.append("TABLE_NAME = 'TABLE')\n");
            } else {
                for (String fullName : whiteList) {
                    buf.append(" (");
                    String schemaName = SchemaUtil.getSchemaNameFromFullName(fullName);
                    buf.append("TABLE_SCHEM" + (schemaName.length() == 0 ? " IS NULL " : " = '" + schemaName + "'") + " AND ");
                    String tableName = SchemaUtil.getTableNameFromFullName(fullName);
                    buf.append("TABLE_NAME = '" + tableName + "' )\nOR");
                }
                buf.setLength(buf.length() - "OR".length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeMetaDataTo3_0(String url, Properties props) throws SQLException {
        block124: {
            if (this.upgradeWhiteList == null) {
                return;
            }
            if (this.upgradeWhiteList.neverMatches()) {
                if (logger.isInfoEnabled()) {
                    logger.info("No table meta data needs to be upgraded to Apache Phoenix 3.0");
                }
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("Upgrading table meta data to Apache Phoenix 3.0 based on the following white list: " + this.upgradeWhiteList);
                }
                boolean createdView = false;
                SQLException sqlE = null;
                PhoenixConnection conn = new PhoenixConnection(this, url, props, this.latestMetaData);
                try {
                    PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + "(\n" + "TENANT_ID" + "," + "TABLE_SCHEM" + "," + "TABLE_NAME" + "," + "COLUMN_NAME" + "," + "COLUMN_FAMILY" + "," + "TABLE_SEQ_NUM" + "," + "TABLE_TYPE" + "," + "DATA_TYPE" + "," + "PK_NAME" + "," + "COLUMN_COUNT" + "," + "SALT_BUCKETS" + "," + "DATA_TABLE_NAME" + "," + "INDEX_STATE" + "," + "IMMUTABLE_ROWS" + "," + "DEFAULT_COLUMN_FAMILY" + "," + "COLUMN_SIZE" + "," + "DECIMAL_DIGITS" + "," + "NULLABLE" + "," + "ORDINAL_POSITION" + "," + "SORT_ORDER" + "," + "KEY_SEQ" + "," + "LINK_TYPE" + ")\n" + "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    StringBuilder buf = new StringBuilder("SELECT * FROM " + OLD_SYSTEM_TABLE_AS_VIEW_NAME + "\n");
                    ConnectionQueryServicesImpl.addWhereClauseForUpgrade3_0(this.upgradeWhiteList, buf);
                    buf.append("ORDER BY TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,TABLE_CAT,ORDINAL_POSITION");
                    ConnectionQueryServicesImpl.addViewForSystemTable(conn);
                    createdView = true;
                    ResultSet rs = conn.createStatement().executeQuery(buf.toString());
                    String lastSchemaName = null;
                    String lastTableName = null;
                    short nextKeySeq = 1;
                    String tablePkName = null;
                    boolean isSalted = false;
                    while (rs.next()) {
                        Integer ordinalPosition;
                        String pkName = null;
                        String defaultColumnFamily = null;
                        String schemaName = rs.getString("TABLE_SCHEM");
                        String tableName = rs.getString("TABLE_NAME");
                        if (!Objects.equal(schemaName, lastSchemaName) || !Objects.equal(tableName, lastTableName)) {
                            if (lastTableName != null) {
                                if (logger.isInfoEnabled()) {
                                    logger.info("Committing upgrades of table meta data for: " + SchemaUtil.getTableName(lastSchemaName, lastTableName));
                                }
                                conn.commit();
                            }
                            lastSchemaName = schemaName;
                            lastTableName = tableName;
                            nextKeySeq = 1;
                            defaultColumnFamily = OLD_DEFAULT_COLUMN_FAMILY;
                            isSalted = rs.getInt("SALT_BUCKETS") > 0;
                            pkName = tablePkName = rs.getString("PK_NAME");
                            if (logger.isInfoEnabled()) {
                                logger.info("Upgrading table meta data for: " + SchemaUtil.getTableName(schemaName, tableName));
                            }
                        }
                        String columnName = rs.getString("COLUMN_NAME");
                        String familyName = rs.getString("TABLE_CAT");
                        Short keySeq = null;
                        Byte linkType = null;
                        if (columnName != null && familyName == null) {
                            short s = nextKeySeq;
                            nextKeySeq = (short)(nextKeySeq + 1);
                            keySeq = s;
                            pkName = tablePkName;
                        }
                        if (columnName == null && familyName != null) {
                            linkType = PTable.LinkType.INDEX_TABLE.getSerializedValue();
                        }
                        if ((ordinalPosition = (Integer)rs.getObject("ORDINAL_POSITION")) != null && isSalted) {
                            Integer n = ordinalPosition;
                            Integer n2 = ordinalPosition = Integer.valueOf(ordinalPosition - 1);
                        }
                        Integer maxLength = (Integer)rs.getObject("COLUMN_SIZE");
                        Integer scale = (Integer)rs.getObject("DECIMAL_DIGITS");
                        Integer dataTypeNum = (Integer)rs.getObject("DATA_TYPE");
                        if (dataTypeNum != null) {
                            PDataType dataType = PDataType.fromTypeId(dataTypeNum);
                            switch (dataType) {
                                case DECIMAL: {
                                    if (!DEFAULT_PRECISION.equals(maxLength) || !DEFAULT_SCALE.equals(scale)) break;
                                    maxLength = null;
                                    scale = null;
                                    break;
                                }
                                case DATE: {
                                    dataTypeNum = PDataType.UNSIGNED_DATE.getSqlType();
                                    break;
                                }
                                case TIME: {
                                    dataTypeNum = PDataType.UNSIGNED_TIME.getSqlType();
                                    break;
                                }
                                case TIMESTAMP: {
                                    dataTypeNum = PDataType.UNSIGNED_TIMESTAMP.getSqlType();
                                    break;
                                }
                                case BINARY: {
                                    rs.getInt("COLUMN_SIZE");
                                    if (!rs.wasNull()) break;
                                    dataTypeNum = PDataType.VARBINARY.getSqlType();
                                    break;
                                }
                                default: {
                                    if (!dataType.isCoercibleTo(PDataType.LONG)) break;
                                    maxLength = null;
                                    scale = null;
                                }
                            }
                        }
                        stmt.setString(1, null);
                        stmt.setString(2, schemaName);
                        stmt.setString(3, tableName);
                        stmt.setString(4, columnName);
                        stmt.setString(5, familyName);
                        stmt.setObject(6, rs.getObject("TABLE_SEQ_NUM"));
                        stmt.setString(7, rs.getString("TABLE_TYPE"));
                        stmt.setObject(8, dataTypeNum);
                        stmt.setString(9, pkName);
                        stmt.setObject(10, rs.getObject("COLUMN_COUNT"));
                        stmt.setObject(11, rs.getObject("SALT_BUCKETS"));
                        stmt.setString(12, rs.getString("DATA_TABLE_NAME"));
                        stmt.setString(13, rs.getString("INDEX_STATE"));
                        stmt.setObject(14, rs.getObject("IMMUTABLE_ROWS"));
                        stmt.setString(15, defaultColumnFamily);
                        stmt.setObject(16, maxLength);
                        stmt.setObject(17, scale);
                        stmt.setObject(18, rs.getObject("NULLABLE"));
                        stmt.setObject(19, ordinalPosition);
                        stmt.setObject(20, rs.getObject("COLUMN_MODIFIER"));
                        stmt.setObject(21, keySeq);
                        stmt.setObject(22, linkType);
                        stmt.execute();
                    }
                    if (lastTableName != null) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Committing upgrades of table meta data for: " + SchemaUtil.getTableName(lastSchemaName, lastTableName));
                        }
                        conn.commit();
                    }
                }
                catch (TableNotFoundException e) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Unable to upgrade metadata.", e);
                    }
                }
                catch (SQLException e) {
                    sqlE = e;
                }
                finally {
                    try {
                        if (createdView) {
                            Long scn = JDBCUtil.getCurrentSCN(url, props);
                            if (scn == null) {
                                conn.createStatement().execute("DROP VIEW IF EXISTS " + OLD_SYSTEM_TABLE_AS_VIEW_NAME);
                            }
                            Properties newProps = new Properties(props);
                            newProps.setProperty("CurrentSCN", Long.toString(scn + 1L));
                            PhoenixConnection newConn = new PhoenixConnection(this, url, newProps, this.latestMetaData);
                            try {
                                newConn.createStatement().execute("DROP VIEW IF EXISTS " + OLD_SYSTEM_TABLE_AS_VIEW_NAME);
                            }
                            catch (Throwable throwable) {
                                try {
                                    newConn.close();
                                }
                                catch (SQLException e) {
                                    logger.warn("Unable to close connection", e);
                                }
                                throw throwable;
                            }
                            try {
                                newConn.close();
                            }
                            catch (SQLException e) {
                                logger.warn("Unable to close connection", e);
                            }
                        }
                    }
                    catch (SQLException e) {
                        if (sqlE == null) {
                            sqlE = e;
                        }
                        sqlE.setNextException(e);
                    }
                    finally {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            logger.warn("Unable to close connection", e);
                        }
                        finally {
                            if (sqlE == null) break block124;
                            throw sqlE;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhiteList upgradeCoprocessorsTo3_0(HBaseAdmin admin, boolean forceUpgrade) throws IOException, SQLException {
        String files = this.config.get("phoenix.client.autoUpgradeWhiteList");
        WhiteList coprocUpgradeWhiteList = new WhiteList(files);
        if (coprocUpgradeWhiteList.neverMatches()) {
            if (logger.isInfoEnabled()) {
                logger.info("No coprocessors will be upgraded from Salesforce Phoenix 2.x to Apache Phoenix 3.0");
            }
            return coprocUpgradeWhiteList;
        }
        HashSet<String> upgradedTables = Sets.newHashSet();
        if (logger.isInfoEnabled()) {
            logger.info("Upgrading coprocessors from Salesforce Phoenix 2.x to Apache Phoenix 3.0 based on the following white list: " + coprocUpgradeWhiteList);
        }
        Scan scan = new Scan();
        scan.addColumn(OLD_DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES);
        scan.addColumn(OLD_DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
        SingleColumnValueFilter filter = new SingleColumnValueFilter(OLD_DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, CompareFilter.CompareOp.GREATER_OR_EQUAL, PDataType.CHAR.toBytes("a"));
        filter.setFilterIfMissing(true);
        scan.setFilter(filter);
        HTableInterface table = null;
        try {
            table = this.getTable(OLD_SYSTEM_TABLE_NAME_BYTES);
            ResultScanner scanner = table.getScanner(scan);
            Result result = null;
            while ((result = scanner.next()) != null) {
                byte[] rowKey = result.getRow();
                byte[][] rowKeyMetaData = new byte[2][];
                SchemaUtil.getVarChars(rowKey, rowKeyMetaData);
                byte[] schemaBytes = rowKeyMetaData[0];
                byte[] tableBytes = rowKeyMetaData[1];
                byte[] tableName = SchemaUtil.getTableNameAsBytes(schemaBytes, tableBytes);
                Cell tableTypeKv = result.getColumnLatestCell(OLD_DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.TABLE_TYPE_BYTES);
                PTableType tableType = PTableType.fromSerializedValue(tableTypeKv.getValueArray()[tableTypeKv.getValueOffset()]);
                Cell dataNameKv = result.getColumnLatestCell(OLD_DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.DATA_TABLE_NAME_BYTES);
                if (tableType == PTableType.SYSTEM || !coprocUpgradeWhiteList.matches(tableName) && (dataNameKv == null || !coprocUpgradeWhiteList.matches(SchemaUtil.getTableName(schemaBytes, dataNameKv.getValue())))) continue;
                HTableDescriptor existingDesc = admin.getTableDescriptor(tableName);
                HTableDescriptor newDesc = new HTableDescriptor(existingDesc);
                this.addCoprocessors(tableName, newDesc, tableType);
                String fullTableName = Bytes.toString(tableName);
                upgradedTables.add(fullTableName);
                if (existingDesc.equals(newDesc)) continue;
                if (logger.isInfoEnabled()) {
                    logger.info("Upgrading coprocessors for: " + SchemaUtil.getTableName(schemaBytes, tableBytes));
                }
                admin.disableTable(tableName);
                admin.modifyTable(tableName, newDesc);
                admin.enableTable(tableName);
            }
            WhiteList whiteList = new WhiteList(upgradedTables);
            return whiteList;
        }
        catch (TableNotFoundException ignore) {
            WhiteList whiteList = new WhiteList();
            return whiteList;
        }
        finally {
            if (table != null) {
                Closeables.closeQuietly(table);
            }
        }
    }

    private static final class WhiteList
    implements Iterable<String> {
        private final Set<String> matchList;
        private static final String MATCH_EVERYTHING = "*";
        private static final String DELIMITER = ",";

        public WhiteList() {
            this.matchList = Collections.emptySet();
        }

        public WhiteList(Set<String> matchList) {
            this.matchList = matchList == null ? null : ImmutableSet.copyOf(matchList);
        }

        public WhiteList(String tableNames) {
            HashSet<String> matchList = Sets.newHashSet();
            if (tableNames == null) {
                this.matchList = ImmutableSet.of();
            } else if (MATCH_EVERYTHING.equals(tableNames)) {
                this.matchList = null;
            } else {
                matchList = Sets.newHashSet();
                StringTokenizer tokenizer = new StringTokenizer(tableNames, DELIMITER);
                while (tokenizer.hasMoreTokens()) {
                    matchList.add(tokenizer.nextToken().trim());
                }
                this.matchList = ImmutableSet.copyOf(matchList);
            }
        }

        public boolean alwaysMatches() {
            return this.matchList == null;
        }

        public boolean neverMatches() {
            return this.matchList != null && this.matchList.isEmpty();
        }

        public boolean matches(byte[] fullTableName) {
            if (this.matchList == null) {
                return true;
            }
            return this.matchList.contains(Bytes.toString(fullTableName));
        }

        @Override
        public Iterator<String> iterator() {
            if (this.matchList == null) {
                return Iterators.emptyIterator();
            }
            return this.matchList.iterator();
        }

        public String toString() {
            return this.alwaysMatches() ? "ALL" : (this.neverMatches() ? "NONE" : this.matchList.toString());
        }

        public boolean matches(String tableName) {
            return this.matchList == null ? true : this.matchList.contains(tableName);
        }
    }

    private static interface Mutator {
        public PMetaData mutate(PMetaData var1) throws SQLException;
    }
}

