/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.DelegateQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.query.QueryServices;
import org.apache.phoenix.query.StatsManager;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PMetaDataImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ConnectionlessQueryServicesImpl
extends DelegateQueryServices
implements ConnectionQueryServices {
    private PMetaData metaData;
    private final Map<SequenceKey, Long> sequenceMap = Maps.newHashMap();
    private KeyValueBuilder kvBuilder;
    private volatile boolean initialized;
    private volatile SQLException initializationException;

    public ConnectionlessQueryServicesImpl(QueryServices queryServices) {
        super(queryServices);
        this.metaData = this.newEmptyMetaData();
        this.kvBuilder = GenericKeyValueBuilder.INSTANCE;
    }

    private PMetaData newEmptyMetaData() {
        long maxSizeBytes = this.getProps().getLong("phoenix.client.maxMetaDataCacheSize", 0xA00000L);
        return new PMetaDataImpl(100, maxSizeBytes);
    }

    @Override
    public ConnectionQueryServices getChildQueryServices(ImmutableBytesWritable childId) {
        return this;
    }

    @Override
    public HTableInterface getTable(byte[] tableName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public StatsManager getStatsManager() {
        return new StatsManager(){

            @Override
            public byte[] getMinKey(TableRef table) {
                return HConstants.EMPTY_START_ROW;
            }

            @Override
            public byte[] getMaxKey(TableRef table) {
                return HConstants.EMPTY_END_ROW;
            }

            @Override
            public void updateStats(TableRef table) throws SQLException {
            }

            @Override
            public void clearStats() throws SQLException {
            }
        };
    }

    @Override
    public List<HRegionLocation> getAllTableRegions(byte[] tableName) throws SQLException {
        return Collections.singletonList(new HRegionLocation(new HRegionInfo(TableName.valueOf(tableName), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW), ServerName.valueOf("localhost", 60020, 0L), -1L));
    }

    @Override
    public PMetaData addTable(PTable table) throws SQLException {
        this.metaData = this.metaData.addTable(table);
        return this.metaData;
    }

    @Override
    public PMetaData addColumn(PName tenantId, String tableName, List<PColumn> columns, long tableTimeStamp, long tableSeqNum, boolean isImmutableRows) throws SQLException {
        this.metaData = this.metaData.addColumn(tenantId, tableName, columns, tableTimeStamp, tableSeqNum, isImmutableRows);
        return this.metaData;
    }

    @Override
    public PMetaData removeTable(PName tenantId, String tableName) throws SQLException {
        this.metaData = this.metaData.removeTable(tenantId, tableName);
        return this.metaData;
    }

    @Override
    public PMetaData removeColumn(PName tenantId, String tableName, String familyName, String columnName, long tableTimeStamp, long tableSeqNum) throws SQLException {
        this.metaData = this.metaData.removeColumn(tenantId, tableName, familyName, columnName, tableTimeStamp, tableSeqNum);
        return this.metaData;
    }

    @Override
    public PhoenixConnection connect(String url, Properties info) throws SQLException {
        return new PhoenixConnection(this, url, info, this.metaData);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult getTable(PName tenantId, byte[] schemaBytes, byte[] tableBytes, long tableTimestamp, long clientTimestamp) throws SQLException {
        try {
            String fullTableName = SchemaUtil.getTableName(schemaBytes, tableBytes);
            PTable table = this.metaData.getTable(new PTableKey(tenantId, fullTableName));
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, table, true);
        }
        catch (TableNotFoundException e) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, 0L, null);
        }
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult createTable(List<Mutation> tableMetaData, byte[] physicalName, PTableType tableType, Map<String, Object> tableProps, List<Pair<byte[], Map<String, Object>>> families, byte[][] splits) throws SQLException {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_NOT_FOUND, 0L, null);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropTable(List<Mutation> tableMetadata, PTableType tableType) throws SQLException {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, null);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult addColumn(List<Mutation> tableMetaData, List<Pair<byte[], Map<String, Object>>> families, PTable table) throws SQLException {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, null);
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult dropColumn(List<Mutation> tableMetadata, PTableType tableType) throws SQLException {
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(String url, Properties props) throws SQLException {
        if (this.initialized) {
            if (this.initializationException == null) return;
            throw this.initializationException;
        }
        ConnectionlessQueryServicesImpl connectionlessQueryServicesImpl = this;
        synchronized (connectionlessQueryServicesImpl) {
            if (this.initialized) {
                if (this.initializationException == null) return;
                throw this.initializationException;
            }
            SQLException sqlE = null;
            PhoenixConnection metaConnection = null;
            try {
                Properties scnProps = PropertiesUtil.deepCopy(props);
                scnProps.setProperty("CurrentSCN", Long.toString(1L));
                scnProps.remove("TenantId");
                metaConnection = new PhoenixConnection(this, url, scnProps, this.newEmptyMetaData());
                try {
                    metaConnection.createStatement().executeUpdate(QueryConstants.CREATE_TABLE_METADATA);
                }
                catch (TableAlreadyExistsException ignore) {
                    // empty catch block
                }
                try {
                    metaConnection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS SYSTEM.\"SEQUENCE\"(\nTENANT_ID VARCHAR NULL,SEQUENCE_SCHEMA VARCHAR NULL, \nSEQUENCE_NAME VARCHAR NOT NULL, \nSTART_WITH BIGINT NOT NULL, \nCURRENT_VALUE BIGINT NOT NULL, \nINCREMENT_BY BIGINT NOT NULL, \nCACHE_SIZE BIGINT NOT NULL \n CONSTRAINT pk PRIMARY KEY (TENANT_ID,SEQUENCE_SCHEMA,SEQUENCE_NAME))\nVERSIONS=1000\n");
                }
                catch (NewerTableAlreadyExistsException ignore) {
                    // empty catch block
                }
            }
            catch (SQLException e) {
                sqlE = e;
            }
            finally {
                try {
                    if (metaConnection != null) {
                        metaConnection.close();
                    }
                }
                catch (SQLException e) {
                    if (sqlE != null) {
                        sqlE.setNextException(e);
                    } else {
                        sqlE = e;
                    }
                }
                finally {
                    try {
                        if (sqlE != null) {
                            this.initializationException = sqlE;
                            throw sqlE;
                        }
                    }
                    finally {
                        this.initialized = true;
                    }
                }
            }
            return;
        }
    }

    @Override
    public MutationState updateData(MutationPlan plan) throws SQLException {
        return new MutationState(0, plan.getConnection());
    }

    @Override
    public int getLowestClusterHBaseVersion() {
        return Integer.MAX_VALUE;
    }

    @Override
    public HBaseAdmin getAdmin() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MetaDataProtocol.MetaDataMutationResult updateIndexState(List<Mutation> tableMetadata, String parentTableName) throws SQLException {
        byte[][] rowKeyMetadata = new byte[3][];
        SchemaUtil.getVarChars(tableMetadata.get(0).getRow(), rowKeyMetadata);
        Mutation m = MetaDataUtil.getTableHeaderRow(tableMetadata);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (!MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.INDEX_STATE_BYTES, this.kvBuilder, ptr)) {
            throw new IllegalStateException();
        }
        PIndexState newState = PIndexState.fromSerializedValue(ptr.get()[ptr.getOffset()]);
        byte[] tenantIdBytes = rowKeyMetadata[0];
        String schemaName = Bytes.toString(rowKeyMetadata[1]);
        String indexName = Bytes.toString(rowKeyMetadata[2]);
        String indexTableName = SchemaUtil.getTableName(schemaName, indexName);
        PName tenantId = tenantIdBytes.length == 0 ? null : PNameFactory.newName(tenantIdBytes);
        PTable index = this.metaData.getTable(new PTableKey(tenantId, indexTableName));
        index = PTableImpl.makePTable(index, newState == PIndexState.USABLE ? PIndexState.ACTIVE : (newState == PIndexState.UNUSABLE ? PIndexState.INACTIVE : newState));
        return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, 0L, index);
    }

    @Override
    public HTableDescriptor getTableDescriptor(byte[] tableName) throws SQLException {
        return null;
    }

    @Override
    public void clearTableRegionCache(byte[] tableName) throws SQLException {
    }

    @Override
    public boolean hasInvalidIndexConfiguration() {
        return false;
    }

    @Override
    public long createSequence(String tenantId, String schemaName, String sequenceName, long startWith, long incrementBy, long cacheSize, long timestamp) throws SQLException {
        SequenceKey key = new SequenceKey(tenantId, schemaName, sequenceName);
        if (this.sequenceMap.get(key) != null) {
            throw new SequenceAlreadyExistsException(schemaName, sequenceName);
        }
        this.sequenceMap.put(key, startWith);
        return timestamp;
    }

    @Override
    public long dropSequence(String tenantId, String schemaName, String sequenceName, long timestamp) throws SQLException {
        SequenceKey key = new SequenceKey(tenantId, schemaName, sequenceName);
        if (this.sequenceMap.remove(key) == null) {
            throw new SequenceNotFoundException(schemaName, sequenceName);
        }
        return timestamp;
    }

    @Override
    public void validateSequences(List<SequenceKey> sequenceKeys, long timestamp, long[] values, SQLException[] exceptions, Sequence.Action action) throws SQLException {
        int i = 0;
        for (SequenceKey key : sequenceKeys) {
            Long value = this.sequenceMap.get(key);
            if (value == null) {
                exceptions[i] = new SequenceNotFoundException(key.getSchemaName(), key.getSequenceName());
            } else {
                values[i] = value;
            }
            ++i;
        }
    }

    @Override
    public void incrementSequences(List<SequenceKey> sequenceKeys, long timestamp, long[] values, SQLException[] exceptions) throws SQLException {
        int i = 0;
        for (SequenceKey key : sequenceKeys) {
            Long value = this.sequenceMap.get(key);
            if (value == null) {
                exceptions[i] = new SequenceNotFoundException(key.getSchemaName(), key.getSequenceName());
            } else {
                Long l = value;
                Long l2 = value = Long.valueOf(value + 1L);
                values[i] = l;
            }
            ++i;
        }
        i = 0;
        for (SQLException e : exceptions) {
            if (e != null) {
                this.sequenceMap.remove(sequenceKeys.get(i));
            }
            ++i;
        }
    }

    @Override
    public long currentSequenceValue(SequenceKey sequenceKey, long timestamp) throws SQLException {
        Long value = this.sequenceMap.get(sequenceKey);
        if (value == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CALL_CURRENT_BEFORE_NEXT_VALUE).setSchemaName(sequenceKey.getSchemaName()).setTableName(sequenceKey.getSequenceName()).build().buildException();
        }
        return value;
    }

    @Override
    public void returnSequences(List<SequenceKey> sequenceKeys, long timestamp, SQLException[] exceptions) throws SQLException {
    }

    @Override
    public void addConnection(PhoenixConnection connection) throws SQLException {
    }

    @Override
    public void removeConnection(PhoenixConnection connection) throws SQLException {
    }

    @Override
    public KeyValueBuilder getKeyValueBuilder() {
        return this.kvBuilder;
    }

    @Override
    public boolean supportsFeature(ConnectionQueryServices.Feature feature) {
        return false;
    }
}

