/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.util.ReadOnlyProps;

public class QueryServicesOptions {
    public static final int DEFAULT_KEEP_ALIVE_MS = 60000;
    public static final int DEFAULT_THREAD_POOL_SIZE = 128;
    public static final int DEFAULT_QUEUE_SIZE = 500;
    public static final int DEFAULT_THREAD_TIMEOUT_MS = 600000;
    public static final int DEFAULT_SPOOL_THRESHOLD_BYTES = 0x1400000;
    public static final int DEFAULT_MAX_MEMORY_PERC = 15;
    public static final int DEFAULT_MAX_MEMORY_WAIT_MS = 10000;
    public static final int DEFAULT_MAX_TENANT_MEMORY_PERC = 100;
    public static final long DEFAULT_MAX_SERVER_CACHE_SIZE = 0x6400000L;
    public static final int DEFAULT_TARGET_QUERY_CONCURRENCY = 32;
    public static final int DEFAULT_MAX_QUERY_CONCURRENCY = 64;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final int DEFAULT_STATS_UPDATE_FREQ_MS = 900000;
    public static final int DEFAULT_MAX_STATS_AGE_MS = 86400000;
    public static final boolean DEFAULT_CALL_QUEUE_ROUND_ROBIN = true;
    public static final int DEFAULT_MAX_MUTATION_SIZE = 500000;
    public static final boolean DEFAULT_ROW_KEY_ORDER_SALTED_TABLE = true;
    public static final boolean DEFAULT_USE_INDEXES = true;
    public static final boolean DEFAULT_IMMUTABLE_ROWS = false;
    public static final boolean DEFAULT_DROP_METADATA = true;
    public static final int DEFAULT_MUTATE_BATCH_SIZE = 1000;
    public static final int DEFAULT_MAX_SERVER_CACHE_TIME_TO_LIVE_MS = 30000;
    public static final int DEFAULT_SCAN_CACHE_SIZE = 1000;
    public static final int DEFAULT_MAX_INTRA_REGION_PARALLELIZATION = 64;
    public static final int DEFAULT_DISTINCT_VALUE_COMPRESS_THRESHOLD = 0x100000;
    public static final int DEFAULT_INDEX_MUTATE_BATCH_SIZE_THRESHOLD = 5;
    public static final long DEFAULT_MAX_SPOOL_TO_DISK_BYTES = 1024000000L;
    public static boolean DEFAULT_GROUPBY_SPILLABLE = true;
    public static final int DEFAULT_GROUPBY_SPILL_FILES = 2;
    public static final long DEFAULT_GROUPBY_MAX_CACHE_MAX = 0x6400000L;
    public static final long DEFAULT_SEQUENCE_CACHE_SIZE = 100L;
    public static final int DEFAULT_INDEX_MAX_FILESIZE_PERC = 50;
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_TIME_TO_LIVE_MS = 1800000L;
    public static final long DEFAULT_MAX_SERVER_METADATA_CACHE_SIZE = 0x1400000L;
    public static final long DEFAULT_MAX_CLIENT_METADATA_CACHE_SIZE = 0xA00000L;
    public static final int DEFAULT_GROUPBY_ESTIMATED_DISTINCT_VALUES = 1000;
    private final Configuration config;

    private QueryServicesOptions(Configuration config) {
        this.config = config;
    }

    public ReadOnlyProps getProps() {
        int hbaseRPCTimeOut;
        int threadTimeOutMS = this.config.getInt("phoenix.query.timeoutMs", 600000);
        if (threadTimeOutMS > (hbaseRPCTimeOut = this.config.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT))) {
            this.config.setInt(HConstants.HBASE_RPC_TIMEOUT_KEY, threadTimeOutMS);
        }
        return new ReadOnlyProps(this.config.iterator());
    }

    public QueryServicesOptions setAll(ReadOnlyProps props) {
        for (Map.Entry<String, String> entry : props) {
            this.config.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public static QueryServicesOptions withDefaults() {
        Configuration config = HBaseFactoryProvider.getConfigurationFactory().getConfiguration();
        QueryServicesOptions options = new QueryServicesOptions(config).setIfUnset("phoenix.query.keepAliveMs", 60000).setIfUnset("phoenix.query.threadPoolSize", 128).setIfUnset("phoenix.query.queueSize", 500).setIfUnset("phoenix.query.timeoutMs", 600000).setIfUnset("phoenix.query.spoolThresholdBytes", 0x1400000).setIfUnset("phoenix.query.maxGlobalMemoryPercentage", 15).setIfUnset("phoenix.query.maxGlobalMemoryWaitMs", 10000).setIfUnset("phoenix.query.maxTenantMemoryPercentage", 100).setIfUnset("phoenix.query.maxServerCacheBytes", 0x6400000L).setIfUnset("hbase.client.scanner.caching", 1000).setIfUnset("phoenix.query.targetConcurrency", 32).setIfUnset("phoenix.query.maxConcurrency", 64).setIfUnset("phoenix.query.dateFormat", DEFAULT_DATE_FORMAT).setIfUnset("phoenix.query.statsUpdateFrequency", 900000).setIfUnset("ipc.server.callqueue.roundrobin", true).setIfUnset("phoenix.mutate.maxSize", 500000).setIfUnset("phoenix.query.maxIntraRegionParallelization", 64).setIfUnset("phoenix.query.rowKeyOrderSaltedTable", true).setIfUnset("phoenix.query.useIndexes", true).setIfUnset("phoenix.mutate.immutableRows", false).setIfUnset("phoenix.index.mutableBatchSizeThreshold", 5).setIfUnset("phoenix.query.maxSpoolToDiskBytes", 1024000000L).setIfUnset("phoenix.schema.dropMetaData", true).setIfUnset("phoenix.groupby.spillable", DEFAULT_GROUPBY_SPILLABLE).setIfUnset("phoenix.groupby.maxCacheSize", 0x6400000L).setIfUnset("phoenix.groupby.spillFiles", 2).setIfUnset("phoenix.sequence.cacheSize", 100L);
        int scanCaching = config.getInt("hbase.client.scanner.caching", 0);
        if (scanCaching == 1) {
            config.setInt("hbase.client.scanner.caching", 1000);
        } else if (scanCaching <= 0) {
            config.setInt("hbase.client.scanner.caching", 1);
        }
        return options;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    private QueryServicesOptions setIfUnset(String name, int value) {
        this.config.setIfUnset(name, Integer.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, boolean value) {
        this.config.setIfUnset(name, Boolean.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, long value) {
        this.config.setIfUnset(name, Long.toString(value));
        return this;
    }

    private QueryServicesOptions setIfUnset(String name, String value) {
        this.config.setIfUnset(name, value);
        return this;
    }

    public QueryServicesOptions setKeepAliveMs(int keepAliveMs) {
        return this.set("phoenix.query.keepAliveMs", keepAliveMs);
    }

    public QueryServicesOptions setThreadPoolSize(int threadPoolSize) {
        return this.set("phoenix.query.threadPoolSize", threadPoolSize);
    }

    public QueryServicesOptions setQueueSize(int queueSize) {
        this.config.setInt("phoenix.query.queueSize", queueSize);
        return this;
    }

    public QueryServicesOptions setThreadTimeoutMs(int threadTimeoutMs) {
        return this.set("phoenix.query.timeoutMs", threadTimeoutMs);
    }

    public QueryServicesOptions setSpoolThresholdBytes(int spoolThresholdBytes) {
        return this.set("phoenix.query.spoolThresholdBytes", spoolThresholdBytes);
    }

    public QueryServicesOptions setMaxMemoryPerc(int maxMemoryPerc) {
        return this.set("phoenix.query.maxGlobalMemoryPercentage", maxMemoryPerc);
    }

    public QueryServicesOptions setMaxMemoryWaitMs(int maxMemoryWaitMs) {
        return this.set("phoenix.query.maxGlobalMemoryWaitMs", maxMemoryWaitMs);
    }

    public QueryServicesOptions setMaxTenantMemoryPerc(int maxTenantMemoryPerc) {
        return this.set("phoenix.query.maxTenantMemoryPercentage", maxTenantMemoryPerc);
    }

    public QueryServicesOptions setMaxServerCacheSize(long maxServerCacheSize) {
        return this.set("phoenix.query.maxServerCacheBytes", maxServerCacheSize);
    }

    public QueryServicesOptions setMaxServerMetaDataCacheSize(long maxMetaDataCacheSize) {
        return this.set("phoenix.coprocessor.maxMetaDataCacheSize", maxMetaDataCacheSize);
    }

    public QueryServicesOptions setMaxClientMetaDataCacheSize(long maxMetaDataCacheSize) {
        return this.set("phoenix.client.maxMetaDataCacheSize", maxMetaDataCacheSize);
    }

    public QueryServicesOptions setScanFetchSize(int scanFetchSize) {
        return this.set("hbase.client.scanner.caching", scanFetchSize);
    }

    public QueryServicesOptions setMaxQueryConcurrency(int maxQueryConcurrency) {
        return this.set("phoenix.query.maxConcurrency", maxQueryConcurrency);
    }

    public QueryServicesOptions setTargetQueryConcurrency(int targetQueryConcurrency) {
        return this.set("phoenix.query.targetConcurrency", targetQueryConcurrency);
    }

    public QueryServicesOptions setDateFormat(String dateFormat) {
        return this.set("phoenix.query.dateFormat", dateFormat);
    }

    public QueryServicesOptions setStatsUpdateFrequencyMs(int frequencyMs) {
        return this.set("phoenix.query.statsUpdateFrequency", frequencyMs);
    }

    public QueryServicesOptions setCallQueueRoundRobin(boolean isRoundRobin) {
        return this.set("CALL_QUEUE_PRODUCER", isRoundRobin);
    }

    public QueryServicesOptions setMaxMutateSize(int maxMutateSize) {
        return this.set("phoenix.mutate.maxSize", maxMutateSize);
    }

    public QueryServicesOptions setMutateBatchSize(int mutateBatchSize) {
        return this.set("phoenix.mutate.batchSize", mutateBatchSize);
    }

    public QueryServicesOptions setMaxIntraRegionParallelization(int maxIntraRegionParallelization) {
        return this.set("phoenix.query.maxIntraRegionParallelization", maxIntraRegionParallelization);
    }

    public QueryServicesOptions setRowKeyOrderSaltedTable(boolean rowKeyOrderSaltedTable) {
        return this.set("phoenix.query.rowKeyOrderSaltedTable", rowKeyOrderSaltedTable);
    }

    public QueryServicesOptions setDropMetaData(boolean dropMetadata) {
        return this.set("phoenix.schema.dropMetaData", dropMetadata);
    }

    public QueryServicesOptions setGroupBySpill(boolean enabled) {
        return this.set("phoenix.groupby.spillable", enabled);
    }

    public QueryServicesOptions setGroupBySpillMaxCacheSize(long size) {
        return this.set("phoenix.groupby.maxCacheSize", size);
    }

    public QueryServicesOptions setGroupBySpillNumSpillFiles(long num) {
        return this.set("phoenix.groupby.spillFiles", num);
    }

    private QueryServicesOptions set(String name, boolean value) {
        this.config.set(name, Boolean.toString(value));
        return this;
    }

    private QueryServicesOptions set(String name, int value) {
        this.config.set(name, Integer.toString(value));
        return this;
    }

    private QueryServicesOptions set(String name, String value) {
        this.config.set(name, value);
        return this;
    }

    private QueryServicesOptions set(String name, long value) {
        this.config.set(name, Long.toString(value));
        return this;
    }

    public int getKeepAliveMs() {
        return this.config.getInt("phoenix.query.keepAliveMs", 60000);
    }

    public int getThreadPoolSize() {
        return this.config.getInt("phoenix.query.threadPoolSize", 128);
    }

    public int getQueueSize() {
        return this.config.getInt("phoenix.query.queueSize", 500);
    }

    public int getMaxMemoryPerc() {
        return this.config.getInt("phoenix.query.maxGlobalMemoryPercentage", 15);
    }

    public int getMaxMemoryWaitMs() {
        return this.config.getInt("phoenix.query.maxGlobalMemoryWaitMs", 10000);
    }

    public int getMaxMutateSize() {
        return this.config.getInt("phoenix.mutate.maxSize", 500000);
    }

    public int getMutateBatchSize() {
        return this.config.getInt("phoenix.mutate.batchSize", 1000);
    }

    public int getMaxIntraRegionParallelization() {
        return this.config.getInt("phoenix.query.maxIntraRegionParallelization", 64);
    }

    public boolean isUseIndexes() {
        return this.config.getBoolean("phoenix.query.useIndexes", true);
    }

    public boolean isImmutableRows() {
        return this.config.getBoolean("phoenix.mutate.immutableRows", false);
    }

    public boolean isDropMetaData() {
        return this.config.getBoolean("phoenix.schema.dropMetaData", true);
    }

    public boolean isSpillableGroupByEnabled() {
        return this.config.getBoolean("phoenix.groupby.spillable", DEFAULT_GROUPBY_SPILLABLE);
    }

    public long getSpillableGroupByMaxCacheSize() {
        return this.config.getLong("phoenix.groupby.maxCacheSize", 0x6400000L);
    }

    public int getSpillableGroupByNumSpillFiles() {
        return this.config.getInt("phoenix.groupby.spillFiles", 2);
    }

    public QueryServicesOptions setMaxServerCacheTTLMs(int ttl) {
        return this.set("phoenix.coprocessor.maxServerCacheTimeToLiveMs", ttl);
    }

    public QueryServicesOptions setMasterInfoPort(int port) {
        return this.set("hbase.master.info.port", port);
    }

    public QueryServicesOptions setRegionServerInfoPort(int port) {
        return this.set("hbase.regionserver.info.port", port);
    }

    public QueryServicesOptions setRegionServerLeasePeriodMs(int period) {
        return this.set("hbase.regionserver.lease.period", period);
    }

    public QueryServicesOptions setRpcTimeoutMs(int timeout) {
        return this.set("hbase.rpc.timeout", timeout);
    }

    public QueryServicesOptions setUseIndexes(boolean useIndexes) {
        return this.set("phoenix.query.useIndexes", useIndexes);
    }

    public QueryServicesOptions setImmutableRows(boolean isImmutableRows) {
        return this.set("phoenix.mutate.immutableRows", isImmutableRows);
    }

    public QueryServicesOptions setWALEditCodec(String walEditCodec) {
        return this.set("hbase.regionserver.wal.codec", walEditCodec);
    }
}

