/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.query;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.StatsManager;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.TimeKeeper;

public class StatsManagerImpl
implements StatsManager {
    private final ConnectionQueryServices services;
    private final int statsUpdateFrequencyMs;
    private final int maxStatsAgeMs;
    private final TimeKeeper timeKeeper;
    private final ConcurrentMap<String, PTableStats> tableStatsMap = new ConcurrentHashMap<String, PTableStats>();

    public StatsManagerImpl(ConnectionQueryServices services, int statsUpdateFrequencyMs, int maxStatsAgeMs) {
        this(services, statsUpdateFrequencyMs, maxStatsAgeMs, TimeKeeper.SYSTEM);
    }

    public StatsManagerImpl(ConnectionQueryServices services, int statsUpdateFrequencyMs, int maxStatsAgeMs, TimeKeeper timeKeeper) {
        this.services = services;
        this.statsUpdateFrequencyMs = statsUpdateFrequencyMs;
        this.maxStatsAgeMs = maxStatsAgeMs;
        this.timeKeeper = timeKeeper;
    }

    public long getStatsUpdateFrequency() {
        return this.statsUpdateFrequencyMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateStats(TableRef tableRef) throws SQLException {
        SQLException sqlE = null;
        HTableInterface hTable = this.services.getTable(tableRef.getTable().getPhysicalName().getBytes());
        try {
            byte[] minKey = null;
            byte[] maxKey = null;
            Scan scan = new Scan(HConstants.EMPTY_START_ROW, new KeyOnlyFilter());
            ResultScanner scanner = hTable.getScanner(scan);
            try {
                Result r = scanner.next();
                if (r != null) {
                    minKey = r.getRow();
                }
            }
            finally {
                scanner.close();
            }
            int maxPossibleKeyLength = SchemaUtil.estimateKeyLength(tableRef.getTable());
            byte[] maxPossibleKey = new byte[maxPossibleKeyLength];
            Arrays.fill(maxPossibleKey, (byte)-1);
            Result r = hTable.getRowOrBefore(maxPossibleKey, tableRef.getTable().getColumnFamilies().iterator().next().getName().getBytes());
            if (r != null) {
                maxKey = r.getRow();
            }
            this.tableStatsMap.put(tableRef.getTable().getName().getString(), new PTableStats(this.timeKeeper.getCurrentTime(), minKey, maxKey));
            return;
        }
        catch (IOException e) {
            sqlE = ServerUtil.parseServerException(e);
        }
        finally {
            try {
                hTable.close();
            }
            catch (IOException e) {
                if (sqlE == null) {
                    sqlE = ServerUtil.parseServerException(e);
                }
                sqlE.setNextException(ServerUtil.parseServerException(e));
            }
            finally {
                if (sqlE == null) return;
                throw sqlE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTableStats getStats(final TableRef table) {
        PTableStats stats = (PTableStats)this.tableStatsMap.get(table);
        if (stats == null) {
            PTableStats newStats = new PTableStats();
            stats = this.tableStatsMap.putIfAbsent(table.getTable().getName().getString(), newStats);
            stats = stats == null ? newStats : stats;
        }
        PTableStats pTableStats = stats;
        synchronized (pTableStats) {
            long initiatedTime = stats.getInitiatedTime();
            long currentTime = this.timeKeeper.getCurrentTime();
            if (currentTime - initiatedTime >= this.getStatsUpdateFrequency()) {
                stats.setInitiatedTime(currentTime);
                this.services.getExecutor().submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        StatsManagerImpl.this.updateStats(table);
                        return null;
                    }
                });
            }
            if (currentTime - stats.getCompletedTime() >= (long)this.maxStatsAgeMs) {
                return PTableStats.NO_STATS;
            }
        }
        return stats;
    }

    @Override
    public byte[] getMinKey(TableRef table) {
        PTableStats stats = this.getStats(table);
        return stats.getMinKey();
    }

    @Override
    public byte[] getMaxKey(TableRef table) {
        PTableStats stats = this.getStats(table);
        return stats.getMaxKey();
    }

    @Override
    public void clearStats() throws SQLException {
        this.tableStatsMap.clear();
    }

    private static class PTableStats {
        private static final PTableStats NO_STATS = new PTableStats();
        private long initiatedTime;
        private final long completedTime;
        private final byte[] minKey;
        private final byte[] maxKey;

        public PTableStats() {
            this(-1L, null, null);
        }

        public PTableStats(long completedTime, byte[] minKey, byte[] maxKey) {
            this.minKey = minKey;
            this.maxKey = maxKey;
            this.completedTime = this.initiatedTime = completedTime;
        }

        private byte[] getMinKey() {
            return this.minKey;
        }

        private byte[] getMaxKey() {
            return this.maxKey;
        }

        private long getCompletedTime() {
            return this.completedTime;
        }

        private void setInitiatedTime(long initiatedTime) {
            this.initiatedTime = initiatedTime;
        }

        private long getInitiatedTime() {
            return this.initiatedTime;
        }
    }
}

