/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.http.annotation.Immutable;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

@Immutable
public final class ColumnRef {
    private final TableRef tableRef;
    private final int columnPosition;
    private final int pkSlotPosition;

    public ColumnRef(ColumnRef columnRef, long timeStamp) {
        this.tableRef = new TableRef(columnRef.tableRef, timeStamp);
        this.columnPosition = columnRef.columnPosition;
        this.pkSlotPosition = columnRef.pkSlotPosition;
    }

    public ColumnRef(TableRef tableRef, int columnPosition) {
        if (tableRef == null) {
            throw new NullPointerException();
        }
        if (columnPosition < 0 || columnPosition >= tableRef.getTable().getColumns().size()) {
            throw new IllegalArgumentException("Column position of " + columnPosition + " must be between 0 and " + tableRef.getTable().getColumns().size() + " for table " + tableRef.getTable().getName().getString());
        }
        this.tableRef = tableRef;
        this.columnPosition = columnPosition;
        PColumn column = this.getColumn();
        int i = -1;
        if (SchemaUtil.isPKColumn(column)) {
            for (PColumn pkColumn : tableRef.getTable().getPKColumns()) {
                ++i;
                if (pkColumn != column) continue;
                break;
            }
        }
        this.pkSlotPosition = i;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.columnPosition;
        result = 31 * result + this.tableRef.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnRef other = (ColumnRef)obj;
        if (this.columnPosition != other.columnPosition) {
            return false;
        }
        return this.tableRef.equals(other.tableRef);
    }

    public ColumnExpression newColumnExpression() {
        boolean isIndex;
        PTable table = this.tableRef.getTable();
        PColumn column = this.getColumn();
        boolean bl = isIndex = table.getType() == PTableType.INDEX;
        if (SchemaUtil.isPKColumn(column)) {
            String name = column.getName().getString();
            if (isIndex) {
                name = IndexUtil.getDataColumnName(name);
            }
            return new RowKeyColumnExpression((PDatum)column, new RowKeyValueAccessor(table.getPKColumns(), this.pkSlotPosition), name);
        }
        if (isIndex) {
            String indexColumnName = column.getName().getString();
            String dataFamilyName = IndexUtil.getDataColumnFamilyName(indexColumnName);
            String dataColumnName = IndexUtil.getDataColumnName(indexColumnName);
            String defaultFamilyName = table.getDefaultFamilyName() == null ? "0" : table.getDefaultFamilyName().getString();
            String displayName = SchemaUtil.getColumnDisplayName(defaultFamilyName.equals(dataFamilyName) ? null : dataFamilyName, dataColumnName);
            return new KeyValueColumnExpression(column, displayName);
        }
        if (table.getType() == PTableType.JOIN) {
            return new ProjectedColumnExpression(column, table, column.getName().getString());
        }
        byte[] defaultFamily = table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : table.getDefaultFamilyName().getBytes();
        String displayName = SchemaUtil.getColumnDisplayName(Bytes.compareTo(defaultFamily, column.getFamilyName().getBytes()) == 0 ? null : column.getFamilyName().getBytes(), column.getName().getBytes());
        return new KeyValueColumnExpression(column, displayName);
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public int getPKSlotPosition() {
        return this.pkSlotPosition;
    }

    public PColumn getColumn() {
        return this.tableRef.getTable().getColumns().get(this.columnPosition);
    }

    public PTable getTable() {
        return this.tableRef.getTable();
    }

    public TableRef getTableRef() {
        return this.tableRef;
    }
}

