/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.PostDDLCompiler;
import org.apache.phoenix.compile.PostIndexDDLCompiler;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.parse.AddColumnStatement;
import org.apache.phoenix.parse.AlterIndexStatement;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.CreateIndexStatement;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DropColumnStatement;
import org.apache.phoenix.parse.DropIndexStatement;
import org.apache.phoenix.parse.DropSequenceStatement;
import org.apache.phoenix.parse.DropTableStatement;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.PrimaryKeyConstraint;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.ConcurrentTableMutationException;
import org.apache.phoenix.schema.DelegateColumn;
import org.apache.phoenix.schema.NewerTableAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SequenceAlreadyExistsException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SequenceNotFoundException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataClient {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataClient.class);
    private static final ParseNodeFactory FACTORY = new ParseNodeFactory();
    private static final String CREATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT,SALT_BUCKETS,PK_NAME,DATA_TABLE_NAME,INDEX_STATE,IMMUTABLE_ROWS,DEFAULT_COLUMN_FAMILY,VIEW_STATEMENT,DISABLE_WAL,MULTI_TENANT,VIEW_TYPE,VIEW_INDEX_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CREATE_LINK = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_FAMILY,LINK_TYPE) VALUES (?, ?, ?, ?, ?)";
    private static final String INCREMENT_SEQ_NUM = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_SEQ_NUM) VALUES (?, ?, ?, ?)";
    private static final String MUTATE_TABLE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,TABLE_TYPE,TABLE_SEQ_NUM,COLUMN_COUNT) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String MUTATE_MULTI_TENANT = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,MULTI_TENANT) VALUES (?, ?, ?, ?)";
    private static final String MUTATE_DISABLE_WAL = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,DISABLE_WAL) VALUES (?, ?, ?, ?)";
    private static final String MUTATE_IMMUTABLE_ROWS = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,IMMUTABLE_ROWS) VALUES (?, ?, ?, ?)";
    private static final String UPDATE_INDEX_STATE = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,INDEX_STATE) VALUES (?, ?, ?, ?)";
    private static final String INSERT_COLUMN = "UPSERT INTO SYSTEM.\"CATALOG\"( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,DATA_TYPE,NULLABLE,COLUMN_SIZE,DECIMAL_DIGITS,ORDINAL_POSITION,SORT_ORDER,DATA_TABLE_NAME,ARRAY_SIZE,VIEW_CONSTANT,IS_VIEW_REFERENCED,PK_NAME,KEY_SEQ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_COLUMN_POSITION = "UPSERT INTO SYSTEM.\"CATALOG\" ( TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME,COLUMN_FAMILY,ORDINAL_POSITION) VALUES (?, ?, ?, ?, ?, ?)";
    private final PhoenixConnection connection;

    public MetaDataClient(PhoenixConnection connection) {
        this.connection = connection;
    }

    public PhoenixConnection getConnection() {
        return this.connection;
    }

    public long getCurrentTime(String schemaName, String tableName) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result = this.updateCache(schemaName, tableName, true);
        return result.getMutationTime();
    }

    public MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, String tableName) throws SQLException {
        return this.updateCache(schemaName, tableName, false);
    }

    private MetaDataProtocol.MetaDataMutationResult updateCache(String schemaName, String tableName, boolean alwaysHitServer) throws SQLException {
        MetaDataProtocol.MetaDataMutationResult result;
        Long scn = this.connection.getSCN();
        boolean systemTable = "SYSTEM".equals(schemaName);
        PName tenantId = systemTable ? null : this.connection.getTenantId();
        long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
        PTable table = null;
        String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
        long tableTimestamp = Long.MAX_VALUE;
        try {
            table = this.connection.getMetaDataCache().getTable(new PTableKey(tenantId, fullTableName));
            tableTimestamp = table.getTimeStamp();
        }
        catch (TableNotFoundException e) {
            // empty catch block
        }
        if (table != null && !alwaysHitServer && (systemTable || tableTimestamp == clientTimeStamp - 1L)) {
            return new MetaDataProtocol.MetaDataMutationResult(MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, -1L, table);
        }
        int maxTryCount = tenantId == null ? 1 : 2;
        int tryCount = 0;
        do {
            byte[] schemaBytes = PDataType.VARCHAR.toBytes(schemaName);
            byte[] tableBytes = PDataType.VARCHAR.toBytes(tableName);
            result = this.connection.getQueryServices().getTable(tenantId, schemaBytes, tableBytes, tableTimestamp, clientTimeStamp);
            if ("SYSTEM".equals(schemaName)) {
                return result;
            }
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            PTable resultTable = result.getTable();
            if (resultTable != null) {
                this.connection.addTable(resultTable);
                return result;
            }
            if (table != null) {
                result.setTable(table);
                if (code == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                    return result;
                }
                if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND && tryCount + 1 == maxTryCount) {
                    this.connection.removeTable(tenantId, fullTableName);
                }
            }
            tenantId = null;
        } while (++tryCount < maxTryCount);
        return result;
    }

    private void addColumnMutation(String schemaName, String tableName, PColumn column, PreparedStatement colUpsert, String parentTableName, String pkName, Short keySeq, boolean isSalted) throws SQLException {
        colUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
        colUpsert.setString(2, schemaName);
        colUpsert.setString(3, tableName);
        colUpsert.setString(4, column.getName().getString());
        colUpsert.setString(5, column.getFamilyName() == null ? null : column.getFamilyName().getString());
        colUpsert.setInt(6, column.getDataType().getSqlType());
        colUpsert.setInt(7, column.isNullable() ? 1 : 0);
        if (column.getMaxLength() == null) {
            colUpsert.setNull(8, 4);
        } else {
            colUpsert.setInt(8, column.getMaxLength());
        }
        if (column.getScale() == null) {
            colUpsert.setNull(9, 4);
        } else {
            colUpsert.setInt(9, column.getScale());
        }
        colUpsert.setInt(10, column.getPosition() + (isSalted ? 0 : 1));
        colUpsert.setInt(11, column.getSortOrder().getSystemValue());
        colUpsert.setString(12, parentTableName);
        if (column.getArraySize() == null) {
            colUpsert.setNull(13, 4);
        } else {
            colUpsert.setInt(13, column.getArraySize());
        }
        colUpsert.setBytes(14, column.getViewConstant());
        colUpsert.setBoolean(15, column.isViewReferenced());
        colUpsert.setString(16, pkName);
        if (keySeq == null) {
            colUpsert.setNull(17, 5);
        } else {
            colUpsert.setShort(17, keySeq);
        }
        colUpsert.execute();
    }

    private PColumn newColumn(int position, ColumnDef def, PrimaryKeyConstraint pkConstraint, String defaultColumnFamily, boolean addingToPK) throws SQLException {
        try {
            Pair<ColumnName, SortOrder> pkSortOrder;
            ColumnName columnDefName = def.getColumnDefName();
            SortOrder sortOrder = def.getSortOrder();
            boolean isPK = def.isPK();
            if (pkConstraint != null && (pkSortOrder = pkConstraint.getColumn(columnDefName)) != null) {
                isPK = true;
                sortOrder = pkSortOrder.getSecond();
            }
            String columnName = columnDefName.getColumnName();
            PName familyName = null;
            if (def.isPK() && !pkConstraint.getColumnNames().isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_ALREADY_EXISTS).setColumnName(columnName).build().buildException();
            }
            boolean isNull = def.isNull();
            if (def.getColumnDefName().getFamilyName() != null) {
                String family = def.getColumnDefName().getFamilyName();
                if (isPK) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_WITH_FAMILY_NAME).setColumnName(columnName).setFamilyName(family).build().buildException();
                }
                if (!def.isNull()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.KEY_VALUE_NOT_NULL).setColumnName(columnName).setFamilyName(family).build().buildException();
                }
                familyName = PNameFactory.newName(family);
            } else if (!isPK) {
                familyName = PNameFactory.newName(defaultColumnFamily == null ? "0" : defaultColumnFamily);
            }
            if (isPK && !addingToPK && pkConstraint.getColumnNames().size() <= 1) {
                if (def.isNull() && def.isNullSet()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.SINGLE_PK_MAY_NOT_BE_NULL).setColumnName(columnName).build().buildException();
                }
                isNull = false;
            }
            PColumnImpl column = new PColumnImpl(PNameFactory.newName(columnName), familyName, def.getDataType(), def.getMaxLength(), def.getScale(), isNull, position, sortOrder, def.getArraySize(), null, false);
            return column;
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
    }

    public MutationState createTable(CreateTableStatement statement, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, byte[][] viewColumnConstants, BitSet isViewColumnReferenced) throws SQLException {
        PTable table = this.createTableInternal(statement, splits, parent, viewStatement, viewType, viewColumnConstants, isViewColumnReferenced, null);
        if (table == null || table.getType() == PTableType.VIEW) {
            return new MutationState(0, this.connection);
        }
        PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
        Long scn = this.connection.getSCN();
        long ts = scn == null ? table.getTimeStamp() : scn.longValue();
        TableRef tableRef = new TableRef(null, table, ts, false);
        byte[] emptyCF = SchemaUtil.getEmptyColumnFamily(table);
        MutationPlan plan = compiler.compile(Collections.singletonList(tableRef), emptyCF, null, null, tableRef.getTimeStamp());
        return this.connection.getQueryServices().updateData(plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState buildIndexAtTimeStamp(PTable index, NamedTableNode dataTableNode) throws SQLException {
        block13: {
            Properties props = new Properties(this.connection.getClientInfo());
            props.setProperty("CurrentSCN", Long.toString(this.connection.getSCN() + 1L));
            PhoenixConnection conn = DriverManager.getConnection(this.connection.getURL(), props).unwrap(PhoenixConnection.class);
            MetaDataClient newClientAtNextTimeStamp = new MetaDataClient(conn);
            conn.setAutoCommit(true);
            ColumnResolver resolver = FromCompiler.getResolver(dataTableNode, conn);
            TableRef tableRef = resolver.getTables().get(0);
            boolean success = false;
            SQLException sqlException = null;
            try {
                MutationState state = newClientAtNextTimeStamp.buildIndex(index, tableRef);
                success = true;
                MutationState mutationState = state;
                return mutationState;
            }
            catch (SQLException e) {
                sqlException = e;
                return sqlException;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    if (sqlException == null) {
                        if (success) {
                            sqlException = e;
                        }
                    }
                    sqlException.setNextException(e);
                }
                if (sqlException == null) break block13;
                throw sqlException;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState buildIndex(PTable index, TableRef dataTableRef) throws SQLException {
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            this.connection.setAutoCommit(true);
            PostIndexDDLCompiler compiler = new PostIndexDDLCompiler(this.connection, dataTableRef);
            MutationPlan plan = compiler.compile(index);
            MutationState state = this.connection.getQueryServices().updateData(plan);
            AlterIndexStatement indexStatement = FACTORY.alterIndex(FACTORY.namedTable(null, TableName.create(index.getSchemaName().getString(), index.getTableName().getString())), dataTableRef.getTable().getTableName().getString(), false, PIndexState.ACTIVE);
            this.alterIndex(indexStatement);
            MutationState mutationState = state;
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    public MutationState createIndex(CreateIndexStatement statement, byte[][] splits) throws SQLException {
        PrimaryKeyConstraint pk = statement.getIndexConstraint();
        TableName indexTableName = statement.getIndexTableName();
        List<Pair<ColumnName, SortOrder>> indexedPkColumns = pk.getColumnNames();
        List<ColumnName> includedColumns = statement.getIncludeColumns();
        TableRef tableRef = null;
        PTable table = null;
        boolean retry = true;
        Short viewIndexId = null;
        boolean allocateViewIndexId = false;
        while (true) {
            try {
                ColumnName colName;
                LinkedHashSet<PColumn> unusedPkColumns;
                boolean isTenantConnection;
                ColumnResolver resolver = FromCompiler.getResolverForMutation(statement, this.connection);
                tableRef = resolver.getTables().get(0);
                PTable dataTable = tableRef.getTable();
                boolean bl = isTenantConnection = this.connection.getTenantId() != null;
                if (isTenantConnection && dataTable.getType() != PTableType.VIEW) {
                    throw new SQLFeatureNotSupportedException("An index may only be created for a VIEW through a tenant-specific connection");
                }
                int hbaseVersion = this.connection.getQueryServices().getLowestClusterHBaseVersion();
                if (!dataTable.isImmutableRows()) {
                    if (hbaseVersion < PhoenixDatabaseMetaData.MUTABLE_SI_VERSION_THRESHOLD) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_MUTABLE_INDEXES).setTableName(indexTableName.getTableName()).build().buildException();
                    }
                    if (this.connection.getQueryServices().hasInvalidIndexConfiguration()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_MUTABLE_INDEX_CONFIG).setTableName(indexTableName.getTableName()).build().buildException();
                    }
                }
                int posOffset = 0;
                if (dataTable.getBucketNum() != null) {
                    unusedPkColumns = new LinkedHashSet<PColumn>(dataTable.getPKColumns().subList(1, dataTable.getPKColumns().size()));
                    ++posOffset;
                } else {
                    unusedPkColumns = new LinkedHashSet<PColumn>(dataTable.getPKColumns());
                }
                ArrayList<Pair<ColumnName, SortOrder>> allPkColumns = Lists.newArrayListWithExpectedSize(unusedPkColumns.size());
                ArrayList<ColumnDef> columnDefs = Lists.newArrayListWithExpectedSize(includedColumns.size() + indexedPkColumns.size());
                if (dataTable.isMultiTenant()) {
                    PColumn col = dataTable.getPKColumns().get(posOffset);
                    unusedPkColumns.remove(col);
                    PDataType dataType = IndexUtil.getIndexColumnDataType(col);
                    colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col));
                    allPkColumns.add(new Pair<ColumnName, SortOrder>(colName, col.getSortOrder()));
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), col.isNullable(), col.getMaxLength(), col.getScale(), false, SortOrder.getDefault()));
                }
                if (dataTable.getType() == PTableType.VIEW && dataTable.getViewType() != PTable.ViewType.MAPPED) {
                    allocateViewIndexId = true;
                    PDataType dataType = MetaDataUtil.getViewIndexIdDataType();
                    ColumnName colName2 = ColumnName.caseSensitiveColumnName(MetaDataUtil.getViewIndexIdColumnName());
                    allPkColumns.add(new Pair<ColumnName, SortOrder>(colName2, SortOrder.getDefault()));
                    columnDefs.add(FACTORY.columnDef(colName2, dataType.getSqlTypeName(), false, null, null, false, SortOrder.getDefault()));
                }
                for (Pair<ColumnName, SortOrder> pair : indexedPkColumns) {
                    colName = pair.getFirst();
                    PColumn col = resolver.resolveColumn(null, colName.getFamilyName(), colName.getColumnName()).getColumn();
                    unusedPkColumns.remove(col);
                    if (col.getViewConstant() != null) continue;
                    PDataType dataType = IndexUtil.getIndexColumnDataType(col);
                    colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col));
                    allPkColumns.add(new Pair<ColumnName, SortOrder>(colName, pair.getSecond()));
                    columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), col.isNullable(), col.getMaxLength(), col.getScale(), false, SortOrder.getDefault()));
                }
                if (!unusedPkColumns.isEmpty()) {
                    for (PColumn col : unusedPkColumns) {
                        if (col.getViewConstant() != null) continue;
                        colName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col));
                        allPkColumns.add(new Pair<ColumnName, SortOrder>(colName, col.getSortOrder()));
                        PDataType dataType = IndexUtil.getIndexColumnDataType(col);
                        columnDefs.add(FACTORY.columnDef(colName, dataType.getSqlTypeName(), col.isNullable(), col.getMaxLength(), col.getScale(), false, col.getSortOrder()));
                    }
                }
                pk = FACTORY.primaryKey(null, allPkColumns);
                for (ColumnName colName2 : includedColumns) {
                    PColumn col = resolver.resolveColumn(null, colName2.getFamilyName(), colName2.getColumnName()).getColumn();
                    if (SchemaUtil.isPKColumn(col)) {
                        if (unusedPkColumns.contains(col)) continue;
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_EXIST_IN_DEF).build().buildException();
                    }
                    colName2 = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(col));
                    if (pk.contains(colName2)) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_EXIST_IN_DEF).build().buildException();
                    }
                    if (SchemaUtil.isPKColumn(col) || col.getViewConstant() != null) continue;
                    colName2 = ColumnName.caseSensitiveColumnName(col.getFamilyName().getString(), IndexUtil.getIndexColumnName(col));
                    columnDefs.add(FACTORY.columnDef(colName2, col.getDataType().getSqlTypeName(), col.isNullable(), col.getMaxLength(), col.getScale(), false, col.getSortOrder()));
                }
                if (allocateViewIndexId && viewIndexId == null) {
                    Long scn = this.connection.getSCN();
                    long timestamp = scn == null ? Long.MAX_VALUE : scn;
                    PName tenantId = this.connection.getTenantId();
                    String tenantIdStr = tenantId == null ? null : this.connection.getTenantId().getString();
                    PName physicalName = dataTable.getPhysicalName();
                    SequenceKey key = MetaDataUtil.getViewIndexSequenceKey(tenantIdStr, physicalName);
                    this.createSequence(key.getTenantId(), key.getSchemaName(), key.getSequenceName(), true, -32768L, 1L, 1L, dataTable.getTimeStamp());
                    long[] seqValues = new long[1];
                    SQLException[] sqlExceptions = new SQLException[1];
                    this.connection.getQueryServices().incrementSequences(Collections.singletonList(key), timestamp, seqValues, sqlExceptions);
                    if (sqlExceptions[0] != null) {
                        throw sqlExceptions[0];
                    }
                    long seqValue = seqValues[0];
                    if (seqValue > 32767L) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.TOO_MANY_VIEW_INDEXES).setSchemaName(SchemaUtil.getSchemaNameFromFullName(physicalName.getString())).setTableName(SchemaUtil.getTableNameFromFullName(physicalName.getString())).build().buildException();
                    }
                    viewIndexId = (short)seqValue;
                }
                if (dataTable.getDefaultFamilyName() != null && dataTable.getType() != PTableType.VIEW) {
                    statement.getProps().put("", new Pair<String, String>("DEFAULT_COLUMN_FAMILY", dataTable.getDefaultFamilyName().getString()));
                }
                CreateTableStatement tableStatement = FACTORY.createTable(indexTableName, statement.getProps(), columnDefs, pk, statement.getSplitNodes(), PTableType.INDEX, statement.ifNotExists(), null, null, statement.getBindCount());
                table = this.createTableInternal(tableStatement, splits, dataTable, null, null, null, null, viewIndexId);
            }
            catch (ConcurrentTableMutationException e) {
                if (retry) {
                    retry = false;
                    continue;
                }
                throw e;
            }
            break;
        }
        if (table == null) {
            return new MutationState(0, this.connection);
        }
        if (this.connection.getSCN() != null) {
            return this.buildIndexAtTimeStamp(table, statement.getTable());
        }
        return this.buildIndex(table, tableRef);
    }

    public MutationState dropSequence(DropSequenceStatement statement) throws SQLException {
        Long scn = this.connection.getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        String schemaName = statement.getSequenceName().getSchemaName();
        String sequenceName = statement.getSequenceName().getTableName();
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        try {
            this.connection.getQueryServices().dropSequence(tenantId, schemaName, sequenceName, timestamp);
        }
        catch (SequenceNotFoundException e) {
            if (statement.ifExists()) {
                return new MutationState(0, this.connection);
            }
            throw e;
        }
        return new MutationState(1, this.connection);
    }

    public MutationState createSequence(CreateSequenceStatement statement, long startWith, long incrementBy, long cacheSize) throws SQLException {
        Long scn = this.connection.getSCN();
        long timestamp = scn == null ? Long.MAX_VALUE : scn;
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        return this.createSequence(tenantId, statement.getSequenceName().getSchemaName(), statement.getSequenceName().getTableName(), statement.ifNotExists(), startWith, incrementBy, cacheSize, timestamp);
    }

    private MutationState createSequence(String tenantId, String schemaName, String sequenceName, boolean ifNotExists, long startWith, long incrementBy, long cacheSize, long timestamp) throws SQLException {
        try {
            this.connection.getQueryServices().createSequence(tenantId, schemaName, sequenceName, startWith, incrementBy, cacheSize, timestamp);
        }
        catch (SequenceAlreadyExistsException e) {
            if (ifNotExists) {
                return new MutationState(0, this.connection);
            }
            throw e;
        }
        return new MutationState(1, this.connection);
    }

    private static ColumnDef findColumnDefOrNull(List<ColumnDef> colDefs, ColumnName colName) {
        for (ColumnDef colDef : colDefs) {
            if (!colDef.getColumnDefName().getColumnName().equals(colName.getColumnName())) continue;
            return colDef;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTable createTableInternal(CreateTableStatement statement, byte[][] splits, PTable parent, String viewStatement, PTable.ViewType viewType, final byte[][] viewColumnConstants, final BitSet isViewColumnReferenced, Short viewIndexId) throws SQLException {
        PTableType tableType = statement.getTableType();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.rollback();
        try {
            HTableDescriptor descriptor;
            boolean bl;
            LinkedHashSet<PColumn> pkColumns;
            ArrayList<PColumn> columns;
            this.connection.setAutoCommit(false);
            ArrayList<Mutation> tableMetaData = Lists.newArrayListWithExpectedSize(statement.getColumnDefs().size() + 3);
            TableName tableNameNode = statement.getTableName();
            String schemaName = tableNameNode.getSchemaName();
            String tableName = tableNameNode.getTableName();
            String parentTableName = null;
            PName tenantId = this.connection.getTenantId();
            String tenantIdStr = tenantId == null ? null : this.connection.getTenantId().getString();
            boolean isParentImmutableRows = false;
            boolean multiTenant = false;
            Integer saltBucketNum = null;
            String defaultFamilyName = null;
            boolean isImmutableRows = false;
            List<Object> physicalNames = Collections.emptyList();
            boolean addSaltColumn = false;
            if (parent != null && tableType == PTableType.INDEX) {
                if (parent.getType() == PTableType.VIEW && parent.getViewType() != PTable.ViewType.MAPPED) {
                    PName physicalName = parent.getPhysicalName();
                    saltBucketNum = parent.getBucketNum();
                    addSaltColumn = saltBucketNum != null;
                    defaultFamilyName = parent.getDefaultFamilyName() == null ? null : parent.getDefaultFamilyName().getString();
                    physicalNames = Collections.singletonList(PNameFactory.newName(MetaDataUtil.getViewIndexPhysicalName(physicalName.getBytes())));
                }
                multiTenant = parent.isMultiTenant();
                isParentImmutableRows = parent.isImmutableRows();
                parentTableName = parent.getTableName().getString();
                PreparedStatement incrementStatement = this.connection.prepareStatement(INCREMENT_SEQ_NUM);
                incrementStatement.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                incrementStatement.setString(2, schemaName);
                incrementStatement.setString(3, parentTableName);
                incrementStatement.setLong(4, parent.getSequenceNumber());
                incrementStatement.execute();
                tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                this.connection.rollback();
                PreparedStatement linkStatement = this.connection.prepareStatement(CREATE_LINK);
                linkStatement.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                linkStatement.setString(2, schemaName);
                linkStatement.setString(3, parentTableName);
                linkStatement.setString(4, tableName);
                linkStatement.setByte(5, PTable.LinkType.INDEX_TABLE.getSerializedValue());
                linkStatement.execute();
            }
            PrimaryKeyConstraint pkConstraint = statement.getPrimaryKeyConstraint();
            String pkName = null;
            List<Object> pkColumnsNames = Collections.emptyList();
            Iterator<Object> pkColumnsIterator = Iterators.emptyIterator();
            if (pkConstraint != null) {
                pkColumnsNames = pkConstraint.getColumnNames();
                pkColumnsIterator = pkColumnsNames.iterator();
                pkName = pkConstraint.getName();
            }
            HashMap<String, Object> tableProps = Maps.newHashMapWithExpectedSize(statement.getProps().size());
            Map commonFamilyProps = Collections.emptyMap();
            HColumnDescriptor defaultDescriptor = new HColumnDescriptor(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES);
            if (!statement.getProps().isEmpty()) {
                commonFamilyProps = Maps.newHashMapWithExpectedSize(statement.getProps().size());
                List<Pair<String, Object>> props = statement.getProps().get("");
                for (Pair pair : props) {
                    if (defaultDescriptor.getValue((String)pair.getFirst()) == null) {
                        tableProps.put((String)pair.getFirst(), pair.getSecond());
                        continue;
                    }
                    commonFamilyProps.put(pair.getFirst(), pair.getSecond());
                }
            }
            if (tableType != PTableType.INDEX && (tableType != PTableType.VIEW || viewType == PTable.ViewType.MAPPED)) {
                Boolean isImmutableRowsProp = (Boolean)tableProps.remove("IMMUTABLE_ROWS");
                isImmutableRows = isImmutableRowsProp == null ? this.connection.getQueryServices().getProps().getBoolean("phoenix.mutate.immutableRows", false) : isImmutableRowsProp.booleanValue();
            }
            if (tableType != PTableType.VIEW && viewIndexId == null) {
                saltBucketNum = (Integer)tableProps.remove("SALT_BUCKETS");
                if (saltBucketNum != null && (saltBucketNum < 0 || saltBucketNum > SaltingUtil.MAX_BUCKET_NUM)) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_BUCKET_NUM).build().buildException();
                }
                if (saltBucketNum == null) {
                    if (parent != null) {
                        saltBucketNum = parent.getBucketNum();
                    }
                } else if (saltBucketNum == 0) {
                    saltBucketNum = null;
                }
                addSaltColumn = saltBucketNum != null;
            }
            boolean removedProp = false;
            if (tableType != PTableType.INDEX && (tableType != PTableType.VIEW || viewType == PTable.ViewType.MAPPED)) {
                Boolean multiTenantProp = (Boolean)tableProps.remove("MULTI_TENANT");
                multiTenant = Boolean.TRUE.equals(multiTenantProp);
                defaultFamilyName = (String)tableProps.remove("DEFAULT_COLUMN_FAMILY");
                removedProp = defaultFamilyName != null;
            }
            boolean disableWAL = false;
            Boolean bl2 = (Boolean)tableProps.remove("DISABLE_WAL");
            disableWAL = bl2 == null ? isParentImmutableRows : bl2;
            if (!(statement.getTableType() != PTableType.VIEW && viewIndexId == null || tableProps.isEmpty())) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
            }
            if (removedProp) {
                tableProps.put("DEFAULT_COLUMN_FAMILY", defaultFamilyName);
            }
            List<ColumnDef> colDefs = statement.getColumnDefs();
            if (tenantId != null && tableType != PTableType.VIEW && viewIndexId == null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CREATE_TENANT_SPECIFIC_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (tableType == PTableType.VIEW) {
                physicalNames = Collections.singletonList(PNameFactory.newName(parent.getPhysicalName().getString()));
                if (viewType == PTable.ViewType.MAPPED) {
                    columns = Lists.newArrayListWithExpectedSize(colDefs.size());
                    pkColumns = Sets.newLinkedHashSetWithExpectedSize(colDefs.size());
                } else {
                    multiTenant = parent.isMultiTenant();
                    saltBucketNum = parent.getBucketNum();
                    isImmutableRows = parent.isImmutableRows();
                    disableWAL = bl2 == null ? parent.isWALDisabled() : bl2.booleanValue();
                    defaultFamilyName = parent.getDefaultFamilyName() == null ? null : parent.getDefaultFamilyName().getString();
                    List<PColumn> allColumns = parent.getColumns();
                    if (saltBucketNum != null) {
                        allColumns = allColumns.subList(1, allColumns.size());
                    }
                    columns = Lists.newArrayListWithExpectedSize(allColumns.size() + colDefs.size());
                    columns.addAll(allColumns);
                    pkColumns = Sets.newLinkedHashSet(parent.getPKColumns());
                }
            } else {
                columns = Lists.newArrayListWithExpectedSize(colDefs.size());
                pkColumns = Sets.newLinkedHashSetWithExpectedSize(colDefs.size() + 1);
            }
            if (!(physicalNames.isEmpty() || viewType == PTable.ViewType.MAPPED && ((PName)physicalNames.get(0)).getString().equals(SchemaUtil.getTableName(schemaName, tableName)))) {
                PreparedStatement linkStatement = this.connection.prepareStatement(CREATE_LINK);
                for (PName pName : physicalNames) {
                    linkStatement.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                    linkStatement.setString(2, schemaName);
                    linkStatement.setString(3, tableName);
                    linkStatement.setString(4, pName.getString());
                    linkStatement.setByte(5, PTable.LinkType.PHYSICAL_TABLE.getSerializedValue());
                    linkStatement.execute();
                }
            }
            PreparedStatement colUpsert = this.connection.prepareStatement(INSERT_COLUMN);
            LinkedHashMap<String, PName> familyNames = Maps.newLinkedHashMap();
            boolean bl3 = false;
            int positionOffset = columns.size();
            if (saltBucketNum != null) {
                ++positionOffset;
                if (addSaltColumn) {
                    pkColumns.add(SaltingUtil.SALTING_COLUMN);
                }
            }
            int position = positionOffset;
            for (ColumnDef colDef : colDefs) {
                PColumn column;
                if (colDef.isPK()) {
                    if (bl) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_ALREADY_EXISTS).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                    }
                    bl = true;
                }
                if (SchemaUtil.isPKColumn(column = this.newColumn(position++, colDef, pkConstraint, defaultFamilyName, false))) {
                    if (pkColumnsIterator.hasNext() && !column.getName().getString().equals(((ColumnName)((Pair)pkColumnsIterator.next()).getFirst()).getColumnName())) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_OUT_OF_ORDER).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                    }
                    if (tableType == PTableType.VIEW && viewType != PTable.ViewType.MAPPED) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_DEFINE_PK_FOR_VIEW).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                    }
                    if (!pkColumns.add(column)) {
                        throw new ColumnAlreadyExistsException(schemaName, tableName, column.getName().getString());
                    }
                }
                if (tableType == PTableType.VIEW && MetaDataClient.hasColumnWithSameNameAndFamily(columns, column)) {
                    throw new ColumnAlreadyExistsException(schemaName, tableName, column.getName().getString());
                }
                columns.add(column);
                if ((colDef.getDataType() == PDataType.VARBINARY || colDef.getDataType().isArrayType()) && SchemaUtil.isPKColumn(column) && pkColumnsIterator.hasNext()) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_IN_ROW_KEY).setSchemaName(schemaName).setTableName(tableName).setColumnName(column.getName().getString()).build().buildException();
                }
                if (column.getFamilyName() == null) continue;
                familyNames.put(column.getFamilyName().getString(), column.getFamilyName());
            }
            if (!bl && pkColumnsNames.isEmpty() && tableType != PTableType.VIEW && viewType != PTable.ViewType.MAPPED) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            if (!pkColumnsNames.isEmpty() && pkColumnsNames.size() != pkColumns.size() - positionOffset) {
                Iterator<Object> pkColumnNamesIterator = pkColumnsNames.iterator();
                while (pkColumnNamesIterator.hasNext()) {
                    ColumnName colName = (ColumnName)((Pair)pkColumnNamesIterator.next()).getFirst();
                    ColumnDef colDef = MetaDataClient.findColumnDefOrNull(colDefs, colName);
                    if (colDef == null) {
                        throw new ColumnNotFoundException(schemaName, tableName, null, colName.getColumnName());
                    }
                    if (colDef.getColumnDefName().getFamilyName() == null) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_WITH_FAMILY_NAME).setSchemaName(schemaName).setTableName(tableName).setColumnName(colDef.getColumnDefName().getColumnName()).setFamilyName(colDef.getColumnDefName().getFamilyName()).build().buildException();
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_PRIMARY_KEY_CONSTRAINT).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            ArrayList<Pair<byte[], Map<String, Object>>> familyPropList = Lists.newArrayListWithExpectedSize(familyNames.size());
            if (!statement.getProps().isEmpty()) {
                for (Object familyName : statement.getProps().keySet()) {
                    if (((String)familyName).equals("")) continue;
                    if (familyNames.get(familyName) == null) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.PROPERTIES_FOR_FAMILY).setFamilyName((String)familyName).build().buildException();
                    }
                    if (statement.getTableType() != PTableType.VIEW) continue;
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.VIEW_WITH_PROPERTIES).build().buildException();
                }
            }
            MetaDataClient.throwIfInsufficientColumns(schemaName, tableName, pkColumns, saltBucketNum != null, multiTenant);
            for (Object familyName : familyNames.values()) {
                List<Pair<String, Object>> props = statement.getProps().get(familyName.getString());
                if (props.isEmpty()) {
                    familyPropList.add(new Pair(familyName.getBytes(), commonFamilyProps));
                    continue;
                }
                HashMap combinedFamilyProps = Maps.newHashMapWithExpectedSize(props.size() + commonFamilyProps.size());
                combinedFamilyProps.putAll(commonFamilyProps);
                for (Pair pair : props) {
                    combinedFamilyProps.put(pair.getFirst(), pair.getSecond());
                }
                familyPropList.add(new Pair(familyName.getBytes(), combinedFamilyProps));
            }
            if (SchemaUtil.isMetaTable(schemaName, tableName)) {
                PTableImpl table = PTableImpl.makePTable(tenantId, PNameFactory.newName(schemaName), PNameFactory.newName(tableName), tableType, null, 0L, 0L, PNameFactory.newName("pk"), null, columns, null, Collections.<PTable>emptyList(), isImmutableRows, Collections.<PName>emptyList(), defaultFamilyName == null ? null : PNameFactory.newName(defaultFamilyName), null, Boolean.TRUE.equals(disableWAL), false, null, viewIndexId);
                this.connection.addTable(table);
            } else if (tableType == PTableType.INDEX && viewIndexId == null && tableProps.get("MAX_FILESIZE") == null) {
                int nIndexRowKeyColumns = bl ? 1 : pkColumnsNames.size();
                int nIndexKeyValueColumns = columns.size() - nIndexRowKeyColumns;
                int nBaseRowKeyColumns = parent.getPKColumns().size() - (parent.getBucketNum() == null ? 0 : 1);
                int nBaseKeyValueColumns = parent.getColumns().size() - parent.getPKColumns().size();
                double ratio = ((double)(1 + nIndexKeyValueColumns) + (double)(nIndexRowKeyColumns - nBaseRowKeyColumns) / 4.0) / (double)(1 + nBaseKeyValueColumns);
                descriptor = this.connection.getQueryServices().getTableDescriptor(parent.getPhysicalName().getBytes());
                if (descriptor != null) {
                    long maxFileSize = descriptor.getMaxFileSize();
                    if (maxFileSize == -1L) {
                        maxFileSize = 0x280000000L;
                    }
                    tableProps.put("MAX_FILESIZE", (long)((double)maxFileSize * ratio));
                }
            }
            short nextKeySeq = 0;
            for (int i = 0; i < columns.size(); ++i) {
                Short s;
                PColumn column = (PColumn)columns.get(i);
                final int columnPosition = column.getPosition();
                if (isViewColumnReferenced != null) {
                    if (viewColumnConstants != null && columnPosition < viewColumnConstants.length) {
                        column = new DelegateColumn(column){

                            @Override
                            public byte[] getViewConstant() {
                                return viewColumnConstants[columnPosition];
                            }

                            @Override
                            public boolean isViewReferenced() {
                                return isViewColumnReferenced.get(columnPosition);
                            }
                        };
                        columns.set(i, column);
                    } else {
                        column = new DelegateColumn(column){

                            @Override
                            public boolean isViewReferenced() {
                                return isViewColumnReferenced.get(columnPosition);
                            }
                        };
                        columns.set(i, column);
                    }
                }
                if (SchemaUtil.isPKColumn(column)) {
                    nextKeySeq = (short)(nextKeySeq + 1);
                    s = nextKeySeq;
                } else {
                    s = null;
                }
                Short keySeq = s;
                this.addColumnMutation(schemaName, tableName, column, colUpsert, parentTableName, pkName, keySeq, saltBucketNum != null);
            }
            tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
            this.connection.rollback();
            String dataTableName = parent == null || tableType == PTableType.VIEW ? null : parent.getTableName().getString();
            PIndexState indexState = parent == null || tableType == PTableType.VIEW ? null : PIndexState.BUILDING;
            PreparedStatement tableUpsert = this.connection.prepareStatement(CREATE_TABLE);
            tableUpsert.setString(1, tenantIdStr);
            tableUpsert.setString(2, schemaName);
            tableUpsert.setString(3, tableName);
            tableUpsert.setString(4, tableType.getSerializedValue());
            tableUpsert.setLong(5, 0L);
            tableUpsert.setInt(6, position);
            if (saltBucketNum != null) {
                tableUpsert.setInt(7, saltBucketNum);
            } else {
                tableUpsert.setNull(7, 4);
            }
            tableUpsert.setString(8, pkName);
            tableUpsert.setString(9, dataTableName);
            tableUpsert.setString(10, indexState == null ? null : indexState.getSerializedValue());
            tableUpsert.setBoolean(11, isImmutableRows);
            tableUpsert.setString(12, defaultFamilyName);
            tableUpsert.setString(13, viewStatement);
            tableUpsert.setBoolean(14, disableWAL);
            tableUpsert.setBoolean(15, multiTenant);
            if (viewType == null) {
                tableUpsert.setNull(16, -6);
            } else {
                tableUpsert.setByte(16, viewType.getSerializedValue());
            }
            if (viewIndexId == null) {
                tableUpsert.setNull(17, 5);
            } else {
                tableUpsert.setShort(17, viewIndexId);
            }
            tableUpsert.execute();
            tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
            this.connection.rollback();
            Collections.reverse(tableMetaData);
            splits = SchemaUtil.processSplits(splits, pkColumns, saltBucketNum, this.connection.getQueryServices().getProps().getBoolean("phoenix.query.rowKeyOrderSaltedTable", true));
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().createTable(tableMetaData, viewType == PTable.ViewType.MAPPED || viewIndexId != null ? ((PName)physicalNames.get(0)).getBytes() : null, tableType, tableProps, familyPropList, splits);
            MetaDataProtocol.MutationCode mutationCode = result.getMutationCode();
            switch (mutationCode) {
                case TABLE_ALREADY_EXISTS: {
                    this.connection.addTable(result.getTable());
                    if (!statement.ifNotExists()) {
                        throw new TableAlreadyExistsException(schemaName, tableName);
                    }
                    descriptor = null;
                    return descriptor;
                }
                case PARENT_TABLE_NOT_FOUND: {
                    throw new TableNotFoundException(schemaName, parent.getName().getString());
                }
                case NEWER_TABLE_FOUND: {
                    throw new NewerTableAlreadyExistsException(schemaName, tableName);
                }
                case UNALLOWED_TABLE_MUTATION: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                case CONCURRENT_TABLE_MUTATION: {
                    this.connection.addTable(result.getTable());
                    throw new ConcurrentTableMutationException(schemaName, tableName);
                }
            }
            PTableImpl table = PTableImpl.makePTable(tenantId, PNameFactory.newName(schemaName), PNameFactory.newName(tableName), tableType, indexState, result.getMutationTime(), 0L, pkName == null ? null : PNameFactory.newName(pkName), saltBucketNum, columns, dataTableName == null ? null : PNameFactory.newName(dataTableName), Collections.<PTable>emptyList(), isImmutableRows, physicalNames, defaultFamilyName == null ? null : PNameFactory.newName(defaultFamilyName), viewStatement, Boolean.TRUE.equals(disableWAL), multiTenant, viewType, viewIndexId);
            this.connection.addTable(table);
            PTableImpl pTableImpl = table;
            return pTableImpl;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private static boolean hasColumnWithSameNameAndFamily(Collection<PColumn> columns, PColumn column) {
        for (PColumn currColumn : columns) {
            if (!Objects.equal(currColumn.getFamilyName(), column.getFamilyName()) || !Objects.equal(currColumn.getName(), column.getName())) continue;
            return true;
        }
        return false;
    }

    private static void throwIfInsufficientColumns(String schemaName, String tableName, Collection<PColumn> columns, boolean isSalted, boolean isMultiTenant) throws SQLException {
        PColumn tenantIdCol;
        if (!isMultiTenant) {
            return;
        }
        int nPKColumns = columns.size() - (isSalted ? 1 : 0);
        if (nPKColumns < 2) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
        Iterator<PColumn> iterator = columns.iterator();
        if (isSalted) {
            iterator.next();
        }
        if (!(tenantIdCol = iterator.next()).getDataType().isCoercibleTo(PDataType.VARCHAR) || tenantIdCol.isNullable()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS).setSchemaName(schemaName).setTableName(tableName).build().buildException();
        }
    }

    public MutationState dropTable(DropTableStatement statement) throws SQLException {
        String schemaName = statement.getTableName().getSchemaName();
        String tableName = statement.getTableName().getTableName();
        return this.dropTable(schemaName, tableName, null, statement.getTableType(), statement.ifExists());
    }

    public MutationState dropIndex(DropIndexStatement statement) throws SQLException {
        String schemaName = statement.getTableName().getSchemaName();
        String tableName = statement.getIndexName().getName();
        String parentTableName = statement.getTableName().getTableName();
        return this.dropTable(schemaName, tableName, parentTableName, PTableType.INDEX, statement.ifExists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MutationState dropTable(String schemaName, String tableName, String parentTableName, PTableType tableType, boolean ifExists) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            PName tenantId = this.connection.getTenantId();
            String tenantIdStr = tenantId == null ? null : tenantId.getString();
            byte[] key = SchemaUtil.getTableKey(tenantIdStr, schemaName, tableName);
            Long scn = this.connection.getSCN();
            long clientTimeStamp = scn == null ? Long.MAX_VALUE : scn;
            ArrayList<Mutation> tableMetaData = Lists.newArrayListWithExpectedSize(2);
            Delete tableDelete = new Delete(key, clientTimeStamp);
            tableMetaData.add(tableDelete);
            if (parentTableName != null) {
                byte[] linkKey = MetaDataUtil.getParentLinkKey(tenantIdStr, schemaName, parentTableName, tableName);
                Delete linkDelete = new Delete(linkKey, clientTimeStamp);
                tableMetaData.add(linkDelete);
            }
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().dropTable(tableMetaData, tableType);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            switch (code) {
                case TABLE_NOT_FOUND: {
                    if (ifExists) break;
                    throw new TableNotFoundException(schemaName, tableName);
                }
                case NEWER_TABLE_FOUND: {
                    throw new NewerTableAlreadyExistsException(schemaName, tableName);
                }
                case UNALLOWED_TABLE_MUTATION: {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                }
                default: {
                    try {
                        this.connection.removeTable(tenantId, tableName);
                    }
                    catch (TableNotFoundException ignore) {
                        // empty catch block
                    }
                    boolean dropMetaData = this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true);
                    if (result.getTable() == null || tableType == PTableType.VIEW) break;
                    this.connection.setAutoCommit(true);
                    PTable table = result.getTable();
                    long ts = scn == null ? result.getMutationTime() : scn.longValue();
                    ArrayList<TableRef> tableRefs = Lists.newArrayListWithExpectedSize(2 + table.getIndexes().size());
                    if (tableType == PTableType.TABLE && (table.isMultiTenant() || MetaDataUtil.hasViewIndexTable(this.connection, table.getPhysicalName()))) {
                        MetaDataUtil.deleteViewIndexSequences(this.connection, table.getPhysicalName());
                        if (!dropMetaData) {
                            String viewIndexSchemaName = MetaDataUtil.getViewIndexSchemaName(schemaName);
                            String viewIndexTableName = MetaDataUtil.getViewIndexTableName(tableName);
                            PTableImpl viewIndexTable = new PTableImpl(null, viewIndexSchemaName, viewIndexTableName, ts, table.getColumnFamilies());
                            tableRefs.add(new TableRef(null, viewIndexTable, ts, false));
                        }
                    }
                    if (dropMetaData) break;
                    tableRefs.add(new TableRef(null, table, ts, false));
                    for (PTable index : table.getIndexes()) {
                        tableRefs.add(new TableRef(null, index, ts, false));
                    }
                    MutationPlan plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.<PColumn>emptyList(), ts);
                    MutationState mutationState = this.connection.getQueryServices().updateData(plan);
                    return mutationState;
                }
            }
            MutationState mutationState = new MutationState(0, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private MetaDataProtocol.MutationCode processMutationResult(String schemaName, String tableName, MetaDataProtocol.MetaDataMutationResult result) throws SQLException {
        MetaDataProtocol.MutationCode mutationCode = result.getMutationCode();
        PName tenantId = this.connection.getTenantId();
        switch (mutationCode) {
            case TABLE_NOT_FOUND: {
                this.connection.removeTable(tenantId, tableName);
                throw new TableNotFoundException(schemaName, tableName);
            }
            case UNALLOWED_TABLE_MUTATION: {
                String columnName = null;
                String familyName = null;
                String msg = null;
                if (result.getColumnName() != null) {
                    familyName = result.getFamilyName() == null ? null : Bytes.toString(result.getFamilyName());
                    columnName = Bytes.toString(result.getColumnName());
                    msg = "Cannot drop column referenced by VIEW";
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MUTATE_TABLE).setSchemaName(schemaName).setTableName(tableName).setFamilyName(familyName).setColumnName(columnName).setMessage(msg).build().buildException();
            }
            case COLUMN_ALREADY_EXISTS: 
            case COLUMN_NOT_FOUND: {
                break;
            }
            case CONCURRENT_TABLE_MUTATION: {
                this.connection.addTable(result.getTable());
                if (logger.isDebugEnabled()) {
                    logger.debug("CONCURRENT_TABLE_MUTATION for table " + SchemaUtil.getTableName(schemaName, tableName));
                }
                throw new ConcurrentTableMutationException(schemaName, tableName);
            }
            case NEWER_TABLE_FOUND: {
                if (result.getTable() != null) {
                    this.connection.addTable(result.getTable());
                }
                throw new NewerTableAlreadyExistsException(schemaName, tableName);
            }
            case NO_PK_COLUMNS: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setSchemaName(schemaName).setTableName(tableName).build().buildException();
            }
            case TABLE_ALREADY_EXISTS: {
                break;
            }
            default: {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.UNEXPECTED_MUTATION_CODE).setSchemaName(schemaName).setTableName(tableName).setMessage("mutation code: " + (Object)((Object)mutationCode)).build().buildException();
            }
        }
        return mutationCode;
    }

    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta) throws SQLException {
        return this.incrementTableSeqNum(table, expectedType, columnCountDelta, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementTableSeqNum(PTable table, PTableType expectedType, int columnCountDelta, Boolean isImmutableRows, Boolean disableWAL, Boolean isMultiTenant) throws SQLException {
        PreparedStatement tableBoolUpsert;
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        int totalColumnCount = table.getColumns().size() + (table.getBucketNum() == null ? 0 : -1);
        long seqNum = table.getSequenceNumber() + 1L;
        PreparedStatement tableUpsert = this.connection.prepareStatement(MUTATE_TABLE);
        String tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString();
        try {
            tableUpsert.setString(1, tenantId);
            tableUpsert.setString(2, schemaName);
            tableUpsert.setString(3, tableName);
            tableUpsert.setString(4, expectedType.getSerializedValue());
            tableUpsert.setLong(5, seqNum);
            tableUpsert.setInt(6, totalColumnCount + columnCountDelta);
            tableUpsert.execute();
        }
        finally {
            tableUpsert.close();
        }
        if (isImmutableRows != null) {
            tableBoolUpsert = this.connection.prepareStatement(MUTATE_IMMUTABLE_ROWS);
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            tableBoolUpsert.setBoolean(4, isImmutableRows);
            tableBoolUpsert.execute();
        }
        if (disableWAL != null) {
            tableBoolUpsert = this.connection.prepareStatement(MUTATE_DISABLE_WAL);
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            tableBoolUpsert.setBoolean(4, disableWAL);
            tableBoolUpsert.execute();
        }
        if (isMultiTenant != null) {
            tableBoolUpsert = this.connection.prepareStatement(MUTATE_MULTI_TENANT);
            tableBoolUpsert.setString(1, tenantId);
            tableBoolUpsert.setString(2, schemaName);
            tableBoolUpsert.setString(3, tableName);
            tableBoolUpsert.setBoolean(4, isMultiTenant);
            tableBoolUpsert.execute();
        }
        return seqNum;
    }

    public MutationState addColumn(AddColumnStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            this.connection.setAutoCommit(false);
            PName tenantId = this.connection.getTenantId();
            TableName tableNameNode = statement.getTable().getName();
            String schemaName = tableNameNode.getSchemaName();
            String tableName = tableNameNode.getTableName();
            Boolean isImmutableRowsProp = (Boolean)statement.getProps().remove("IMMUTABLE_ROWS");
            Boolean multiTenantProp = (Boolean)statement.getProps().remove("MULTI_TENANT");
            Boolean disableWALProp = (Boolean)statement.getProps().remove("DISABLE_WAL");
            boolean retried = false;
            while (true) {
                Long scn;
                MetaDataProtocol.MetaDataMutationResult result;
                byte[] projectCF;
                byte[] emptyCF;
                Boolean multiTenant;
                PTable table;
                block48: {
                    Object indexColDataType;
                    ArrayList<Mutation> tableMetaData = Lists.newArrayListWithExpectedSize(2);
                    ColumnResolver resolver = FromCompiler.getResolverForMutation(statement, this.connection);
                    table = resolver.getTables().get(0).getTable();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Resolved table to " + table.getName().getString() + " with seqNum " + table.getSequenceNumber() + " at timestamp " + table.getTimeStamp() + " with " + table.getColumns().size() + " columns: " + table.getColumns());
                    }
                    int position = table.getColumns().size();
                    List<PColumn> currentPKs = table.getPKColumns();
                    PColumn lastPK = currentPKs.get(currentPKs.size() - 1);
                    if (lastPK.getDataType() == PDataType.VARBINARY || lastPK.getDataType().isArrayType()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.VARBINARY_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                    }
                    if (lastPK.isNullable() && lastPK.getDataType().isFixedWidth()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.NULLABLE_FIXED_WIDTH_LAST_PK).setColumnName(lastPK.getName().getString()).build().buildException();
                    }
                    Boolean isImmutableRows = null;
                    if (isImmutableRowsProp != null && isImmutableRowsProp.booleanValue() != table.isImmutableRows()) {
                        isImmutableRows = isImmutableRowsProp;
                    }
                    multiTenant = null;
                    if (multiTenantProp != null && multiTenantProp.booleanValue() != table.isMultiTenant()) {
                        multiTenant = multiTenantProp;
                    }
                    Boolean disableWAL = null;
                    if (disableWALProp != null && disableWALProp.booleanValue() != table.isWALDisabled()) {
                        disableWAL = disableWALProp;
                    }
                    if (statement.getProps().get("SALT_BUCKETS") != null) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.SALT_ONLY_ON_CREATE_TABLE).setTableName(table.getName().getString()).build().buildException();
                    }
                    if (statement.getProps().get("DEFAULT_COLUMN_FAMILY") != null) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.DEFAULT_COLUMN_FAMILY_ONLY_ON_CREATE_TABLE).setTableName(table.getName().getString()).build().buildException();
                    }
                    boolean isAddingPKColumn = false;
                    PreparedStatement colUpsert = this.connection.prepareStatement(INSERT_COLUMN);
                    List<ColumnDef> columnDefs = statement.getColumnDefs();
                    if (columnDefs == null) {
                        columnDefs = Lists.newArrayListWithExpectedSize(1);
                    }
                    ArrayList<Pair<byte[], Map<String, Object>>> families = Lists.newArrayList();
                    ArrayList<PColumn> columns = Lists.newArrayListWithExpectedSize(columnDefs.size());
                    if (columnDefs.size() > 0) {
                        if (isImmutableRowsProp != null || multiTenantProp != null) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.SET_UNSUPPORTED_PROP_ON_ALTER_TABLE).setTableName(table.getName().getString()).build().buildException();
                        }
                        short nextKeySeq = SchemaUtil.getMaxKeySeq(table);
                        for (ColumnDef colDef : columnDefs) {
                            if (colDef != null && !colDef.isNull()) {
                                if (colDef.isPK()) {
                                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NOT_NULLABLE_COLUMN_IN_ROW_KEY).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                                }
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_ADD_NOT_NULLABLE_COLUMN).setColumnName(colDef.getColumnDefName().getColumnName()).build().buildException();
                            }
                            this.throwIfAlteringViewPK(colDef, table);
                            PColumn column = this.newColumn(position++, colDef, PrimaryKeyConstraint.EMPTY, table.getDefaultFamilyName() == null ? null : table.getDefaultFamilyName().getString(), true);
                            columns.add(column);
                            String pkName = null;
                            Short keySeq = null;
                            if (column.getFamilyName() == null) {
                                isAddingPKColumn = true;
                                pkName = table.getPKName() == null ? null : table.getPKName().getString();
                                nextKeySeq = (short)(nextKeySeq + 1);
                                keySeq = nextKeySeq;
                            } else {
                                families.add(new Pair<byte[], Map<String, Object>>(column.getFamilyName().getBytes(), statement.getProps()));
                            }
                            this.addColumnMutation(schemaName, tableName, column, colUpsert, null, pkName, keySeq, table.getBucketNum() != null);
                        }
                        if (isAddingPKColumn) {
                            for (PTable index : table.getIndexes()) {
                                short nextIndexKeySeq = SchemaUtil.getMaxKeySeq(index);
                                int indexPosition = index.getColumns().size();
                                for (ColumnDef colDef : columnDefs) {
                                    if (!colDef.isPK()) continue;
                                    indexColDataType = IndexUtil.getIndexColumnDataType(colDef.isNull(), colDef.getDataType());
                                    ColumnName indexColName = ColumnName.caseSensitiveColumnName(IndexUtil.getIndexColumnName(null, colDef.getColumnDefName().getColumnName()));
                                    ColumnDef indexColDef = FACTORY.columnDef(indexColName, indexColDataType.getSqlTypeName(), colDef.isNull(), colDef.getMaxLength(), colDef.getScale(), true, colDef.getSortOrder());
                                    PColumn indexColumn = this.newColumn(indexPosition++, indexColDef, PrimaryKeyConstraint.EMPTY, null, true);
                                    nextIndexKeySeq = (short)(nextIndexKeySeq + 1);
                                    this.addColumnMutation(schemaName, index.getTableName().getString(), indexColumn, colUpsert, index.getParentTableName().getString(), index.getPKName() == null ? null : index.getPKName().getString(), nextIndexKeySeq, index.getBucketNum() != null);
                                }
                            }
                        }
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                        this.connection.rollback();
                    } else {
                        if (!statement.getProps().isEmpty()) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.SET_UNSUPPORTED_PROP_ON_ALTER_TABLE).setTableName(table.getName().getString()).build().buildException();
                        }
                        if (Boolean.FALSE.equals(isImmutableRows) && !table.getIndexes().isEmpty()) {
                            int hbaseVersion = this.connection.getQueryServices().getLowestClusterHBaseVersion();
                            if (hbaseVersion < PhoenixDatabaseMetaData.MUTABLE_SI_VERSION_THRESHOLD) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_MUTABLE_INDEXES).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                            if (this.connection.getQueryServices().hasInvalidIndexConfiguration()) {
                                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_MUTABLE_INDEX_CONFIG).setSchemaName(schemaName).setTableName(tableName).build().buildException();
                            }
                        }
                        if (Boolean.TRUE.equals(multiTenant)) {
                            MetaDataClient.throwIfInsufficientColumns(schemaName, tableName, table.getPKColumns(), table.getBucketNum() != null, multiTenant);
                        }
                    }
                    if (isAddingPKColumn && !table.getIndexes().isEmpty()) {
                        for (PTable index : table.getIndexes()) {
                            this.incrementTableSeqNum(index, index.getType(), 1);
                        }
                        tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                        this.connection.rollback();
                    }
                    long seqNum = this.incrementTableSeqNum(table, statement.getTableType(), 1, isImmutableRows, disableWAL, multiTenant);
                    tableMetaData.addAll((Collection)this.connection.getMutationState().toMutations().next().getSecond());
                    this.connection.rollback();
                    Collections.reverse(tableMetaData);
                    Pair family = families.size() > 0 ? (Pair)families.get(0) : null;
                    emptyCF = null;
                    projectCF = null;
                    if (table.getType() != PTableType.VIEW && family != null) {
                        if (table.getColumnFamilies().isEmpty()) {
                            emptyCF = (byte[])family.getFirst();
                        } else {
                            try {
                                table.getColumnFamily((byte[])family.getFirst());
                            }
                            catch (ColumnFamilyNotFoundException e) {
                                projectCF = (byte[])family.getFirst();
                                emptyCF = SchemaUtil.getEmptyColumnFamily(table);
                            }
                        }
                    }
                    result = this.connection.getQueryServices().addColumn(tableMetaData, families, table);
                    try {
                        MetaDataProtocol.MutationCode code = this.processMutationResult(schemaName, tableName, result);
                        if (code == MetaDataProtocol.MutationCode.COLUMN_ALREADY_EXISTS) {
                            this.connection.addTable(result.getTable());
                            if (!statement.ifNotExists()) {
                                throw new ColumnAlreadyExistsException(schemaName, tableName, SchemaUtil.findExistingColumn(result.getTable(), columns));
                            }
                            indexColDataType = new MutationState(0, this.connection);
                            return indexColDataType;
                        }
                        if (isAddingPKColumn && !table.getIndexes().isEmpty()) break block48;
                    }
                    catch (ConcurrentTableMutationException e) {
                        if (retried) {
                            throw e;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Caught ConcurrentTableMutationException for table " + SchemaUtil.getTableName(schemaName, tableName) + ". Will try again...");
                        }
                        retried = true;
                        continue;
                    }
                    this.connection.addColumn(tenantId, SchemaUtil.getTableName(schemaName, tableName), columns, result.getMutationTime(), seqNum, isImmutableRows == null ? table.isImmutableRows() : isImmutableRows.booleanValue());
                }
                if (table.getType() == PTableType.TABLE && Boolean.FALSE.equals(multiTenant) && MetaDataUtil.hasViewIndexTable(this.connection, table.getPhysicalName())) {
                    this.connection.setAutoCommit(true);
                    MetaDataUtil.deleteViewIndexSequences(this.connection, table.getPhysicalName());
                    if (!this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true)) {
                        scn = this.connection.getSCN();
                        long ts = scn == null ? result.getMutationTime() : scn.longValue();
                        String viewIndexSchemaName = MetaDataUtil.getViewIndexSchemaName(schemaName);
                        String viewIndexTableName = MetaDataUtil.getViewIndexTableName(tableName);
                        PTableImpl viewIndexTable = new PTableImpl(null, viewIndexSchemaName, viewIndexTableName, ts, table.getColumnFamilies());
                        List<TableRef> tableRefs = Collections.singletonList(new TableRef(null, viewIndexTable, ts, false));
                        MutationPlan plan = new PostDDLCompiler(this.connection).compile(tableRefs, null, null, Collections.<PColumn>emptyList(), ts);
                        this.connection.getQueryServices().updateData(plan);
                    }
                }
                if (emptyCF != null) {
                    scn = this.connection.getSCN();
                    this.connection.setAutoCommit(true);
                    long ts = scn == null ? result.getMutationTime() : scn.longValue();
                    MutationPlan plan = new PostDDLCompiler(this.connection).compile(Collections.singletonList(new TableRef(null, table, ts, false)), emptyCF, projectCF, null, ts);
                    MutationState mutationState = this.connection.getQueryServices().updateData(plan);
                    return mutationState;
                }
                MutationState mutationState = new MutationState(0, this.connection);
                return mutationState;
            }
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private String dropColumnMutations(PTable table, List<PColumn> columnsToDrop, List<Mutation> tableMetaData) throws SQLException {
        String tenantId = this.connection.getTenantId() == null ? "" : this.connection.getTenantId().getString();
        String schemaName = table.getSchemaName().getString();
        String tableName = table.getTableName().getString();
        String familyName = null;
        StringBuilder buf = new StringBuilder("DELETE FROM SYSTEM.\"CATALOG\" WHERE ");
        buf.append("(TENANT_ID,TABLE_SCHEM,TABLE_NAME,COLUMN_NAME, COLUMN_FAMILY) IN (");
        for (PColumn columnToDrop : columnsToDrop) {
            buf.append("('" + tenantId + "'");
            buf.append(",'" + schemaName + "'");
            buf.append(",'" + tableName + "'");
            buf.append(",'" + columnToDrop.getName().getString() + "'");
            buf.append(",'" + (columnToDrop.getFamilyName() == null ? "" : columnToDrop.getFamilyName().getString()) + "'),");
        }
        buf.setCharAt(buf.length() - 1, ')');
        this.connection.createStatement().execute(buf.toString());
        Collections.sort(columnsToDrop, new Comparator<PColumn>(){

            @Override
            public int compare(PColumn left, PColumn right) {
                return Ints.compare(left.getPosition(), right.getPosition());
            }
        });
        boolean isSalted = table.getBucketNum() != null;
        int columnsToDropIndex = 0;
        PreparedStatement colUpdate = this.connection.prepareStatement(UPDATE_COLUMN_POSITION);
        colUpdate.setString(1, tenantId);
        colUpdate.setString(2, schemaName);
        colUpdate.setString(3, tableName);
        for (int i = columnsToDrop.get(columnsToDropIndex).getPosition() + 1; i < table.getColumns().size(); ++i) {
            PColumn column = table.getColumns().get(i);
            if (columnsToDrop.contains(column)) {
                ++columnsToDropIndex;
                continue;
            }
            colUpdate.setString(4, column.getName().getString());
            colUpdate.setString(5, column.getFamilyName() == null ? null : column.getFamilyName().getString());
            colUpdate.setInt(6, column.getPosition() - columnsToDropIndex - (isSalted ? 1 : 0));
            colUpdate.execute();
        }
        return familyName;
    }

    private static byte[] getNewEmptyColumnFamilyOrNull(PTable table, PColumn columnToDrop) {
        if (table.getType() != PTableType.VIEW && !SchemaUtil.isPKColumn(columnToDrop) && table.getColumnFamilies().get(0).getName().equals(columnToDrop.getFamilyName()) && table.getColumnFamilies().get(0).getColumns().size() == 1) {
            return SchemaUtil.getEmptyColumnFamily(table.getDefaultFamilyName(), table.getColumnFamilies().subList(1, table.getColumnFamilies().size()));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MutationState dropColumn(DropColumnStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            MetaDataProtocol.MetaDataMutationResult result;
            MutationState mutationState;
            ArrayList<TableRef> indexesToDrop;
            ArrayList<ColumnRef> columnsToDrop;
            PTable table;
            block33: {
                Iterator i$;
                long seqNum;
                this.connection.setAutoCommit(false);
                PName tenantId = this.connection.getTenantId();
                TableName tableNameNode = statement.getTable().getName();
                String schemaName = tableNameNode.getSchemaName();
                String tableName = tableNameNode.getTableName();
                String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
                boolean retried = false;
                while (true) {
                    Object tableContainingColumnToDrop;
                    ColumnResolver resolver = FromCompiler.getResolverForMutation(statement, this.connection);
                    table = resolver.getTables().get(0).getTable();
                    List<ColumnName> columnRefs = statement.getColumnRefs();
                    if (columnRefs == null) {
                        columnRefs = Lists.newArrayListWithCapacity(0);
                    }
                    TableRef tableRef = null;
                    columnsToDrop = Lists.newArrayListWithExpectedSize(columnRefs.size() + table.getIndexes().size());
                    indexesToDrop = Lists.newArrayListWithExpectedSize(table.getIndexes().size());
                    ArrayList<Mutation> tableMetaData = Lists.newArrayListWithExpectedSize((table.getIndexes().size() + 1) * (1 + table.getColumns().size() - columnRefs.size()));
                    ArrayList<PColumn> tableColumnsToDrop = Lists.newArrayListWithExpectedSize(columnRefs.size());
                    for (ColumnName column : columnRefs) {
                        ColumnRef columnRef = null;
                        try {
                            columnRef = resolver.resolveColumn(null, column.getFamilyName(), column.getColumnName());
                        }
                        catch (ColumnNotFoundException e) {
                            if (!statement.ifExists()) throw e;
                            mutationState = new MutationState(0, this.connection);
                            this.connection.setAutoCommit(wasAutoCommit);
                            return mutationState;
                        }
                        tableRef = columnRef.getTableRef();
                        PColumn columnToDrop = columnRef.getColumn();
                        tableColumnsToDrop.add(columnToDrop);
                        if (SchemaUtil.isPKColumn(columnToDrop)) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_DROP_PK).setColumnName(columnToDrop.getName().getString()).build().buildException();
                        }
                        columnsToDrop.add(new ColumnRef(tableRef, columnToDrop.getPosition()));
                    }
                    this.dropColumnMutations(table, tableColumnsToDrop, tableMetaData);
                    for (PTable index : table.getIndexes()) {
                        ArrayList<PColumn> indexColumnsToDrop = Lists.newArrayListWithExpectedSize(columnRefs.size());
                        for (PColumn columnToDrop : tableColumnsToDrop) {
                            String indexColumnName = IndexUtil.getIndexColumnName(columnToDrop);
                            try {
                                PColumn indexColumn = index.getColumn(indexColumnName);
                                if (SchemaUtil.isPKColumn(indexColumn)) {
                                    indexesToDrop.add(new TableRef(index));
                                    continue;
                                }
                                indexColumnsToDrop.add(indexColumn);
                                columnsToDrop.add(new ColumnRef(tableRef, columnToDrop.getPosition()));
                            }
                            catch (ColumnNotFoundException e) {}
                        }
                        if (indexColumnsToDrop.isEmpty()) continue;
                        this.incrementTableSeqNum(index, index.getType(), -1);
                        this.dropColumnMutations(index, indexColumnsToDrop, tableMetaData);
                    }
                    tableMetaData.addAll((Collection<Mutation>)this.connection.getMutationState().toMutations().next().getSecond());
                    this.connection.rollback();
                    seqNum = this.incrementTableSeqNum(table, statement.getTableType(), -1);
                    tableMetaData.addAll((Collection<Mutation>)this.connection.getMutationState().toMutations().next().getSecond());
                    this.connection.rollback();
                    Collections.reverse(tableMetaData);
                    for (ColumnRef columnRefToDrop : columnsToDrop) {
                        tableContainingColumnToDrop = columnRefToDrop.getTable();
                        byte[] emptyCF = MetaDataClient.getNewEmptyColumnFamilyOrNull((PTable)tableContainingColumnToDrop, columnRefToDrop.getColumn());
                        if (emptyCF == null) continue;
                        try {
                            tableContainingColumnToDrop.getColumnFamily(emptyCF);
                        }
                        catch (ColumnFamilyNotFoundException e) {
                            byte[] tenantIdBytes;
                            ArrayList<Pair<byte[], Map<String, Object>>> family = Lists.newArrayListWithExpectedSize(1);
                            family.add(new Pair(emptyCF, Collections.emptyMap()));
                            byte[] byArray = tenantIdBytes = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getBytes();
                            if (tenantIdBytes == null) {
                                tenantIdBytes = ByteUtil.EMPTY_BYTE_ARRAY;
                            }
                            this.connection.getQueryServices().addColumn(Collections.singletonList(new Put(SchemaUtil.getTableKey(tenantIdBytes, tableContainingColumnToDrop.getSchemaName().getBytes(), tableContainingColumnToDrop.getTableName().getBytes()))), family, (PTable)tableContainingColumnToDrop);
                        }
                    }
                    result = this.connection.getQueryServices().dropColumn(tableMetaData, statement.getTableType());
                    try {
                        MetaDataProtocol.MutationCode code = this.processMutationResult(schemaName, tableName, result);
                        if (code == MetaDataProtocol.MutationCode.COLUMN_NOT_FOUND) {
                            this.connection.addTable(result.getTable());
                            if (!statement.ifExists()) {
                                throw new ColumnNotFoundException(schemaName, tableName, Bytes.toString(result.getFamilyName()), Bytes.toString(result.getColumnName()));
                            }
                            tableContainingColumnToDrop = new MutationState(0, this.connection);
                            return tableContainingColumnToDrop;
                        }
                        if (columnsToDrop.size() > 0 && indexesToDrop.isEmpty()) {
                            i$ = tableColumnsToDrop.iterator();
                            break;
                        }
                        break block33;
                    }
                    catch (ConcurrentTableMutationException e) {
                        if (retried) {
                            throw e;
                        }
                        table = this.connection.getMetaDataCache().getTable(new PTableKey(tenantId, fullTableName));
                        retried = true;
                        continue;
                    }
                    break;
                }
                while (i$.hasNext()) {
                    PColumn columnToDrop = (PColumn)i$.next();
                    this.connection.removeColumn(tenantId, SchemaUtil.getTableName(schemaName, tableName), columnToDrop.getFamilyName().getString(), columnToDrop.getName().getString(), result.getMutationTime(), seqNum);
                }
            }
            if (table.getType() != PTableType.VIEW) {
                MutationState state = null;
                this.connection.setAutoCommit(true);
                Long scn = this.connection.getSCN();
                long ts = scn == null ? result.getMutationTime() : scn.longValue();
                PostDDLCompiler compiler = new PostDDLCompiler(this.connection);
                boolean dropMetaData = this.connection.getQueryServices().getProps().getBoolean("phoenix.schema.dropMetaData", true);
                if (!dropMetaData) {
                    this.connection.getQueryServices().updateData(compiler.compile(indexesToDrop, null, null, Collections.<PColumn>emptyList(), ts));
                }
                Iterator i$ = columnsToDrop.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        MutationState mutationState2 = state;
                        return mutationState2;
                    }
                    ColumnRef droppedColumnRef = (ColumnRef)i$.next();
                    droppedColumnRef = new ColumnRef(droppedColumnRef, ts);
                    TableRef droppedColumnTableRef = droppedColumnRef.getTableRef();
                    PColumn droppedColumn = droppedColumnRef.getColumn();
                    MutationPlan plan = compiler.compile(Collections.singletonList(droppedColumnTableRef), MetaDataClient.getNewEmptyColumnFamilyOrNull(droppedColumnTableRef.getTable(), droppedColumn), null, Collections.singletonList(droppedColumn), ts);
                    state = this.connection.getQueryServices().updateData(plan);
                }
            }
            mutationState = new MutationState(0, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutationState alterIndex(AlterIndexStatement statement) throws SQLException {
        this.connection.rollback();
        boolean wasAutoCommit = this.connection.getAutoCommit();
        try {
            String dataTableName = statement.getTableName();
            String schemaName = statement.getTable().getName().getSchemaName();
            String indexName = statement.getTable().getName().getTableName();
            PIndexState newIndexState = statement.getIndexState();
            if (newIndexState == PIndexState.REBUILD) {
                newIndexState = PIndexState.BUILDING;
            }
            this.connection.setAutoCommit(false);
            TableRef indexRef = FromCompiler.getResolverForMutation(statement, this.connection).getTables().get(0);
            PreparedStatement tableUpsert = null;
            try {
                tableUpsert = this.connection.prepareStatement(UPDATE_INDEX_STATE);
                tableUpsert.setString(1, this.connection.getTenantId() == null ? null : this.connection.getTenantId().getString());
                tableUpsert.setString(2, schemaName);
                tableUpsert.setString(3, indexName);
                tableUpsert.setString(4, newIndexState.getSerializedValue());
                tableUpsert.execute();
            }
            finally {
                if (tableUpsert != null) {
                    tableUpsert.close();
                }
            }
            List<Mutation> tableMetadata = this.connection.getMutationState().toMutations().next().getSecond();
            this.connection.rollback();
            MetaDataProtocol.MetaDataMutationResult result = this.connection.getQueryServices().updateIndexState(tableMetadata, dataTableName);
            MetaDataProtocol.MutationCode code = result.getMutationCode();
            if (code == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
                throw new TableNotFoundException(schemaName, indexName);
            }
            if (code == MetaDataProtocol.MutationCode.UNALLOWED_TABLE_MUTATION) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION).setMessage(" currentState=" + (Object)((Object)indexRef.getTable().getIndexState()) + ". requestedState=" + (Object)((Object)newIndexState)).setSchemaName(schemaName).setTableName(indexName).build().buildException();
            }
            if (code == MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS && result.getTable() != null) {
                this.connection.addTable(result.getTable());
            }
            if (newIndexState == PIndexState.BUILDING) {
                PTable index = indexRef.getTable();
                Long scn = this.connection.getSCN();
                long ts = scn == null ? Long.MAX_VALUE : scn;
                MutationPlan plan = new PostDDLCompiler(this.connection).compile(Collections.singletonList(indexRef), null, null, Collections.<PColumn>emptyList(), ts);
                this.connection.getQueryServices().updateData(plan);
                NamedTableNode dataTableNode = NamedTableNode.create(null, TableName.create(schemaName, dataTableName), Collections.<ColumnDef>emptyList());
                this.connection.setAutoCommit(true);
                if (this.connection.getSCN() != null) {
                    MutationState mutationState = this.buildIndexAtTimeStamp(index, dataTableNode);
                    return mutationState;
                }
                TableRef dataTableRef = FromCompiler.getResolver(dataTableNode, this.connection).getTables().get(0);
                MutationState mutationState = this.buildIndex(index, dataTableRef);
                return mutationState;
            }
            MutationState mutationState = new MutationState(1, this.connection);
            return mutationState;
        }
        catch (TableNotFoundException e) {
            if (!statement.ifExists()) {
                throw e;
            }
            MutationState mutationState = new MutationState(0, this.connection);
            return mutationState;
        }
        finally {
            this.connection.setAutoCommit(wasAutoCommit);
        }
    }

    private void throwIfAlteringViewPK(ColumnDef col, PTable table) throws SQLException {
        if (col != null && col.isPK() && table.getType() == PTableType.VIEW) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_MODIFY_VIEW_PK).setSchemaName(table.getSchemaName().getString()).setTableName(table.getTableName().getString()).setColumnName(col.getColumnDefName().getColumnName()).build().buildException();
        }
    }
}

