/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Objects;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PhoenixArray;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class PArrayDataType {
    public static final byte ARRAY_SERIALIZATION_VERSION = 1;

    public byte[] toBytes(Object object, PDataType baseType, SortOrder sortOrder) {
        if (object == null) {
            throw new ConstraintViolationException(this + " may not be null");
        }
        PhoenixArray arr = (PhoenixArray)object;
        int noOfElements = arr.numElements;
        if (noOfElements == 0) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        TrustedByteArrayOutputStream byteStream = null;
        if (!baseType.isFixedWidth()) {
            Pair<Integer, Integer> nullsVsNullRepeationCounter = new Pair<Integer, Integer>();
            int size = this.estimateByteSize(object, nullsVsNullRepeationCounter, PDataType.fromTypeId(baseType.getSqlType() + 3000));
            int capacity = noOfElements * 2;
            byteStream = new TrustedByteArrayOutputStream((size += 2 + (noOfElements - nullsVsNullRepeationCounter.getFirst()) * 1 + nullsVsNullRepeationCounter.getSecond() * 2 * 1) + capacity + 4 + 1 + 4);
        } else {
            int size = arr.getMaxLength() * noOfElements;
            byteStream = new TrustedByteArrayOutputStream(size);
        }
        DataOutputStream oStream = new DataOutputStream(byteStream);
        return this.createArrayBytes(byteStream, oStream, (PhoenixArray)object, noOfElements, baseType, sortOrder);
    }

    public static int serializeNulls(DataOutputStream oStream, int nulls) throws IOException {
        if (nulls > 0) {
            oStream.write(0);
            int nMultiplesOver255 = nulls / 255;
            while (nMultiplesOver255-- > 0) {
                oStream.write(1);
            }
            int nRemainingNulls = nulls % 255;
            if (nRemainingNulls > 0) {
                byte nNullByte = SortOrder.invert((byte)(nRemainingNulls - 1));
                oStream.write(nNullByte);
            }
        }
        return 0;
    }

    public static void writeEndSeperatorForVarLengthArray(DataOutputStream oStream) throws IOException {
        oStream.write(0);
        oStream.write(0);
    }

    public static boolean useShortForOffsetArray(int maxOffset) {
        return maxOffset <= 65534;
    }

    public int toBytes(Object object, byte[] bytes, int offset) {
        PhoenixArray array = (PhoenixArray)object;
        if (array == null || array.baseType == null) {
            return 0;
        }
        return this.estimateByteSize(object, null, PDataType.fromTypeId(array.baseType.getSqlType() + 3000));
    }

    public int estimateByteSize(Object o, Pair<Integer, Integer> nullsVsNullRepeationCounter, PDataType baseType) {
        if (baseType.isFixedWidth()) {
            return baseType.getByteSize();
        }
        if (baseType.isArrayType()) {
            PhoenixArray array = (PhoenixArray)o;
            int noOfElements = array.numElements;
            int totalVarSize = 0;
            int nullsRepeationCounter = 0;
            int nulls = 0;
            int totalNulls = 0;
            for (int i = 0; i < noOfElements; ++i) {
                totalVarSize += array.estimateByteSize(i);
                if (PDataType.fromTypeId(baseType.getSqlType() - 3000).isFixedWidth()) continue;
                if (array.isNull(i)) {
                    ++nulls;
                    continue;
                }
                if (nulls <= 0) continue;
                totalNulls += nulls;
                nulls = 0;
                ++nullsRepeationCounter;
            }
            if (nullsVsNullRepeationCounter != null) {
                if (nulls > 0) {
                    totalNulls += nulls;
                }
                nullsVsNullRepeationCounter.setFirst(totalNulls);
                nullsVsNullRepeationCounter.setSecond(nullsRepeationCounter);
            }
            return totalVarSize;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return targetType.isCoercibleTo(targetType, value);
    }

    public boolean isCoercibleTo(PDataType targetType, PDataType expectedTargetType) {
        if (!targetType.isArrayType()) {
            return false;
        }
        PDataType targetElementType = PDataType.fromTypeId(targetType.getSqlType() - 3000);
        PDataType expectedTargetElementType = PDataType.fromTypeId(expectedTargetType.getSqlType() - 3000);
        return expectedTargetElementType.isCoercibleTo(targetElementType);
    }

    public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
        PhoenixArray pArr = (PhoenixArray)value;
        Object[] arr = (Object[])pArr.array;
        PDataType baseType = PDataType.fromTypeId(srcType.getSqlType() - 3000);
        for (int i = 0; i < arr.length; ++i) {
            if (baseType.isSizeCompatible(ptr, arr[i], baseType, srcType.getMaxLength(arr[i]), scale, desiredMaxLength, desiredScale)) continue;
            return false;
        }
        return true;
    }

    public void coerceBytes(ImmutableBytesWritable ptr, Object value, PDataType actualType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale, PDataType desiredType, SortOrder actualModifer, SortOrder expectedModifier) {
        if (ptr.getLength() == 0) {
            return;
        }
        PDataType baseType = PDataType.fromTypeId(actualType.getSqlType() - 3000);
        PDataType desiredBaseType = PDataType.fromTypeId(desiredType.getSqlType() - 3000);
        if ((Objects.equal(maxLength, desiredMaxLength) || maxLength == null || desiredMaxLength == null) && actualType.isBytesComparableWith(desiredType) && baseType.isFixedWidth() == desiredBaseType.isFixedWidth() && actualModifer == expectedModifier) {
            return;
        }
        if (value == null && actualType != desiredType) {
            value = this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), baseType, actualModifer, maxLength, desiredScale, desiredBaseType);
            PhoenixArray pArr = (PhoenixArray)value;
            if (baseType.isFixedWidth() != desiredBaseType.isFixedWidth()) {
                pArr = new PhoenixArray(pArr, desiredMaxLength);
            }
            baseType = desiredBaseType;
            ptr.set(this.toBytes((Object)pArr, baseType, expectedModifier));
        } else {
            PhoenixArray pArr = (PhoenixArray)value;
            pArr = new PhoenixArray(pArr, desiredMaxLength);
            ptr.set(this.toBytes((Object)pArr, baseType, expectedModifier));
        }
    }

    public Object toObject(String value) {
        throw new IllegalArgumentException("This operation is not suppported");
    }

    public Object toObject(byte[] bytes, int offset, int length, PDataType baseType, SortOrder sortOrder, Integer maxLength, Integer scale, PDataType desiredDataType) {
        return this.createPhoenixArray(bytes, offset, length, sortOrder, baseType, maxLength, desiredDataType);
    }

    public static void positionAtArrayElement(ImmutableBytesWritable ptr, int arrayIndex, PDataType baseDataType, Integer byteSize) {
        byte[] bytes = ptr.get();
        int initPos = ptr.getOffset();
        if (!baseDataType.isFixedWidth()) {
            int noOfElements = Bytes.toInt(bytes, ptr.getOffset() + ptr.getLength() - 5, 4);
            boolean useShort = true;
            if (noOfElements < 0) {
                noOfElements = -noOfElements;
                useShort = false;
            }
            if (arrayIndex >= noOfElements) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return;
            }
            int indexOffset = Bytes.toInt(bytes, ptr.getOffset() + ptr.getLength() - 9) + ptr.getOffset();
            if (arrayIndex >= noOfElements) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            } else {
                int currOffset = PArrayDataType.getOffset(bytes, arrayIndex, useShort, indexOffset);
                int elementLength = 0;
                elementLength = arrayIndex == noOfElements - 1 ? (bytes[currOffset + initPos] == 0 ? 0 : indexOffset - (currOffset + initPos) - 3) : (bytes[currOffset + initPos] == 0 ? 0 : PArrayDataType.getOffset(bytes, arrayIndex + 1, useShort, indexOffset) - currOffset - 1);
                ptr.set(bytes, currOffset + initPos, elementLength);
            }
        } else {
            int elemByteSize = byteSize == null ? baseDataType.getByteSize() : byteSize;
            int offset = arrayIndex * elemByteSize;
            if (offset >= ptr.getLength()) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            } else {
                ptr.set(bytes, ptr.getOffset() + offset, elemByteSize);
            }
        }
    }

    private static int getOffset(byte[] bytes, int arrayIndex, boolean useShort, int indexOffset) {
        if (useShort) {
            int offset = indexOffset + 2 * arrayIndex;
            return Bytes.toShort(bytes, offset, 2) + Short.MAX_VALUE;
        }
        int offset = indexOffset + 4 * arrayIndex;
        return Bytes.toInt(bytes, offset, 4);
    }

    private static int getOffset(ByteBuffer indexBuffer, int arrayIndex, boolean useShort, int indexOffset) {
        int offset = useShort ? indexBuffer.getShort() + Short.MAX_VALUE : indexBuffer.getInt();
        return offset;
    }

    public Object toObject(Object object, PDataType actualType) {
        return object;
    }

    public Object toObject(Object object, PDataType actualType, SortOrder sortOrder) {
        return this.toObject(object, actualType);
    }

    private byte[] createArrayBytes(TrustedByteArrayOutputStream byteStream, DataOutputStream oStream, PhoenixArray array, int noOfElements, PDataType baseType, SortOrder sortOrder) {
        try {
            if (!baseType.isFixedWidth()) {
                int[] offsetPos = new int[noOfElements];
                int nulls = 0;
                for (int i = 0; i < noOfElements; ++i) {
                    byte[] bytes = array.toBytes(i);
                    if (bytes.length == 0) {
                        offsetPos[i] = byteStream.size();
                        ++nulls;
                        continue;
                    }
                    nulls = PArrayDataType.serializeNulls(oStream, nulls);
                    offsetPos[i] = byteStream.size();
                    if (sortOrder == SortOrder.DESC) {
                        SortOrder.invert(bytes, 0, bytes, 0, bytes.length);
                    }
                    oStream.write(bytes, 0, bytes.length);
                    oStream.write(0);
                }
                PArrayDataType.writeEndSeperatorForVarLengthArray(oStream);
                noOfElements = PArrayDataType.serailizeOffsetArrayIntoStream(oStream, byteStream, noOfElements, offsetPos[offsetPos.length - 1], offsetPos);
                PArrayDataType.serializeHeaderInfoIntoStream(oStream, noOfElements);
            } else {
                for (int i = 0; i < noOfElements; ++i) {
                    byte[] bytes = array.toBytes(i);
                    int length = bytes.length;
                    if (sortOrder == SortOrder.DESC) {
                        SortOrder.invert(bytes, 0, bytes, 0, bytes.length);
                    }
                    oStream.write(bytes, 0, length);
                }
            }
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            ptr.set(byteStream.getBuffer(), 0, byteStream.size());
            return ByteUtil.copyKeyBytesIfNecessary(ptr);
        }
        catch (IOException e) {
            try {
                byteStream.close();
                oStream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return null;
        }
    }

    public static int serailizeOffsetArrayIntoStream(DataOutputStream oStream, TrustedByteArrayOutputStream byteStream, int noOfElements, int maxOffset, int[] offsetPos) throws IOException {
        int offsetPosition = byteStream.size();
        byte[] offsetArr = null;
        boolean useInt = true;
        if (PArrayDataType.useShortForOffsetArray(maxOffset)) {
            offsetArr = new byte[PArrayDataType.initOffsetArray(noOfElements, 2)];
            useInt = false;
        } else {
            offsetArr = new byte[PArrayDataType.initOffsetArray(noOfElements, 4)];
            noOfElements = -noOfElements;
        }
        int off = 0;
        if (useInt) {
            for (int pos : offsetPos) {
                Bytes.putInt(offsetArr, off, pos);
                off += 4;
            }
        } else {
            for (int pos : offsetPos) {
                Bytes.putShort(offsetArr, off, (short)(pos - Short.MAX_VALUE));
                off += 2;
            }
        }
        oStream.write(offsetArr);
        oStream.writeInt(offsetPosition);
        return noOfElements;
    }

    public static void serializeHeaderInfoIntoBuffer(ByteBuffer buffer, int noOfElements) {
        buffer.putInt(noOfElements);
        buffer.put((byte)1);
    }

    public static void serializeHeaderInfoIntoStream(DataOutputStream oStream, int noOfElements) throws IOException {
        oStream.writeInt(noOfElements);
        oStream.write(1);
    }

    public static int initOffsetArray(int noOfElements, int baseSize) {
        return noOfElements * baseSize;
    }

    private Object createPhoenixArray(byte[] bytes, int offset, int length, SortOrder sortOrder, PDataType baseDataType, Integer maxLength, PDataType desiredDataType) {
        Object[] elements;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (!baseDataType.isFixedWidth()) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes, offset, length);
            int initPos = buffer.position();
            buffer.position(buffer.limit() - 5);
            int noOfElements = buffer.getInt();
            boolean useShort = true;
            int baseSize = 2;
            if (noOfElements < 0) {
                noOfElements = -noOfElements;
                baseSize = 4;
                useShort = false;
            }
            elements = baseDataType == desiredDataType ? (Object[])Array.newInstance(baseDataType.getJavaClass(), noOfElements) : (Object[])Array.newInstance(desiredDataType.getJavaClass(), noOfElements);
            buffer.position(buffer.limit() - 9);
            int indexOffset = buffer.getInt();
            buffer.position(initPos);
            buffer.position(indexOffset + initPos);
            ByteBuffer indexArr = ByteBuffer.allocate(PArrayDataType.initOffsetArray(noOfElements, baseSize));
            byte[] array = indexArr.array();
            buffer.get(array);
            int countOfElementsRead = 0;
            int i = 0;
            int currOffset = -1;
            int nextOff = -1;
            boolean foundNull = false;
            if (noOfElements != 0) {
                while (countOfElementsRead <= noOfElements) {
                    if (countOfElementsRead == 0) {
                        currOffset = PArrayDataType.getOffset(indexArr, countOfElementsRead, useShort, indexOffset);
                        ++countOfElementsRead;
                    } else {
                        currOffset = nextOff;
                    }
                    nextOff = countOfElementsRead == noOfElements ? indexOffset - 2 : PArrayDataType.getOffset(indexArr, countOfElementsRead + 1, useShort, indexOffset);
                    ++countOfElementsRead;
                    if (bytes[currOffset + initPos] != 0 && foundNull) {
                        foundNull = false;
                    }
                    if (bytes[currOffset + initPos] == 0) {
                        foundNull = true;
                        ++i;
                        continue;
                    }
                    int elementLength = nextOff - currOffset;
                    buffer.position(currOffset + initPos);
                    byte[] val = new byte[elementLength - 1];
                    buffer.get(val);
                    if (baseDataType == desiredDataType) {
                        elements[i++] = baseDataType.toObject(val, sortOrder);
                        continue;
                    }
                    elements[i++] = desiredDataType.toObject(val, sortOrder, baseDataType);
                }
            }
        } else {
            int elemLength = maxLength == null ? baseDataType.getByteSize() : maxLength;
            int noOfElements = length / elemLength;
            elements = baseDataType == desiredDataType ? (Object[])Array.newInstance(baseDataType.getJavaClass(), noOfElements) : (Object[])Array.newInstance(desiredDataType.getJavaClass(), noOfElements);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            for (int i = 0; i < noOfElements; ++i) {
                ptr.set(bytes, offset + i * elemLength, elemLength);
                elements[i] = baseDataType == desiredDataType ? baseDataType.toObject(ptr, sortOrder) : desiredDataType.toObject(ptr, baseDataType, sortOrder);
            }
        }
        if (baseDataType == desiredDataType) {
            return PArrayDataType.instantiatePhoenixArray(baseDataType, elements);
        }
        return PArrayDataType.instantiatePhoenixArray(desiredDataType, elements);
    }

    public static PhoenixArray instantiatePhoenixArray(PDataType actualType, Object[] elements) {
        return PDataType.instantiatePhoenixArray(actualType, elements);
    }

    public int compareTo(Object lhs, Object rhs) {
        PhoenixArray lhsArr = (PhoenixArray)lhs;
        PhoenixArray rhsArr = (PhoenixArray)rhs;
        if (lhsArr.equals(rhsArr)) {
            return 0;
        }
        return 1;
    }

    public static int getArrayLength(ImmutableBytesWritable ptr, PDataType baseType, Integer maxLength) {
        byte[] bytes = ptr.get();
        if (baseType.isFixedWidth()) {
            int elemLength = maxLength == null ? baseType.getByteSize() : maxLength;
            return ptr.getLength() / elemLength;
        }
        return Bytes.toInt(bytes, ptr.getOffset() + ptr.getLength() - 5);
    }

    public static int estimateSize(int size, PDataType baseType) {
        if (baseType.isFixedWidth()) {
            return baseType.getByteSize() * size;
        }
        return size * 10;
    }
}

