/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.util.SizedUtil;

public class PColumnFamilyImpl
implements PColumnFamily {
    private final PName name;
    private final List<PColumn> columns;
    private final Map<String, PColumn> columnByString;
    private final Map<byte[], PColumn> columnByBytes;
    private final int estimatedSize;

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    public PColumnFamilyImpl(PName name, List<PColumn> columns) {
        Preconditions.checkNotNull(name);
        long estimatedSize = (long)(52 + name.getEstimatedSize()) + SizedUtil.sizeOfMap(columns.size()) * 2L + (long)SizedUtil.sizeOfArrayList(columns.size());
        this.name = name;
        this.columns = ImmutableList.copyOf(columns);
        ImmutableMap.Builder<String, PColumn> columnByStringBuilder = ImmutableMap.builder();
        ImmutableSortedMap.Builder columnByBytesBuilder = ImmutableSortedMap.orderedBy(Bytes.BYTES_COMPARATOR);
        for (PColumn column : columns) {
            estimatedSize += (long)column.getEstimatedSize();
            columnByBytesBuilder.put(column.getName().getBytes(), column);
            columnByStringBuilder.put(column.getName().getString(), column);
        }
        this.columnByBytes = columnByBytesBuilder.build();
        this.columnByString = columnByStringBuilder.build();
        this.estimatedSize = (int)estimatedSize;
    }

    @Override
    public PName getName() {
        return this.name;
    }

    public List<PColumn> getColumns() {
        return this.columns;
    }

    @Override
    public PColumn getColumn(byte[] qualifier) throws ColumnNotFoundException {
        PColumn column = this.columnByBytes.get(qualifier);
        if (column == null) {
            throw new ColumnNotFoundException(Bytes.toString(qualifier));
        }
        return column;
    }

    @Override
    public PColumn getColumn(String name) throws ColumnNotFoundException {
        PColumn column = this.columnByString.get(name);
        if (column == null) {
            throw new ColumnNotFoundException(name);
        }
        return column;
    }
}

