/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.LongMath;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.ValueTypeIncompatibleException;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PArrayDataType;
import org.apache.phoenix.schema.PhoenixArray;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.NumberUtil;
import org.apache.phoenix.util.StringUtil;

public abstract class PDataType
extends Enum<PDataType> {
    public static final /* enum */ PDataType VARCHAR;
    public static final /* enum */ PDataType CHAR;
    public static final /* enum */ PDataType LONG;
    public static final /* enum */ PDataType INTEGER;
    public static final /* enum */ PDataType SMALLINT;
    public static final /* enum */ PDataType TINYINT;
    public static final /* enum */ PDataType FLOAT;
    public static final /* enum */ PDataType DOUBLE;
    public static final /* enum */ PDataType DECIMAL;
    public static final /* enum */ PDataType TIMESTAMP;
    public static final /* enum */ PDataType TIME;
    public static final /* enum */ PDataType DATE;
    public static final /* enum */ PDataType UNSIGNED_TIMESTAMP;
    public static final /* enum */ PDataType UNSIGNED_TIME;
    public static final /* enum */ PDataType UNSIGNED_DATE;
    public static final /* enum */ PDataType UNSIGNED_LONG;
    public static final /* enum */ PDataType UNSIGNED_INT;
    public static final /* enum */ PDataType UNSIGNED_SMALLINT;
    public static final /* enum */ PDataType UNSIGNED_TINYINT;
    public static final /* enum */ PDataType UNSIGNED_FLOAT;
    public static final /* enum */ PDataType UNSIGNED_DOUBLE;
    public static final /* enum */ PDataType BOOLEAN;
    public static final /* enum */ PDataType VARBINARY;
    public static final /* enum */ PDataType BINARY;
    public static final /* enum */ PDataType INTEGER_ARRAY;
    public static final /* enum */ PDataType BOOLEAN_ARRAY;
    public static final /* enum */ PDataType VARCHAR_ARRAY;
    public static final /* enum */ PDataType VARBINARY_ARRAY;
    public static final /* enum */ PDataType BINARY_ARRAY;
    public static final /* enum */ PDataType CHAR_ARRAY;
    public static final /* enum */ PDataType LONG_ARRAY;
    public static final /* enum */ PDataType SMALLINT_ARRAY;
    public static final /* enum */ PDataType TINYINT_ARRAY;
    public static final /* enum */ PDataType FLOAT_ARRAY;
    public static final /* enum */ PDataType DOUBLE_ARRAY;
    public static final /* enum */ PDataType DECIMAL_ARRAY;
    public static final /* enum */ PDataType TIMESTAMP_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_TIMESTAMP_ARRAY;
    public static final /* enum */ PDataType TIME_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_TIME_ARRAY;
    public static final /* enum */ PDataType DATE_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_DATE_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_LONG_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_INT_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_SMALLINT_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_TINYINT_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_FLOAT_ARRAY;
    public static final /* enum */ PDataType UNSIGNED_DOUBLE_ARRAY;
    private static final BigDecimal MIN_DOUBLE_AS_BIG_DECIMAL;
    private static final BigDecimal MAX_DOUBLE_AS_BIG_DECIMAL;
    private static final BigDecimal MIN_FLOAT_AS_BIG_DECIMAL;
    private static final BigDecimal MAX_FLOAT_AS_BIG_DECIMAL;
    private final String sqlTypeName;
    private final int sqlType;
    private final Class clazz;
    private final byte[] clazzNameBytes;
    private final byte[] sqlTypeNameBytes;
    private final PDataCodec codec;
    final PArrayDataType pDataTypeForArray = new PArrayDataType();
    public static final int MAX_PRECISION = 38;
    public static final int MIN_DECIMAL_AVG_SCALE = 4;
    public static final MathContext DEFAULT_MATH_CONTEXT;
    public static final int DEFAULT_SCALE = 0;
    private static final Integer MAX_BIG_DECIMAL_BYTES;
    private static final Integer MAX_TIMESTAMP_BYTES;
    private static final byte ZERO_BYTE = -128;
    private static final byte NEG_TERMINAL_BYTE = 102;
    private static final int EXP_BYTE_OFFSET = 65;
    private static final int POS_DIGIT_OFFSET = 1;
    private static final int NEG_DIGIT_OFFSET = 101;
    private static final BigInteger MAX_LONG;
    private static final BigInteger MIN_LONG;
    private static final long MAX_LONG_FOR_DESERIALIZE = 9223372036854775L;
    private static final BigInteger ONE_HUNDRED;
    private static final byte FALSE_BYTE = 0;
    private static final byte TRUE_BYTE = 1;
    public static final byte[] FALSE_BYTES;
    public static final byte[] TRUE_BYTES;
    public static final byte[] NULL_BYTES;
    private static final Integer BOOLEAN_LENGTH;
    public static final Integer ZERO;
    public static final Integer INT_PRECISION;
    public static final Integer LONG_PRECISION;
    public static final Integer SHORT_PRECISION;
    public static final Integer BYTE_PRECISION;
    public static final int ARRAY_TYPE_BASE = 3000;
    private static final Map<String, PDataType> SQL_TYPE_NAME_TO_PCOLUMN_DATA_TYPE;
    private static final int SQL_TYPE_OFFSET;
    private static final PDataType[] SQL_TYPE_TO_PCOLUMN_DATA_TYPE;
    public static PhoenixArrayFactory[] ARRAY_FACTORY;
    private static final /* synthetic */ PDataType[] $VALUES;

    public static PDataType[] values() {
        return (PDataType[])$VALUES.clone();
    }

    public static PDataType valueOf(String name) {
        return Enum.valueOf(PDataType.class, name);
    }

    private PDataType(String sqlTypeName, int sqlType, Class clazz, PDataCodec codec) {
        this.sqlTypeName = sqlTypeName;
        this.sqlType = sqlType;
        this.clazz = clazz;
        this.clazzNameBytes = Bytes.toBytes(clazz.getName());
        this.sqlTypeNameBytes = Bytes.toBytes(sqlTypeName);
        this.codec = codec;
    }

    public boolean isCastableTo(PDataType targetType) {
        return this.isComparableTo(targetType);
    }

    public final PDataCodec getCodec() {
        return this.codec;
    }

    public boolean isBytesComparableWith(PDataType otherType) {
        return this == otherType || this == VARBINARY || otherType == VARBINARY || this == BINARY || otherType == BINARY;
    }

    public int estimateByteSize(Object o) {
        if (this.isFixedWidth()) {
            return this.getByteSize();
        }
        if (this.isArrayType()) {
            PhoenixArray array = (PhoenixArray)o;
            int noOfElements = array.numElements;
            int totalVarSize = 0;
            for (int i = 0; i < noOfElements; ++i) {
                totalVarSize += array.estimateByteSize(i);
            }
            return totalVarSize;
        }
        throw new UnsupportedOperationException();
    }

    public Integer getMaxLength(Object o) {
        return null;
    }

    public Integer getScale(Object o) {
        return null;
    }

    public Integer estimateByteSizeFromLength(Integer length) {
        if (this.isFixedWidth()) {
            return this.getByteSize();
        }
        if (this.isArrayType()) {
            return null;
        }
        return length;
    }

    public final String getSqlTypeName() {
        return this.sqlTypeName;
    }

    public final int getSqlType() {
        return this.sqlType;
    }

    public final Class getJavaClass() {
        return this.clazz;
    }

    public boolean isArrayType() {
        return false;
    }

    public final int compareTo(byte[] lhs, int lhsOffset, int lhsLength, SortOrder lhsSortOrder, byte[] rhs, int rhsOffset, int rhsLength, SortOrder rhsSortOrder, PDataType rhsType) {
        Preconditions.checkNotNull(lhsSortOrder);
        Preconditions.checkNotNull(rhsSortOrder);
        if (this.isBytesComparableWith(rhsType)) {
            return this.compareTo(lhs, lhsOffset, lhsLength, lhsSortOrder, rhs, rhsOffset, rhsLength, rhsSortOrder);
        }
        PDataCodec lhsCodec = this.getCodec();
        if (lhsCodec == null) {
            byte[] rhsConverted = this.toBytes(this.toObject(rhs, rhsOffset, rhsLength, rhsType, rhsSortOrder));
            if (rhsSortOrder == SortOrder.DESC) {
                rhsSortOrder = SortOrder.ASC;
            }
            if (lhsSortOrder == SortOrder.DESC) {
                lhs = SortOrder.invert(lhs, lhsOffset, new byte[lhsLength], 0, lhsLength);
            }
            return Bytes.compareTo(lhs, lhsOffset, lhsLength, rhsConverted, 0, rhsConverted.length);
        }
        PDataCodec rhsCodec = rhsType.getCodec();
        if (rhsCodec == null) {
            byte[] lhsConverted = rhsType.toBytes(rhsType.toObject(lhs, lhsOffset, lhsLength, this, lhsSortOrder));
            if (lhsSortOrder == SortOrder.DESC) {
                lhsSortOrder = SortOrder.ASC;
            }
            if (rhsSortOrder == SortOrder.DESC) {
                rhs = SortOrder.invert(rhs, rhsOffset, new byte[rhsLength], 0, rhsLength);
            }
            return Bytes.compareTo(lhsConverted, 0, lhsConverted.length, rhs, rhsOffset, rhsLength);
        }
        if (this.isCoercibleTo(LONG) && rhsType.isCoercibleTo(LONG)) {
            return Longs.compare(this.getCodec().decodeLong(lhs, lhsOffset, lhsSortOrder), rhsType.getCodec().decodeLong(rhs, rhsOffset, rhsSortOrder));
        }
        if (PDataType.isDoubleOrFloat(this) && PDataType.isDoubleOrFloat(rhsType)) {
            return Doubles.compare(this.getCodec().decodeDouble(lhs, lhsOffset, lhsSortOrder), rhsType.getCodec().decodeDouble(rhs, rhsOffset, rhsSortOrder));
        }
        float fvalue = 0.0f;
        double dvalue = 0.0;
        long lvalue = 0L;
        boolean isFloat = false;
        int invert = 1;
        if (this.isCoercibleTo(LONG)) {
            lvalue = this.getCodec().decodeLong(lhs, lhsOffset, lhsSortOrder);
        } else if (this == FLOAT) {
            isFloat = true;
            fvalue = this.getCodec().decodeFloat(lhs, lhsOffset, lhsSortOrder);
        } else if (this.isCoercibleTo(DOUBLE)) {
            dvalue = this.getCodec().decodeDouble(lhs, lhsOffset, lhsSortOrder);
        }
        if (rhsType.isCoercibleTo(LONG)) {
            lvalue = rhsType.getCodec().decodeLong(rhs, rhsOffset, rhsSortOrder);
        } else if (rhsType == FLOAT) {
            invert = -1;
            isFloat = true;
            fvalue = rhsType.getCodec().decodeFloat(rhs, rhsOffset, rhsSortOrder);
        } else if (rhsType.isCoercibleTo(DOUBLE)) {
            invert = -1;
            dvalue = rhsType.getCodec().decodeDouble(rhs, rhsOffset, rhsSortOrder);
        }
        return invert * (isFloat ? PDataType.compareFloatToLong(fvalue, lvalue) : PDataType.compareDoubleToLong(dvalue, lvalue));
    }

    public static boolean isDoubleOrFloat(PDataType type) {
        return type == FLOAT || type == DOUBLE || type == UNSIGNED_FLOAT || type == UNSIGNED_DOUBLE;
    }

    private static int compareFloatToLong(float f, long l) {
        if (f > 2.1474836E9f || f < -2.1474836E9f) {
            return f < (float)l ? -1 : (f > (float)l ? 1 : 0);
        }
        long diff = (long)f - l;
        return Long.signum(diff);
    }

    private static int compareDoubleToLong(double d, long l) {
        if (d > 9.223372036854776E18) {
            return 1;
        }
        if (d < -9.223372036854776E18) {
            return -1;
        }
        long diff = (long)d - l;
        return Long.signum(diff);
    }

    private static int toBytes(BigDecimal v, byte[] result, int offset, int length) {
        long divBy;
        BigInteger compareAgainst;
        int digitOffset;
        BigInteger divideBy;
        int multiplyBy;
        int scale;
        int signum = v.signum();
        if (signum == 0) {
            result[offset] = -128;
            return 1;
        }
        int index = offset + length;
        int expOffset = scale % 2 * ((scale = v.scale()) < 0 ? -1 : 1);
        if (expOffset == 0) {
            multiplyBy = 1;
            divideBy = ONE_HUNDRED;
        } else {
            multiplyBy = 10;
            divideBy = BigInteger.TEN;
        }
        if (signum == 1) {
            digitOffset = 1;
            compareAgainst = MAX_LONG;
            result[offset] = (byte)(-((scale -= (length - 2) * 2) + expOffset) / 2 + 65 | 0x80);
        } else {
            digitOffset = 101;
            compareAgainst = MIN_LONG;
            result[offset] = (byte)(~(-((scale -= (length - 2 - 1) * 2) + expOffset) / 2 + 65 + 128) & 0x7F);
            if (length <= MAX_BIG_DECIMAL_BYTES) {
                result[--index] = 102;
            } else {
                length = MAX_BIG_DECIMAL_BYTES;
                index = offset + length - 1;
            }
        }
        BigInteger bi = v.unscaledValue();
        while (bi.compareTo(compareAgainst) * signum > 0) {
            BigInteger[] dandr = bi.divideAndRemainder(divideBy);
            bi = dandr[0];
            int digit = dandr[1].intValue();
            result[--index] = (byte)(signum * digit * multiplyBy + digitOffset);
            multiplyBy = 1;
            divideBy = ONE_HUNDRED;
        }
        long l = bi.longValue();
        do {
            divBy = 100 / multiplyBy;
            long digit = l % divBy;
            result[--index] = (byte)(digit * (long)multiplyBy + (long)digitOffset);
            multiplyBy = 1;
        } while ((l /= divBy) != 0L);
        return length;
    }

    private static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        BigInteger bi;
        int digitOffset;
        int index;
        int scale;
        if (length == 1 && bytes[offset] == -128) {
            return BigDecimal.ZERO;
        }
        int signum = (bytes[offset] & 0x80) == 0 ? -1 : 1;
        long multiplier = 100L;
        int begIndex = offset + 1;
        if (signum == 1) {
            scale = ((bytes[offset] & 0x7F) - 65) * -2;
            index = offset + length;
            digitOffset = 1;
        } else {
            scale = (byte)((~bytes[offset] - 65 - 128) * -2);
            index = offset + length - (bytes[offset + length - 1] == 102 ? 1 : 0);
            digitOffset = -101;
        }
        length = index - offset;
        long l = signum * bytes[--index] - digitOffset;
        if (l % 10L == 0L) {
            --scale;
            l /= 10L;
            multiplier = 10L;
        }
        while (index > begIndex) {
            if (l >= 9223372036854775L || multiplier >= 92233720368547758L) {
                multiplier = LongMath.divide(multiplier, 100L, RoundingMode.UNNECESSARY);
                break;
            }
            int digit100 = signum * bytes[--index] - digitOffset;
            l += (long)digit100 * multiplier;
            multiplier = LongMath.checkedMultiply(multiplier, 100L);
        }
        if (index > begIndex) {
            bi = BigInteger.valueOf(l);
            BigInteger biMultiplier = BigInteger.valueOf(multiplier).multiply(ONE_HUNDRED);
            do {
                int digit100 = signum * bytes[--index] - digitOffset;
                bi = bi.add(biMultiplier.multiply(BigInteger.valueOf(digit100)));
                biMultiplier = biMultiplier.multiply(ONE_HUNDRED);
            } while (index > begIndex);
            if (signum == -1) {
                bi = bi.negate();
            }
        } else {
            bi = BigInteger.valueOf(l * (long)signum);
        }
        BigDecimal v = new BigDecimal(bi, scale += (length - 2) * 2);
        return v;
    }

    static int[] getDecimalPrecisionAndScale(byte[] bytes, int offset, int length) {
        int digitOffset;
        int index;
        int scale;
        int signum;
        if (length == 1 && bytes[offset] == -128) {
            return new int[]{0, 0};
        }
        int n = signum = (bytes[offset] & 0x80) == 0 ? -1 : 1;
        if (signum == 1) {
            scale = ((bytes[offset] & 0x7F) - 65) * -2;
            index = offset + length;
            digitOffset = 1;
        } else {
            scale = (byte)((~bytes[offset] - 65 - 128) * -2);
            index = offset + length - (bytes[offset + length - 1] == 102 ? 1 : 0);
            digitOffset = -101;
        }
        length = index - offset;
        int precision = 2 * (length - 1);
        int d = signum * bytes[--index] - digitOffset;
        if (d % 10 == 0) {
            d /= 10;
            --scale;
            --precision;
        }
        if ((d = signum * bytes[offset + 1] - digitOffset) < 10) {
            --precision;
        }
        if ((scale += (length - 2) * 2) < 0) {
            precision -= scale;
            scale = 0;
        }
        return new int[]{precision, scale};
    }

    public boolean isCoercibleTo(PDataType targetType) {
        return this == targetType || targetType == VARBINARY;
    }

    public boolean isComparableTo(PDataType targetType) {
        return targetType.isCoercibleTo(this) || this.isCoercibleTo(targetType);
    }

    public boolean isCoercibleTo(PDataType targetType, Object value) {
        return this.isCoercibleTo(targetType);
    }

    public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
        return true;
    }

    public int compareTo(byte[] b1, byte[] b2) {
        return this.compareTo(b1, 0, b1.length, SortOrder.getDefault(), b2, 0, b2.length, SortOrder.getDefault());
    }

    public final int compareTo(ImmutableBytesWritable ptr1, ImmutableBytesWritable ptr2) {
        return this.compareTo(ptr1.get(), ptr1.getOffset(), ptr1.getLength(), SortOrder.getDefault(), ptr2.get(), ptr2.getOffset(), ptr2.getLength(), SortOrder.getDefault());
    }

    public final int compareTo(byte[] ba1, int offset1, int length1, SortOrder so1, byte[] ba2, int offset2, int length2, SortOrder so2) {
        Preconditions.checkNotNull(so1);
        Preconditions.checkNotNull(so2);
        if (so1 != so2) {
            int length = Math.min(length1, length2);
            for (int i = 0; i < length; ++i) {
                byte b1 = ba1[offset1 + i];
                byte b2 = ba2[offset2 + i];
                if (so1 == SortOrder.DESC) {
                    b1 = SortOrder.invert(b1);
                } else {
                    b2 = SortOrder.invert(b2);
                }
                int c = b1 - b2;
                if (c == 0) continue;
                return c;
            }
            return length1 - length2;
        }
        return Bytes.compareTo(ba1, offset1, length1, ba2, offset2, length2) * (so1 == SortOrder.DESC ? -1 : 1);
    }

    public final int compareTo(ImmutableBytesWritable ptr1, SortOrder ptr1SortOrder, ImmutableBytesWritable ptr2, SortOrder ptr2SortOrder, PDataType type2) {
        return this.compareTo(ptr1.get(), ptr1.getOffset(), ptr1.getLength(), ptr1SortOrder, ptr2.get(), ptr2.getOffset(), ptr2.getLength(), ptr2SortOrder, type2);
    }

    public final int compareTo(Object lhs, Object rhs) {
        return this.compareTo(lhs, rhs, this);
    }

    public final boolean isNull(byte[] value) {
        return value == null || value.length == 0;
    }

    public byte[] toBytes(Object object, SortOrder sortOrder) {
        Preconditions.checkNotNull(sortOrder);
        byte[] bytes = this.toBytes(object);
        if (sortOrder == SortOrder.DESC) {
            SortOrder.invert(bytes, 0, bytes, 0, bytes.length);
        }
        return bytes;
    }

    public void coerceBytes(ImmutableBytesWritable ptr, Object o, PDataType actualType, Integer actualMaxLength, Integer actualScale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
        Preconditions.checkNotNull(actualModifier);
        Preconditions.checkNotNull(expectedModifier);
        if (ptr.getLength() == 0) {
            return;
        }
        if (this.isBytesComparableWith(actualType)) {
            if (actualModifier == expectedModifier) {
                return;
            }
            byte[] b = ptr.copyBytes();
            SortOrder.invert(b, 0, b, 0, b.length);
            ptr.set(b);
            return;
        }
        if (o == null) {
            o = actualType.toObject(ptr, actualType, actualModifier);
        }
        o = this.toObject(o, actualType);
        byte[] b = this.toBytes(o, expectedModifier);
        ptr.set(b);
    }

    public final void coerceBytes(ImmutableBytesWritable ptr, PDataType actualType, SortOrder actualModifier, SortOrder expectedModifier) {
        this.coerceBytes(ptr, null, actualType, null, null, actualModifier, null, null, expectedModifier);
    }

    public final void coerceBytes(ImmutableBytesWritable ptr, PDataType actualType, SortOrder actualModifier, SortOrder expectedModifier, Integer desiredMaxLength) {
        this.coerceBytes(ptr, null, actualType, null, null, actualModifier, desiredMaxLength, null, expectedModifier);
    }

    private static Void throwConstraintViolationException(PDataType source, PDataType target) {
        throw new ConstraintViolationException((Object)((Object)source) + " cannot be coerced to " + (Object)((Object)target));
    }

    private static boolean isNonNegativeDate(java.util.Date date) {
        return date == null || date.getTime() >= 0L;
    }

    private static void throwIfNonNegativeDate(java.util.Date date) {
        if (!PDataType.isNonNegativeDate(date)) {
            throw new IllegalDataException("Value may not be negative(" + date + ")");
        }
    }

    private static boolean isNonNegativeNumber(Number v) {
        return v == null || v.longValue() >= 0L;
    }

    private static void throwIfNonNegativeNumber(Number v) {
        if (!PDataType.isNonNegativeNumber(v)) {
            throw new IllegalDataException("Value may not be negative(" + v + ")");
        }
    }

    public abstract Integer getByteSize();

    public abstract boolean isFixedWidth();

    public abstract int compareTo(Object var1, Object var2, PDataType var3);

    public abstract int toBytes(Object var1, byte[] var2, int var3);

    public abstract byte[] toBytes(Object var1);

    public abstract Object toObject(String var1);

    public abstract Object toObject(Object var1, PDataType var2);

    public abstract Object toObject(byte[] var1, int var2, int var3, PDataType var4, SortOrder var5, Integer var6, Integer var7);

    public final Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder) {
        return this.toObject(bytes, offset, length, actualType, sortOrder, null, null);
    }

    public final Object toObject(byte[] bytes, int offset, int length, PDataType actualType) {
        return this.toObject(bytes, offset, length, actualType, SortOrder.getDefault());
    }

    public final Object toObject(ImmutableBytesWritable ptr, PDataType actualType) {
        return this.toObject(ptr, actualType, SortOrder.getDefault());
    }

    public final Object toObject(ImmutableBytesWritable ptr, PDataType actualType, SortOrder sortOrder) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), actualType, sortOrder);
    }

    public final Object toObject(ImmutableBytesWritable ptr, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), actualType, sortOrder, maxLength, scale);
    }

    public final Object toObject(ImmutableBytesWritable ptr, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), this, sortOrder, maxLength, scale);
    }

    public final Object toObject(ImmutableBytesWritable ptr) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength());
    }

    public final Object toObject(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        return this.toObject(ptr.get(), ptr.getOffset(), ptr.getLength(), this, sortOrder);
    }

    public final Object toObject(byte[] bytes, int offset, int length) {
        return this.toObject(bytes, offset, length, this);
    }

    public final Object toObject(byte[] bytes) {
        return this.toObject(bytes, SortOrder.getDefault());
    }

    public final Object toObject(byte[] bytes, SortOrder sortOrder) {
        return this.toObject(bytes, 0, bytes.length, this, sortOrder);
    }

    public final Object toObject(byte[] bytes, SortOrder sortOrder, PDataType actualType) {
        return this.toObject(bytes, 0, bytes.length, actualType, sortOrder);
    }

    public static PDataType fromSqlTypeName(String sqlTypeName) {
        PDataType dataType = SQL_TYPE_NAME_TO_PCOLUMN_DATA_TYPE.get(sqlTypeName);
        if (dataType != null) {
            return dataType;
        }
        throw new IllegalDataException("Unsupported sql type: " + sqlTypeName);
    }

    public static int sqlArrayType(String sqlTypeName) {
        PDataType fromSqlTypeName = PDataType.fromSqlTypeName(sqlTypeName);
        return fromSqlTypeName.getSqlType() + 3000;
    }

    public static PDataType fromTypeId(int typeId) {
        PDataType type;
        int offset = typeId - SQL_TYPE_OFFSET;
        if (offset >= 0 && offset < SQL_TYPE_TO_PCOLUMN_DATA_TYPE.length && (type = SQL_TYPE_TO_PCOLUMN_DATA_TYPE[offset]) != null) {
            return type;
        }
        throw new IllegalDataException("Unsupported sql type: " + typeId);
    }

    public static PhoenixArrayFactory[] getArrayFactory() {
        return ARRAY_FACTORY;
    }

    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public byte[] getJavaClassNameBytes() {
        return this.clazzNameBytes;
    }

    public byte[] getSqlTypeNameBytes() {
        return this.sqlTypeNameBytes;
    }

    public int getResultSetSqlType() {
        return this.sqlType;
    }

    public KeyRange getKeyRange(byte[] point) {
        return this.getKeyRange(point, true, point, true);
    }

    public final String toStringLiteral(ImmutableBytesWritable ptr, Format formatter) {
        return this.toStringLiteral(ptr.get(), ptr.getOffset(), ptr.getLength(), formatter);
    }

    public final String toStringLiteral(byte[] b, Format formatter) {
        return this.toStringLiteral(b, 0, b.length, formatter);
    }

    public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
        Object o = this.toObject(b, offset, length);
        if (formatter != null) {
            return formatter.format(o);
        }
        return o.toString();
    }

    public static PhoenixArray instantiatePhoenixArray(PDataType actualType, Object[] elements) {
        PhoenixArrayFactory factory = ARRAY_FACTORY[actualType.ordinal()];
        if (factory == null) {
            throw new IllegalArgumentException("Cannot create an array of " + (Object)((Object)actualType));
        }
        return factory.newArray(actualType, elements);
    }

    public KeyRange getKeyRange(byte[] lowerRange, boolean lowerInclusive, byte[] upperRange, boolean upperInclusive) {
        if (lowerRange != KeyRange.UNBOUND && !lowerInclusive && this.isFixedWidth()) {
            lowerRange = ByteUtil.nextKey(lowerRange);
            lowerInclusive = true;
        }
        return KeyRange.getKeyRange(lowerRange, lowerInclusive, upperRange, upperInclusive);
    }

    public static PDataType fromLiteral(Object value) {
        if (value == null) {
            return null;
        }
        for (PDataType type : PDataType.values()) {
            if (type.isArrayType()) {
                PhoenixArray arr = (PhoenixArray)value;
                if (type.getSqlType() != arr.baseType.sqlType + 3000 || !type.getJavaClass().isInstance(value)) continue;
                return type;
            }
            if (!type.getJavaClass().isInstance(value)) continue;
            return type;
        }
        throw new UnsupportedOperationException("Unsupported literal value [" + value + "] of type " + value.getClass().getName());
    }

    public int getNanos(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        throw new UnsupportedOperationException("Operation not supported for type " + (Object)((Object)this));
    }

    public long getMillis(ImmutableBytesWritable ptr, SortOrder sortOrder) {
        throw new UnsupportedOperationException("Operation not supported for type " + (Object)((Object)this));
    }

    public Object pad(Object object, int maxLength) {
        return object;
    }

    static {
        int sqlType;
        VARCHAR = new PDataType("VARCHAR", 12, String.class, null){

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    return ByteUtil.EMPTY_BYTE_ARRAY;
                }
                return Bytes.toBytes((String)object);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    return 0;
                }
                byte[] b = this.toBytes(object);
                System.arraycopy(b, 0, bytes, offset, b.length);
                return b.length;
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (!actualType.isCoercibleTo(this)) {
                    throw new ConstraintViolationException((Object)((Object)actualType) + " cannot be coerced to " + (Object)((Object)this));
                }
                if (length == 0) {
                    return null;
                }
                if (sortOrder == SortOrder.DESC) {
                    bytes = SortOrder.invert(bytes, offset, length);
                    offset = 0;
                }
                return Bytes.toString(bytes, offset, length);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                switch (actualType) {
                    case VARCHAR: 
                    case CHAR: {
                        String s = (String)object;
                        return s == null || s.length() > 0 ? s : null;
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || targetType == CHAR || targetType == VARBINARY || targetType == BINARY;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (this.isCoercibleTo(targetType)) {
                    if (targetType == CHAR) {
                        return value != null;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                if (ptr.getLength() != 0 && maxLength != null && desiredMaxLength != null) {
                    return maxLength <= desiredMaxLength;
                }
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int estimateByteSize(Object o) {
                String value = (String)o;
                return value == null ? 1 : value.length();
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return ((String)lhs).compareTo((String)rhs);
            }

            @Override
            public Object toObject(String value) {
                return value;
            }

            @Override
            public boolean isBytesComparableWith(PDataType otherType) {
                return super.isBytesComparableWith(otherType) || this == CHAR;
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                while (b[length - 1] == 0) {
                    --length;
                }
                if (formatter != null) {
                    Object o = this.toObject(b, offset, length);
                    return "'" + formatter.format(o) + "'";
                }
                return "'" + Bytes.toStringBinary(b, offset, length) + "'";
            }
        };
        CHAR = new PDataType("CHAR", 1, String.class, null){

            @Override
            public Object pad(Object object, int maxLength) {
                String s = (String)object;
                if (s == null) {
                    return s;
                }
                if (s.length() == maxLength) {
                    return object;
                }
                if (s.length() > maxLength) {
                    throw new ValueTypeIncompatibleException(this, maxLength, null);
                }
                return Strings.padEnd(s, maxLength, ' ');
            }

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                byte[] b = VARCHAR.toBytes(object);
                if (b.length != ((String)object).length()) {
                    throw new IllegalDataException("CHAR types may only contain single byte characters (" + object + ")");
                }
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                int len = VARCHAR.toBytes(object, bytes, offset);
                if (len != ((String)object).length()) {
                    throw new IllegalDataException("CHAR types may only contain single byte characters (" + object + ")");
                }
                return len;
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                String s;
                if (!actualType.isCoercibleTo(this)) {
                    throw new ConstraintViolationException((Object)((Object)actualType) + " cannot be coerced to " + (Object)((Object)this));
                }
                if (length == 0) {
                    return null;
                }
                length = StringUtil.getUnpaddedCharLength(bytes, offset, length, sortOrder);
                if (sortOrder == SortOrder.DESC) {
                    bytes = SortOrder.invert(bytes, offset, length);
                    offset = 0;
                }
                if (length != (s = Bytes.toString(bytes, offset, length)).length()) {
                    throw new IllegalDataException("CHAR types may only contain single byte characters (" + s + ")");
                }
                return s;
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                switch (actualType) {
                    case VARCHAR: 
                    case CHAR: {
                        String s = (String)object;
                        return s == null || s.length() > 0 ? s : null;
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || targetType == VARCHAR || targetType == BINARY || targetType == VARBINARY;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object o, PDataType actualType, Integer actualMaxLength, Integer actualScale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
                if (o != null && actualType == VARCHAR && ((String)o).length() != ptr.getLength()) {
                    throw new IllegalDataException("CHAR types may only contain single byte characters (" + o + ")");
                }
                super.coerceBytes(ptr, o, actualType, actualMaxLength, actualScale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                return VARCHAR.isSizeCompatible(ptr, value, srcType, maxLength, scale, desiredMaxLength, desiredScale);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public Integer getMaxLength(Object o) {
                if (o == null) {
                    return null;
                }
                String value = (String)o;
                return value.length();
            }

            @Override
            public int estimateByteSize(Object o) {
                String value = (String)o;
                return value.length();
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return VARCHAR.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                if (StringUtil.hasMultiByteChars(value)) {
                    throw new IllegalDataException("CHAR types may only contain single byte characters (" + value + ")");
                }
                return value;
            }

            @Override
            public Integer estimateByteSizeFromLength(Integer length) {
                return length;
            }

            @Override
            public boolean isBytesComparableWith(PDataType otherType) {
                return super.isBytesComparableWith(otherType) || this == VARCHAR;
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                return VARCHAR.toStringLiteral(b, offset, length, formatter);
            }
        };
        LONG = new PDataType("BIGINT", -5, Long.class, new LongCodec()){

            @Override
            public Integer getScale(Object o) {
                return ZERO;
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[8];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] b, int o) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeLong(((Number)object).longValue(), b, o);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                if (object == null) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: {
                        return object;
                    }
                    case UNSIGNED_INT: 
                    case INTEGER: {
                        long s = ((Integer)object).intValue();
                        return s;
                    }
                    case TINYINT: 
                    case UNSIGNED_TINYINT: {
                        long s = ((Byte)object).byteValue();
                        return s;
                    }
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: {
                        long s = ((Short)object).shortValue();
                        return s;
                    }
                    case FLOAT: 
                    case UNSIGNED_FLOAT: {
                        Float f = (Float)object;
                        if (f.floatValue() > 9.223372E18f || f.floatValue() < -9.223372E18f) {
                            throw new IllegalDataException((Object)((Object)actualType) + " value " + f + " cannot be cast to Long without changing its value");
                        }
                        long s = f.longValue();
                        return s;
                    }
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        Double de = (Double)object;
                        if (de > 9.223372036854776E18 || de < -9.223372036854776E18) {
                            throw new IllegalDataException((Object)((Object)actualType) + " value " + de + " cannot be cast to Long without changing its value");
                        }
                        long s = de.longValue();
                        return s;
                    }
                    case DECIMAL: {
                        BigDecimal d = (BigDecimal)object;
                        return d.longValueExact();
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public Long toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (l == 0) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case UNSIGNED_INT: 
                    case INTEGER: 
                    case TINYINT: 
                    case UNSIGNED_TINYINT: 
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: 
                    case FLOAT: 
                    case UNSIGNED_FLOAT: 
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return actualType.getCodec().decodeLong(b, o, sortOrder);
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        return bd.longValueExact();
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || targetType == DECIMAL || targetType == VARBINARY || targetType == BINARY || targetType == DOUBLE;
            }

            @Override
            public boolean isComparableTo(PDataType targetType) {
                return DECIMAL.isComparableTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    switch (targetType) {
                        case UNSIGNED_LONG: 
                        case UNSIGNED_FLOAT: 
                        case UNSIGNED_DOUBLE: {
                            long l = (Long)value;
                            return l >= 0L;
                        }
                        case UNSIGNED_INT: {
                            long l = (Long)value;
                            return l >= 0L && l <= Integer.MAX_VALUE;
                        }
                        case INTEGER: {
                            long l = (Long)value;
                            return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
                        }
                        case UNSIGNED_SMALLINT: {
                            long l = (Long)value;
                            return l >= 0L && l <= 32767L;
                        }
                        case SMALLINT: {
                            long l = (Long)value;
                            return l >= -32768L && l <= 32767L;
                        }
                        case TINYINT: {
                            long l = (Long)value;
                            return l >= -128L && l < 127L;
                        }
                        case UNSIGNED_TINYINT: {
                            long l = (Long)value;
                            return l >= 0L && l < 127L;
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 8;
            }

            @Override
            public Integer getMaxLength(Object o) {
                return LONG_PRECISION;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (rhsType == DECIMAL) {
                    return -((BigDecimal)rhs).compareTo(BigDecimal.valueOf(((Number)lhs).longValue()));
                }
                if (rhsType == DOUBLE || rhsType == FLOAT || rhsType == UNSIGNED_DOUBLE || rhsType == UNSIGNED_FLOAT) {
                    return Doubles.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
                }
                return Longs.compare(((Number)lhs).longValue(), ((Number)rhs).longValue());
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }
        };
        INTEGER = new PDataType("INTEGER", 4, Integer.class, new IntCodec()){

            @Override
            public Integer getScale(Object o) {
                return ZERO;
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[4];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] b, int o) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeInt(((Number)object).intValue(), b, o);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Object o = LONG.toObject(object, actualType);
                if (!(o instanceof Long) || o == null) {
                    return o;
                }
                long l = (Long)o;
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    throw new IllegalDataException((Object)((Object)actualType) + " value " + l + " cannot be cast to Integer without changing its value");
                }
                int v = (int)l;
                return v;
            }

            @Override
            public Integer toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (l == 0) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case UNSIGNED_INT: 
                    case INTEGER: 
                    case TINYINT: 
                    case UNSIGNED_TINYINT: 
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: 
                    case FLOAT: 
                    case UNSIGNED_FLOAT: 
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return actualType.getCodec().decodeInt(b, o, sortOrder);
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        return bd.intValueExact();
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    switch (targetType) {
                        case UNSIGNED_LONG: 
                        case UNSIGNED_INT: 
                        case UNSIGNED_FLOAT: 
                        case UNSIGNED_DOUBLE: {
                            int i = (Integer)value;
                            return i >= 0;
                        }
                        case UNSIGNED_SMALLINT: {
                            int i = (Integer)value;
                            return i >= 0 && i <= Short.MAX_VALUE;
                        }
                        case SMALLINT: {
                            int i = (Integer)value;
                            return i >= Short.MIN_VALUE && i <= Short.MAX_VALUE;
                        }
                        case TINYINT: {
                            int i = (Integer)value;
                            return i >= -128 && i <= 127;
                        }
                        case UNSIGNED_TINYINT: {
                            int i = (Integer)value;
                            return i >= 0 && i < 127;
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || targetType == FLOAT || LONG.isCoercibleTo(targetType);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 4;
            }

            @Override
            public Integer getMaxLength(Object o) {
                return INT_PRECISION;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return LONG.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public boolean isComparableTo(PDataType targetType) {
                return DECIMAL.isComparableTo(targetType);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }
        };
        SMALLINT = new PDataType("SMALLINT", 5, Short.class, new ShortCodec()){

            @Override
            public Integer getScale(Object o) {
                return ZERO;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return LONG.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public boolean isComparableTo(PDataType targetType) {
                return DECIMAL.isComparableTo(targetType);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 2;
            }

            @Override
            public Integer getMaxLength(Object o) {
                return SHORT_PRECISION;
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[2];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeShort(((Number)object).shortValue(), bytes, offset);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Object o = LONG.toObject(object, actualType);
                if (!(o instanceof Long) || o == null) {
                    return o;
                }
                long l = (Long)o;
                if (l < -32768L || l > 32767L) {
                    throw new IllegalDataException((Object)((Object)actualType) + " value " + l + " cannot be cast to Short without changing its value");
                }
                short s = (short)l;
                return s;
            }

            @Override
            public Short toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (l == 0) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case UNSIGNED_INT: 
                    case INTEGER: 
                    case TINYINT: 
                    case UNSIGNED_TINYINT: 
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: 
                    case FLOAT: 
                    case UNSIGNED_FLOAT: 
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return actualType.getCodec().decodeShort(b, o, sortOrder);
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        return bd.shortValueExact();
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    return Short.parseShort(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    switch (targetType) {
                        case UNSIGNED_LONG: 
                        case UNSIGNED_INT: 
                        case UNSIGNED_SMALLINT: 
                        case UNSIGNED_FLOAT: 
                        case UNSIGNED_DOUBLE: {
                            short i = (Short)value;
                            return i >= 0;
                        }
                        case UNSIGNED_TINYINT: {
                            short i = (Short)value;
                            return i >= 0 && i <= 127;
                        }
                        case TINYINT: {
                            short i = (Short)value;
                            return i >= -128 && i <= 127;
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || INTEGER.isCoercibleTo(targetType);
            }
        };
        TINYINT = new PDataType("TINYINT", -6, Byte.class, new ByteCodec()){

            @Override
            public Integer getScale(Object o) {
                return ZERO;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return LONG.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public boolean isComparableTo(PDataType targetType) {
                return DECIMAL.isComparableTo(targetType);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 1;
            }

            @Override
            public Integer getMaxLength(Object o) {
                return BYTE_PRECISION;
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[1];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeByte(((Number)object).byteValue(), bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    Byte b = Byte.parseByte(value);
                    return b;
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Object o = LONG.toObject(object, actualType);
                if (!(o instanceof Long) || o == null) {
                    return o;
                }
                long l = (Long)o;
                if (l < -128L || l > 127L) {
                    throw new IllegalDataException((Object)((Object)actualType) + " value " + l + " cannot be cast to Byte without changing its value");
                }
                return (byte)l;
            }

            @Override
            public Byte toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (l == 0) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case UNSIGNED_INT: 
                    case INTEGER: 
                    case TINYINT: 
                    case UNSIGNED_TINYINT: 
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: 
                    case FLOAT: 
                    case UNSIGNED_FLOAT: 
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return actualType.getCodec().decodeByte(b, o, sortOrder);
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        return bd.byteValueExact();
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    switch (targetType) {
                        case UNSIGNED_LONG: 
                        case UNSIGNED_INT: 
                        case UNSIGNED_TINYINT: 
                        case UNSIGNED_SMALLINT: 
                        case UNSIGNED_FLOAT: 
                        case UNSIGNED_DOUBLE: {
                            byte i = (Byte)value;
                            return i >= 0;
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || SMALLINT.isCoercibleTo(targetType);
            }
        };
        FLOAT = new PDataType("FLOAT", 6, Float.class, new FloatCodec()){

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return DOUBLE.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 4;
            }

            @Override
            public Integer getScale(Object o) {
                if (o == null) {
                    return null;
                }
                Float v = (Float)o;
                BigDecimal bd = BigDecimal.valueOf(v.floatValue());
                return bd.scale() == 0 ? null : Integer.valueOf(bd.scale());
            }

            @Override
            public Integer getMaxLength(Object o) {
                if (o == null) {
                    return null;
                }
                Float v = (Float)o;
                BigDecimal bd = BigDecimal.valueOf(v.floatValue());
                return bd.precision();
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[4];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeFloat(((Number)object).floatValue(), bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    return Float.valueOf(Float.parseFloat(value));
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                if (object == null) {
                    return null;
                }
                switch (actualType) {
                    case FLOAT: 
                    case UNSIGNED_FLOAT: {
                        return object;
                    }
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        double d = (Double)object;
                        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                            return Float.valueOf((float)d);
                        }
                        throw new IllegalDataException((Object)((Object)actualType) + " value " + d + " cannot be cast to Float without changing its value");
                    }
                    case LONG: 
                    case UNSIGNED_LONG: {
                        float f = ((Long)object).longValue();
                        return Float.valueOf(f);
                    }
                    case UNSIGNED_INT: 
                    case INTEGER: {
                        float f = ((Integer)object).intValue();
                        return Float.valueOf(f);
                    }
                    case TINYINT: 
                    case UNSIGNED_TINYINT: {
                        float f = ((Byte)object).byteValue();
                        return Float.valueOf(f);
                    }
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: {
                        float f = ((Short)object).shortValue();
                        return Float.valueOf(f);
                    }
                    case DECIMAL: {
                        BigDecimal dl = (BigDecimal)object;
                        return Float.valueOf(dl.floatValue());
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public Float toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (l <= 0) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case UNSIGNED_INT: 
                    case INTEGER: 
                    case TINYINT: 
                    case UNSIGNED_TINYINT: 
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: 
                    case FLOAT: 
                    case UNSIGNED_FLOAT: 
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return Float.valueOf(actualType.getCodec().decodeFloat(b, o, sortOrder));
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        return Float.valueOf(bd.floatValue());
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    float f = ((Float)value).floatValue();
                    switch (targetType) {
                        case UNSIGNED_FLOAT: {
                            return f >= 0.0f;
                        }
                        case UNSIGNED_LONG: {
                            return f >= 0.0f && f <= 9.223372E18f;
                        }
                        case LONG: {
                            return f >= -9.223372E18f && f <= 9.223372E18f;
                        }
                        case UNSIGNED_INT: {
                            return f >= 0.0f && f <= 2.1474836E9f;
                        }
                        case INTEGER: {
                            return f >= -2.1474836E9f && f <= 2.1474836E9f;
                        }
                        case UNSIGNED_SMALLINT: {
                            return f >= 0.0f && f <= 32767.0f;
                        }
                        case SMALLINT: {
                            return f >= -32768.0f && f <= 32767.0f;
                        }
                        case TINYINT: {
                            return f >= -128.0f && f < 127.0f;
                        }
                        case UNSIGNED_TINYINT: {
                            return f >= 0.0f && f < 127.0f;
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || DOUBLE.isCoercibleTo(targetType);
            }
        };
        DOUBLE = new PDataType("DOUBLE", 8, Double.class, new DoubleCodec()){

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (rhsType == DECIMAL) {
                    return -((BigDecimal)rhs).compareTo(BigDecimal.valueOf(((Number)lhs).doubleValue()));
                }
                return Doubles.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 8;
            }

            @Override
            public Integer getScale(Object o) {
                if (o == null) {
                    return null;
                }
                Double v = (Double)o;
                BigDecimal bd = BigDecimal.valueOf(v);
                return bd.scale() == 0 ? null : Integer.valueOf(bd.scale());
            }

            @Override
            public Integer getMaxLength(Object o) {
                if (o == null) {
                    return null;
                }
                Double v = (Double)o;
                BigDecimal db = BigDecimal.valueOf(v);
                return db.precision();
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[8];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeDouble(((Number)object).doubleValue(), bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                if (object == null) {
                    return null;
                }
                switch (actualType) {
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return object;
                    }
                    case FLOAT: 
                    case UNSIGNED_FLOAT: {
                        double de = ((Float)object).floatValue();
                        return de;
                    }
                    case LONG: 
                    case UNSIGNED_LONG: {
                        double de = ((Long)object).longValue();
                        return de;
                    }
                    case UNSIGNED_INT: 
                    case INTEGER: {
                        double de = ((Integer)object).intValue();
                        return de;
                    }
                    case TINYINT: 
                    case UNSIGNED_TINYINT: {
                        double de = ((Byte)object).byteValue();
                        return de;
                    }
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: {
                        double de = ((Short)object).shortValue();
                        return de;
                    }
                    case DECIMAL: {
                        BigDecimal d = (BigDecimal)object;
                        return d.doubleValue();
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public Double toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (l <= 0) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case UNSIGNED_INT: 
                    case INTEGER: 
                    case TINYINT: 
                    case UNSIGNED_TINYINT: 
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: 
                    case FLOAT: 
                    case UNSIGNED_FLOAT: 
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return actualType.getCodec().decodeDouble(b, o, sortOrder);
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        return bd.doubleValue();
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    double d = (Double)value;
                    switch (targetType) {
                        case UNSIGNED_DOUBLE: {
                            return d >= 0.0;
                        }
                        case FLOAT: {
                            return Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38;
                        }
                        case UNSIGNED_FLOAT: {
                            return Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d >= 0.0 && d <= 3.4028234663852886E38;
                        }
                        case UNSIGNED_LONG: {
                            return d >= 0.0 && d <= 9.223372036854776E18;
                        }
                        case LONG: {
                            return d >= -9.223372036854776E18 && d <= 9.223372036854776E18;
                        }
                        case UNSIGNED_INT: {
                            return d >= 0.0 && d <= 2.147483647E9;
                        }
                        case INTEGER: {
                            return d >= -2.147483648E9 && d <= 2.147483647E9;
                        }
                        case UNSIGNED_SMALLINT: {
                            return d >= 0.0 && d <= 32767.0;
                        }
                        case SMALLINT: {
                            return d >= -32768.0 && d <= 32767.0;
                        }
                        case TINYINT: {
                            return d >= -128.0 && d < 127.0;
                        }
                        case UNSIGNED_TINYINT: {
                            return d >= 0.0 && d < 127.0;
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || targetType == DECIMAL || targetType == VARBINARY || targetType == BINARY;
            }
        };
        DECIMAL = new PDataType("DECIMAL", 3, BigDecimal.class, null){

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    return ByteUtil.EMPTY_BYTE_ARRAY;
                }
                BigDecimal v = (BigDecimal)object;
                v = NumberUtil.normalize(v);
                int len = this.getLength(v);
                byte[] result = new byte[Math.min(len, MAX_BIG_DECIMAL_BYTES)];
                PDataType.toBytes(v, result, 0, len);
                return result;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    return 0;
                }
                BigDecimal v = (BigDecimal)object;
                v = NumberUtil.normalize(v);
                int len = this.getLength(v);
                return PDataType.toBytes(v, bytes, offset, len);
            }

            private int getLength(BigDecimal v) {
                int signum = v.signum();
                if (signum == 0) {
                    return 1;
                }
                return (signum < 0 ? 2 : 1) + (v.precision() + 1 + (v.scale() % 2 == 0 ? 0 : 1)) / 2;
            }

            @Override
            public int estimateByteSize(Object o) {
                if (o == null) {
                    return 1;
                }
                BigDecimal v = (BigDecimal)o;
                return Math.min(this.getLength(v), MAX_BIG_DECIMAL_BYTES);
            }

            @Override
            public Integer getMaxLength(Object o) {
                if (o == null) {
                    return 38;
                }
                BigDecimal v = (BigDecimal)o;
                return v.precision();
            }

            @Override
            public Integer getScale(Object o) {
                if (o == null) {
                    return null;
                }
                BigDecimal v = (BigDecimal)o;
                int scale = v.scale();
                if (scale == 0) {
                    return null;
                }
                return v.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0 ? null : Integer.valueOf(scale);
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Preconditions.checkNotNull(sortOrder);
                if (l == 0) {
                    return null;
                }
                switch (actualType) {
                    case DECIMAL: {
                        if (sortOrder == SortOrder.DESC) {
                            b = SortOrder.invert(b, o, new byte[l], 0, l);
                            o = 0;
                        }
                        return PDataType.toBigDecimal(b, o, l);
                    }
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case UNSIGNED_INT: 
                    case INTEGER: 
                    case TINYINT: 
                    case UNSIGNED_TINYINT: 
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: 
                    case DATE: 
                    case TIME: 
                    case UNSIGNED_DATE: 
                    case UNSIGNED_TIME: {
                        return BigDecimal.valueOf(actualType.getCodec().decodeLong(b, o, sortOrder));
                    }
                    case FLOAT: 
                    case UNSIGNED_FLOAT: {
                        return BigDecimal.valueOf(actualType.getCodec().decodeFloat(b, o, sortOrder));
                    }
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return BigDecimal.valueOf(actualType.getCodec().decodeDouble(b, o, sortOrder));
                    }
                    case TIMESTAMP: 
                    case UNSIGNED_TIMESTAMP: {
                        long millisPart = actualType.getCodec().decodeLong(b, o, sortOrder);
                        int nanoPart = UNSIGNED_INT.getCodec().decodeInt(b, o + 8, sortOrder);
                        BigDecimal nanosPart = BigDecimal.valueOf((double)nanoPart % QueryConstants.MILLIS_TO_NANOS_CONVERTOR / QueryConstants.MILLIS_TO_NANOS_CONVERTOR);
                        BigDecimal value = BigDecimal.valueOf(millisPart).add(nanosPart);
                        return value;
                    }
                    case BOOLEAN: {
                        return (Boolean)BOOLEAN.toObject(b, o, l, actualType, sortOrder) != false ? BigDecimal.ONE : BigDecimal.ZERO;
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                if (object == null) {
                    return null;
                }
                switch (actualType) {
                    case UNSIGNED_INT: 
                    case INTEGER: {
                        return BigDecimal.valueOf(((Integer)object).intValue());
                    }
                    case LONG: 
                    case UNSIGNED_LONG: {
                        return BigDecimal.valueOf((Long)object);
                    }
                    case SMALLINT: 
                    case UNSIGNED_SMALLINT: {
                        return BigDecimal.valueOf(((Short)object).shortValue());
                    }
                    case TINYINT: 
                    case UNSIGNED_TINYINT: {
                        return BigDecimal.valueOf(((Byte)object).byteValue());
                    }
                    case FLOAT: 
                    case UNSIGNED_FLOAT: {
                        return BigDecimal.valueOf(((Float)object).floatValue());
                    }
                    case DOUBLE: 
                    case UNSIGNED_DOUBLE: {
                        return BigDecimal.valueOf((Double)object);
                    }
                    case DECIMAL: {
                        return object;
                    }
                    case DATE: 
                    case TIME: 
                    case UNSIGNED_DATE: 
                    case UNSIGNED_TIME: {
                        java.util.Date d = (java.util.Date)object;
                        return BigDecimal.valueOf(d.getTime());
                    }
                    case TIMESTAMP: 
                    case UNSIGNED_TIMESTAMP: {
                        Timestamp ts = (Timestamp)object;
                        long millisPart = ts.getTime();
                        BigDecimal nanosPart = BigDecimal.valueOf((double)ts.getNanos() % QueryConstants.MILLIS_TO_NANOS_CONVERTOR / QueryConstants.MILLIS_TO_NANOS_CONVERTOR);
                        BigDecimal value = BigDecimal.valueOf(millisPart).add(nanosPart);
                        return value;
                    }
                    case BOOLEAN: {
                        return (Boolean)object != false ? BigDecimal.ONE : BigDecimal.ZERO;
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public Integer getByteSize() {
                return MAX_BIG_DECIMAL_BYTES;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (rhsType == DECIMAL) {
                    return ((BigDecimal)lhs).compareTo((BigDecimal)rhs);
                }
                return -rhsType.compareTo(rhs, lhs, this);
            }

            @Override
            public boolean isCastableTo(PDataType targetType) {
                return super.isCastableTo(targetType) || targetType.isCoercibleTo(TIMESTAMP) || targetType == BOOLEAN;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    switch (targetType) {
                        case UNSIGNED_LONG: 
                        case UNSIGNED_INT: 
                        case UNSIGNED_TINYINT: 
                        case UNSIGNED_SMALLINT: {
                            BigDecimal bd = (BigDecimal)value;
                            if (bd.signum() == -1) {
                                return false;
                            }
                        }
                        case LONG: {
                            BigDecimal bd = (BigDecimal)value;
                            try {
                                bd.longValueExact();
                                return true;
                            }
                            catch (ArithmeticException e) {
                                return false;
                            }
                        }
                        case INTEGER: {
                            BigDecimal bd = (BigDecimal)value;
                            try {
                                bd.intValueExact();
                                return true;
                            }
                            catch (ArithmeticException e) {
                                return false;
                            }
                        }
                        case SMALLINT: {
                            BigDecimal bd = (BigDecimal)value;
                            try {
                                bd.shortValueExact();
                                return true;
                            }
                            catch (ArithmeticException e) {
                                return false;
                            }
                        }
                        case TINYINT: {
                            BigDecimal bd = (BigDecimal)value;
                            try {
                                bd.byteValueExact();
                                return true;
                            }
                            catch (ArithmeticException e) {
                                return false;
                            }
                        }
                        case UNSIGNED_FLOAT: {
                            BigDecimal bd = (BigDecimal)value;
                            try {
                                BigDecimal maxFloat = MAX_FLOAT_AS_BIG_DECIMAL;
                                boolean isNegtive = bd.signum() == -1;
                                return bd.compareTo(maxFloat) <= 0 && !isNegtive;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        case FLOAT: {
                            BigDecimal bd = (BigDecimal)value;
                            try {
                                BigDecimal maxFloat = MAX_FLOAT_AS_BIG_DECIMAL;
                                BigDecimal minFloat = MIN_FLOAT_AS_BIG_DECIMAL;
                                return bd.compareTo(maxFloat) <= 0 && bd.compareTo(minFloat) >= 0;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        case UNSIGNED_DOUBLE: {
                            BigDecimal bd = (BigDecimal)value;
                            try {
                                BigDecimal maxDouble = MAX_DOUBLE_AS_BIG_DECIMAL;
                                boolean isNegtive = bd.signum() == -1;
                                return bd.compareTo(maxDouble) <= 0 && !isNegtive;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        case DOUBLE: {
                            BigDecimal bd = (BigDecimal)value;
                            try {
                                BigDecimal maxDouble = MAX_DOUBLE_AS_BIG_DECIMAL;
                                BigDecimal minDouble = MIN_DOUBLE_AS_BIG_DECIMAL;
                                return bd.compareTo(maxDouble) <= 0 && bd.compareTo(minDouble) >= 0;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                if (ptr.getLength() == 0) {
                    return true;
                }
                if (value != null) {
                    BigDecimal v = (BigDecimal)value;
                    maxLength = v.precision();
                    scale = v.scale();
                } else {
                    int[] v = 9.getDecimalPrecisionAndScale(ptr.get(), ptr.getOffset(), ptr.getLength());
                    maxLength = v[0];
                    scale = v[1];
                }
                return desiredMaxLength == null || desiredScale == null || maxLength == null || scale == null || (desiredScale != null || desiredMaxLength >= maxLength) && desiredMaxLength - desiredScale >= maxLength - scale;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
                if (desiredScale == null) {
                    super.coerceBytes(ptr, object, actualType, maxLength, scale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
                    return;
                }
                if (ptr.getLength() == 0) {
                    return;
                }
                if (scale == null) {
                    Object v;
                    if (object != null) {
                        v = (BigDecimal)object;
                        scale = ((BigDecimal)v).scale();
                    } else {
                        v = 9.getDecimalPrecisionAndScale(ptr.get(), ptr.getOffset(), ptr.getLength());
                        scale = (int)v[1];
                    }
                }
                if (this == actualType && scale <= desiredScale) {
                    return;
                }
                BigDecimal decimal = object != null ? (BigDecimal)this.toObject(object, actualType) : (BigDecimal)this.toObject(ptr);
                decimal = decimal.setScale((int)desiredScale, 1);
                ptr.set(this.toBytes(decimal));
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    return new BigDecimal(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public Integer estimateByteSizeFromLength(Integer length) {
                return null;
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                if (formatter == null) {
                    BigDecimal o = (BigDecimal)this.toObject(b, offset, length);
                    return o.toPlainString();
                }
                return super.toStringLiteral(b, offset, length, formatter);
            }
        };
        TIMESTAMP = new PDataType("TIMESTAMP", 93, Timestamp.class, new DateCodec()){

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                byte[] bytes = new byte[this.getByteSize().intValue()];
                this.toBytes(object, bytes, 0);
                return bytes;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                Timestamp value = (Timestamp)object;
                DATE.getCodec().encodeLong(value.getTime(), bytes, offset);
                Bytes.putInt(bytes, offset + 8, value.getNanos() % 1000000);
                return this.getByteSize();
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                if (object == null) {
                    return null;
                }
                switch (actualType) {
                    case DATE: 
                    case TIME: 
                    case UNSIGNED_DATE: 
                    case UNSIGNED_TIME: {
                        return new Timestamp(((java.util.Date)object).getTime());
                    }
                    case TIMESTAMP: 
                    case UNSIGNED_TIMESTAMP: {
                        return object;
                    }
                    case LONG: 
                    case UNSIGNED_LONG: {
                        return new Timestamp((Long)object);
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)object;
                        long ms = bd.longValue();
                        int nanos = bd.remainder(BigDecimal.ONE).multiply(QueryConstants.BD_MILLIS_NANOS_CONVERSION).intValue();
                        return DateUtil.getTimestamp(ms, nanos);
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public Timestamp toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (actualType == null || l == 0) {
                    return null;
                }
                switch (actualType) {
                    case TIMESTAMP: 
                    case UNSIGNED_TIMESTAMP: {
                        long millisDeserialized = (actualType == TIMESTAMP ? DATE : UNSIGNED_DATE).getCodec().decodeLong(b, o, sortOrder);
                        Timestamp v = new Timestamp(millisDeserialized);
                        int nanosDeserialized = UNSIGNED_INT.getCodec().decodeInt(b, o + 8, sortOrder);
                        v.setNanos(nanosDeserialized < 1000000 ? v.getNanos() + nanosDeserialized : nanosDeserialized);
                        return v;
                    }
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case DATE: 
                    case TIME: 
                    case UNSIGNED_DATE: 
                    case UNSIGNED_TIME: {
                        return new Timestamp(actualType.getCodec().decodeLong(b, o, sortOrder));
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        long ms = bd.longValue();
                        int nanos = bd.remainder(BigDecimal.ONE).multiply(QueryConstants.BD_MILLIS_NANOS_CONVERSION).intValue();
                        Timestamp v = DateUtil.getTimestamp(ms, nanos);
                        return v;
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public boolean isCastableTo(PDataType targetType) {
                return DATE.isCastableTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || targetType == VARBINARY || targetType == BINARY;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    switch (targetType) {
                        case UNSIGNED_TIMESTAMP: {
                            return ((java.util.Date)value).getTime() >= 0L;
                        }
                        case UNSIGNED_DATE: 
                        case UNSIGNED_TIME: {
                            return ((java.util.Date)value).getTime() >= 0L && ((Timestamp)value).getNanos() == 0;
                        }
                        case DATE: 
                        case TIME: {
                            return ((Timestamp)value).getNanos() == 0;
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return MAX_TIMESTAMP_BYTES;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (rhsType == TIMESTAMP || rhsType == UNSIGNED_TIMESTAMP) {
                    return ((Timestamp)lhs).compareTo((Timestamp)rhs);
                }
                int c = ((Date)rhs).compareTo((Date)lhs);
                if (c != 0) {
                    return c;
                }
                return ((Timestamp)lhs).getNanos();
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                return DateUtil.parseTimestamp(value);
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                Timestamp value = (Timestamp)this.toObject(b, offset, length);
                if (formatter == null || formatter == DateUtil.DEFAULT_DATE_FORMATTER) {
                    formatter = DateUtil.DEFAULT_MS_DATE_FORMATTER;
                }
                return "'" + super.toStringLiteral(b, offset, length, formatter) + "." + value.getNanos() + "'";
            }

            @Override
            public int getNanos(ImmutableBytesWritable ptr, SortOrder sortOrder) {
                int nanos = UNSIGNED_INT.getCodec().decodeInt(ptr.get(), ptr.getOffset() + LONG.getByteSize(), sortOrder);
                return nanos;
            }

            @Override
            public long getMillis(ImmutableBytesWritable ptr, SortOrder sortOrder) {
                long millis = LONG.getCodec().decodeLong(ptr.get(), ptr.getOffset(), sortOrder);
                return millis;
            }
        };
        TIME = new PDataType("TIME", 92, Time.class, new DateCodec()){

            @Override
            public byte[] toBytes(Object object) {
                return DATE.toBytes(object);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return DATE.toBytes(object, bytes, offset);
            }

            @Override
            public Time toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (l == 0) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case DATE: 
                    case TIME: 
                    case UNSIGNED_DATE: 
                    case UNSIGNED_TIME: 
                    case TIMESTAMP: 
                    case UNSIGNED_TIMESTAMP: {
                        return new Time(actualType.getCodec().decodeLong(b, o, sortOrder));
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        return new Time(bd.longValueExact());
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                if (object == null) {
                    return null;
                }
                switch (actualType) {
                    case DATE: 
                    case UNSIGNED_DATE: {
                        return new Time(((Date)object).getTime());
                    }
                    case TIMESTAMP: 
                    case UNSIGNED_TIMESTAMP: {
                        return new Time(((Timestamp)object).getTime());
                    }
                    case TIME: 
                    case UNSIGNED_TIME: {
                        return object;
                    }
                    case LONG: 
                    case UNSIGNED_LONG: {
                        return new Time((Long)object);
                    }
                    case DECIMAL: {
                        return new Time(((BigDecimal)object).longValueExact());
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public boolean isCastableTo(PDataType targetType) {
                return DATE.isCastableTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return DATE.isCoercibleTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return DATE.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 8;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return DATE.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                return DateUtil.parseTime(value);
            }

            @Override
            public boolean isBytesComparableWith(PDataType otherType) {
                return super.isBytesComparableWith(otherType) || this == DATE;
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                return DATE.toStringLiteral(b, offset, length, formatter);
            }
        };
        DATE = new PDataType("DATE", 91, Date.class, new DateCodec()){

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                byte[] bytes = new byte[this.getByteSize().intValue()];
                this.toBytes(object, bytes, 0);
                return bytes;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                this.getCodec().encodeLong(((java.util.Date)object).getTime(), bytes, offset);
                return this.getByteSize();
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                if (object == null) {
                    return null;
                }
                switch (actualType) {
                    case TIME: 
                    case UNSIGNED_TIME: {
                        return new Date(((Time)object).getTime());
                    }
                    case TIMESTAMP: 
                    case UNSIGNED_TIMESTAMP: {
                        return new Date(((Timestamp)object).getTime());
                    }
                    case DATE: 
                    case UNSIGNED_DATE: {
                        return object;
                    }
                    case LONG: 
                    case UNSIGNED_LONG: {
                        return new Date((Long)object);
                    }
                    case DECIMAL: {
                        return new Date(((BigDecimal)object).longValueExact());
                    }
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }

            @Override
            public Date toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (l == 0) {
                    return null;
                }
                switch (actualType) {
                    case LONG: 
                    case UNSIGNED_LONG: 
                    case DATE: 
                    case TIME: 
                    case UNSIGNED_DATE: 
                    case UNSIGNED_TIME: 
                    case TIMESTAMP: 
                    case UNSIGNED_TIMESTAMP: {
                        return new Date(actualType.getCodec().decodeLong(b, o, sortOrder));
                    }
                    case DECIMAL: {
                        BigDecimal bd = (BigDecimal)actualType.toObject(b, o, l, actualType, sortOrder);
                        return new Date(bd.longValueExact());
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public boolean isCastableTo(PDataType targetType) {
                return super.isCastableTo(targetType) || targetType == DECIMAL || targetType == LONG || targetType == UNSIGNED_LONG;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return targetType == DATE || targetType == TIME || targetType == TIMESTAMP || targetType == VARBINARY || targetType == BINARY;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                if (value != null) {
                    switch (targetType) {
                        case UNSIGNED_DATE: 
                        case UNSIGNED_TIME: 
                        case UNSIGNED_TIMESTAMP: {
                            return ((java.util.Date)value).getTime() >= 0L;
                        }
                    }
                }
                return super.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 8;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (rhsType == TIMESTAMP || rhsType == UNSIGNED_TIMESTAMP) {
                    return -rhsType.compareTo(rhs, lhs, TIME);
                }
                return ((java.util.Date)rhs).compareTo((java.util.Date)lhs);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                return DateUtil.parseDate(value);
            }

            @Override
            public boolean isBytesComparableWith(PDataType otherType) {
                return super.isBytesComparableWith(otherType) || this == TIME;
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                if (formatter == null || formatter == DateUtil.DEFAULT_DATE_FORMATTER) {
                    formatter = DateUtil.DEFAULT_MS_DATE_FORMATTER;
                }
                return "'" + super.toStringLiteral(b, offset, length, formatter) + "'";
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
                if (ptr.getLength() > 0 && actualType == TIMESTAMP && actualModifier == expectedModifier) {
                    ptr.set(ptr.get(), ptr.getOffset(), this.getByteSize());
                    return;
                }
                super.coerceBytes(ptr, object, actualType, maxLength, scale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
            }
        };
        UNSIGNED_TIMESTAMP = new PDataType("UNSIGNED_TIMESTAMP", 19, Timestamp.class, null){

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                byte[] bytes = new byte[this.getByteSize().intValue()];
                this.toBytes(object, bytes, 0);
                return bytes;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                Timestamp value = (Timestamp)object;
                UNSIGNED_DATE.getCodec().encodeLong(value.getTime(), bytes, offset);
                Bytes.putInt(bytes, offset + 8, value.getNanos() % 1000000);
                return this.getByteSize();
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Timestamp ts = (Timestamp)TIMESTAMP.toObject(object, actualType);
                PDataType.throwIfNonNegativeDate(ts);
                return ts;
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Timestamp ts = (Timestamp)TIMESTAMP.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeDate(ts);
                return ts;
            }

            @Override
            public boolean isCastableTo(PDataType targetType) {
                return UNSIGNED_DATE.isCastableTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return targetType == this || UNSIGNED_DATE.isCoercibleTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType, value) || TIMESTAMP.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return TIMESTAMP.getByteSize();
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return TIMESTAMP.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public Object toObject(String value) {
                return TIMESTAMP.toObject(value);
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                Timestamp value = (Timestamp)this.toObject(b, offset, length);
                if (formatter == null || formatter == DateUtil.DEFAULT_DATE_FORMATTER) {
                    formatter = DateUtil.DEFAULT_MS_DATE_FORMATTER;
                }
                return "'" + super.toStringLiteral(b, offset, length, formatter) + "." + value.getNanos() + "'";
            }

            @Override
            public int getNanos(ImmutableBytesWritable ptr, SortOrder sortOrder) {
                int nanos = UNSIGNED_INT.getCodec().decodeInt(ptr.get(), ptr.getOffset() + LONG.getByteSize(), sortOrder);
                return nanos;
            }

            @Override
            public long getMillis(ImmutableBytesWritable ptr, SortOrder sortOrder) {
                long millis = UNSIGNED_LONG.getCodec().decodeLong(ptr.get(), ptr.getOffset(), sortOrder);
                return millis;
            }
        };
        UNSIGNED_TIME = new PDataType("UNSIGNED_TIME", 18, Time.class, new UnsignedDateCodec()){

            @Override
            public byte[] toBytes(Object object) {
                return UNSIGNED_DATE.toBytes(object);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return UNSIGNED_DATE.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Time t = (Time)TIME.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeDate(t);
                return t;
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Time t = (Time)TIME.toObject(object, actualType);
                PDataType.throwIfNonNegativeDate(t);
                return t;
            }

            @Override
            public boolean isCastableTo(PDataType targetType) {
                return UNSIGNED_DATE.isCastableTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return UNSIGNED_DATE.isCoercibleTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType, value) || TIME.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 8;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return TIME.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public Object toObject(String value) {
                return TIME.toObject(value);
            }

            @Override
            public boolean isBytesComparableWith(PDataType otherType) {
                return super.isBytesComparableWith(otherType) || this == UNSIGNED_DATE;
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                return UNSIGNED_DATE.toStringLiteral(b, offset, length, formatter);
            }
        };
        UNSIGNED_DATE = new PDataType("UNSIGNED_DATE", 19, Date.class, new UnsignedDateCodec()){

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                byte[] bytes = new byte[this.getByteSize().intValue()];
                this.toBytes(object, bytes, 0);
                return bytes;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                this.getCodec().encodeLong(((java.util.Date)object).getTime(), bytes, offset);
                return this.getByteSize();
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Date d = (Date)DATE.toObject(object, actualType);
                PDataType.throwIfNonNegativeDate(d);
                return d;
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Date d = (Date)DATE.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeDate(d);
                return d;
            }

            @Override
            public boolean isCastableTo(PDataType targetType) {
                return DATE.isCastableTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return targetType == this || targetType == UNSIGNED_TIME || targetType == UNSIGNED_TIMESTAMP || DATE.isCoercibleTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType, value) || DATE.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return DATE.getByteSize();
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return DATE.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public Object toObject(String value) {
                return DATE.toObject(value);
            }

            @Override
            public boolean isBytesComparableWith(PDataType otherType) {
                return super.isBytesComparableWith(otherType) || this == UNSIGNED_TIME;
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                if (formatter == null || formatter == DateUtil.DEFAULT_DATE_FORMATTER) {
                    formatter = DateUtil.DEFAULT_MS_DATE_FORMATTER;
                }
                return "'" + super.toStringLiteral(b, offset, length, formatter) + "'";
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifier, Integer desiredMaxLength, Integer desiredScale, SortOrder expectedModifier) {
                if (ptr.getLength() > 0 && actualType == UNSIGNED_TIMESTAMP && actualModifier == expectedModifier) {
                    ptr.set(ptr.get(), ptr.getOffset(), this.getByteSize());
                    return;
                }
                super.coerceBytes(ptr, object, actualType, maxLength, scale, actualModifier, desiredMaxLength, desiredScale, expectedModifier);
            }
        };
        UNSIGNED_LONG = new PDataType("UNSIGNED_LONG", 10, Long.class, new UnsignedLongCodec()){

            @Override
            public Integer getScale(Object o) {
                return ZERO;
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[8];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] b, int o) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeLong(((Number)object).longValue(), b, o);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Long v = (Long)LONG.toObject(object, actualType);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Long v = (Long)LONG.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return targetType == this || targetType == UNSIGNED_DOUBLE || LONG.isCoercibleTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType, value) || LONG.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 8;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (rhsType == DECIMAL) {
                    return -((BigDecimal)rhs).compareTo(BigDecimal.valueOf(((Number)lhs).longValue()));
                }
                if (rhsType == DOUBLE || rhsType == FLOAT || rhsType == UNSIGNED_DOUBLE || rhsType == UNSIGNED_FLOAT) {
                    return Doubles.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
                }
                return Longs.compare(((Number)lhs).longValue(), ((Number)rhs).longValue());
            }

            @Override
            public boolean isComparableTo(PDataType targetType) {
                return DECIMAL.isComparableTo(targetType);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    Long l = Long.parseLong(value);
                    if (l < 0L) {
                        throw new IllegalDataException("Value may not be negative(" + l + ")");
                    }
                    return l;
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public int getResultSetSqlType() {
                return LONG.getResultSetSqlType();
            }
        };
        UNSIGNED_INT = new PDataType("UNSIGNED_INT", 9, Integer.class, new UnsignedIntCodec()){

            @Override
            public Integer getScale(Object o) {
                return ZERO;
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[4];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] b, int o) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeInt(((Number)object).intValue(), b, o);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Integer v = (Integer)INTEGER.toObject(object, actualType);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Integer v = (Integer)INTEGER.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return targetType == this || targetType == UNSIGNED_FLOAT || UNSIGNED_LONG.isCoercibleTo(targetType) || INTEGER.isCoercibleTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType, value) || INTEGER.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 4;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return LONG.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public boolean isComparableTo(PDataType targetType) {
                return DECIMAL.isComparableTo(targetType);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    Integer i = Integer.parseInt(value);
                    if (i < 0) {
                        throw new IllegalDataException("Value may not be negative(" + i + ")");
                    }
                    return i;
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public int getResultSetSqlType() {
                return INTEGER.getResultSetSqlType();
            }
        };
        UNSIGNED_SMALLINT = new PDataType("UNSIGNED_SMALLINT", 13, Short.class, new UnsignedShortCodec()){

            @Override
            public Integer getScale(Object o) {
                return ZERO;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return LONG.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 2;
            }

            @Override
            public Integer getMaxLength(Object o) {
                return SHORT_PRECISION;
            }

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                byte[] b = new byte[2];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeShort(((Number)object).shortValue(), bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    Short b = Short.parseShort(value);
                    if (b < 0) {
                        throw new IllegalDataException("Value may not be negative(" + b + ")");
                    }
                    return b;
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Short v = (Short)SMALLINT.toObject(object, actualType);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Short v = (Short)SMALLINT.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public boolean isComparableTo(PDataType targetType) {
                return DECIMAL.isComparableTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return targetType == this || UNSIGNED_INT.isCoercibleTo(targetType) || SMALLINT.isCoercibleTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType, value) || SMALLINT.isCoercibleTo(targetType, value);
            }

            @Override
            public int getResultSetSqlType() {
                return SMALLINT.getResultSetSqlType();
            }
        };
        UNSIGNED_TINYINT = new PDataType("UNSIGNED_TINYINT", 11, Byte.class, new UnsignedByteCodec()){

            @Override
            public Integer getScale(Object o) {
                return ZERO;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return LONG.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 1;
            }

            @Override
            public Integer getMaxLength(Object o) {
                return BYTE_PRECISION;
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[1];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeByte(((Number)object).byteValue(), bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    Byte b = Byte.parseByte(value);
                    if (b < 0) {
                        throw new IllegalDataException("Value may not be negative(" + b + ")");
                    }
                    return b;
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Byte v = (Byte)TINYINT.toObject(object, actualType);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Byte v = (Byte)TINYINT.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return targetType == this || UNSIGNED_SMALLINT.isCoercibleTo(targetType) || TINYINT.isCoercibleTo(targetType);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType, value) || TINYINT.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isComparableTo(PDataType targetType) {
                return DECIMAL.isComparableTo(targetType);
            }

            @Override
            public int getResultSetSqlType() {
                return TINYINT.getResultSetSqlType();
            }
        };
        UNSIGNED_FLOAT = new PDataType("UNSIGNED_FLOAT", 14, Float.class, new UnsignedFloatCodec()){

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return FLOAT.compareTo(lhs, rhs, rhsType);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 4;
            }

            @Override
            public Integer getScale(Object o) {
                return FLOAT.getScale(o);
            }

            @Override
            public Integer getMaxLength(Object o) {
                return FLOAT.getMaxLength(o);
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[4];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeFloat(((Number)object).floatValue(), bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    Float f = Float.valueOf(Float.parseFloat(value));
                    if (f.floatValue() < 0.0f) {
                        throw new IllegalDataException("Value may not be negative(" + f + ")");
                    }
                    return f;
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Float v = (Float)FLOAT.toObject(object, actualType);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Float v = (Float)FLOAT.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType) || FLOAT.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || UNSIGNED_DOUBLE.isCoercibleTo(targetType) || FLOAT.isCoercibleTo(targetType);
            }

            @Override
            public int getResultSetSqlType() {
                return FLOAT.getResultSetSqlType();
            }
        };
        UNSIGNED_DOUBLE = new PDataType("UNSIGNED_DOUBLE", 15, Double.class, new UnsignedDoubleCodec()){

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (rhsType == DECIMAL) {
                    return -((BigDecimal)rhs).compareTo(BigDecimal.valueOf(((Number)lhs).doubleValue()));
                }
                return Doubles.compare(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return 8;
            }

            @Override
            public Integer getScale(Object o) {
                return DOUBLE.getScale(o);
            }

            @Override
            public Integer getMaxLength(Object o) {
                return DOUBLE.getMaxLength(o);
            }

            @Override
            public byte[] toBytes(Object object) {
                byte[] b = new byte[8];
                this.toBytes(object, b, 0);
                return b;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return this.getCodec().encodeDouble(((Number)object).doubleValue(), bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                try {
                    Double d = Double.parseDouble(value);
                    if (d < 0.0) {
                        throw new IllegalDataException("Value may not be negative(" + d + ")");
                    }
                    return d;
                }
                catch (NumberFormatException e) {
                    throw new IllegalDataException(e);
                }
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                Double v = (Double)DOUBLE.toObject(object, actualType);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public Object toObject(byte[] b, int o, int l, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Double v = (Double)DOUBLE.toObject(b, o, l, actualType, sortOrder);
                PDataType.throwIfNonNegativeNumber(v);
                return v;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                return super.isCoercibleTo(targetType, value) || DOUBLE.isCoercibleTo(targetType, value);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || DOUBLE.isCoercibleTo(targetType);
            }

            @Override
            public int getResultSetSqlType() {
                return DOUBLE.getResultSetSqlType();
            }
        };
        BOOLEAN = new PDataType("BOOLEAN", 16, Boolean.class, null){

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return (Boolean)object != false ? TRUE_BYTES : FALSE_BYTES;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                bytes[offset] = (Boolean)object != false ? (byte)1 : 0;
                return BOOLEAN_LENGTH;
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return (Boolean)object ^ sortOrder == SortOrder.ASC ? TRUE_BYTES : FALSE_BYTES;
            }

            @Override
            public Boolean toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                Preconditions.checkNotNull(sortOrder);
                if (length == 0) {
                    return null;
                }
                switch (actualType) {
                    case BOOLEAN: {
                        if (length > 1) {
                            throw new IllegalDataException("BOOLEAN may only be a single byte");
                        }
                        return bytes[offset] == 0 ^ sortOrder == SortOrder.DESC ? Boolean.FALSE : Boolean.TRUE;
                    }
                    case DECIMAL: {
                        return bytes[offset] == -128 ^ sortOrder == SortOrder.DESC ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
                PDataType.throwConstraintViolationException(actualType, (PDataType)this);
                return null;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return super.isCoercibleTo(targetType) || targetType == BINARY;
            }

            @Override
            public boolean isCastableTo(PDataType targetType) {
                return super.isCastableTo(targetType) || targetType == DECIMAL;
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public Integer getByteSize() {
                return BOOLEAN_LENGTH;
            }

            @Override
            public int estimateByteSize(Object o) {
                return BOOLEAN_LENGTH;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return Booleans.compare((Boolean)lhs, (Boolean)rhs);
            }

            @Override
            public Object toObject(String value) {
                return Boolean.parseBoolean(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                if (actualType == this || object == null) {
                    return object;
                }
                if (actualType == VARBINARY || actualType == BINARY) {
                    byte[] bytes = (byte[])object;
                    return this.toObject(bytes, 0, bytes.length);
                }
                return PDataType.throwConstraintViolationException(actualType, (PDataType)this);
            }
        };
        VARBINARY = new PDataType("VARBINARY", -3, byte[].class, null){

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    return ByteUtil.EMPTY_BYTE_ARRAY;
                }
                return (byte[])object;
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    return 0;
                }
                byte[] o = (byte[])object;
                System.arraycopy(bytes, offset, o, 0, o.length);
                return o.length;
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                byte[] bytes = this.toBytes(object);
                if (sortOrder == SortOrder.DESC) {
                    return SortOrder.invert(bytes, 0, new byte[bytes.length], 0, bytes.length);
                }
                return bytes;
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (length == 0) {
                    return null;
                }
                if (offset == 0 && bytes.length == length && sortOrder == SortOrder.ASC) {
                    return bytes;
                }
                byte[] bytesCopy = new byte[length];
                System.arraycopy(bytes, offset, bytesCopy, 0, length);
                if (sortOrder == SortOrder.DESC) {
                    bytesCopy = SortOrder.invert(bytes, offset, bytesCopy, 0, length);
                    offset = 0;
                }
                return bytesCopy;
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return actualType.toBytes(object);
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int estimateByteSize(Object o) {
                byte[] value = (byte[])o;
                return value == null ? 1 : value.length;
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || targetType == BINARY;
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                if (ptr.getLength() != 0 && srcType == BINARY && maxLength != null && desiredMaxLength != null) {
                    return maxLength <= desiredMaxLength;
                }
                return true;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (lhs == null && rhs == null) {
                    return 0;
                }
                if (lhs == null) {
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                if (rhsType == VARBINARY || rhsType == BINARY) {
                    return Bytes.compareTo((byte[])lhs, (byte[])rhs);
                }
                byte[] rhsBytes = rhsType.toBytes(rhs);
                return Bytes.compareTo((byte[])lhs, rhsBytes);
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                return Base64.decode(value);
            }

            @Override
            public String toStringLiteral(byte[] b, int o, int length, Format formatter) {
                if (formatter != null) {
                    return formatter.format(b);
                }
                StringBuilder buf = new StringBuilder();
                buf.append('[');
                for (int i = 0; i < b.length; ++i) {
                    buf.append(0xFF & b[i]);
                    buf.append(',');
                }
                buf.setCharAt(buf.length() - 1, ']');
                return buf.toString();
            }
        };
        BINARY = new PDataType("BINARY", -2, byte[].class, null){

            @Override
            public Object pad(Object object, int maxLength) {
                byte[] b = (byte[])object;
                if (b == null) {
                    return null;
                }
                if (b.length == maxLength) {
                    return object;
                }
                if (b.length > maxLength) {
                    throw new ValueTypeIncompatibleException(this, maxLength, null);
                }
                byte[] newBytes = new byte[maxLength];
                System.arraycopy(b, 0, newBytes, 0, b.length);
                return newBytes;
            }

            @Override
            public byte[] toBytes(Object object) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return VARBINARY.toBytes(object);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                if (object == null) {
                    throw new ConstraintViolationException((Object)((Object)this) + " may not be null");
                }
                return VARBINARY.toBytes(object, bytes, offset);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                byte[] bytes = this.toBytes(object);
                if (sortOrder == SortOrder.DESC) {
                    return SortOrder.invert(bytes, 0, new byte[bytes.length], 0, bytes.length);
                }
                return bytes;
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                if (!actualType.isCoercibleTo(this)) {
                    throw new ConstraintViolationException((Object)((Object)actualType) + " cannot be coerced to " + (Object)((Object)this));
                }
                return VARBINARY.toObject(bytes, offset, length, actualType, sortOrder);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return actualType.toBytes(object);
            }

            @Override
            public boolean isFixedWidth() {
                return true;
            }

            @Override
            public int estimateByteSize(Object o) {
                byte[] value = (byte[])o;
                return value == null ? 1 : value.length;
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this == targetType || targetType == VARBINARY;
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                return ptr.getLength() == 0 || (srcType != VARBINARY || ((String)value).length() == ptr.getLength()) && (maxLength == null || desiredMaxLength == null || maxLength <= desiredMaxLength);
            }

            @Override
            public Integer estimateByteSizeFromLength(Integer length) {
                return length;
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                if (lhs == null && rhs == null) {
                    return 0;
                }
                if (lhs == null) {
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                if (rhsType == VARBINARY || rhsType == BINARY) {
                    return Bytes.compareTo((byte[])lhs, (byte[])rhs);
                }
                byte[] rhsBytes = rhsType.toBytes(rhs);
                return Bytes.compareTo((byte[])lhs, rhsBytes);
            }

            @Override
            public Integer getMaxLength(Object o) {
                if (o == null) {
                    return null;
                }
                byte[] value = (byte[])o;
                return value.length;
            }

            @Override
            public Object toObject(String value) {
                if (value == null || value.length() == 0) {
                    return null;
                }
                return Base64.decode(value);
            }

            @Override
            public String toStringLiteral(byte[] b, int offset, int length, Format formatter) {
                if (formatter == null && b.length == 1) {
                    return Integer.toString(0xFF & b[0]);
                }
                return VARBINARY.toStringLiteral(b, offset, length, formatter);
            }
        };
        INTEGER_ARRAY = new PDataType("INTEGER_ARRAY", 3000 + INTEGER.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, INTEGER, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, INTEGER, sortOrder, maxLength, scale, INTEGER);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, INTEGER_ARRAY);
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                int[] intArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (int i : intArr = (int[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(INTEGER, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        BOOLEAN_ARRAY = new PDataType("BOOLEAN_ARRAY", 3000 + BOOLEAN.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, BOOLEAN, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, BOOLEAN, sortOrder, maxLength, scale, BOOLEAN);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, BOOLEAN_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                boolean[] booleanArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (boolean i : booleanArr = (boolean[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(BOOLEAN, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        VARCHAR_ARRAY = new PDataType("VARCHAR_ARRAY", 3000 + VARCHAR.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, VARCHAR, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, VARCHAR, sortOrder, maxLength, scale, VARCHAR);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, VARCHAR_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] charArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : charArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(VARCHAR, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                return this.pDataTypeForArray.isSizeCompatible(ptr, value, srcType, maxLength, scale, desiredMaxLength, desiredScale);
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        VARBINARY_ARRAY = new PDataType("VARBINARY_ARRAY", 3000 + VARBINARY.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, VARBINARY, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, VARBINARY, sortOrder, maxLength, scale, VARBINARY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, VARBINARY_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] charArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : charArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(VARBINARY, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                return this.pDataTypeForArray.isSizeCompatible(ptr, value, srcType, maxLength, scale, desiredMaxLength, desiredScale);
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        BINARY_ARRAY = new PDataType("BINARY_ARRAY", 3000 + BINARY.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, BINARY, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, BINARY, sortOrder, maxLength, scale, BINARY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, BINARY_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] charArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : charArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(BINARY, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                return this.pDataTypeForArray.isSizeCompatible(ptr, value, srcType, maxLength, scale, desiredMaxLength, desiredScale);
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        CHAR_ARRAY = new PDataType("CHAR_ARRAY", 3000 + CHAR.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, CHAR, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, CHAR, sortOrder, maxLength, scale, CHAR);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, CHAR_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] charArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : charArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(CHAR, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                return this.pDataTypeForArray.isSizeCompatible(ptr, value, srcType, maxLength, scale, desiredMaxLength, desiredScale);
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        LONG_ARRAY = new PDataType("LONG_ARRAY", 3000 + LONG.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, LONG, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, LONG, sortOrder, maxLength, scale, LONG);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, LONG_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                long[] longArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (long i : longArr = (long[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(LONG, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        SMALLINT_ARRAY = new PDataType("SMALLINT_ARRAY", 3000 + SMALLINT.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, SMALLINT, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, SMALLINT, sortOrder, maxLength, scale, SMALLINT);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, SMALLINT_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                short[] shortArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (short i : shortArr = (short[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(SMALLINT, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        TINYINT_ARRAY = new PDataType("TINYINT_ARRAY", 3000 + TINYINT.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, TINYINT, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, TINYINT, sortOrder, maxLength, scale, TINYINT);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, TINYINT_ARRAY);
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                byte[] byteArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (byte i : byteArr = (byte[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(TINYINT, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        FLOAT_ARRAY = new PDataType("FLOAT_ARRAY", 3000 + FLOAT.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, FLOAT, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, FLOAT, sortOrder, maxLength, scale, FLOAT);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, FLOAT_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                float[] floatArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (float i : floatArr = (float[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(FLOAT, Float.valueOf(i))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        DOUBLE_ARRAY = new PDataType("DOUBLE_ARRAY", 3000 + DOUBLE.getSqlType(), PhoenixArray.class, null){
            final PArrayDataType pDataTypeForArray = new PArrayDataType();

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, DOUBLE, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, DOUBLE, sortOrder, maxLength, scale, DOUBLE);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, DOUBLE_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                double[] doubleArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (double i : doubleArr = (double[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(DOUBLE, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        DECIMAL_ARRAY = new PDataType("DECIMAL_ARRAY", 3000 + DECIMAL.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, DECIMAL, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, DECIMAL, sortOrder, maxLength, scale, DECIMAL);
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, DECIMAL_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] decimalArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : decimalArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(DECIMAL, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isSizeCompatible(ImmutableBytesWritable ptr, Object value, PDataType srcType, Integer maxLength, Integer scale, Integer desiredMaxLength, Integer desiredScale) {
                return this.pDataTypeForArray.isSizeCompatible(ptr, value, srcType, maxLength, scale, desiredMaxLength, desiredScale);
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        TIMESTAMP_ARRAY = new PDataType("TIMESTAMP_ARRAY", 3000 + TIMESTAMP.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, TIMESTAMP, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, TIMESTAMP, sortOrder, maxLength, scale, TIMESTAMP);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, TIMESTAMP_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] timeStampArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : timeStampArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(TIMESTAMP, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_TIMESTAMP_ARRAY = new PDataType("UNSIGNED_TIMESTAMP_ARRAY", 3000 + UNSIGNED_TIMESTAMP.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_TIMESTAMP, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_TIMESTAMP, sortOrder, maxLength, scale, UNSIGNED_TIMESTAMP);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_TIMESTAMP_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] timeStampArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : timeStampArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_TIMESTAMP, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        TIME_ARRAY = new PDataType("TIME_ARRAY", 3000 + TIME.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, TIME, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, TIME, sortOrder, maxLength, scale, TIME);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, TIME_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] timeArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : timeArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(TIME, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_TIME_ARRAY = new PDataType("UNSIGNED_TIME_ARRAY", 3000 + UNSIGNED_TIME.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_TIME, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_TIME, sortOrder, maxLength, scale, UNSIGNED_TIME);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_TIME_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] timeArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : timeArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_TIME, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        DATE_ARRAY = new PDataType("DATE_ARRAY", 3000 + DATE.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, DATE, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, DATE, sortOrder, maxLength, scale, DATE);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, DATE_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] dateArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : dateArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(DATE, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_DATE_ARRAY = new PDataType("UNSIGNED_DATE_ARRAY", 3000 + UNSIGNED_DATE.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_DATE, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_DATE, sortOrder, maxLength, scale, UNSIGNED_DATE);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_DATE_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                Object[] dateArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (Object i : dateArr = (Object[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_DATE, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_LONG_ARRAY = new PDataType("UNSIGNED_LONG_ARRAY", 3000 + UNSIGNED_LONG.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_LONG, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_LONG, sortOrder, maxLength, scale, UNSIGNED_LONG);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_LONG_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                long[] longArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (long i : longArr = (long[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_LONG, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_INT_ARRAY = new PDataType("UNSIGNED_INT_ARRAY", 3000 + UNSIGNED_INT.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_INT, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_INT, sortOrder, maxLength, scale, UNSIGNED_INT);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_INT_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                int[] intArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (int i : intArr = (int[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_INT, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_SMALLINT_ARRAY = new PDataType("UNSIGNED_SMALLINT_ARRAY", 3000 + UNSIGNED_SMALLINT.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_SMALLINT, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_SMALLINT, sortOrder, maxLength, scale, UNSIGNED_SMALLINT);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_SMALLINT_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                short[] shortArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (short i : shortArr = (short[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_SMALLINT, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_TINYINT_ARRAY = new PDataType("UNSIGNED_TINYINT__ARRAY", 3000 + UNSIGNED_TINYINT.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_TINYINT, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_TINYINT, sortOrder, maxLength, scale, UNSIGNED_TINYINT);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_TINYINT_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                byte[] byteArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (byte i : byteArr = (byte[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_TINYINT, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_FLOAT_ARRAY = new PDataType("UNSIGNED_FLOAT_ARRAY", 3000 + UNSIGNED_FLOAT.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_FLOAT, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_FLOAT, sortOrder, maxLength, scale, UNSIGNED_FLOAT);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_FLOAT_ARRAY);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                float[] floatArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (float i : floatArr = (float[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_FLOAT, Float.valueOf(i))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }
        };
        UNSIGNED_DOUBLE_ARRAY = new PDataType("UNSIGNED_DOUBLE__ARRAY", 3000 + UNSIGNED_DOUBLE.getSqlType(), PhoenixArray.class, null){

            @Override
            public boolean isArrayType() {
                return true;
            }

            @Override
            public boolean isFixedWidth() {
                return false;
            }

            @Override
            public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
                return this.pDataTypeForArray.compareTo(lhs, rhs);
            }

            @Override
            public Integer getByteSize() {
                return null;
            }

            @Override
            public byte[] toBytes(Object object) {
                return this.toBytes(object, SortOrder.ASC);
            }

            @Override
            public byte[] toBytes(Object object, SortOrder sortOrder) {
                return this.pDataTypeForArray.toBytes(object, UNSIGNED_DOUBLE, sortOrder);
            }

            @Override
            public int toBytes(Object object, byte[] bytes, int offset) {
                return this.pDataTypeForArray.toBytes(object, bytes, offset);
            }

            @Override
            public Object toObject(String value) {
                return this.pDataTypeForArray.toObject(value);
            }

            @Override
            public Object toObject(Object object, PDataType actualType) {
                return this.pDataTypeForArray.toObject(object, actualType);
            }

            @Override
            public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
                return this.pDataTypeForArray.toObject(bytes, offset, length, UNSIGNED_DOUBLE, sortOrder, maxLength, scale, UNSIGNED_DOUBLE);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType) {
                return this.pDataTypeForArray.isCoercibleTo(targetType, UNSIGNED_DOUBLE_ARRAY);
            }

            @Override
            public void coerceBytes(ImmutableBytesWritable ptr, Object object, PDataType actualType, Integer maxLength, Integer scale, SortOrder actualModifer, Integer desiredMaxLength, Integer desiredScale, SortOrder desiredModifier) {
                this.pDataTypeForArray.coerceBytes(ptr, object, actualType, maxLength, scale, desiredMaxLength, desiredScale, this, actualModifer, desiredModifier);
            }

            @Override
            public boolean isCoercibleTo(PDataType targetType, Object value) {
                double[] doubleArr;
                PhoenixArray pArr = (PhoenixArray)value;
                for (double i : doubleArr = (double[])pArr.array) {
                    if (this.pDataTypeForArray.isCoercibleTo(UNSIGNED_DOUBLE, i) || this.pDataTypeForArray.isCoercibleTo(UNSIGNED_TIMESTAMP, i) || this.pDataTypeForArray.isCoercibleTo(UNSIGNED_TIME, i) || this.pDataTypeForArray.isCoercibleTo(UNSIGNED_DATE, i)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getResultSetSqlType() {
                return 2003;
            }
        };
        $VALUES = new PDataType[]{VARCHAR, CHAR, LONG, INTEGER, SMALLINT, TINYINT, FLOAT, DOUBLE, DECIMAL, TIMESTAMP, TIME, DATE, UNSIGNED_TIMESTAMP, UNSIGNED_TIME, UNSIGNED_DATE, UNSIGNED_LONG, UNSIGNED_INT, UNSIGNED_SMALLINT, UNSIGNED_TINYINT, UNSIGNED_FLOAT, UNSIGNED_DOUBLE, BOOLEAN, VARBINARY, BINARY, INTEGER_ARRAY, BOOLEAN_ARRAY, VARCHAR_ARRAY, VARBINARY_ARRAY, BINARY_ARRAY, CHAR_ARRAY, LONG_ARRAY, SMALLINT_ARRAY, TINYINT_ARRAY, FLOAT_ARRAY, DOUBLE_ARRAY, DECIMAL_ARRAY, TIMESTAMP_ARRAY, UNSIGNED_TIMESTAMP_ARRAY, TIME_ARRAY, UNSIGNED_TIME_ARRAY, DATE_ARRAY, UNSIGNED_DATE_ARRAY, UNSIGNED_LONG_ARRAY, UNSIGNED_INT_ARRAY, UNSIGNED_SMALLINT_ARRAY, UNSIGNED_TINYINT_ARRAY, UNSIGNED_FLOAT_ARRAY, UNSIGNED_DOUBLE_ARRAY};
        MIN_DOUBLE_AS_BIG_DECIMAL = BigDecimal.valueOf(-1.7976931348623157E308);
        MAX_DOUBLE_AS_BIG_DECIMAL = BigDecimal.valueOf(Double.MAX_VALUE);
        MIN_FLOAT_AS_BIG_DECIMAL = BigDecimal.valueOf(-3.4028234663852886E38);
        MAX_FLOAT_AS_BIG_DECIMAL = BigDecimal.valueOf(3.4028234663852886E38);
        DEFAULT_MATH_CONTEXT = new MathContext(38, RoundingMode.HALF_UP);
        MAX_BIG_DECIMAL_BYTES = 21;
        MAX_TIMESTAMP_BYTES = 12;
        MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        ONE_HUNDRED = BigInteger.valueOf(100L);
        FALSE_BYTES = new byte[]{0};
        TRUE_BYTES = new byte[]{1};
        NULL_BYTES = ByteUtil.EMPTY_BYTE_ARRAY;
        BOOLEAN_LENGTH = 1;
        ZERO = 0;
        INT_PRECISION = 10;
        LONG_PRECISION = 19;
        SHORT_PRECISION = 5;
        BYTE_PRECISION = 3;
        ImmutableMap.Builder<String, PDataType> builder = ImmutableMap.builder();
        PDataType[] arr$ = PDataType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            PDataType dataType = arr$[i$];
            builder.put(dataType.getSqlTypeName(), dataType);
        }
        SQL_TYPE_NAME_TO_PCOLUMN_DATA_TYPE = builder.build();
        int minSqlType = Integer.MAX_VALUE;
        int maxSqlType = Integer.MIN_VALUE;
        for (PDataType dataType : PDataType.values()) {
            sqlType = dataType.getSqlType();
            if (sqlType < minSqlType) {
                minSqlType = sqlType;
            }
            if (sqlType <= maxSqlType) continue;
            maxSqlType = sqlType;
        }
        SQL_TYPE_OFFSET = minSqlType;
        SQL_TYPE_TO_PCOLUMN_DATA_TYPE = new PDataType[maxSqlType - minSqlType + 1];
        for (PDataType dataType : PDataType.values()) {
            sqlType = dataType.getSqlType();
            PDataType.SQL_TYPE_TO_PCOLUMN_DATA_TYPE[sqlType - PDataType.SQL_TYPE_OFFSET] = dataType;
        }
        ARRAY_FACTORY = new PhoenixArrayFactory[PDataType.values().length];
        int i = 0;
        for (PDataType type : PDataType.values()) {
            if (type.isArrayType()) continue;
            PDataType.ARRAY_FACTORY[i++] = type.getCodec() != null ? type.getCodec().getPhoenixArrayFactory() : new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray(type, elements);
                }
            };
        }
    }

    private static interface PhoenixArrayFactory {
        public PhoenixArray newArray(PDataType var1, Object[] var2);
    }

    public static class UnsignedDateCodec
    extends UnsignedLongCodec {
        private UnsignedDateCodec() {
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray(type, elements);
                }
            };
        }
    }

    public static class DateCodec
    extends LongCodec {
        private DateCodec() {
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray(type, elements);
                }
            };
        }
    }

    public static class UnsignedDoubleCodec
    extends DoubleCodec {
        private UnsignedDoubleCodec() {
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < 0.0) {
                throw new IllegalDataException();
            }
            Bytes.putDouble(b, o, v);
            return 8;
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            double v;
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[8], 0, 8);
            }
            if ((v = Bytes.toDouble(b, o)) < 0.0) {
                throw new IllegalDataException();
            }
            return v;
        }
    }

    public static class UnsignedFloatCodec
    extends FloatCodec {
        private UnsignedFloatCodec() {
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < 0.0f) {
                throw new IllegalDataException();
            }
            Bytes.putFloat(b, o, v);
            return 4;
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            float v;
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[4], 0, 4);
            }
            if ((v = Bytes.toFloat(b, o)) < 0.0f) {
                throw new IllegalDataException();
            }
            return v;
        }
    }

    public static class DoubleCodec
    extends BaseCodec {
        private DoubleCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (v < -9.223372036854776E18 || v > 9.223372036854776E18) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Long without changing its value");
            }
            return (long)v;
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (v < -2.147483648E9 || v > 2.147483647E9) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Integer without changing its value");
            }
            return (int)v;
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (v < -128.0 || v > 127.0) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (v < -32768.0 || v > 32767.0) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Short without changing its value");
            }
            return (short)v;
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.DESC) {
                for (int i = o; i < 8; ++i) {
                    b[i] = (byte)(b[i] ^ 0xFF);
                }
            }
            long l = Bytes.toLong(b, o);
            --l;
            l ^= (l ^ 0xFFFFFFFFFFFFFFFFL) >> 63 | Long.MIN_VALUE;
            return Double.longBitsToDouble(l);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            double v = this.decodeDouble(b, o, sortOrder);
            if (Double.isNaN(v) || v == Double.NEGATIVE_INFINITY || v == Double.POSITIVE_INFINITY || v >= -3.4028234663852886E38 && v <= 3.4028234663852886E38) {
                return (float)v;
            }
            throw new IllegalDataException("Value " + v + " cannot be cast to Float without changing its value");
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            long l = Double.doubleToLongBits(v);
            l = (l ^ (l >> 63 | Long.MIN_VALUE)) + 1L;
            Bytes.putLong(b, o, l);
            return 8;
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            return this.encodeDouble(v, b, o);
        }

        @Override
        public PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveDoublePhoenixArray(type, elements);
                }
            };
        }
    }

    public static class FloatCodec
    extends BaseCodec {
        private FloatCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            float v = this.decodeFloat(b, o, sortOrder);
            if (v < -9.223372E18f || v > 9.223372E18f) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Long without changing its value");
            }
            return (long)v;
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            float v = this.decodeFloat(b, o, sortOrder);
            if (v < -2.1474836E9f || v > 2.1474836E9f) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Integer without changing its value");
            }
            return (int)v;
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            float v = this.decodeFloat(b, o, sortOrder);
            if (v < -128.0f || v > 127.0f) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            float v = this.decodeFloat(b, o, sortOrder);
            if (v < -32768.0f || v > 32767.0f) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Short without changing its value");
            }
            return (short)v;
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeFloat(b, o, sortOrder);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            int i;
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.DESC) {
                for (i = o; i < 4; ++i) {
                    b[i] = (byte)(b[i] ^ 0xFF);
                }
            }
            i = Bytes.toInt(b, o);
            --i;
            i ^= ~i >> 31 | Integer.MIN_VALUE;
            return Float.intBitsToFloat(i);
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            return this.encodeFloat(v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            return this.encodeFloat(v, b, o);
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            return this.encodeFloat(v, b, o);
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeFloat(v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (Double.isNaN(v) || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY || v >= -3.4028234663852886E38 && v <= 3.4028234663852886E38) {
                return this.encodeFloat((float)v, b, o);
            }
            throw new IllegalDataException("Value " + v + " cannot be encoded as an Float without changing its value");
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            int i = Float.floatToIntBits(v);
            i = (i ^ (i >> 31 | Integer.MIN_VALUE)) + 1;
            Bytes.putInt(b, o, i);
            return 4;
        }

        @Override
        public PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveFloatPhoenixArray(type, elements);
                }
            };
        }
    }

    public static class UnsignedIntCodec
    extends IntCodec {
        private UnsignedIntCodec() {
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            int v;
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[4], 0, 4);
            }
            if ((v = Bytes.toInt(b, o)) < 0) {
                throw new IllegalDataException();
            }
            return v;
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            if (v < 0) {
                throw new IllegalDataException();
            }
            Bytes.putInt(b, o, v);
            return 4;
        }
    }

    public static class UnsignedShortCodec
    extends ShortCodec {
        private UnsignedShortCodec() {
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            short v;
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[4], 0, 4);
            }
            if ((v = Bytes.toShort(b, o)) < 0) {
                throw new IllegalDataException();
            }
            return v;
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            if (v < 0) {
                throw new IllegalDataException();
            }
            Bytes.putShort(b, o, v);
            return 2;
        }
    }

    public static class UnsignedLongCodec
    extends LongCodec {
        private UnsignedLongCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            Preconditions.checkNotNull(sortOrder);
            long v = 0L;
            if (sortOrder == SortOrder.ASC) {
                for (int i = o; i < o + 8; ++i) {
                    v <<= 8;
                    v ^= (long)(b[i] & 0xFF);
                }
            } else {
                for (int i = o; i < o + 8; ++i) {
                    v <<= 8;
                    v ^= (long)(b[i] & 0xFF ^ 0xFF);
                }
            }
            if (v < 0L) {
                throw new IllegalDataException();
            }
            return v;
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            if (v < 0L) {
                throw new IllegalDataException();
            }
            Bytes.putLong(b, o, v);
            return 8;
        }
    }

    public static class UnsignedByteCodec
    extends ByteCodec {
        private UnsignedByteCodec() {
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            byte v;
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.DESC) {
                b = SortOrder.invert(b, o, new byte[1], 0, 1);
            }
            if ((v = b[o]) < 0) {
                throw new IllegalDataException();
            }
            return v;
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            if (v < 0) {
                throw new IllegalDataException();
            }
            Bytes.putByte(b, o, v);
            return 1;
        }
    }

    public static class ByteCodec
    extends BaseCodec {
        private ByteCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            Preconditions.checkNotNull(sortOrder);
            int v = sortOrder == SortOrder.ASC ? b[o] ^ 0x80 : b[o] ^ 0xFF ^ 0x80;
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            if (v < -128 || v > 127) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            if (v < -128L || v > 127L) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            if (v < -128 || v > 127) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            b[o] = (byte)(v ^ 0x80);
            return 1;
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeByte(b, o, sortOrder);
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < -128.0f || v > 127.0f) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < -128.0 || v > 127.0) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Byte without changing its value");
            }
            return this.encodeByte((byte)v, b, o);
        }

        @Override
        public PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveBytePhoenixArray(type, elements);
                }
            };
        }
    }

    public static class ShortCodec
    extends BaseCodec {
        private ShortCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeShort(b, o, sortOrder);
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeShort(b, o, sortOrder);
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            short v = this.decodeShort(b, o, sortOrder);
            if (v < -128 || v > 127) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            int v;
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.ASC) {
                v = b[o] ^ 0x80;
                for (int i = 1; i < 2; ++i) {
                    v = (v << 8) + (b[o + i] & 0xFF);
                }
            } else {
                v = b[o] ^ 0xFF ^ 0x80;
                for (int i = 1; i < 2; ++i) {
                    v = (v << 8) + ((b[o + i] ^ 0xFF) & 0xFF);
                }
            }
            return (short)v;
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            b[o + 0] = (byte)(v >> 8 ^ 0x80);
            b[o + 1] = (byte)v;
            return 2;
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            if (v < -32768L || v > 32767L) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Short without changing its value");
            }
            return this.encodeShort((short)v, b, o);
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Short without changing its value");
            }
            return this.encodeShort((short)v, b, o);
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeShort(v, b, o);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeShort(b, o, sortOrder);
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeShort(b, o, sortOrder);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < -32768.0 || v > 32767.0) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Short without changing its value");
            }
            return this.encodeShort((short)v, b, o);
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < -32768.0f || v > 32767.0f) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Short without changing its value");
            }
            return this.encodeShort((short)v, b, o);
        }

        @Override
        public PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveShortPhoenixArray(type, elements);
                }
            };
        }
    }

    public static class IntCodec
    extends BaseCodec {
        private IntCodec() {
        }

        @Override
        public long decodeLong(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeInt(b, o, sortOrder);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeInt(b, o, sortOrder);
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeInt(b, o, sortOrder);
        }

        @Override
        public int decodeInt(byte[] bytes, int o, SortOrder sortOrder) {
            int v;
            Preconditions.checkNotNull(sortOrder);
            if (sortOrder == SortOrder.ASC) {
                v = bytes[o] ^ 0x80;
                for (int i = 1; i < 4; ++i) {
                    v = (v << 8) + (bytes[o + i] & 0xFF);
                }
            } else {
                v = bytes[o] ^ 0xFF ^ 0x80;
                for (int i = 1; i < 4; ++i) {
                    v = (v << 8) + ((bytes[o + i] ^ 0xFF) & 0xFF);
                }
            }
            return v;
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            b[o + 0] = (byte)(v >> 24 ^ 0x80);
            b[o + 1] = (byte)(v >> 16);
            b[o + 2] = (byte)(v >> 8);
            b[o + 3] = (byte)v;
            return 4;
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < -2.1474836E9f || v > 2.1474836E9f) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Integer without changing its value");
            }
            return this.encodeInt((int)v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < -2.147483648E9 || v > 2.147483647E9) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Integer without changing its value");
            }
            return this.encodeInt((int)v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Integer without changing its value");
            }
            return this.encodeInt((int)v, b, o);
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            int v = this.decodeInt(b, o, sortOrder);
            if (v < -128 || v > 127) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            int v = this.decodeInt(b, o, sortOrder);
            if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Short without changing its value");
            }
            return (short)v;
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeInt(v, b, o);
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            return this.encodeInt(v, b, o);
        }

        @Override
        public PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveIntPhoenixArray(type, elements);
                }
            };
        }
    }

    public static class LongCodec
    extends BaseCodec {
        private LongCodec() {
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeLong(b, o, sortOrder);
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            return this.decodeLong(b, o, sortOrder);
        }

        @Override
        public long decodeLong(byte[] bytes, int o, SortOrder sortOrder) {
            long v;
            Preconditions.checkNotNull(sortOrder);
            byte b = bytes[o];
            if (sortOrder == SortOrder.ASC) {
                v = b ^ 0x80;
                for (int i = 1; i < 8; ++i) {
                    b = bytes[o + i];
                    v = (v << 8) + (long)(b & 0xFF);
                }
            } else {
                b = (byte)(b ^ 0xFF);
                v = b ^ 0x80;
                for (int i = 1; i < 8; ++i) {
                    b = bytes[o + i];
                    b = (byte)(b ^ 0xFF);
                    v = (v << 8) + (long)(b & 0xFF);
                }
            }
            return v;
        }

        @Override
        public int decodeInt(byte[] b, int o, SortOrder sortOrder) {
            long v = this.decodeLong(b, o, sortOrder);
            if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Integer without changing its value");
            }
            return (int)v;
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            if (v < -9.223372E18f || v > 9.223372E18f) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Long without changing its value");
            }
            return this.encodeLong((long)v, b, o);
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            if (v < -9.223372036854776E18 || v > 9.223372036854776E18) {
                throw new IllegalDataException("Value " + v + " cannot be encoded as an Long without changing its value");
            }
            return this.encodeLong((long)v, b, o);
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            b[o + 0] = (byte)(v >> 56 ^ 0x80L);
            b[o + 1] = (byte)(v >> 48);
            b[o + 2] = (byte)(v >> 40);
            b[o + 3] = (byte)(v >> 32);
            b[o + 4] = (byte)(v >> 24);
            b[o + 5] = (byte)(v >> 16);
            b[o + 6] = (byte)(v >> 8);
            b[o + 7] = (byte)v;
            return 8;
        }

        @Override
        public byte decodeByte(byte[] b, int o, SortOrder sortOrder) {
            long v = this.decodeLong(b, o, sortOrder);
            if (v < -128L || v > 127L) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Byte without changing its value");
            }
            return (byte)v;
        }

        @Override
        public short decodeShort(byte[] b, int o, SortOrder sortOrder) {
            long v = this.decodeLong(b, o, sortOrder);
            if (v < -32768L || v > 32767L) {
                throw new IllegalDataException("Value " + v + " cannot be cast to Short without changing its value");
            }
            return (short)v;
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            return this.encodeLong(v, b, o);
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            return this.encodeLong(v, b, o);
        }

        @Override
        public PhoenixArrayFactory getPhoenixArrayFactory() {
            return new PhoenixArrayFactory(){

                @Override
                public PhoenixArray newArray(PDataType type, Object[] elements) {
                    return new PhoenixArray.PrimitiveLongPhoenixArray(type, elements);
                }
            };
        }
    }

    public static abstract class BaseCodec
    implements PDataCodec {
        @Override
        public int decodeInt(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeInt(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public long decodeLong(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeLong(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public byte decodeByte(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeByte(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public short decodeShort(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeShort(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public float decodeFloat(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeFloat(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public float decodeFloat(byte[] b, int o, SortOrder sortOrder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double decodeDouble(ImmutableBytesWritable ptr, SortOrder sortOrder) {
            return this.decodeDouble(ptr.get(), ptr.getOffset(), sortOrder);
        }

        @Override
        public double decodeDouble(byte[] b, int o, SortOrder sortOrder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeInt(int v, ImmutableBytesWritable ptr) {
            return this.encodeInt(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeLong(long v, ImmutableBytesWritable ptr) {
            return this.encodeLong(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeByte(byte v, ImmutableBytesWritable ptr) {
            return this.encodeByte(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeShort(short v, ImmutableBytesWritable ptr) {
            return this.encodeShort(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeFloat(float v, ImmutableBytesWritable ptr) {
            return this.encodeFloat(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeDouble(double v, ImmutableBytesWritable ptr) {
            return this.encodeDouble(v, ptr.get(), ptr.getOffset());
        }

        @Override
        public int encodeInt(int v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeLong(long v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeByte(byte v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeShort(short v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeFloat(float v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int encodeDouble(double v, byte[] b, int o) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface PDataCodec {
        public long decodeLong(ImmutableBytesWritable var1, SortOrder var2);

        public long decodeLong(byte[] var1, int var2, SortOrder var3);

        public int decodeInt(ImmutableBytesWritable var1, SortOrder var2);

        public int decodeInt(byte[] var1, int var2, SortOrder var3);

        public byte decodeByte(ImmutableBytesWritable var1, SortOrder var2);

        public byte decodeByte(byte[] var1, int var2, SortOrder var3);

        public short decodeShort(ImmutableBytesWritable var1, SortOrder var2);

        public short decodeShort(byte[] var1, int var2, SortOrder var3);

        public float decodeFloat(ImmutableBytesWritable var1, SortOrder var2);

        public float decodeFloat(byte[] var1, int var2, SortOrder var3);

        public double decodeDouble(ImmutableBytesWritable var1, SortOrder var2);

        public double decodeDouble(byte[] var1, int var2, SortOrder var3);

        public int encodeLong(long var1, ImmutableBytesWritable var3);

        public int encodeLong(long var1, byte[] var3, int var4);

        public int encodeInt(int var1, ImmutableBytesWritable var2);

        public int encodeInt(int var1, byte[] var2, int var3);

        public int encodeByte(byte var1, ImmutableBytesWritable var2);

        public int encodeByte(byte var1, byte[] var2, int var3);

        public int encodeShort(short var1, ImmutableBytesWritable var2);

        public int encodeShort(short var1, byte[] var2, int var3);

        public int encodeFloat(float var1, ImmutableBytesWritable var2);

        public int encodeFloat(float var1, byte[] var2, int var3);

        public int encodeDouble(double var1, ImmutableBytesWritable var3);

        public int encodeDouble(double var1, byte[] var3, int var4);

        public PhoenixArrayFactory getPhoenixArrayFactory();
    }
}

