/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.primitives.Longs;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.TimeKeeper;

public class PMetaDataImpl
implements PMetaData {
    private final PMetaData.Cache metaData;

    public PMetaDataImpl(int initialCapacity, long maxByteSize) {
        this.metaData = new CacheImpl(initialCapacity, maxByteSize, TimeKeeper.SYSTEM);
    }

    public PMetaDataImpl(int initialCapacity, long maxByteSize, TimeKeeper timeKeeper) {
        this.metaData = new CacheImpl(initialCapacity, maxByteSize, timeKeeper);
    }

    public PMetaDataImpl(PMetaData.Cache tables) {
        this.metaData = tables.clone();
    }

    @Override
    public PTable getTable(PTableKey key) throws TableNotFoundException {
        PTable table = this.metaData.get(key);
        if (table == null) {
            throw new TableNotFoundException(key.getName());
        }
        return table;
    }

    @Override
    public PMetaData.Cache getTables() {
        return this.metaData;
    }

    @Override
    public PMetaData addTable(PTable table) throws SQLException {
        PMetaData.Cache tables = this.metaData.clone();
        PTable oldTable = tables.put(table.getKey(), table);
        if (table.getParentName() != null) {
            String parentName = table.getParentName().getString();
            PTable parentTable = tables.get(new PTableKey(table.getTenantId(), parentName));
            if (parentTable != null) {
                List<PTable> oldIndexes = parentTable.getIndexes();
                ArrayList<PTable> newIndexes = Lists.newArrayListWithExpectedSize(oldIndexes.size() + 1);
                newIndexes.addAll(oldIndexes);
                if (oldTable != null) {
                    newIndexes.remove(oldTable);
                }
                newIndexes.add(table);
                parentTable = PTableImpl.makePTable(parentTable, table.getTimeStamp(), newIndexes);
                tables.put(parentTable.getKey(), parentTable);
            }
        }
        for (PTable index : table.getIndexes()) {
            tables.put(index.getKey(), index);
        }
        return new PMetaDataImpl(tables);
    }

    @Override
    public PMetaData addColumn(PName tenantId, String tableName, List<PColumn> columnsToAdd, long tableTimeStamp, long tableSeqNum, boolean isImmutableRows) throws SQLException {
        List<PColumn> newColumns;
        PTable table = this.getTable(new PTableKey(tenantId, tableName));
        PMetaData.Cache tables = this.metaData.clone();
        List<PColumn> oldColumns = PTableImpl.getColumnsToClone(table);
        if (columnsToAdd.isEmpty()) {
            newColumns = oldColumns;
        } else {
            newColumns = Lists.newArrayListWithExpectedSize(oldColumns.size() + columnsToAdd.size());
            newColumns.addAll(oldColumns);
            newColumns.addAll(columnsToAdd);
        }
        PTableImpl newTable = PTableImpl.makePTable(table, tableTimeStamp, tableSeqNum, newColumns, isImmutableRows);
        tables.put(newTable.getKey(), newTable);
        return new PMetaDataImpl(tables);
    }

    @Override
    public PMetaData removeTable(PName tenantId, String tableName) throws SQLException {
        PMetaData.Cache tables = this.metaData.clone();
        PTable table = tables.remove(new PTableKey(tenantId, tableName));
        if (table == null) {
            throw new TableNotFoundException(tableName);
        }
        for (PTable index : table.getIndexes()) {
            if (tables.remove(index.getKey()) != null) continue;
            throw new TableNotFoundException(index.getName().getString());
        }
        return new PMetaDataImpl(tables);
    }

    @Override
    public PMetaData removeColumn(PName tenantId, String tableName, String familyName, String columnName, long tableTimeStamp, long tableSeqNum) throws SQLException {
        PTable table = this.getTable(new PTableKey(tenantId, tableName));
        PMetaData.Cache tables = this.metaData.clone();
        PColumn column = familyName == null ? table.getPKColumn(columnName) : table.getColumnFamily(familyName).getColumn(columnName);
        int positionOffset = 0;
        int position = column.getPosition();
        List<PColumn> oldColumns = table.getColumns();
        if (table.getBucketNum() != null) {
            --position;
            positionOffset = 1;
            oldColumns = oldColumns.subList(positionOffset, oldColumns.size());
        }
        ArrayList<PColumn> columns = Lists.newArrayListWithExpectedSize(oldColumns.size() - 1);
        columns.addAll(oldColumns.subList(0, position));
        for (int i = position + 1; i < oldColumns.size(); ++i) {
            PColumn oldColumn = oldColumns.get(i);
            PColumnImpl newColumn = new PColumnImpl(oldColumn.getName(), oldColumn.getFamilyName(), oldColumn.getDataType(), oldColumn.getMaxLength(), oldColumn.getScale(), oldColumn.isNullable(), i - 1 + positionOffset, oldColumn.getSortOrder(), oldColumn.getArraySize(), oldColumn.getViewConstant(), oldColumn.isViewReferenced());
            columns.add(newColumn);
        }
        PTableImpl newTable = PTableImpl.makePTable(table, tableTimeStamp, tableSeqNum, columns);
        tables.put(newTable.getKey(), newTable);
        return new PMetaDataImpl(tables);
    }

    @Override
    public PMetaData pruneTables(PMetaData.Pruner pruner) {
        ArrayList<PTableKey> keysToPrune = Lists.newArrayListWithExpectedSize(this.getTables().size());
        for (PTable table : this.getTables()) {
            if (!pruner.prune(table)) continue;
            keysToPrune.add(table.getKey());
        }
        if (keysToPrune.isEmpty()) {
            return this;
        }
        PMetaData.Cache tables = this.metaData.clone();
        for (PTableKey key : keysToPrune) {
            tables.remove(key);
        }
        return new PMetaDataImpl(tables);
    }

    private static class CacheImpl
    implements PMetaData.Cache,
    Cloneable {
        private static final int MIN_REMOVAL_SIZE = 3;
        private static final Comparator<PTableAccess> COMPARATOR = new Comparator<PTableAccess>(){

            @Override
            public int compare(PTableAccess tableAccess1, PTableAccess tableAccess2) {
                return Longs.compare(tableAccess1.lastAccessTime, tableAccess2.lastAccessTime);
            }
        };
        private static final MinMaxPriorityQueue.Builder<PTableAccess> BUILDER = MinMaxPriorityQueue.orderedBy(COMPARATOR);
        private long currentSize;
        private final long maxByteSize;
        private final int expectedCapacity;
        private final TimeKeeper timeKeeper;
        private final HashMap<PTableKey, PTableAccess> tables;

        private static HashMap<PTableKey, PTableAccess> newMap(int expectedCapacity) {
            return Maps.newHashMapWithExpectedSize(expectedCapacity);
        }

        private static HashMap<PTableKey, PTableAccess> cloneMap(HashMap<PTableKey, PTableAccess> tables, int expectedCapacity) {
            HashMap<PTableKey, PTableAccess> newTables = Maps.newHashMapWithExpectedSize(Math.max(tables.size(), expectedCapacity));
            for (PTableAccess tableAccess : tables.values()) {
                newTables.put(tableAccess.table.getKey(), new PTableAccess(tableAccess));
            }
            return newTables;
        }

        private CacheImpl(CacheImpl toClone) {
            this.timeKeeper = toClone.timeKeeper;
            this.maxByteSize = toClone.maxByteSize;
            this.currentSize = toClone.currentSize;
            this.expectedCapacity = toClone.expectedCapacity;
            this.tables = CacheImpl.cloneMap(toClone.tables, toClone.expectedCapacity);
        }

        public CacheImpl(int initialCapacity, long maxByteSize, TimeKeeper timeKeeper) {
            this.currentSize = 0L;
            this.maxByteSize = maxByteSize;
            this.expectedCapacity = initialCapacity;
            this.tables = CacheImpl.newMap(initialCapacity);
            this.timeKeeper = timeKeeper;
        }

        @Override
        public PMetaData.Cache clone() {
            return new CacheImpl(this);
        }

        @Override
        public PTable get(PTableKey key) {
            PTableAccess tableAccess = this.tables.get(key);
            if (tableAccess == null) {
                return null;
            }
            tableAccess.lastAccessTime = this.timeKeeper.getCurrentTime();
            return tableAccess.table;
        }

        private void pruneIfNecessary() {
            while (this.currentSize > this.maxByteSize && this.size() > 1) {
                int nToRemove = Math.max(3, (int)Math.ceil((double)(this.currentSize - this.maxByteSize) / ((double)this.currentSize / (double)this.size())));
                MinMaxPriorityQueue toRemove = BUILDER.expectedSize(nToRemove + 1).create();
                for (PTableAccess tableAccess : this.tables.values()) {
                    toRemove.add(tableAccess);
                    if (toRemove.size() <= nToRemove) continue;
                    toRemove.removeLast();
                }
                do {
                    PTableAccess tableAccess = (PTableAccess)toRemove.removeFirst();
                    this.remove(tableAccess.table.getKey());
                } while (this.currentSize > this.maxByteSize && this.size() > 1 && !toRemove.isEmpty());
            }
        }

        @Override
        public PTable put(PTableKey key, PTable value) {
            this.currentSize += (long)value.getEstimatedSize();
            PTableAccess oldTableAccess = this.tables.put(key, new PTableAccess(value, this.timeKeeper.getCurrentTime()));
            PTable oldTable = null;
            if (oldTableAccess != null) {
                this.currentSize -= (long)oldTableAccess.table.getEstimatedSize();
                oldTable = oldTableAccess.table;
            }
            this.pruneIfNecessary();
            return oldTable;
        }

        @Override
        public PTable remove(PTableKey key) {
            PTableAccess value = this.tables.remove(key);
            if (value == null) {
                return null;
            }
            this.currentSize -= (long)value.table.getEstimatedSize();
            return value.table;
        }

        @Override
        public Iterator<PTable> iterator() {
            final Iterator<PTableAccess> iterator = this.tables.values().iterator();
            return new Iterator<PTable>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public PTable next() {
                    return ((PTableAccess)iterator.next()).table;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.tables.size();
        }

        private static class PTableAccess {
            public PTable table;
            public volatile long lastAccessTime;

            public PTableAccess(PTable table, long lastAccessTime) {
                this.table = table;
                this.lastAccessTime = lastAccessTime;
            }

            public PTableAccess(PTableAccess tableAccess) {
                this.table = tableAccess.table;
                this.lastAccessTime = tableAccess.lastAccessTime;
            }
        }
    }
}

