/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.HBaseZeroCopyByteString;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnFamilyImpl;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.stat.PTableStats;
import org.apache.phoenix.schema.stat.PTableStatsImpl;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.SizedUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class PTableImpl
implements PTable {
    private static final Integer NO_SALTING = -1;
    private PTableKey key;
    private PName name;
    private PName schemaName;
    private PName tableName;
    private PName tenantId;
    private PTableType type;
    private PIndexState state;
    private long sequenceNumber;
    private long timeStamp;
    private List<PColumn> pkColumns;
    private List<PColumn> allColumns;
    private List<PColumnFamily> families;
    private Map<byte[], PColumnFamily> familyByBytes;
    private Map<String, PColumnFamily> familyByString;
    private ListMultimap<String, PColumn> columnsByName;
    private PName pkName;
    private Integer bucketNum;
    private PTableStats stats;
    private RowKeySchema rowKeySchema;
    private List<PTable> indexes;
    private PName parentName;
    private PName parentTableName;
    private List<PName> physicalNames;
    private boolean isImmutableRows;
    private IndexMaintainer indexMaintainer;
    private ImmutableBytesWritable indexMaintainersPtr;
    private PName defaultFamilyName;
    private String viewStatement;
    private boolean disableWAL;
    private boolean multiTenant;
    private PTable.ViewType viewType;
    private Short viewIndexId;
    private int estimatedSize;

    public PTableImpl() {
    }

    public PTableImpl(PName tenantId, String schemaName, String tableName, long timestamp, List<PColumnFamily> families) {
        Preconditions.checkArgument(tenantId == null || tenantId.getBytes().length > 0);
        this.tenantId = tenantId;
        this.name = PNameFactory.newName(SchemaUtil.getTableName(schemaName, tableName));
        this.key = new PTableKey(tenantId, this.name.getString());
        this.schemaName = PNameFactory.newName(schemaName);
        this.tableName = PNameFactory.newName(tableName);
        this.type = PTableType.VIEW;
        this.viewType = PTable.ViewType.MAPPED;
        this.timeStamp = timestamp;
        this.allColumns = Collections.emptyList();
        this.pkColumns = this.allColumns;
        this.rowKeySchema = RowKeySchema.EMPTY_SCHEMA;
        this.indexes = Collections.emptyList();
        this.familyByBytes = Maps.newHashMapWithExpectedSize(families.size());
        this.familyByString = Maps.newHashMapWithExpectedSize(families.size());
        for (PColumnFamily family : families) {
            this.familyByBytes.put(family.getName().getBytes(), family);
            this.familyByString.put(family.getName().getString(), family);
        }
        this.families = families;
        this.physicalNames = Collections.emptyList();
    }

    public PTableImpl(long timeStamp) {
        this(timeStamp, false);
    }

    public PTableImpl(long timeStamp, boolean isIndex) {
        if (isIndex) {
            this.type = PTableType.INDEX;
            this.state = PIndexState.INACTIVE;
        } else {
            this.type = PTableType.TABLE;
        }
        this.timeStamp = timeStamp;
        this.allColumns = Collections.emptyList();
        this.pkColumns = this.allColumns;
        this.families = Collections.emptyList();
        this.familyByBytes = Collections.emptyMap();
        this.familyByString = Collections.emptyMap();
        this.rowKeySchema = RowKeySchema.EMPTY_SCHEMA;
        this.indexes = Collections.emptyList();
        this.physicalNames = Collections.emptyList();
    }

    public static List<PColumn> getColumnsToClone(PTable table) {
        return table.getBucketNum() == null ? table.getColumns() : table.getColumns().subList(1, table.getColumns().size());
    }

    public static PTableImpl makePTable(PTable table, long timeStamp, List<PTable> indexes) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), timeStamp, table.getSequenceNumber() + 1L, table.getPKName(), table.getBucketNum(), PTableImpl.getColumnsToClone(table), table.getParentTableName(), indexes, table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getViewType(), table.getViewIndexId());
    }

    public static PTableImpl makePTable(PTable table, List<PColumn> columns) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), columns, table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getViewType(), table.getViewIndexId());
    }

    public static PTableImpl makePTable(PTable table, long timeStamp, long sequenceNumber, List<PColumn> columns) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), timeStamp, sequenceNumber, table.getPKName(), table.getBucketNum(), columns, table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getViewType(), table.getViewIndexId());
    }

    public static PTableImpl makePTable(PTable table, long timeStamp, long sequenceNumber, List<PColumn> columns, boolean isImmutableRows) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), timeStamp, sequenceNumber, table.getPKName(), table.getBucketNum(), columns, table.getParentTableName(), table.getIndexes(), isImmutableRows, table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getViewType(), table.getViewIndexId());
    }

    public static PTableImpl makePTable(PTable table, PIndexState state) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), state, table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), PTableImpl.getColumnsToClone(table), table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getViewType(), table.getViewIndexId());
    }

    public static PTableImpl makePTable(PName tenantId, PName schemaName, PName tableName, PTableType type, PIndexState state, long timeStamp, long sequenceNumber, PName pkName, Integer bucketNum, List<PColumn> columns, PName dataTableName, List<PTable> indexes, boolean isImmutableRows, List<PName> physicalNames, PName defaultFamilyName, String viewExpression, boolean disableWAL, boolean multiTenant, PTable.ViewType viewType, Short viewIndexId) throws SQLException {
        return new PTableImpl(tenantId, schemaName, tableName, type, state, timeStamp, sequenceNumber, pkName, bucketNum, columns, dataTableName, indexes, isImmutableRows, physicalNames, defaultFamilyName, viewExpression, disableWAL, multiTenant, viewType, viewIndexId);
    }

    private PTableImpl(PName tenantId, PName schemaName, PName tableName, PTableType type, PIndexState state, long timeStamp, long sequenceNumber, PName pkName, Integer bucketNum, List<PColumn> columns, PName dataTableName, List<PTable> indexes, boolean isImmutableRows, List<PName> physicalNames, PName defaultFamilyName, String viewExpression, boolean disableWAL, boolean multiTenant, PTable.ViewType viewType, Short viewIndexId) throws SQLException {
        this.init(tenantId, schemaName, tableName, type, state, timeStamp, sequenceNumber, pkName, bucketNum, columns, new PTableStatsImpl(), dataTableName, indexes, isImmutableRows, physicalNames, defaultFamilyName, viewExpression, disableWAL, multiTenant, viewType, viewIndexId);
    }

    @Override
    public boolean isMultiTenant() {
        return this.multiTenant;
    }

    @Override
    public PTable.ViewType getViewType() {
        return this.viewType;
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    private void init(PName tenantId, PName schemaName, PName tableName, PTableType type, PIndexState state, long timeStamp, long sequenceNumber, PName pkName, Integer bucketNum, List<PColumn> columns, PTableStats stats, PName parentTableName, List<PTable> indexes, boolean isImmutableRows, List<PName> physicalNames, PName defaultFamilyName, String viewExpression, boolean disableWAL, boolean multiTenant, PTable.ViewType viewType, Short viewIndexId) throws SQLException {
        ArrayList<PColumn> pkColumns;
        PColumn[] allColumns;
        Preconditions.checkNotNull(schemaName);
        Preconditions.checkArgument(tenantId == null || tenantId.getBytes().length > 0);
        int estimatedSize = 288 + PNameFactory.getEstimatedSize(tenantId) + PNameFactory.getEstimatedSize(schemaName) + PNameFactory.getEstimatedSize(tableName) + PNameFactory.getEstimatedSize(pkName) + PNameFactory.getEstimatedSize(parentTableName) + PNameFactory.getEstimatedSize(defaultFamilyName);
        this.tenantId = tenantId;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.name = PNameFactory.newName(SchemaUtil.getTableName(schemaName.getString(), tableName.getString()));
        this.key = new PTableKey(tenantId, this.name.getString());
        this.type = type;
        this.state = state;
        this.timeStamp = timeStamp;
        this.sequenceNumber = sequenceNumber;
        this.pkName = pkName;
        this.isImmutableRows = isImmutableRows;
        this.defaultFamilyName = defaultFamilyName;
        this.viewStatement = viewExpression;
        this.disableWAL = disableWAL;
        this.multiTenant = multiTenant;
        this.viewType = viewType;
        this.viewIndexId = viewIndexId;
        this.columnsByName = ArrayListMultimap.create(columns.size(), 1);
        if (bucketNum != null) {
            allColumns = new PColumn[columns.size() + 1];
            allColumns[SaltingUtil.SALTING_COLUMN.getPosition()] = SaltingUtil.SALTING_COLUMN;
            pkColumns = Lists.newArrayListWithExpectedSize(columns.size() + 1);
            pkColumns.add(SaltingUtil.SALTING_COLUMN);
        } else {
            allColumns = new PColumn[columns.size()];
            pkColumns = Lists.newArrayListWithExpectedSize(columns.size());
        }
        for (int i = 0; i < columns.size(); ++i) {
            String columnName;
            PColumn column;
            allColumns[column.getPosition()] = column = columns.get(i);
            PName familyName = column.getFamilyName();
            if (familyName == null) {
                pkColumns.add(column);
            }
            if (!this.columnsByName.put(columnName = column.getName().getString(), column)) continue;
            int count = 0;
            for (PColumn dupColumn : this.columnsByName.get(columnName)) {
                if (!Objects.equal(familyName, dupColumn.getFamilyName()) || ++count <= 1) continue;
                throw new ColumnAlreadyExistsException(null, this.name.getString(), columnName);
            }
        }
        estimatedSize = (int)((long)estimatedSize + SizedUtil.sizeOfMap(allColumns.length, 8, SizedUtil.sizeOfArrayList(1)));
        this.bucketNum = bucketNum;
        this.pkColumns = ImmutableList.copyOf(pkColumns);
        this.allColumns = ImmutableList.copyOf(allColumns);
        estimatedSize = (int)((long)estimatedSize + (SizedUtil.sizeOfMap(pkColumns.size()) + SizedUtil.sizeOfMap(allColumns.length)));
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(pkColumns.size());
        int maxExpectedSize = allColumns.length - pkColumns.size();
        LinkedHashMap familyMap = Maps.newLinkedHashMap();
        for (PColumn column : allColumns) {
            PName familyName = column.getFamilyName();
            if (familyName == null) {
                estimatedSize += column.getEstimatedSize();
                builder.addField(column, column.isNullable(), column.getSortOrder());
                continue;
            }
            ArrayList<PColumn> columnsInFamily = (ArrayList<PColumn>)familyMap.get(familyName);
            if (columnsInFamily == null) {
                columnsInFamily = Lists.newArrayListWithExpectedSize(maxExpectedSize);
                familyMap.put(familyName, columnsInFamily);
            }
            columnsInFamily.add(column);
        }
        this.rowKeySchema = builder.build();
        estimatedSize += this.rowKeySchema.getEstimatedSize();
        Iterator iterator = familyMap.entrySet().iterator();
        PColumnFamily[] families = new PColumnFamily[familyMap.size()];
        ImmutableMap.Builder<String, PColumnFamilyImpl> familyByString = ImmutableMap.builder();
        ImmutableSortedMap.Builder familyByBytes = ImmutableSortedMap.orderedBy(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < families.length; ++i) {
            Map.Entry entry = iterator.next();
            PColumnFamilyImpl family = new PColumnFamilyImpl((PName)entry.getKey(), (List)entry.getValue());
            families[i] = family;
            familyByString.put(family.getName().getString(), family);
            familyByBytes.put(family.getName().getBytes(), family);
            estimatedSize += family.getEstimatedSize();
        }
        this.families = ImmutableList.copyOf(families);
        this.familyByBytes = familyByBytes.build();
        this.familyByString = familyByString.build();
        estimatedSize += SizedUtil.sizeOfArrayList(families.length);
        estimatedSize = (int)((long)estimatedSize + SizedUtil.sizeOfMap(families.length) * 2L);
        this.stats = stats;
        this.indexes = indexes == null ? Collections.emptyList() : indexes;
        for (PTable index : this.indexes) {
            estimatedSize += index.getEstimatedSize();
        }
        this.parentTableName = parentTableName;
        this.parentName = parentTableName == null ? null : PNameFactory.newName(SchemaUtil.getTableName(schemaName.getString(), parentTableName.getString()));
        estimatedSize += PNameFactory.getEstimatedSize(this.parentName);
        this.physicalNames = physicalNames == null ? ImmutableList.of() : ImmutableList.copyOf(physicalNames);
        for (PName name : this.physicalNames) {
            estimatedSize += name.getEstimatedSize();
        }
        this.estimatedSize = estimatedSize;
    }

    @Override
    public boolean isImmutableRows() {
        return this.isImmutableRows;
    }

    public String toString() {
        return this.name.getString();
    }

    @Override
    public List<PColumn> getPKColumns() {
        return this.pkColumns;
    }

    @Override
    public final PName getName() {
        return this.name;
    }

    @Override
    public final PName getSchemaName() {
        return this.schemaName;
    }

    @Override
    public final PName getTableName() {
        return this.tableName;
    }

    @Override
    public final PTableType getType() {
        return this.type;
    }

    @Override
    public final List<PColumnFamily> getColumnFamilies() {
        return this.families;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int newKey(ImmutableBytesWritable key, byte[][] values) {
        int nValues;
        for (nValues = values.length; nValues > 0 && (values[nValues - 1] == null || values[nValues - 1].length == 0); --nValues) {
        }
        int i = 0;
        TrustedByteArrayOutputStream os = new TrustedByteArrayOutputStream(SchemaUtil.estimateKeyLength(this));
        try {
            PColumn column;
            Integer bucketNum = this.getBucketNum();
            if (bucketNum != null) {
                ++i;
                os.write(QueryConstants.SEPARATOR_BYTE_ARRAY);
            }
            List<PColumn> columns = this.getPKColumns();
            int nColumns = columns.size();
            PDataType type = null;
            while (i < nValues && i < nColumns) {
                byte[] byteValue;
                if (type != null && !type.isFixedWidth()) {
                    os.write(0);
                }
                column = columns.get(i);
                type = column.getDataType();
                if ((byteValue = values[i++]) == null) {
                    byteValue = ByteUtil.EMPTY_BYTE_ARRAY;
                }
                if (byteValue.length == 0 && !column.isNullable()) {
                    throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " may not be null");
                }
                Integer maxLength = column.getMaxLength();
                if (maxLength != null && type.isFixedWidth() && byteValue.length <= maxLength) {
                    byteValue = StringUtil.padChar(byteValue, maxLength);
                } else if (maxLength != null && byteValue.length > maxLength) {
                    throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " may not exceed " + maxLength + " bytes (" + SchemaUtil.toString(type, byteValue) + ")");
                }
                os.write(byteValue, 0, byteValue.length);
            }
            if (i < nColumns && ((type = (column = columns.get(i)).getDataType()).isFixedWidth() || !column.isNullable())) {
                throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " may not be null");
            }
            if (nValues == 0) {
                throw new ConstraintViolationException("Primary key may not be null (" + this.name.getString() + ")");
            }
            byte[] buf = os.getBuffer();
            int size = os.size();
            if (bucketNum != null) {
                buf[0] = SaltingUtil.getSaltingByte(buf, 1, size - 1, bucketNum);
            }
            key.set(buf, 0, size);
            int n = i;
            return n;
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private PRow newRow(KeyValueBuilder builder, long ts, ImmutableBytesWritable key, int i, byte[] ... values) {
        PRowImpl row = new PRowImpl(builder, key, ts, this.getBucketNum());
        if (i < values.length) {
            for (PColumnFamily family : this.getColumnFamilies()) {
                for (PColumn column : family.getColumns()) {
                    row.setValue(column, values[i++]);
                    if (i != values.length) continue;
                    return row;
                }
            }
        }
        return row;
    }

    @Override
    public PRow newRow(KeyValueBuilder builder, long ts, ImmutableBytesWritable key, byte[] ... values) {
        return this.newRow(builder, ts, key, 0, values);
    }

    @Override
    public PRow newRow(KeyValueBuilder builder, ImmutableBytesWritable key, byte[] ... values) {
        return this.newRow(builder, Long.MAX_VALUE, key, values);
    }

    @Override
    public PColumn getColumn(String name) throws ColumnNotFoundException, AmbiguousColumnException {
        List<PColumn> columns = this.columnsByName.get(name);
        int size = columns.size();
        if (size == 0) {
            throw new ColumnNotFoundException(name);
        }
        if (size > 1) {
            for (PColumn column : columns) {
                if (column.getFamilyName() != null && !"0".equals(column.getFamilyName().getString())) continue;
                return column;
            }
            throw new AmbiguousColumnException(name);
        }
        return columns.get(0);
    }

    @Override
    public PColumnFamily getColumnFamily(String familyName) throws ColumnFamilyNotFoundException {
        PColumnFamily family = this.familyByString.get(familyName);
        if (family == null) {
            throw new ColumnFamilyNotFoundException(familyName);
        }
        return family;
    }

    @Override
    public PColumnFamily getColumnFamily(byte[] familyBytes) throws ColumnFamilyNotFoundException {
        PColumnFamily family = this.familyByBytes.get(familyBytes);
        if (family == null) {
            String familyName = Bytes.toString(familyBytes);
            throw new ColumnFamilyNotFoundException(familyName);
        }
        return family;
    }

    @Override
    public List<PColumn> getColumns() {
        return this.allColumns;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public PTableStats getTableStats() {
        return this.stats;
    }

    @Override
    public PColumn getPKColumn(String name) throws ColumnNotFoundException {
        List<PColumn> columns = this.columnsByName.get(name);
        int size = columns.size();
        if (size == 0) {
            throw new ColumnNotFoundException(name);
        }
        if (size > 1) {
            do {
                PColumn column;
                if ((column = columns.get(--size)).getFamilyName() != null) continue;
                return column;
            } while (size > 0);
            throw new ColumnNotFoundException(name);
        }
        return columns.get(0);
    }

    @Override
    public PName getPKName() {
        return this.pkName;
    }

    @Override
    public RowKeySchema getRowKeySchema() {
        return this.rowKeySchema;
    }

    @Override
    public Integer getBucketNum() {
        return this.bucketNum;
    }

    @Override
    public List<PTable> getIndexes() {
        return this.indexes;
    }

    @Override
    public PIndexState getIndexState() {
        return this.state;
    }

    @Override
    public PName getParentTableName() {
        return this.parentTableName;
    }

    @Override
    public PName getParentName() {
        return this.parentName;
    }

    @Override
    public synchronized IndexMaintainer getIndexMaintainer(PTable dataTable) {
        if (this.indexMaintainer == null) {
            this.indexMaintainer = IndexMaintainer.create(dataTable, this);
        }
        return this.indexMaintainer;
    }

    @Override
    public synchronized void getIndexMaintainers(ImmutableBytesWritable ptr) {
        if (this.indexMaintainersPtr == null) {
            this.indexMaintainersPtr = new ImmutableBytesWritable();
            if (this.indexes.isEmpty()) {
                this.indexMaintainersPtr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            } else {
                IndexMaintainer.serialize(this, this.indexMaintainersPtr);
            }
        }
        ptr.set(this.indexMaintainersPtr.get(), this.indexMaintainersPtr.getOffset(), this.indexMaintainersPtr.getLength());
    }

    @Override
    public PName getPhysicalName() {
        return this.physicalNames.isEmpty() ? this.getName() : this.physicalNames.get(0);
    }

    @Override
    public List<PName> getPhysicalNames() {
        return this.physicalNames;
    }

    @Override
    public PName getDefaultFamilyName() {
        return this.defaultFamilyName;
    }

    @Override
    public String getViewStatement() {
        return this.viewStatement;
    }

    @Override
    public boolean isWALDisabled() {
        return this.disableWAL;
    }

    @Override
    public Short getViewIndexId() {
        return this.viewIndexId;
    }

    @Override
    public PName getTenantId() {
        return this.tenantId;
    }

    public static PTable createFromProto(PTableProtos.PTable table) {
        PName tenantId = null;
        if (table.hasTenantId()) {
            tenantId = PNameFactory.newName(table.getTenantId().toByteArray());
        }
        PName schemaName = PNameFactory.newName(table.getSchemaNameBytes().toByteArray());
        PName tableName = PNameFactory.newName(table.getTableNameBytes().toByteArray());
        PTableType tableType = PTableType.values()[table.getTableType().ordinal()];
        PIndexState indexState = null;
        if (table.hasIndexState()) {
            indexState = PIndexState.fromSerializedValue(table.getIndexState());
        }
        Short viewIndexId = null;
        if (table.hasViewIndexId()) {
            viewIndexId = (short)table.getViewIndexId();
        }
        long sequenceNumber = table.getSequenceNumber();
        long timeStamp = table.getTimeStamp();
        PName pkName = null;
        if (table.hasPkNameBytes()) {
            pkName = PNameFactory.newName(table.getPkNameBytes().toByteArray());
        }
        int bucketNum = table.getBucketNum();
        ArrayList<PColumn> columns = Lists.newArrayListWithExpectedSize(table.getColumnsCount());
        for (PTableProtos.PColumn curPColumnProto : table.getColumnsList()) {
            columns.add(PColumnImpl.createFromProto(curPColumnProto));
        }
        ArrayList<PTable> indexes = Lists.newArrayListWithExpectedSize(table.getIndexesCount());
        for (PTableProtos.PTable curPTableProto : table.getIndexesList()) {
            indexes.add(PTableImpl.createFromProto(curPTableProto));
        }
        boolean isImmutableRows = table.getIsImmutableRows();
        HashMap<String, byte[][]> guidePosts = new HashMap<String, byte[][]>();
        for (PTableProtos.PTableStats pTableStatsProto : table.getGuidePostsList()) {
            byte[][] value = new byte[pTableStatsProto.getValuesCount()][];
            for (int j = 0; j < pTableStatsProto.getValuesCount(); ++j) {
                value[j] = pTableStatsProto.getValues(j).toByteArray();
            }
            guidePosts.put(pTableStatsProto.getKey(), value);
        }
        PName dataTableName = null;
        if (table.hasDataTableNameBytes()) {
            dataTableName = PNameFactory.newName(table.getDataTableNameBytes().toByteArray());
        }
        PName defaultFamilyName = null;
        if (table.hasDefaultFamilyName()) {
            defaultFamilyName = PNameFactory.newName(table.getDefaultFamilyName().toByteArray());
        }
        boolean disableWAL = table.getDisableWAL();
        boolean multiTenant = table.getMultiTenant();
        PTable.ViewType viewType = null;
        String viewStatement = null;
        List<PName> physicalNames = Collections.emptyList();
        if (tableType == PTableType.VIEW) {
            viewType = PTable.ViewType.fromSerializedValue(table.getViewType().toByteArray()[0]);
            if (table.hasViewStatement()) {
                viewStatement = (String)PDataType.VARCHAR.toObject(table.getViewStatement().toByteArray());
            }
        }
        if (tableType == PTableType.VIEW || viewIndexId != null) {
            physicalNames = Lists.newArrayListWithExpectedSize(table.getPhysicalNamesCount());
            for (int i = 0; i < table.getPhysicalNamesCount(); ++i) {
                physicalNames.add(PNameFactory.newName(table.getPhysicalNames(i).toByteArray()));
            }
        }
        PTableStatsImpl stats = new PTableStatsImpl(guidePosts);
        try {
            PTableImpl result = new PTableImpl();
            result.init(tenantId, schemaName, tableName, tableType, indexState, timeStamp, sequenceNumber, pkName, bucketNum == NO_SALTING ? null : Integer.valueOf(bucketNum), columns, stats, dataTableName, indexes, isImmutableRows, physicalNames, defaultFamilyName, viewStatement, disableWAL, multiTenant, viewType, viewIndexId);
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static PTableProtos.PTable toProto(PTable table) {
        PTableProtos.PTable.Builder builder = PTableProtos.PTable.newBuilder();
        if (table.getTenantId() != null) {
            builder.setTenantId(HBaseZeroCopyByteString.wrap(table.getTenantId().getBytes()));
        }
        builder.setSchemaNameBytes(HBaseZeroCopyByteString.wrap(table.getSchemaName().getBytes()));
        builder.setTableNameBytes(HBaseZeroCopyByteString.wrap(table.getTableName().getBytes()));
        builder.setTableType(ProtobufUtil.toPTableTypeProto(table.getType()));
        if (table.getType() == PTableType.INDEX) {
            if (table.getIndexState() != null) {
                builder.setIndexState(table.getIndexState().getSerializedValue());
            }
            if (table.getViewIndexId() != null) {
                builder.setViewIndexId(table.getViewIndexId().shortValue());
            }
        }
        builder.setSequenceNumber(table.getSequenceNumber());
        builder.setTimeStamp(table.getTimeStamp());
        PName tmp = table.getPKName();
        if (tmp != null) {
            builder.setPkNameBytes(HBaseZeroCopyByteString.wrap(tmp.getBytes()));
        }
        Integer bucketNum = table.getBucketNum();
        int offset = 0;
        if (bucketNum == null) {
            builder.setBucketNum(NO_SALTING);
        } else {
            offset = 1;
            builder.setBucketNum(bucketNum);
        }
        List<PColumn> columns = table.getColumns();
        int columnSize = columns.size();
        for (int i = offset; i < columnSize; ++i) {
            PColumn column = columns.get(i);
            builder.addColumns(PColumnImpl.toProto(column));
        }
        List<PTable> indexes = table.getIndexes();
        for (PTable curIndex : indexes) {
            builder.addIndexes(PTableImpl.toProto(curIndex));
        }
        builder.setIsImmutableRows(table.isImmutableRows());
        Map<String, byte[][]> statsMap = table.getTableStats().getGuidePosts();
        if (statsMap != null) {
            for (Map.Entry<String, byte[][]> entry : statsMap.entrySet()) {
                PTableProtos.PTableStats.Builder statsBuilder = PTableProtos.PTableStats.newBuilder();
                statsBuilder.setKey(entry.getKey());
                for (byte[] curVal : entry.getValue()) {
                    statsBuilder.addValues(HBaseZeroCopyByteString.wrap(curVal));
                }
                builder.addGuidePosts(statsBuilder.build());
            }
        }
        if (table.getParentName() != null) {
            builder.setDataTableNameBytes(HBaseZeroCopyByteString.wrap(table.getParentTableName().getBytes()));
        }
        if (table.getDefaultFamilyName() != null) {
            builder.setDefaultFamilyName(HBaseZeroCopyByteString.wrap(table.getDefaultFamilyName().getBytes()));
        }
        builder.setDisableWAL(table.isWALDisabled());
        builder.setMultiTenant(table.isMultiTenant());
        if (table.getType() == PTableType.VIEW) {
            builder.setViewType(HBaseZeroCopyByteString.wrap(new byte[]{table.getViewType().getSerializedValue()}));
            builder.setViewStatement(HBaseZeroCopyByteString.wrap(PDataType.VARCHAR.toBytes(table.getViewStatement())));
        }
        if (table.getType() == PTableType.VIEW || table.getViewIndexId() != null) {
            for (int i = 0; i < table.getPhysicalNames().size(); ++i) {
                builder.addPhysicalNames(HBaseZeroCopyByteString.wrap(table.getPhysicalNames().get(i).getBytes()));
            }
        }
        return builder.build();
    }

    @Override
    public PTableKey getKey() {
        return this.key;
    }

    private class PRowImpl
    implements PRow {
        private final byte[] key;
        private final ImmutableBytesWritable keyPtr;
        private final KeyValueBuilder kvBuilder;
        private Put setValues;
        private Delete unsetValues;
        private Delete deleteRow;
        private final long ts;

        public PRowImpl(KeyValueBuilder kvBuilder, ImmutableBytesWritable key, long ts, Integer bucketNum) {
            this.kvBuilder = kvBuilder;
            this.ts = ts;
            if (bucketNum != null) {
                this.key = SaltingUtil.getSaltedKey(key, bucketNum);
                this.keyPtr = new ImmutableBytesPtr(this.key);
            } else {
                this.keyPtr = new ImmutableBytesPtr(key);
                this.key = ByteUtil.copyKeyBytesIfNecessary(key);
            }
            this.newMutations();
        }

        private void newMutations() {
            this.setValues = new Put(this.key);
            this.unsetValues = new Delete(this.key);
            this.setValues.setWriteToWAL(!PTableImpl.this.isWALDisabled());
            this.unsetValues.setWriteToWAL(!PTableImpl.this.isWALDisabled());
        }

        @Override
        public List<Mutation> toRowMutations() {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(3);
            if (this.deleteRow != null) {
                mutations.add(this.deleteRow);
            } else {
                KeyValueBuilder.addQuietly(this.setValues, this.kvBuilder, this.kvBuilder.buildPut(this.keyPtr, SchemaUtil.getEmptyColumnFamilyPtr(PTableImpl.this), QueryConstants.EMPTY_COLUMN_BYTES_PTR, this.ts, ByteUtil.EMPTY_BYTE_ARRAY_PTR));
                mutations.add(this.setValues);
                if (!this.unsetValues.isEmpty()) {
                    mutations.add(this.unsetValues);
                }
            }
            return mutations;
        }

        private void removeIfPresent(Mutation m, byte[] family, byte[] qualifier) {
            NavigableMap<byte[], List<Cell>> familyMap = m.getFamilyCellMap();
            List kvs = (List)familyMap.get(family);
            if (kvs != null) {
                Iterator iterator = kvs.iterator();
                while (iterator.hasNext()) {
                    Cell kv = (Cell)iterator.next();
                    if (Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), qualifier, 0, qualifier.length) != 0) continue;
                    iterator.remove();
                }
            }
        }

        @Override
        public void setValue(PColumn column, Object value) {
            byte[] byteValue = value == null ? ByteUtil.EMPTY_BYTE_ARRAY : column.getDataType().toBytes(value);
            this.setValue(column, byteValue);
        }

        @Override
        public void setValue(PColumn column, byte[] byteValue) {
            this.deleteRow = null;
            byte[] family = column.getFamilyName().getBytes();
            byte[] qualifier = column.getName().getBytes();
            PDataType type = column.getDataType();
            if (type.isNull(byteValue)) {
                if (!column.isNullable()) {
                    throw new ConstraintViolationException(PTableImpl.this.name.getString() + "." + column.getName().getString() + " may not be null");
                }
                this.removeIfPresent(this.setValues, family, qualifier);
                KeyValueBuilder.deleteQuietly(this.unsetValues, this.kvBuilder, this.kvBuilder.buildDeleteColumns(this.keyPtr, column.getFamilyName().getBytesPtr(), column.getName().getBytesPtr(), this.ts));
            } else {
                Integer maxLength = column.getMaxLength();
                if (type.isFixedWidth() && maxLength != null) {
                    if (byteValue.length <= maxLength) {
                        byteValue = StringUtil.padChar(byteValue, maxLength);
                    } else if (byteValue.length > maxLength) {
                        throw new ConstraintViolationException(PTableImpl.this.name.getString() + "." + column.getName().getString() + " may not exceed " + maxLength + " bytes (" + type.toObject(byteValue) + ")");
                    }
                }
                this.removeIfPresent(this.unsetValues, family, qualifier);
                KeyValueBuilder.addQuietly(this.setValues, this.kvBuilder, this.kvBuilder.buildPut(this.keyPtr, column.getFamilyName().getBytesPtr(), column.getName().getBytesPtr(), this.ts, new ImmutableBytesPtr(byteValue)));
            }
        }

        @Override
        public void delete() {
            Delete delete;
            this.newMutations();
            this.deleteRow = delete = new Delete(this.key, this.ts);
            if (PTableImpl.this.getType() == PTableType.INDEX) {
                this.deleteRow.setDurability(Durability.SKIP_WAL);
            }
        }
    }
}

