/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.util.SQLCloseable;

public class PhoenixArray
implements java.sql.Array,
SQLCloseable {
    PDataType baseType;
    Object array;
    int numElements;
    Integer maxLength;

    public PhoenixArray() {
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    private static Object[] coerceToNewLength(PDataType baseType, Object[] elements, int maxLength) {
        Object[] resizedElements = new Object[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            int length = baseType.getMaxLength(elements[i]);
            resizedElements[i] = length == maxLength ? elements[i] : baseType.pad(elements[i], maxLength);
        }
        return resizedElements;
    }

    private static Object[] coerceToEqualLength(PDataType baseType, Object[] elements) {
        if (elements == null || elements.length == 0) {
            return elements;
        }
        Object element = elements[0];
        int maxLength = baseType.getMaxLength(element);
        boolean resizeElements = false;
        for (int i = 1; i < elements.length; ++i) {
            int length = baseType.getMaxLength(elements[i]);
            if (length > maxLength) {
                maxLength = length;
                resizeElements = true;
                continue;
            }
            if (length >= maxLength) continue;
            resizeElements = true;
        }
        if (!resizeElements) {
            return elements;
        }
        return PhoenixArray.coerceToNewLength(baseType, elements, maxLength);
    }

    public PhoenixArray(PDataType baseType, Object[] elements) {
        this.baseType = baseType;
        if (baseType.isFixedWidth()) {
            if (baseType.getByteSize() == null) {
                if ((elements = PhoenixArray.coerceToEqualLength(baseType, elements)) != null && elements.length > 0) {
                    this.maxLength = baseType.getMaxLength(elements[0]);
                }
            } else {
                this.maxLength = baseType.getByteSize();
            }
        }
        this.array = this.convertObjectArrayToPrimitiveArray(elements);
        this.numElements = elements.length;
    }

    public PhoenixArray(PhoenixArray pArr, Integer desiredMaxLength) {
        this.baseType = pArr.baseType;
        Object[] elements = (Object[])pArr.array;
        if (this.baseType.isFixedWidth()) {
            if (this.baseType.getByteSize() == null) {
                elements = PhoenixArray.coerceToNewLength(this.baseType, (Object[])pArr.array, desiredMaxLength);
                this.maxLength = desiredMaxLength;
            } else {
                this.maxLength = this.baseType.getByteSize();
            }
        }
        this.array = this.convertObjectArrayToPrimitiveArray(elements);
        this.numElements = elements.length;
    }

    public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
        return elements;
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Object getArray() throws SQLException {
        return this.array;
    }

    @Override
    public void close() throws SQLException {
        this.array = null;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (index < 1L) {
            throw new IllegalArgumentException("Index cannot be less than 1");
        }
        Object[] intArr = (Object[])this.array;
        this.boundaryCheck(index, count, intArr);
        Object[] newArr = new Object[count];
        int i = 0;
        for (int j = (int)index; j < count; ++j) {
            newArr[i] = intArr[j];
            ++i;
        }
        return newArr;
    }

    private void boundaryCheck(long index, int count, Object[] arr) {
        if (--index + (long)count > (long)arr.length) {
            throw new IllegalArgumentException("The array index is out of range of the total number of elements in the array " + arr.length);
        }
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            throw new UnsupportedOperationException("Currently not supported");
        }
        return null;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.baseType.getSqlType();
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.baseType.getSqlTypeName();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> arg0) throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public ResultSet getResultSet(long arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    @Override
    public ResultSet getResultSet(long arg0, int arg1, Map<String, Class<?>> arg2) throws SQLException {
        throw new UnsupportedOperationException("Currently not supported");
    }

    public int getDimensions() {
        return this.numElements;
    }

    public int estimateByteSize(int pos) {
        if (((Object[])this.array)[pos] == null) {
            return 0;
        }
        return this.baseType.estimateByteSize(((Object[])this.array)[pos]);
    }

    public Integer getMaxLength(int pos) {
        return this.baseType.getMaxLength(((Object[])this.array)[pos]);
    }

    public byte[] toBytes(int pos) {
        return this.baseType.toBytes(((Object[])this.array)[pos]);
    }

    public boolean isNull(int pos) {
        return this.baseType.toBytes(((Object[])this.array)[pos]).length == 0;
    }

    public boolean equals(Object obj) {
        if (this.numElements != ((PhoenixArray)obj).numElements) {
            return false;
        }
        if (this.baseType != ((PhoenixArray)obj).baseType) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.array, (Object[])((PhoenixArray)obj).array);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.array == null ? 0 : this.array.hashCode());
        return result;
    }

    public static class PrimitiveBooleanPhoenixArray
    extends PhoenixArray {
        private boolean[] booleanArr;

        public PrimitiveBooleanPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            Object object = Array.newInstance(Boolean.TYPE, elements.length);
            this.booleanArr = (boolean[])object;
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.booleanArr[i] = (Boolean)o;
                }
                ++i;
            }
            return this.booleanArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.booleanArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.booleanArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.numElements != ((PhoenixArray)obj).numElements) {
                return false;
            }
            if (this.baseType != ((PhoenixArray)obj).baseType) {
                return false;
            }
            return Arrays.equals((boolean[])this.array, (boolean[])((PhoenixArray)obj).array);
        }
    }

    public static class PrimitiveBytePhoenixArray
    extends PhoenixArray {
        private byte[] byteArr;

        public PrimitiveBytePhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            Object object = Array.newInstance(Byte.TYPE, elements.length);
            this.byteArr = (byte[])object;
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.byteArr[i] = (Byte)o;
                }
                ++i;
            }
            return this.byteArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.byteArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.byteArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.numElements != ((PhoenixArray)obj).numElements) {
                return false;
            }
            if (this.baseType != ((PhoenixArray)obj).baseType) {
                return false;
            }
            return Arrays.equals((byte[])this.array, (byte[])((PhoenixArray)obj).array);
        }
    }

    public static class PrimitiveFloatPhoenixArray
    extends PhoenixArray {
        private float[] floatArr;

        public PrimitiveFloatPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            Object object = Array.newInstance(Float.TYPE, elements.length);
            this.floatArr = (float[])object;
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.floatArr[i] = ((Float)o).floatValue();
                }
                ++i;
            }
            return this.floatArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(Float.valueOf(this.floatArr[pos]));
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(Float.valueOf(this.floatArr[pos]));
        }

        @Override
        public boolean equals(Object obj) {
            if (this.numElements != ((PhoenixArray)obj).numElements) {
                return false;
            }
            if (this.baseType != ((PhoenixArray)obj).baseType) {
                return false;
            }
            return Arrays.equals((float[])this.array, (float[])((PhoenixArray)obj).array);
        }
    }

    public static class PrimitiveDoublePhoenixArray
    extends PhoenixArray {
        private double[] doubleArr;

        public PrimitiveDoublePhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            Object object = Array.newInstance(Double.TYPE, elements.length);
            this.doubleArr = (double[])object;
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.doubleArr[i] = (Double)o;
                }
                ++i;
            }
            return this.doubleArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.doubleArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.doubleArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.numElements != ((PhoenixArray)obj).numElements) {
                return false;
            }
            if (this.baseType != ((PhoenixArray)obj).baseType) {
                return false;
            }
            return Arrays.equals((double[])this.array, (double[])((PhoenixArray)obj).array);
        }
    }

    public static class PrimitiveLongPhoenixArray
    extends PhoenixArray {
        private long[] longArr;

        public PrimitiveLongPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            Object object = Array.newInstance(Long.TYPE, elements.length);
            this.longArr = (long[])object;
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.longArr[i] = (Long)o;
                }
                ++i;
            }
            return this.longArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.longArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.longArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.numElements != ((PhoenixArray)obj).numElements) {
                return false;
            }
            if (this.baseType != ((PhoenixArray)obj).baseType) {
                return false;
            }
            return Arrays.equals((long[])this.array, (long[])((PhoenixArray)obj).array);
        }
    }

    public static class PrimitiveShortPhoenixArray
    extends PhoenixArray {
        private short[] shortArr;

        public PrimitiveShortPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            Object object = Array.newInstance(Short.TYPE, elements.length);
            this.shortArr = (short[])object;
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.shortArr[i] = (Short)o;
                }
                ++i;
            }
            return this.shortArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.shortArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.shortArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.numElements != ((PhoenixArray)obj).numElements) {
                return false;
            }
            if (this.baseType != ((PhoenixArray)obj).baseType) {
                return false;
            }
            return Arrays.equals((short[])this.array, (short[])((PhoenixArray)obj).array);
        }
    }

    public static class PrimitiveIntPhoenixArray
    extends PhoenixArray {
        private int[] intArr;

        public PrimitiveIntPhoenixArray(PDataType dataType, Object[] elements) {
            super(dataType, elements);
        }

        @Override
        public Object convertObjectArrayToPrimitiveArray(Object[] elements) {
            Object object = Array.newInstance(Integer.TYPE, elements.length);
            this.intArr = (int[])object;
            int i = 0;
            for (Object o : elements) {
                if (o != null) {
                    this.intArr[i] = (Integer)o;
                }
                ++i;
            }
            return this.intArr;
        }

        @Override
        public int estimateByteSize(int pos) {
            return this.baseType.estimateByteSize(this.intArr[pos]);
        }

        @Override
        public byte[] toBytes(int pos) {
            return this.baseType.toBytes(this.intArr[pos]);
        }

        @Override
        public boolean equals(Object obj) {
            if (this.numElements != ((PhoenixArray)obj).numElements) {
                return false;
            }
            if (this.baseType != ((PhoenixArray)obj).baseType) {
                return false;
            }
            return Arrays.equals((int[])this.array, (int[])((PhoenixArray)obj).array);
        }
    }
}

