/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.SequenceRegionObserver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.EmptySequenceCacheException;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.SchemaUtil;

public class Sequence {
    public static final int SUCCESS = 0;
    private static final KeyValue CURRENT_VALUE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES);
    private static final KeyValue INCREMENT_BY_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.INCREMENT_BY_BYTES);
    private static final KeyValue CACHE_SIZE_KV = KeyValue.createFirstOnRow(ByteUtil.EMPTY_BYTE_ARRAY, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CACHE_SIZE_BYTES);
    private static final List<KeyValue> SEQUENCE_KV_COLUMNS = Arrays.asList(CURRENT_VALUE_KV, INCREMENT_BY_KV, CACHE_SIZE_KV);
    private static final int CURRENT_VALUE_INDEX;
    private static final int INCREMENT_BY_INDEX;
    private static final int CACHE_SIZE_INDEX;
    private static final int SEQUENCE_KEY_VALUES;
    private static final EmptySequenceCacheException EMPTY_SEQUENCE_CACHE_EXCEPTION;
    private final SequenceKey key;
    private final ReentrantLock lock;
    private List<SequenceValue> values;

    public Sequence(SequenceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.lock = new ReentrantLock();
    }

    private void insertSequenceValue(SequenceValue value) {
        if (this.values == null) {
            this.values = Lists.newArrayListWithExpectedSize(1);
            this.values.add(value);
        } else {
            int i;
            for (i = this.values.size() - 1; i >= 0 && this.values.get((int)i).timestamp > value.timestamp; --i) {
            }
            if (i >= 0 && this.values.get((int)i).timestamp == value.timestamp) {
                if (this.values.get(i).isDeleted()) {
                    throw new IllegalStateException("Unexpected delete marker at timestamp " + value.timestamp + " for " + this.key);
                }
                this.values.set(i, value);
            } else {
                this.values.add(i + 1, value);
            }
        }
    }

    private SequenceValue findSequenceValue(long timestamp) {
        int i;
        if (this.values == null) {
            return null;
        }
        for (i = this.values.size() - 1; i >= 0 && this.values.get((int)i).timestamp >= timestamp; --i) {
        }
        if (i < 0) {
            return null;
        }
        SequenceValue value = this.values.get(i);
        return value.isDeleted() ? null : value;
    }

    public long incrementValue(long timestamp, int factor, Action action) throws EmptySequenceCacheException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        if (value.currentValue == value.nextValue) {
            if (action == Action.VALIDATE) {
                return value.currentValue;
            }
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        long returnValue = value.currentValue;
        value.currentValue += (long)factor * value.incrementBy;
        return returnValue;
    }

    public List<Append> newReturns() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        ArrayList<Append> appends = Lists.newArrayListWithExpectedSize(this.values.size());
        for (SequenceValue value : this.values) {
            if (!value.isInitialized() || value.currentValue == value.nextValue) continue;
            appends.add(this.newReturn(value));
        }
        return appends;
    }

    public Append newReturn(long timestamp) throws EmptySequenceCacheException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        if (value.currentValue == value.nextValue) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        return this.newReturn(value);
    }

    private Append newReturn(SequenceValue value) {
        byte[] key = SchemaUtil.getSequenceKey(this.key.getTenantId(), this.key.getSchemaName(), this.key.getSequenceName());
        Append append = new Append(key);
        byte[] opBuf = new byte[]{(byte)SequenceRegionObserver.Op.RETURN_SEQUENCE.ordinal()};
        append.setAttribute("SEQUENCE_OPERATION", opBuf);
        append.setAttribute("CURRENT_VALUE", PDataType.LONG.toBytes(value.nextValue));
        NavigableMap<byte[], List<Cell>> familyMap = append.getFamilyCellMap();
        familyMap.put(PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, Arrays.asList(KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES, value.timestamp, PDataType.LONG.toBytes(value.currentValue))));
        return append;
    }

    public long currentValue(long timestamp) throws EmptySequenceCacheException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null || value.isUnitialized()) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        return value.currentValue - value.incrementBy;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public SequenceKey getKey() {
        return this.key;
    }

    public long incrementValue(Result result, int factor) throws SQLException {
        if (result.rawCells().length == 1) {
            Cell errorKV = result.rawCells()[0];
            int errorCode = PDataType.INTEGER.getCodec().decodeInt(errorKV.getValueArray(), errorKV.getValueOffset(), SortOrder.getDefault());
            SQLExceptionCode code = SQLExceptionCode.fromErrorCode(errorCode);
            throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
        }
        SequenceValue value = new SequenceValue(result);
        this.insertSequenceValue(value);
        long currentValue = value.currentValue;
        value.currentValue += (long)factor * value.incrementBy;
        return currentValue;
    }

    public Increment newIncrement(long timestamp, Action action) {
        Increment inc = new Increment(SchemaUtil.getSequenceKey(this.key.getTenantId(), this.key.getSchemaName(), this.key.getSequenceName()));
        try {
            inc.setTimeRange(0L, timestamp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (KeyValue kv : SEQUENCE_KV_COLUMNS) {
            inc.addColumn(kv.getFamily(), kv.getQualifier(), action.ordinal());
        }
        return inc;
    }

    public static KeyValue getCurrentValueKV(List<KeyValue> kvs) {
        assert (kvs.size() == SEQUENCE_KEY_VALUES);
        return kvs.get(CURRENT_VALUE_INDEX);
    }

    public static KeyValue getIncrementByKV(List<KeyValue> kvs) {
        assert (kvs.size() == SEQUENCE_KEY_VALUES);
        return kvs.get(INCREMENT_BY_INDEX);
    }

    public static KeyValue getCacheSizeKV(List<KeyValue> kvs) {
        assert (kvs.size() == SEQUENCE_KEY_VALUES);
        return kvs.get(CACHE_SIZE_INDEX);
    }

    public static KeyValue getCurrentValueKV(Result r) {
        Cell[] kvs = r.rawCells();
        assert (kvs.length == SEQUENCE_KEY_VALUES);
        return org.apache.hadoop.hbase.KeyValueUtil.ensureKeyValue(kvs[CURRENT_VALUE_INDEX]);
    }

    public static KeyValue getIncrementByKV(Result r) {
        Cell[] kvs = r.rawCells();
        assert (kvs.length == SEQUENCE_KEY_VALUES);
        return org.apache.hadoop.hbase.KeyValueUtil.ensureKeyValue(kvs[INCREMENT_BY_INDEX]);
    }

    public static KeyValue getCacheSizeKV(Result r) {
        Cell[] kvs = r.rawCells();
        assert (kvs.length == SEQUENCE_KEY_VALUES);
        return org.apache.hadoop.hbase.KeyValueUtil.ensureKeyValue(kvs[CACHE_SIZE_INDEX]);
    }

    public static Result replaceCurrentValueKV(Result r, KeyValue currentValueKV) {
        Cell[] kvs = r.rawCells();
        ArrayList<Cell> newkvs = Lists.newArrayList(kvs);
        newkvs.set(CURRENT_VALUE_INDEX, currentValueKV);
        return Result.create(newkvs);
    }

    public boolean returnValue(Result result) throws SQLException {
        Cell statusKV = result.rawCells()[0];
        if (statusKV.getValueLength() == 0) {
            return false;
        }
        long timestamp = statusKV.getTimestamp();
        int statusCode = PDataType.INTEGER.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        if (statusCode == 0) {
            SequenceValue value = this.findSequenceValue(timestamp);
            if (value == null) {
                throw new EmptySequenceCacheException(this.key.getSchemaName(), this.key.getSequenceName());
            }
            value.nextValue = value.currentValue;
            return true;
        }
        SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    public Append createSequence(long startWith, long incrementBy, long cacheSize, long timestamp) {
        byte[] key = SchemaUtil.getSequenceKey(this.key.getTenantId(), this.key.getSchemaName(), this.key.getSequenceName());
        Append append = new Append(key);
        append.setAttribute("SEQUENCE_OPERATION", new byte[]{(byte)SequenceRegionObserver.Op.CREATE_SEQUENCE.ordinal()});
        if (timestamp != Long.MAX_VALUE) {
            append.setAttribute("MAX_TIMERANGE", Bytes.toBytes(timestamp));
        }
        NavigableMap<byte[], List<Cell>> familyMap = append.getFamilyCellMap();
        byte[] startWithBuf = PDataType.LONG.toBytes(startWith);
        familyMap.put(PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, Arrays.asList(KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timestamp, ByteUtil.EMPTY_BYTE_ARRAY), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES, timestamp, startWithBuf), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.START_WITH_BYTES, timestamp, startWithBuf), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.INCREMENT_BY_BYTES, timestamp, PDataType.LONG.toBytes(incrementBy)), KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CACHE_SIZE_BYTES, timestamp, PDataType.LONG.toBytes(cacheSize))));
        return append;
    }

    public long createSequence(Result result) throws SQLException {
        Cell statusKV = result.rawCells()[0];
        long timestamp = statusKV.getTimestamp();
        int statusCode = PDataType.INTEGER.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        if (statusCode == 0) {
            SequenceValue value = new SequenceValue(timestamp);
            this.insertSequenceValue(value);
            return timestamp;
        }
        SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    public Append dropSequence(long timestamp) {
        byte[] key = SchemaUtil.getSequenceKey(this.key.getTenantId(), this.key.getSchemaName(), this.key.getSequenceName());
        Append append = new Append(key);
        append.setAttribute("SEQUENCE_OPERATION", new byte[]{(byte)SequenceRegionObserver.Op.DROP_SEQUENCE.ordinal()});
        if (timestamp != Long.MAX_VALUE) {
            append.setAttribute("MAX_TIMERANGE", Bytes.toBytes(timestamp));
        }
        NavigableMap<byte[], List<Cell>> familyMap = append.getFamilyCellMap();
        familyMap.put(PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, Arrays.asList(KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timestamp, ByteUtil.EMPTY_BYTE_ARRAY)));
        return append;
    }

    public long dropSequence(Result result) throws SQLException {
        SQLExceptionCode code;
        Cell statusKV = result.rawCells()[0];
        long timestamp = statusKV.getTimestamp();
        int statusCode = PDataType.INTEGER.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        SQLExceptionCode sQLExceptionCode = code = statusCode == 0 ? null : SQLExceptionCode.fromErrorCode(statusCode);
        if (code == null) {
            this.insertSequenceValue(new SequenceValue(timestamp, true));
            return timestamp;
        }
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    static {
        Collections.sort(SEQUENCE_KV_COLUMNS, KeyValue.COMPARATOR);
        CURRENT_VALUE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(CURRENT_VALUE_KV);
        INCREMENT_BY_INDEX = SEQUENCE_KV_COLUMNS.indexOf(INCREMENT_BY_KV);
        CACHE_SIZE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(CACHE_SIZE_KV);
        SEQUENCE_KEY_VALUES = SEQUENCE_KV_COLUMNS.size();
        EMPTY_SEQUENCE_CACHE_EXCEPTION = new EmptySequenceCacheException();
    }

    private static final class SequenceValue {
        public final long incrementBy;
        public final long cacheSize;
        public final long timestamp;
        public long currentValue;
        public long nextValue;

        public SequenceValue(long timestamp) {
            this(timestamp, false);
        }

        public SequenceValue(long timestamp, boolean isDeleted) {
            this.timestamp = timestamp;
            this.incrementBy = isDeleted ? -1L : 0L;
            this.cacheSize = 0L;
        }

        public boolean isInitialized() {
            return this.incrementBy > 0L;
        }

        public boolean isUnitialized() {
            return this.incrementBy == 0L;
        }

        public boolean isDeleted() {
            return this.incrementBy < 0L;
        }

        public SequenceValue(Result r) {
            KeyValue currentValueKV = Sequence.getCurrentValueKV(r);
            KeyValue incrementByKV = Sequence.getIncrementByKV(r);
            KeyValue cacheSizeKV = Sequence.getCacheSizeKV(r);
            this.timestamp = currentValueKV.getTimestamp();
            this.nextValue = PDataType.LONG.getCodec().decodeLong(currentValueKV.getValueArray(), currentValueKV.getValueOffset(), SortOrder.getDefault());
            this.incrementBy = PDataType.LONG.getCodec().decodeLong(incrementByKV.getValueArray(), incrementByKV.getValueOffset(), SortOrder.getDefault());
            this.cacheSize = PDataType.LONG.getCodec().decodeLong(cacheSizeKV.getValueArray(), cacheSizeKV.getValueOffset(), SortOrder.getDefault());
            this.currentValue = this.nextValue - this.incrementBy * this.cacheSize;
        }
    }

    public static enum Action {
        VALIDATE,
        RESERVE;

    }
}

