/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

public class SequenceKey
implements Comparable<SequenceKey> {
    private final String tenantId;
    private final String schemaName;
    private final String sequenceName;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        result = 31 * result + this.sequenceName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceKey other = (SequenceKey)obj;
        return this.compareTo(other) == 0;
    }

    public SequenceKey(String tenantId, String schemaName, String sequenceName) {
        this.tenantId = tenantId;
        this.schemaName = schemaName;
        this.sequenceName = sequenceName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    @Override
    public int compareTo(SequenceKey that) {
        int c;
        int n = this.tenantId == that.getTenantId() ? 0 : (this.tenantId == null ? -1 : (c = that.getTenantId() == null ? 1 : this.tenantId.compareTo(that.getTenantId())));
        if (c == 0) {
            int n2 = this.schemaName == that.getSchemaName() ? 0 : (this.schemaName == null ? -1 : (c = that.getSchemaName() == null ? 1 : this.schemaName.compareTo(that.getSchemaName())));
            if (c == 0) {
                return this.sequenceName.compareTo(that.getSequenceName());
            }
        }
        return c;
    }
}

