/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;

public class SequenceNotFoundException
extends MetaDataEntityNotFoundException {
    private static final long serialVersionUID = 1L;
    private static SQLExceptionCode code = SQLExceptionCode.SEQUENCE_UNDEFINED;
    private final String schemaName;
    private final String tableName;

    public SequenceNotFoundException(String tableName) {
        this(null, tableName);
    }

    public SequenceNotFoundException(String schemaName, String tableName) {
        super(new SQLExceptionInfo.Builder(code).setSchemaName(schemaName).setTableName(tableName).build().toString(), code.getSQLState(), code.getErrorCode(), null);
        this.tableName = tableName;
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }
}

