/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.schema.PTable;

public final class TableRef {
    private final PTable table;
    private final String alias;
    private final long timeStamp;
    private final boolean hasDynamicCols;

    public TableRef(TableRef tableRef, long timeStamp) {
        this(tableRef.alias, tableRef.table, timeStamp, tableRef.hasDynamicCols);
    }

    public TableRef(PTable table) {
        this(null, table, Long.MAX_VALUE, false);
    }

    public TableRef(String alias, PTable table, long timeStamp, boolean hasDynamicCols) {
        this.alias = alias;
        this.table = table;
        this.timeStamp = timeStamp;
        this.hasDynamicCols = hasDynamicCols;
    }

    public PTable getTable() {
        return this.table;
    }

    public String getTableAlias() {
        return this.alias;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.alias == null ? 0 : this.alias.hashCode();
        result = 31 * result + this.table.getName().getString().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableRef other = (TableRef)obj;
        if (this.alias == null && other.alias != null || this.alias != null && !this.alias.equals(other.alias)) {
            return false;
        }
        return this.table.getName().getString().equals(other.table.getName().getString());
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean hasDynamicCols() {
        return this.hasDynamicCols;
    }
}

