/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.util.Arrays;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.ValueSchema;

public class ValueBitSet {
    public static final ValueBitSet EMPTY_VALUE_BITSET = new ValueBitSet();
    private static final int BITS_PER_LONG = 64;
    private static final int BITS_PER_SHORT = 16;
    private final long[] bits;
    private final ValueSchema schema;
    private int maxSetBit = -1;

    public static ValueBitSet newInstance(ValueSchema schema) {
        if (schema.getFieldCount() == schema.getMinNullable()) {
            return EMPTY_VALUE_BITSET;
        }
        return new ValueBitSet(schema);
    }

    private ValueBitSet() {
        this.schema = null;
        this.bits = new long[0];
    }

    private ValueBitSet(ValueSchema schema) {
        this.schema = schema;
        this.bits = new long[Math.max(1, (schema.getFieldCount() - schema.getMinNullable() + 64 - 1) / 64)];
    }

    public int getMaxSetBit() {
        return this.maxSetBit;
    }

    private boolean isVarLength() {
        return this.schema == null ? false : this.schema.getFieldCount() - this.schema.getMinNullable() > 16;
    }

    public int getNullCount(int nBit, int nFields) {
        if (this.schema == null) {
            return 0;
        }
        int count = 0;
        int index = nBit / 64;
        int shiftRight = nBit % 64;
        int bitsToLeft = 64 - shiftRight;
        int shiftLeft = Math.max(0, 64 - nFields);
        count += Math.min(nFields, bitsToLeft) - Long.bitCount(this.bits[index] >>> shiftRight << shiftLeft);
        if ((nFields -= bitsToLeft) > 0) {
            while (nFields > 64) {
                count += 64 - Long.bitCount(this.bits[++index]);
                nFields -= 64;
            }
            if (nFields > 0) {
                count += nFields - Long.bitCount(this.bits[++index] << 64 - nFields);
            }
        }
        return count;
    }

    public int toBytes(byte[] b, int offset) {
        if (this.schema == null) {
            return offset;
        }
        if (this.isVarLength()) {
            int nLongs = (this.maxSetBit + 64 - 1) / 64;
            for (int i = 0; i < nLongs; ++i) {
                offset = Bytes.putLong(b, offset, this.bits[i]);
            }
            offset = Bytes.putShort(b, offset, (short)nLongs);
        } else {
            offset = Bytes.putShort(b, offset, (short)this.bits[0]);
        }
        return offset;
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
        this.maxSetBit = -1;
    }

    public boolean get(int nBit) {
        int lIndex = nBit / 64;
        int bIndex = nBit % 64;
        return (this.bits[lIndex] & 1L << bIndex) != 0L;
    }

    public void set(int nBit) {
        int lIndex = nBit / 64;
        int bIndex = nBit % 64;
        int n = lIndex;
        this.bits[n] = this.bits[n] | 1L << bIndex;
        this.maxSetBit = Math.max(this.maxSetBit, nBit);
    }

    public void or(ImmutableBytesWritable ptr) {
        if (this.schema == null) {
            return;
        }
        if (this.isVarLength()) {
            int offset = ptr.getOffset() + ptr.getLength() - 2;
            int nLongs = Bytes.toShort(ptr.get(), offset);
            offset -= nLongs * 8;
            int i = 0;
            while (i < nLongs) {
                int n = i++;
                this.bits[n] = this.bits[n] | Bytes.toLong(ptr.get(), offset);
                offset += 8;
            }
            this.maxSetBit = Math.max(this.maxSetBit, nLongs * 8 - 1);
        } else {
            long l = Bytes.toShort(ptr.get(), ptr.getOffset() + ptr.getLength() - 2);
            this.bits[0] = this.bits[0] | l;
            this.maxSetBit = Math.max(this.maxSetBit, 15);
        }
    }

    public int getEstimatedLength() {
        if (this.schema == null) {
            return 0;
        }
        return 2 + (this.isVarLength() ? (this.maxSetBit + 64 - 1) / 64 * 8 : 0);
    }

    public static int getSize(int nBits) {
        return 52 + (nBits + 64 - 1) / 64 * 8;
    }

    public int getSize() {
        if (this.schema == null) {
            return 0;
        }
        return 48 + 8 * this.bits.length + 4;
    }

    public void or(ValueBitSet isSet) {
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | isSet.bits[i];
        }
        this.maxSetBit = Math.max(this.maxSetBit, isSet.maxSetBit);
    }
}

