/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stat;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.phoenix.schema.stat.PTableStats;

public class PTableStatsImpl
implements PTableStats {
    private Map<String, byte[][]> regionGuidePosts;

    public PTableStatsImpl() {
    }

    public PTableStatsImpl(Map<String, byte[][]> stats) {
        this.regionGuidePosts = ImmutableMap.copyOf(stats);
    }

    @Override
    public byte[][] getRegionGuidePosts(HRegionInfo region) {
        return this.regionGuidePosts.get(region.getRegionNameAsString());
    }

    @Override
    public Map<String, byte[][]> getGuidePosts() {
        if (this.regionGuidePosts != null) {
            return ImmutableMap.copyOf(this.regionGuidePosts);
        }
        return null;
    }
}

