/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.schema.tuple.BaseTuple;
import org.apache.phoenix.util.KeyValueUtil;

public class ResultTuple
extends BaseTuple {
    private Result result;

    public ResultTuple(Result result) {
        this.result = result;
    }

    public ResultTuple() {
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    @Override
    public void getKey(ImmutableBytesWritable ptr) {
        ptr.set(this.result.getRow());
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public KeyValue getValue(byte[] family, byte[] qualifier) {
        Cell cell = KeyValueUtil.getColumnLatest(GenericKeyValueBuilder.INSTANCE, this.result.rawCells(), family, qualifier);
        return org.apache.hadoop.hbase.KeyValueUtil.ensureKeyValue(cell);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("keyvalues=");
        if (this.result.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (Cell kv : this.result.listCells()) {
            if (moreThanOne) {
                sb.append(", \n");
            } else {
                moreThanOne = true;
            }
            sb.append(kv.toString() + "/value=" + Bytes.toString(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength()));
        }
        sb.append("}\n");
        return sb.toString();
    }

    @Override
    public int size() {
        return this.result.size();
    }

    @Override
    public KeyValue getValue(int index) {
        return org.apache.hadoop.hbase.KeyValueUtil.ensureKeyValue(this.result.rawCells()[index]);
    }

    @Override
    public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
        KeyValue kv = this.getValue(family, qualifier);
        if (kv == null) {
            return false;
        }
        ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        return true;
    }
}

