/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class Closeables {
    private Closeables() {
    }

    public static void closeAll(Iterable<? extends Closeable> iterable) throws IOException {
        IOException ex = Closeables.closeAllQuietly(iterable);
        if (ex != null) {
            throw ex;
        }
    }

    public static IOException closeAllQuietly(Iterable<? extends Closeable> iterable) {
        if (iterable == null) {
            return null;
        }
        LinkedList<IOException> exceptions = null;
        for (Closeable closeable : iterable) {
            try {
                closeable.close();
            }
            catch (IOException x) {
                if (exceptions == null) {
                    exceptions = new LinkedList<IOException>();
                }
                exceptions.add(x);
            }
        }
        IOException ex = MultipleCausesIOException.fromIOExceptions(exceptions);
        return ex;
    }

    private static class MultipleCausesIOException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final Collection<? extends IOException> exceptions;
        private boolean hasSetStackTrace;

        static IOException fromIOExceptions(Collection<? extends IOException> exceptions) {
            if (exceptions == null || exceptions.isEmpty()) {
                return null;
            }
            if (exceptions.size() == 1) {
                return Iterables.getOnlyElement(exceptions);
            }
            return new MultipleCausesIOException(exceptions);
        }

        private MultipleCausesIOException(Collection<? extends IOException> exceptions) {
            this.exceptions = exceptions;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder(this.exceptions.size() * 50);
            int exceptionNum = 0;
            for (IOException iOException : this.exceptions) {
                sb.append("Cause Number " + exceptionNum + ": " + iOException.getMessage() + "\n");
                ++exceptionNum;
            }
            return sb.toString();
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            if (!this.hasSetStackTrace) {
                ArrayList<StackTraceElement> frames = new ArrayList<StackTraceElement>(this.exceptions.size() * 20);
                int exceptionNum = 0;
                for (IOException iOException : this.exceptions) {
                    StackTraceElement header = new StackTraceElement(MultipleCausesIOException.class.getName(), "Exception Number " + exceptionNum, "<no file>", 0);
                    frames.add(header);
                    for (StackTraceElement ste : iOException.getStackTrace()) {
                        frames.add(ste);
                    }
                    ++exceptionNum;
                }
                this.setStackTrace(frames.toArray(new StackTraceElement[frames.size()]));
                this.hasSetStackTrace = true;
            }
            return super.getStackTrace();
        }
    }
}

