/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.phoenix.schema.PDataType;

public class ColumnInfo {
    private static final String STR_SEPARATOR = ":";
    private final String columnName;
    private final int sqlType;

    public ColumnInfo(String columnName, int sqlType) {
        Preconditions.checkNotNull(columnName, "columnName cannot be null");
        Preconditions.checkArgument(!columnName.isEmpty(), "columnName cannot be empty");
        this.columnName = columnName;
        this.sqlType = sqlType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public PDataType getPDataType() {
        return PDataType.fromTypeId(this.sqlType);
    }

    public String toString() {
        return this.columnName + STR_SEPARATOR + this.getPDataType().getSqlTypeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)o;
        if (this.sqlType != that.sqlType) {
            return false;
        }
        return this.columnName.equals(that.columnName);
    }

    public int hashCode() {
        int result = this.columnName.hashCode();
        result = 31 * result + this.sqlType;
        return result;
    }

    public static ColumnInfo fromString(String stringRepresentation) {
        ArrayList<String> components = Lists.newArrayList(Splitter.on(STR_SEPARATOR).split(stringRepresentation));
        if (components.size() != 2) {
            throw new IllegalArgumentException("Unparseable string: " + stringRepresentation);
        }
        return new ColumnInfo((String)components.get(0), PDataType.fromSqlTypeName((String)components.get(1)).getSqlType());
    }
}

