/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.IllegalDataException;

public class DateUtil {
    public static final TimeZone DATE_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final Format DEFAULT_DATE_FORMATTER = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss", DATE_TIME_ZONE);
    public static final String DEFAULT_MS_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final Format DEFAULT_MS_DATE_FORMATTER = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss.SSS", DATE_TIME_ZONE);
    private static ThreadLocal<Format> dateFormat = new ThreadLocal<Format>(){

        @Override
        protected Format initialValue() {
            return DateUtil.getDateParser(DateUtil.DEFAULT_DATE_FORMAT);
        }
    };
    private static ThreadLocal<Format> timeFormat = new ThreadLocal<Format>(){

        @Override
        protected Format initialValue() {
            return DateUtil.getTimeParser(DateUtil.DEFAULT_DATE_FORMAT);
        }
    };
    private static ThreadLocal<Format> timestampFormat = new ThreadLocal<Format>(){

        @Override
        protected Format initialValue() {
            return DateUtil.getTimestampParser(DateUtil.DEFAULT_DATE_FORMAT);
        }
    };

    private DateUtil() {
    }

    public static Format getDateParser(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern){

            @Override
            public Date parseObject(String source) throws ParseException {
                Date date = super.parse(source);
                return new java.sql.Date(date.getTime());
            }
        };
        format.setTimeZone(DATE_TIME_ZONE);
        return format;
    }

    public static Format getTimeParser(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern){

            @Override
            public Date parseObject(String source) throws ParseException {
                Date date = super.parse(source);
                return new Time(date.getTime());
            }
        };
        format.setTimeZone(DATE_TIME_ZONE);
        return format;
    }

    public static Format getTimestampParser(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern){

            @Override
            public Date parseObject(String source) throws ParseException {
                Date date = super.parse(source);
                return new Timestamp(date.getTime());
            }
        };
        format.setTimeZone(DATE_TIME_ZONE);
        return format;
    }

    public static Format getDateFormatter(String pattern) {
        return DEFAULT_DATE_FORMAT.equals(pattern) ? DEFAULT_DATE_FORMATTER : FastDateFormat.getInstance(pattern, DATE_TIME_ZONE);
    }

    public static java.sql.Date parseDate(String dateValue) {
        try {
            return (java.sql.Date)dateFormat.get().parseObject(dateValue);
        }
        catch (ParseException e) {
            throw new IllegalDataException(e);
        }
    }

    public static Time parseTime(String timeValue) {
        try {
            return (Time)timeFormat.get().parseObject(timeValue);
        }
        catch (ParseException e) {
            throw new IllegalDataException(e);
        }
    }

    public static Timestamp parseTimestamp(String timeValue) {
        try {
            return (Timestamp)timestampFormat.get().parseObject(timeValue);
        }
        catch (ParseException e) {
            throw new IllegalDataException(e);
        }
    }

    public static Timestamp getTimestamp(long millis, int nanos) {
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(ts.getNanos() + nanos);
        return ts;
    }

    public static Timestamp getTimestamp(BigDecimal bd) {
        return DateUtil.getTimestamp(bd.longValue(), bd.remainder(BigDecimal.ONE).multiply(BigDecimal.valueOf(QueryConstants.MILLIS_TO_NANOS_CONVERTOR)).intValue());
    }
}

