/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;

public class IndexUtil {
    public static final String INDEX_COLUMN_NAME_SEP = ":";
    public static final byte[] INDEX_COLUMN_NAME_SEP_BYTES = Bytes.toBytes(":");

    private IndexUtil() {
    }

    public static PDataType getIndexColumnDataType(PColumn dataColumn) throws SQLException {
        PDataType type = IndexUtil.getIndexColumnDataType(dataColumn.isNullable(), dataColumn.getDataType());
        if (type == null) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_INDEX_COLUMN_ON_TYPE).setColumnName(dataColumn.getName().getString()).setMessage("Type=" + (Object)((Object)dataColumn.getDataType())).build().buildException();
        }
        return type;
    }

    public static PDataType getIndexColumnDataType(boolean isNullable, PDataType dataType) {
        if (dataType == null || !isNullable || !dataType.isFixedWidth()) {
            return dataType;
        }
        if (dataType.isCastableTo(PDataType.DECIMAL)) {
            return PDataType.DECIMAL;
        }
        if (dataType.isCoercibleTo(PDataType.VARCHAR)) {
            return PDataType.VARCHAR;
        }
        throw new IllegalArgumentException("Unsupported non nullable index type " + (Object)((Object)dataType));
    }

    public static String getDataColumnName(String name) {
        return name.substring(name.indexOf(INDEX_COLUMN_NAME_SEP) + 1);
    }

    public static String getDataColumnFamilyName(String name) {
        return name.substring(0, name.indexOf(INDEX_COLUMN_NAME_SEP));
    }

    public static String getDataColumnFullName(String name) {
        int index = name.indexOf(INDEX_COLUMN_NAME_SEP);
        if (index == 0) {
            return name.substring(index + 1);
        }
        return SchemaUtil.getColumnDisplayName(name.substring(0, index), name.substring(index + 1));
    }

    public static String getIndexColumnName(String dataColumnFamilyName, String dataColumnName) {
        return (dataColumnFamilyName == null ? "" : dataColumnFamilyName) + INDEX_COLUMN_NAME_SEP + dataColumnName;
    }

    public static byte[] getIndexColumnName(byte[] dataColumnFamilyName, byte[] dataColumnName) {
        return ByteUtil.concat(dataColumnFamilyName == null ? ByteUtil.EMPTY_BYTE_ARRAY : dataColumnFamilyName, INDEX_COLUMN_NAME_SEP_BYTES, dataColumnName);
    }

    public static String getIndexColumnName(PColumn dataColumn) {
        String dataColumnFamilyName = SchemaUtil.isPKColumn(dataColumn) ? null : dataColumn.getFamilyName().getString();
        return IndexUtil.getIndexColumnName(dataColumnFamilyName, dataColumn.getName().getString());
    }

    public static PColumn getDataColumn(PTable dataTable, String indexColumnName) {
        PColumnFamily family;
        int pos = indexColumnName.indexOf(INDEX_COLUMN_NAME_SEP);
        if (pos < 0) {
            throw new IllegalArgumentException("Could not find expected ':' separator in index column name of \"" + indexColumnName + "\"");
        }
        if (pos == 0) {
            try {
                return dataTable.getPKColumn(indexColumnName.substring(1));
            }
            catch (ColumnNotFoundException e) {
                throw new IllegalArgumentException("Could not find PK column \"" + indexColumnName.substring(pos + 1) + "\" in index column name of \"" + indexColumnName + "\"", e);
            }
        }
        try {
            family = dataTable.getColumnFamily(indexColumnName.substring(0, pos));
        }
        catch (ColumnFamilyNotFoundException e) {
            throw new IllegalArgumentException("Could not find column family \"" + indexColumnName.substring(0, pos) + "\" in index column name of \"" + indexColumnName + "\"", e);
        }
        try {
            return family.getColumn(indexColumnName.substring(pos + 1));
        }
        catch (ColumnNotFoundException e) {
            throw new IllegalArgumentException("Could not find column \"" + indexColumnName.substring(pos + 1) + "\" in index column name of \"" + indexColumnName + "\"", e);
        }
    }

    private static boolean isEmptyKeyValue(PTable table, ColumnReference ref) {
        byte[] emptyKeyValueCF = SchemaUtil.getEmptyColumnFamily(table);
        return Bytes.compareTo(emptyKeyValueCF, ref.getFamily()) == 0 && Bytes.compareTo(QueryConstants.EMPTY_COLUMN_BYTES, ref.getQualifier()) == 0;
    }

    public static List<Mutation> generateIndexData(final PTable table, PTable index, List<Mutation> dataMutations, ImmutableBytesWritable ptr, final KeyValueBuilder kvBuilder) throws SQLException {
        try {
            IndexMaintainer maintainer = index.getIndexMaintainer(table);
            ArrayList<Mutation> indexMutations = Lists.newArrayListWithExpectedSize(dataMutations.size());
            for (final Mutation dataMutation : dataMutations) {
                long ts = MetaDataUtil.getClientTimeStamp(dataMutation);
                ptr.set(dataMutation.getRow());
                if (dataMutation instanceof Put) {
                    ValueGetter valueGetter = new ValueGetter(){

                        @Override
                        public ImmutableBytesPtr getLatestValue(ColumnReference ref) {
                            byte[] family;
                            if (IndexUtil.isEmptyKeyValue(table, ref)) {
                                return null;
                            }
                            NavigableMap<byte[], List<Cell>> familyMap = dataMutation.getFamilyCellMap();
                            List kvs = (List)familyMap.get(family = ref.getFamily());
                            if (kvs == null) {
                                return null;
                            }
                            byte[] qualifier = ref.getQualifier();
                            for (Cell kv : kvs) {
                                if (Bytes.compareTo(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), family, 0, family.length) != 0 || Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), qualifier, 0, qualifier.length) != 0) continue;
                                ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                                kvBuilder.getValueAsPtr(kv, ptr);
                                return ptr;
                            }
                            return null;
                        }
                    };
                    indexMutations.add(maintainer.buildUpdateMutation(kvBuilder, valueGetter, ptr, ts));
                    continue;
                }
                if (!maintainer.getIndexedColumns().isEmpty()) continue;
                indexMutations.add(maintainer.buildDeleteMutation(kvBuilder, ptr, ts));
            }
            return indexMutations;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static boolean isDataPKColumn(PColumn column) {
        return column.getName().getString().startsWith(INDEX_COLUMN_NAME_SEP);
    }

    public static boolean getViewConstantValue(PColumn column, ImmutableBytesWritable ptr) {
        byte[] value = column.getViewConstant();
        if (value != null) {
            ptr.set(value, 0, value.length - 1);
            return true;
        }
        return false;
    }
}

