/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.util.ReadOnlyProps;

public class JDBCUtil {
    private JDBCUtil() {
    }

    public static String findProperty(String url, Properties info, String propName) {
        int begIndex;
        String urlPropName = ";" + propName + "=";
        String propValue = info.getProperty(propName);
        if (propValue == null && (begIndex = url.indexOf(urlPropName)) >= 0) {
            int endIndex = url.indexOf(59, begIndex + urlPropName.length());
            if (endIndex < 0) {
                endIndex = url.length();
            }
            propValue = url.substring(begIndex + urlPropName.length(), endIndex);
        }
        return propValue;
    }

    public static Long getCurrentSCN(String url, Properties info) throws SQLException {
        String scnStr = JDBCUtil.findProperty(url, info, "CurrentSCN");
        return scnStr == null ? null : Long.valueOf(Long.parseLong(scnStr));
    }

    public static int getMutateBatchSize(String url, Properties info, ReadOnlyProps props) throws SQLException {
        String batchSizeStr = JDBCUtil.findProperty(url, info, "UpsertBatchSize");
        return batchSizeStr == null ? props.getInt("phoenix.mutate.batchSize", 1000) : Integer.parseInt(batchSizeStr);
    }

    @Nullable
    public static PName getTenantId(String url, Properties info) throws SQLException {
        String tenantId = JDBCUtil.findProperty(url, info, "TenantId");
        return tenantId == null ? null : PNameFactory.newName(tenantId);
    }
}

