/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;

public class KeyValueUtil {
    private KeyValueUtil() {
    }

    public static KeyValue newKeyValue(byte[] key, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return new KeyValue(key, 0, key.length, cf, 0, cf.length, cq, 0, cq.length, ts, KeyValue.Type.Put, value, valueOffset, valueLength);
    }

    public static KeyValue newKeyValue(ImmutableBytesWritable key, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return new KeyValue(key.get(), key.getOffset(), key.getLength(), cf, 0, cf.length, cq, 0, cq.length, ts, KeyValue.Type.Put, value, valueOffset, valueLength);
    }

    public static KeyValue newKeyValue(byte[] key, int keyOffset, int keyLength, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return new KeyValue(key, keyOffset, keyLength, cf, 0, cf.length, cq, 0, cq.length, ts, KeyValue.Type.Put, value, valueOffset, valueLength);
    }

    public static KeyValue newKeyValue(byte[] key, int keyOffset, int keyLength, byte[] cf, int cfOffset, int cfLength, byte[] cq, int cqOffset, int cqLength, long ts, byte[] value, int valueOffset, int valueLength) {
        return new KeyValue(key, keyOffset, keyLength, cf, cfOffset, cfLength, cq, cqOffset, cqLength, ts, KeyValue.Type.Put, value, valueOffset, valueLength);
    }

    public static KeyValue newKeyValue(byte[] key, byte[] cf, byte[] cq, long ts, byte[] value) {
        return KeyValueUtil.newKeyValue(key, cf, cq, ts, value, 0, value.length);
    }

    public static Cell getColumnLatest(KeyValueBuilder kvBuilder, List<Cell> kvs, byte[] family, byte[] qualifier) {
        if (kvs.size() == 0) {
            return null;
        }
        Cell row = kvs.get(0);
        SearchComparator comp = new SearchComparator(kvBuilder, row.getRowArray(), row.getRowOffset(), row.getRowLength(), family, qualifier);
        int pos = Collections.binarySearch(kvs, null, comp);
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.size()) {
            return null;
        }
        Cell kv = kvs.get(pos);
        if (Bytes.compareTo(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), family, 0, family.length) != 0) {
            return null;
        }
        if (Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), qualifier, 0, qualifier.length) != 0) {
            return null;
        }
        return kv;
    }

    public static Cell getColumnLatest(KeyValueBuilder kvBuilder, Cell[] kvs, byte[] family, byte[] qualifier) {
        if (kvs.length == 0) {
            return null;
        }
        Cell kvForRow = kvs[0];
        SearchComparator comp = new SearchComparator(kvBuilder, kvForRow.getRowArray(), kvForRow.getRowOffset(), kvForRow.getRowLength(), family, qualifier);
        int pos = Arrays.binarySearch(kvs, null, comp);
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return null;
        }
        Cell kv = kvs[pos];
        if (Bytes.compareTo(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), family, 0, family.length) != 0) {
            return null;
        }
        if (Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), qualifier, 0, qualifier.length) != 0) {
            return null;
        }
        return kv;
    }

    private static class SearchComparator
    implements Comparator<Cell> {
        private final KeyValueBuilder kvBuilder;
        private final byte[] row;
        private final byte[] family;
        private final byte[] qualifier;
        private final int rowOff;
        private final int rowLen;

        public SearchComparator(KeyValueBuilder kvBuilder, byte[] r, int rOff, int rLen, byte[] f, byte[] q) {
            this.kvBuilder = kvBuilder;
            this.row = r;
            this.family = f;
            this.qualifier = q;
            this.rowOff = rOff;
            this.rowLen = rLen;
        }

        @Override
        public int compare(Cell l, Cell ignored) {
            assert (ignored == null);
            KeyValue.KVComparator comparator = this.kvBuilder.getKeyValueComparator();
            int val = comparator.compareRows(l.getRowArray(), l.getRowOffset(), l.getRowLength(), this.row, this.rowOff, this.rowLen);
            if (val != 0) {
                return val;
            }
            val = this.kvBuilder.compareFamily(l, this.family, 0, this.family.length);
            if (val != 0) {
                return val;
            }
            val = this.kvBuilder.compareQualifier(l, this.qualifier, 0, this.qualifier.length);
            if (val != 0) {
                return val;
            }
            return 1;
        }
    }
}

