/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;

public class MetaDataUtil {
    public static final String VIEW_INDEX_TABLE_PREFIX = "_IDX_";
    public static final byte[] VIEW_INDEX_TABLE_PREFIX_BYTES = Bytes.toBytes("_IDX_");
    public static final String VIEW_INDEX_SEQUENCE_PREFIX = "_SEQ_";
    public static final byte[] VIEW_INDEX_SEQUENCE_PREFIX_BYTES = Bytes.toBytes("_SEQ_");
    public static final String VIEW_INDEX_ID_COLUMN_NAME = "_INDEX_ID";
    public static final String IS_VIEW_INDEX_TABLE_PROP_NAME = "IS_VIEW_INDEX_TABLE";
    public static final byte[] IS_VIEW_INDEX_TABLE_PROP_BYTES = Bytes.toBytes("IS_VIEW_INDEX_TABLE");

    public static boolean areClientAndServerCompatible(long version) {
        return MetaDataUtil.areClientAndServerCompatible(MetaDataUtil.decodePhoenixVersion(version), 4);
    }

    static boolean areClientAndServerCompatible(int version, int pMajor) {
        return VersionUtil.encodeMaxMinorVersion(pMajor) >= version && VersionUtil.encodeMinMinorVersion(pMajor) <= version;
    }

    public static int decodePhoenixVersion(long version) {
        return (int)(version << 24 >>> 32);
    }

    public static long encodeMutableIndexConfiguredProperly(long version, boolean isValid) {
        if (!isValid) {
            return version | 1L;
        }
        return version;
    }

    public static boolean decodeMutableIndexConfiguredProperly(long version) {
        return (version & 0xFL) == 0L;
    }

    public static int decodeHBaseVersion(long version) {
        return (int)(version >>> 40);
    }

    public static String decodeHBaseVersionAsString(int version) {
        int major = version >>> 16 & 0xFF;
        int minor = version >>> 8 & 0xFF;
        int patch = version & 0xFF;
        return major + "." + minor + "." + patch;
    }

    public static long encodeHBaseAndPhoenixVersions(String hbaseVersion) {
        return (long)VersionUtil.encodeVersion(hbaseVersion) << 40 | (long)VersionUtil.encodeVersion(4, 0, 0) << 8;
    }

    public static void getTenantIdAndSchemaAndTableName(List<Mutation> tableMetadata, byte[][] rowKeyMetaData) {
        Mutation m = MetaDataUtil.getTableHeaderRow(tableMetadata);
        SchemaUtil.getVarChars(m.getRow(), 3, rowKeyMetaData);
    }

    public static byte[] getParentTableName(List<Mutation> tableMetadata) {
        if (tableMetadata.size() == 1) {
            return null;
        }
        byte[][] rowKeyMetaData = new byte[3][];
        MetaDataUtil.getTenantIdAndSchemaAndTableName(tableMetadata, rowKeyMetaData);
        byte[] tableName = rowKeyMetaData[2];
        Mutation m = MetaDataUtil.getParentTableHeaderRow(tableMetadata);
        SchemaUtil.getVarChars(m.getRow(), 3, rowKeyMetaData);
        if (Bytes.compareTo(tableName, rowKeyMetaData[2]) == 0) {
            return null;
        }
        return rowKeyMetaData[2];
    }

    public static long getSequenceNumber(Mutation tableMutation) {
        List kvs = (List)tableMutation.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell kv : kvs) {
                if (Bytes.compareTo(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES, 0, PhoenixDatabaseMetaData.TABLE_SEQ_NUM_BYTES.length) != 0) continue;
                return PDataType.LONG.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
            }
        }
        throw new IllegalStateException();
    }

    public static long getSequenceNumber(List<Mutation> tableMetaData) {
        return MetaDataUtil.getSequenceNumber(MetaDataUtil.getTableHeaderRow(tableMetaData));
    }

    public static PTableType getTableType(List<Mutation> tableMetaData, KeyValueBuilder builder, ImmutableBytesPtr value) {
        if (MetaDataUtil.getMutationValue(MetaDataUtil.getPutOnlyTableHeaderRow(tableMetaData), PhoenixDatabaseMetaData.TABLE_TYPE_BYTES, builder, value)) {
            return PTableType.fromSerializedValue(value.get()[value.getOffset()]);
        }
        return null;
    }

    public static long getParentSequenceNumber(List<Mutation> tableMetaData) {
        return MetaDataUtil.getSequenceNumber(MetaDataUtil.getParentTableHeaderRow(tableMetaData));
    }

    public static Mutation getTableHeaderRow(List<Mutation> tableMetaData) {
        return tableMetaData.get(0);
    }

    public static boolean getMutationValue(Mutation headerRow, byte[] key, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        List kvs = (List)headerRow.getFamilyCellMap().get(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES);
        if (kvs != null) {
            for (Cell cell : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                if (builder.compareQualifier(kv, key, 0, key.length) != 0) continue;
                builder.getValueAsPtr(kv, ptr);
                return true;
            }
        }
        return false;
    }

    public static Mutation getPutOnlyTableHeaderRow(List<Mutation> tableMetaData) {
        for (Mutation m : tableMetaData) {
            if (!(m instanceof Put)) continue;
            return m;
        }
        throw new IllegalStateException("No table header row found in table meatadata");
    }

    public static Mutation getParentTableHeaderRow(List<Mutation> tableMetaData) {
        return tableMetaData.get(tableMetaData.size() - 1);
    }

    public static long getClientTimeStamp(List<Mutation> tableMetadata) {
        Mutation m = tableMetadata.get(0);
        return MetaDataUtil.getClientTimeStamp(m);
    }

    public static long getClientTimeStamp(Mutation m) {
        Collection kvs = m.getFamilyCellMap().values();
        return kvs.isEmpty() ? m.getTimeStamp() : ((Cell)((List)kvs.iterator().next()).get(0)).getTimestamp();
    }

    public static byte[] getParentLinkKey(String tenantId, String schemaName, String tableName, String indexName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes(tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes(schemaName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes(tableName), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes(indexName));
    }

    public static byte[] getParentLinkKey(byte[] tenantId, byte[] schemaName, byte[] tableName, byte[] indexName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId, QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : schemaName, QueryConstants.SEPARATOR_BYTE_ARRAY, tableName, QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, indexName);
    }

    public static boolean isMultiTenant(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        if (MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.MULTI_TENANT_BYTES, builder, ptr)) {
            return Boolean.TRUE.equals(PDataType.BOOLEAN.toObject(ptr));
        }
        return false;
    }

    public static boolean isSalted(Mutation m, KeyValueBuilder builder, ImmutableBytesWritable ptr) {
        return MetaDataUtil.getMutationValue(m, PhoenixDatabaseMetaData.SALT_BUCKETS_BYTES, builder, ptr);
    }

    public static byte[] getViewIndexPhysicalName(byte[] physicalTableName) {
        return ByteUtil.concat(VIEW_INDEX_TABLE_PREFIX_BYTES, new byte[][]{physicalTableName});
    }

    public static String getViewIndexTableName(String tableName) {
        return VIEW_INDEX_TABLE_PREFIX + tableName;
    }

    public static String getViewIndexSchemaName(String schemaName) {
        return schemaName;
    }

    public static SequenceKey getViewIndexSequenceKey(String tenantId, PName physicalName) {
        String schemaName = VIEW_INDEX_SEQUENCE_PREFIX + physicalName.getString();
        String tableName = tenantId == null ? "" : tenantId;
        return new SequenceKey(null, schemaName, tableName);
    }

    public static PDataType getViewIndexIdDataType() {
        return PDataType.SMALLINT;
    }

    public static String getViewIndexIdColumnName() {
        return VIEW_INDEX_ID_COLUMN_NAME;
    }

    public static boolean hasViewIndexTable(PhoenixConnection connection, PName name) throws SQLException {
        byte[] physicalIndexName = MetaDataUtil.getViewIndexPhysicalName(name.getBytes());
        try {
            HTableDescriptor desc = connection.getQueryServices().getTableDescriptor(physicalIndexName);
            return desc != null && Boolean.TRUE.equals(PDataType.BOOLEAN.toObject(desc.getValue(IS_VIEW_INDEX_TABLE_PROP_BYTES)));
        }
        catch (TableNotFoundException e) {
            return false;
        }
    }

    public static void deleteViewIndexSequences(PhoenixConnection connection, PName name) throws SQLException {
        SequenceKey key = MetaDataUtil.getViewIndexSequenceKey(null, name);
        connection.createStatement().executeUpdate("DELETE FROM SYSTEM.\"SEQUENCE\" WHERE TENANT_ID IS NULL AND SEQUENCE_SCHEMA = '" + key.getSchemaName() + "'");
    }
}

