/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.math.BigDecimal;
import org.apache.phoenix.schema.PDataType;

public class NumberUtil {
    public static final String DEFAULT_NUMBER_FORMAT = "#,##0.###";

    public static BigDecimal normalize(BigDecimal bigDecimal) {
        return bigDecimal.stripTrailingZeros().round(PDataType.DEFAULT_MATH_CONTEXT);
    }

    public static BigDecimal setDecimalWidthAndScale(BigDecimal decimal, Integer precisionOrNull, Integer scaleOrNull) {
        int scale;
        int precision = precisionOrNull == null ? 38 : precisionOrNull;
        int n = scale = scaleOrNull == null ? 0 : scaleOrNull;
        if (precision - scale < decimal.precision() - decimal.scale()) {
            return null;
        }
        if (scaleOrNull != null) {
            decimal = decimal.setScale(scale, 1);
        }
        return decimal;
    }
}

