/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.CSVCommonsLoader;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class PhoenixRuntime {
    public static final String CURRENT_SCN_ATTRIB = "CurrentSCN";
    public static final String JDBC_PROTOCOL = "jdbc:phoenix";
    public static final char JDBC_PROTOCOL_TERMINATOR = ';';
    public static final char JDBC_PROTOCOL_SEPARATOR = ':';
    @Deprecated
    public static final String EMBEDDED_JDBC_PROTOCOL = "jdbc:phoenix:";
    public static final String UPSERT_BATCH_SIZE_ATTRIB = "UpsertBatchSize";
    public static final String TENANT_ID_ATTRIB = "TenantId";
    public static final String CONNECTIONLESS = "none";
    private static final String TABLE_OPTION = "-t";
    private static final String HEADER_OPTION = "-h";
    private static final String STRICT_OPTION = "-s";
    private static final String CSV_OPTION = "-d";
    private static final String ARRAY_ELEMENT_SEP_OPTION = "-a";
    private static final String HEADER_IN_LINE = "in-line";
    private static final String SQL_FILE_EXT = ".sql";
    private static final String CSV_FILE_EXT = ".csv";
    public static final String PHOENIX_TEST_DRIVER_URL_PARAM = "test=true";

    private static void usageError() {
        System.err.println("Usage: psql [-t table-name] [-h comma-separated-column-names | in-line] [-d field-delimiter-char quote-char escape-char]<zookeeper>  <path-to-sql-or-csv-file>...\n  By default, the name of the CSV file (case insensitive) is used to determine the Phoenix table into which the CSV data is loaded\n  and the ordinal value of the columns determines the mapping.\n  -t overrides the table into which the CSV data is loaded and is case sensitive.\n  -h overrides the column names to which the CSV data maps and is case sensitive.\n     A special value of in-line indicating that the first line of the CSV file\n     determines the column to which the data maps.\n  -s uses strict mode by throwing an exception if a column name doesn't match during CSV loading.\n  -d uses custom delimiters for CSV loader, need to specify single char for field delimiter, phrase delimiter, and escape char.\n     number is NOT usually a delimiter and shall be taken as 1 -> ctrl A, 2 -> ctrl B ... 9 -> ctrl I. \n  -a define the array element separator, defaults to ':'\nExamples:\n  psql localhost my_ddl.sql\n  psql localhost my_ddl.sql my_table.csv\n  psql -t MY_TABLE my_cluster:1825 my_table2012-Q3.csv\n  psql -t MY_TABLE -h COL1,COL2,COL3 my_cluster:1825 my_table2012-Q3.csv\n  psql -t MY_TABLE -h COL1,COL2,COL3 -d 1 2 3 my_cluster:1825 my_table2012-Q3.csv\n");
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            PhoenixRuntime.usageError();
        }
        PhoenixConnection conn = null;
        try {
            int i;
            String tableName = null;
            List<String> columns = null;
            boolean isStrict = false;
            String arrayElementSeparator = ":";
            ArrayList<String> customMetaCharacters = new ArrayList<String>();
            for (i = 0; i < args.length; ++i) {
                if (TABLE_OPTION.equals(args[i])) {
                    if (++i == args.length || tableName != null) {
                        PhoenixRuntime.usageError();
                    }
                    tableName = args[i];
                    continue;
                }
                if (HEADER_OPTION.equals(args[i])) {
                    String header;
                    if (++i >= args.length || columns != null) {
                        PhoenixRuntime.usageError();
                    }
                    if (HEADER_IN_LINE.equals(header = args[i])) {
                        columns = Collections.emptyList();
                        continue;
                    }
                    columns = Lists.newArrayList();
                    StringTokenizer tokenizer = new StringTokenizer(header, ",");
                    while (tokenizer.hasMoreTokens()) {
                        columns.add(tokenizer.nextToken());
                    }
                    continue;
                }
                if (STRICT_OPTION.equals(args[i])) {
                    isStrict = true;
                    continue;
                }
                if (CSV_OPTION.equals(args[i])) {
                    for (int j = 0; j < 3; ++j) {
                        if (args[++i].length() == 1) {
                            customMetaCharacters.add(args[i]);
                            continue;
                        }
                        PhoenixRuntime.usageError();
                    }
                    continue;
                }
                if (!ARRAY_ELEMENT_SEP_OPTION.equals(args[i])) break;
                arrayElementSeparator = args[++i];
            }
            if (i == args.length) {
                PhoenixRuntime.usageError();
            }
            Properties props = new Properties();
            String connectionUrl = EMBEDDED_JDBC_PROTOCOL + args[i++];
            conn = DriverManager.getConnection(connectionUrl, props).unwrap(PhoenixConnection.class);
            while (i < args.length) {
                String fileName = args[i];
                if (fileName.endsWith(SQL_FILE_EXT)) {
                    PhoenixRuntime.executeStatements(conn, new FileReader(args[i]), Collections.<Object>emptyList());
                } else if (fileName.endsWith(CSV_FILE_EXT)) {
                    if (tableName == null) {
                        tableName = SchemaUtil.normalizeIdentifier(fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1, fileName.length() - CSV_FILE_EXT.length()));
                    }
                    CSVCommonsLoader csvLoader = new CSVCommonsLoader(conn, tableName, columns, isStrict, customMetaCharacters, arrayElementSeparator);
                    csvLoader.upsert(fileName);
                } else {
                    PhoenixRuntime.usageError();
                }
                Long scn = conn.getSCN();
                if (scn != null) {
                    Long l = scn;
                    Long l2 = scn = Long.valueOf(scn + 1L);
                    props.setProperty(CURRENT_SCN_ATTRIB, scn.toString());
                    conn.close();
                    conn = DriverManager.getConnection(connectionUrl, props).unwrap(PhoenixConnection.class);
                }
                ++i;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
            System.exit(0);
        }
    }

    private PhoenixRuntime() {
    }

    public static int executeStatements(Connection conn, Reader reader, List<Object> binds) throws IOException, SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        pconn.setAutoCommit(true);
        return pconn.executeStatements(reader, binds, System.out);
    }

    @Deprecated
    public static List<KeyValue> getUncommittedData(Connection conn) throws SQLException {
        Iterator<Pair<byte[], List<KeyValue>>> iterator = PhoenixRuntime.getUncommittedDataIterator(conn);
        if (iterator.hasNext()) {
            return iterator.next().getSecond();
        }
        return Collections.emptyList();
    }

    public static Iterator<Pair<byte[], List<KeyValue>>> getUncommittedDataIterator(Connection conn) throws SQLException {
        return PhoenixRuntime.getUncommittedDataIterator(conn, false);
    }

    public static Iterator<Pair<byte[], List<KeyValue>>> getUncommittedDataIterator(Connection conn, boolean includeMutableIndexes) throws SQLException {
        final PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        final Iterator<Pair<byte[], List<Mutation>>> iterator = pconn.getMutationState().toMutations(includeMutableIndexes);
        return new Iterator<Pair<byte[], List<KeyValue>>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Pair<byte[], List<KeyValue>> next() {
                Pair pair = (Pair)iterator.next();
                ArrayList<KeyValue> keyValues = Lists.newArrayListWithExpectedSize(((List)pair.getSecond()).size() * 5);
                for (Mutation mutation : (List)pair.getSecond()) {
                    for (List keyValueList : mutation.getFamilyCellMap().values()) {
                        for (Cell keyValue : keyValueList) {
                            keyValues.add(KeyValueUtil.ensureKeyValue(keyValue));
                        }
                    }
                }
                Collections.sort(keyValues, pconn.getKeyValueBuilder().getKeyValueComparator());
                return new Pair<byte[], List<KeyValue>>((byte[])pair.getFirst(), (List<KeyValue>)keyValues);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static PTable getTable(Connection conn, String name) throws SQLException {
        PTable table = null;
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        try {
            table = pconn.getMetaDataCache().getTable(new PTableKey(pconn.getTenantId(), name));
        }
        catch (TableNotFoundException e) {
            String schemaName = SchemaUtil.getSchemaNameFromFullName(name);
            String tableName = SchemaUtil.getTableNameFromFullName(name);
            MetaDataProtocol.MetaDataMutationResult result = new MetaDataClient(pconn).updateCache(schemaName, tableName);
            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                throw e;
            }
            table = result.getTable();
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encodePK(Connection conn, String fullTableName, Object[] values) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, fullTableName);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        int offset = (table.getBucketNum() == null ? 0 : 1) + (table.isMultiTenant() && pconn.getTenantId() != null ? 1 : 0);
        List<PColumn> pkColumns = table.getPKColumns();
        if (pkColumns.size() - offset != values.length) {
            throw new SQLException("Expected " + (pkColumns.size() - offset) + " but got " + values.length);
        }
        PDataType type = null;
        TrustedByteArrayOutputStream output = new TrustedByteArrayOutputStream(table.getRowKeySchema().getEstimatedValueLength());
        try {
            for (int i = offset; i < pkColumns.size(); ++i) {
                if (type != null && !type.isFixedWidth()) {
                    output.write(0);
                }
                type = pkColumns.get(i).getDataType();
                byte[] value = type.toBytes(values[i - offset]);
                output.write(value);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Object[] decodePK(Connection conn, String name, byte[] value) throws SQLException {
        PTable table = PhoenixRuntime.getTable(conn, name);
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        int offset = (table.getBucketNum() == null ? 0 : 1) + (table.isMultiTenant() && pconn.getTenantId() != null ? 1 : 0);
        RowKeySchema schema = table.getRowKeySchema();
        int nValues = schema.getMaxFields() - offset;
        Object[] values = new Object[nValues];
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        schema.iterator(value, ptr, offset);
        for (int i = 0; i < nValues && schema.next(ptr, i, value.length) != null; ++i) {
            values[i] = schema.getField(i).getDataType().toObject(ptr);
        }
        return values;
    }
}

