/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.phoenix.util.ColumnInfo;

public class QueryUtil {
    public static final int COLUMN_FAMILY_POSITION = 24;
    public static final int COLUMN_NAME_POSITION = 4;
    public static final int DATA_TYPE_POSITION = 5;
    public static final int DATA_TYPE_NAME_POSITION = 6;

    public static String constructUpsertStatement(String tableName, List<ColumnInfo> columnInfos) {
        if (columnInfos.isEmpty()) {
            throw new IllegalArgumentException("At least one column must be provided for upserts");
        }
        ArrayList<String> parameterList = Lists.newArrayList();
        for (int i = 0; i < columnInfos.size(); ++i) {
            parameterList.add("?");
        }
        return String.format("UPSERT INTO %s (%s) VALUES (%s)", tableName, Joiner.on(", ").join(Iterables.transform(columnInfos, new Function<ColumnInfo, String>(){

            @Override
            @Nullable
            public String apply(@Nullable ColumnInfo columnInfo) {
                return columnInfo.getColumnName();
            }
        })), Joiner.on(", ").join(parameterList));
    }

    public static String constructGenericUpsertStatement(String tableName, int numColumns) {
        if (numColumns == 0) {
            throw new IllegalArgumentException("At least one column must be provided for upserts");
        }
        ArrayList<String> parameterList = Lists.newArrayListWithCapacity(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            parameterList.add("?");
        }
        return String.format("UPSERT INTO %s VALUES (%s)", tableName, Joiner.on(", ").join(parameterList));
    }

    public static String getUrl(String server) {
        return "jdbc:phoenix:" + server;
    }

    public static String getExplainPlan(ResultSet rs) throws SQLException {
        StringBuilder buf = new StringBuilder();
        while (rs.next()) {
            buf.append(rs.getString(1));
            buf.append('\n');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }
}

