/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReadOnlyProps
implements Iterable<Map.Entry<String, String>> {
    public static final ReadOnlyProps EMPTY_PROPS = new ReadOnlyProps(Iterators.<Map.Entry<String, String>>emptyIterator());
    private final Map<String, String> props;
    private static Pattern varPat = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
    private static int MAX_SUBST = 20;

    public ReadOnlyProps(Iterator<Map.Entry<String, String>> iterator) {
        HashMap<String, String> map = Maps.newHashMap();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            map.put(entry.getKey(), entry.getValue());
        }
        this.props = ImmutableMap.copyOf(map);
    }

    public ReadOnlyProps(Map<String, String> props) {
        this.props = ImmutableMap.copyOf(props);
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        Matcher match = varPat.matcher("");
        String eval = expr;
        for (int s = 0; s < MAX_SUBST; ++s) {
            match.reset(eval);
            if (!match.find()) {
                return eval;
            }
            String var = match.group();
            var = var.substring(2, var.length() - 1);
            String val = null;
            try {
                val = System.getProperty(var);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            eval = eval.substring(0, match.start()) + val + eval.substring(match.end());
        }
        throw new IllegalStateException("Variable substitution depth too large: " + MAX_SUBST + " " + expr);
    }

    public String getRaw(String name) {
        return this.props.get(name);
    }

    public String getRaw(String name, String defaultValue) {
        String value = this.getRaw(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String get(String name, String defaultValue) {
        return this.substituteVars(this.getRaw(name, defaultValue));
    }

    public String get(String name) {
        return this.substituteVars(this.getRaw(name));
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Integer.parseInt(hexString, 16);
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Long.parseLong(hexString, 16);
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float getFloat(String name, float defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Map<String, String> asMap() {
        return this.props;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.props.entrySet().iterator();
    }
}

