/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ScanUtil {
    private static final String REVERSED_ATTR = "_reversed_";

    private ScanUtil() {
    }

    public static void setTenantId(Scan scan, byte[] tenantId) {
        scan.setAttribute("TenantId", tenantId);
    }

    public static ImmutableBytesWritable getTenantId(Scan scan) {
        byte[] tenantId = scan.getAttribute("TenantId");
        if (tenantId == null) {
            return null;
        }
        return new ImmutableBytesWritable(tenantId);
    }

    public static Scan newScan(Scan scan) {
        try {
            Scan newScan = new Scan(scan);
            TreeMap existingMap = (TreeMap)scan.getFamilyMap();
            TreeMap<byte[], NavigableSet<byte[]>> clonedMap = new TreeMap<byte[], NavigableSet<byte[]>>(existingMap);
            newScan.setFamilyMap(clonedMap);
            return newScan;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean intersectScanRange(Scan scan, byte[] startKey, byte[] stopKey) {
        return ScanUtil.intersectScanRange(scan, startKey, stopKey, false);
    }

    public static boolean intersectScanRange(Scan scan, byte[] startKey, byte[] stopKey, boolean useSkipScan) {
        boolean mayHaveRows = false;
        byte[] existingStartKey = scan.getStartRow();
        byte[] existingStopKey = scan.getStopRow();
        if (existingStartKey.length > 0) {
            if (startKey.length == 0 || Bytes.compareTo(existingStartKey, startKey) > 0) {
                startKey = existingStartKey;
            }
        } else {
            mayHaveRows = true;
        }
        if (existingStopKey.length > 0) {
            if (stopKey.length == 0 || Bytes.compareTo(existingStopKey, stopKey) < 0) {
                stopKey = existingStopKey;
            }
        } else {
            mayHaveRows = true;
        }
        scan.setStartRow(startKey);
        scan.setStopRow(stopKey);
        boolean bl = mayHaveRows = mayHaveRows || Bytes.compareTo(scan.getStartRow(), scan.getStopRow()) < 0;
        if (mayHaveRows && useSkipScan) {
            FilterList filterList;
            Filter firstFilter;
            Filter filter = scan.getFilter();
            if (filter instanceof SkipScanFilter) {
                SkipScanFilter oldFilter = (SkipScanFilter)filter;
                SkipScanFilter newFilter = oldFilter.intersect(startKey, stopKey);
                if (newFilter == null) {
                    return false;
                }
                scan.setFilter(newFilter);
            } else if (filter instanceof FilterList && (firstFilter = (filterList = (FilterList)filter).getFilters().get(0)) instanceof SkipScanFilter) {
                SkipScanFilter oldFilter = (SkipScanFilter)firstFilter;
                SkipScanFilter newFilter = oldFilter.intersect(startKey, stopKey);
                if (newFilter == null) {
                    return false;
                }
                ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size());
                allFilters.addAll(filterList.getFilters());
                allFilters.set(0, newFilter);
                scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
            }
        }
        return mayHaveRows;
    }

    public static void andFilterAtBeginning(Scan scan, Filter andWithFilter) {
        if (andWithFilter == null) {
            return;
        }
        Filter filter = scan.getFilter();
        if (filter == null) {
            scan.setFilter(andWithFilter);
        } else if (filter instanceof FilterList && ((FilterList)filter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            FilterList filterList = (FilterList)filter;
            ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size() + 1);
            allFilters.add(andWithFilter);
            allFilters.addAll(filterList.getFilters());
            scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
        } else {
            scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(andWithFilter, filter)));
        }
    }

    public static void andFilterAtEnd(Scan scan, Filter andWithFilter) {
        if (andWithFilter == null) {
            return;
        }
        Filter filter = scan.getFilter();
        if (filter == null) {
            scan.setFilter(andWithFilter);
        } else if (filter instanceof FilterList && ((FilterList)filter).getOperator() == FilterList.Operator.MUST_PASS_ALL) {
            FilterList filterList = (FilterList)filter;
            ArrayList<Filter> allFilters = new ArrayList<Filter>(filterList.getFilters().size() + 1);
            allFilters.addAll(filterList.getFilters());
            allFilters.add(andWithFilter);
            scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, allFilters));
        } else {
            scan.setFilter(new FilterList(FilterList.Operator.MUST_PASS_ALL, Arrays.asList(filter, andWithFilter)));
        }
    }

    public static void setTimeRange(Scan scan, long ts) {
        try {
            scan.setTimeRange(0L, ts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getMinKey(RowKeySchema schema, List<List<KeyRange>> slots) {
        return ScanUtil.getKey(schema, slots, KeyRange.Bound.LOWER);
    }

    public static byte[] getMaxKey(RowKeySchema schema, List<List<KeyRange>> slots) {
        return ScanUtil.getKey(schema, slots, KeyRange.Bound.UPPER);
    }

    private static byte[] getKey(RowKeySchema schema, List<List<KeyRange>> slots, KeyRange.Bound bound) {
        if (slots.isEmpty()) {
            return null;
        }
        int[] position = new int[slots.size()];
        int maxLength = 0;
        for (int i = 0; i < position.length; ++i) {
            position[i] = bound == KeyRange.Bound.LOWER ? 0 : slots.get(i).size() - 1;
            KeyRange range = slots.get(i).get(position[i]);
            maxLength += range.getRange(bound).length + (schema.getField(i).getDataType().isFixedWidth() ? 0 : 1);
        }
        byte[] key = new byte[maxLength];
        int length = ScanUtil.setKey(schema, slots, position, bound, key, 0, 0, position.length);
        if (length == 0) {
            return null;
        }
        if (length == maxLength) {
            return key;
        }
        byte[] keyCopy = new byte[length];
        System.arraycopy(key, 0, keyCopy, 0, length);
        return keyCopy;
    }

    public static int setKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] position, KeyRange.Bound bound, byte[] key, int byteOffset, int slotStartIndex, int slotEndIndex) {
        return ScanUtil.setKey(schema, slots, position, bound, key, byteOffset, slotStartIndex, slotEndIndex, slotStartIndex);
    }

    public static int setKey(RowKeySchema schema, List<List<KeyRange>> slots, int[] position, KeyRange.Bound bound, byte[] key, int byteOffset, int slotStartIndex, int slotEndIndex, int schemaStartIndex) {
        int offset = byteOffset;
        boolean lastInclusiveUpperSingleKey = false;
        boolean anyInclusiveUpperRangeKey = false;
        for (int i = slotStartIndex; i < slotEndIndex; ++i) {
            KeyRange range = slots.get(i).get(position[i]);
            boolean isFixedWidth = schema.getField(schemaStartIndex++).getDataType().isFixedWidth();
            if (range.isUnbound(bound) && (bound == KeyRange.Bound.UPPER || isFixedWidth)) break;
            byte[] bytes = range.getRange(bound);
            System.arraycopy(bytes, 0, key, offset, bytes.length);
            offset += bytes.length;
            boolean inclusiveUpper = range.isInclusive(bound) && bound == KeyRange.Bound.UPPER;
            boolean exclusiveLower = !range.isInclusive(bound) && bound == KeyRange.Bound.LOWER;
            lastInclusiveUpperSingleKey = range.isSingleKey() && inclusiveUpper;
            anyInclusiveUpperRangeKey |= !range.isSingleKey() && inclusiveUpper;
            if (!isFixedWidth && (i < schema.getMaxFields() - 1 || inclusiveUpper || exclusiveLower)) {
                key[offset++] = 0;
                lastInclusiveUpperSingleKey &= i < schema.getMaxFields() - 1;
            }
            if (range.isSingleKey() || !exclusiveLower || ByteUtil.nextKey(key, offset)) continue;
            return -byteOffset;
        }
        if ((lastInclusiveUpperSingleKey || anyInclusiveUpperRangeKey) && !ByteUtil.nextKey(key, offset)) {
            return -byteOffset;
        }
        if (bound == KeyRange.Bound.LOWER) {
            while (schemaStartIndex > 0 && offset > byteOffset && !schema.getField(--schemaStartIndex).getDataType().isFixedWidth() && key[offset - 1] == 0) {
                --offset;
            }
        }
        return offset - byteOffset;
    }

    public static int searchClosestKeyRangeWithUpperHigherThanPtr(List<KeyRange> slots, ImmutableBytesWritable ptr, int lower) {
        int mid;
        int upper = slots.size() - 1;
        while (lower <= upper) {
            mid = (lower + upper) / 2;
            int cmp = slots.get(mid).compareUpperToLowerBound(ptr, true);
            if (cmp < 0) {
                lower = mid + 1;
                continue;
            }
            if (cmp > 0) {
                upper = mid - 1;
                continue;
            }
            return mid;
        }
        mid = (lower + upper) / 2;
        if (mid == 0 && slots.get(mid).compareUpperToLowerBound(ptr, true) > 0) {
            return mid;
        }
        return ++mid;
    }

    public static ScanRanges newScanRanges(List<Mutation> mutations) throws SQLException {
        ArrayList<KeyRange> keys = Lists.newArrayListWithExpectedSize(mutations.size());
        for (Mutation m : mutations) {
            keys.add(PDataType.VARBINARY.getKeyRange(m.getRow()));
        }
        ScanRanges keyRanges = ScanRanges.create(Collections.singletonList(keys), SchemaUtil.VAR_BINARY_SCHEMA);
        return keyRanges;
    }

    public static byte[] nextKey(byte[] key, PTable table, ImmutableBytesWritable ptr) {
        int pos = 0;
        RowKeySchema schema = table.getRowKeySchema();
        int maxOffset = schema.iterator(key, ptr);
        while (schema.next(ptr, pos, maxOffset) != null) {
            ++pos;
        }
        if (!schema.getField(pos - 1).getDataType().isFixedWidth()) {
            byte[] newLowerRange = new byte[key.length + 1];
            System.arraycopy(key, 0, newLowerRange, 0, key.length);
            newLowerRange[key.length] = 0;
            key = newLowerRange;
        } else {
            key = Arrays.copyOf(key, key.length);
        }
        ByteUtil.nextKey(key, key.length);
        return key;
    }

    public static void setReversed(Scan scan) {
        scan.setAttribute(REVERSED_ATTR, PDataType.TRUE_BYTES);
    }

    public static void swapStartStopRowIfReversed(Scan scan) {
        if (ScanUtil.isReversed(scan)) {
            byte[] startRow = scan.getStartRow();
            byte[] stopRow = scan.getStopRow();
            scan.setStartRow(stopRow);
            scan.setStopRow(startRow);
        }
    }

    public static boolean isReversed(Scan scan) {
        byte[] reversed = scan.getAttribute(REVERSED_ATTR);
        return PDataType.TRUE_BYTES.equals(reversed);
    }
}

