/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;

public class ServerUtil {
    private static final String FORMAT = "ERROR %d (%s): %s";
    private static final Pattern PATTERN = Pattern.compile("ERROR (\\d+) \\((\\w+)\\): (.*)");
    private static final Map<Class<? extends Exception>, SQLExceptionCode> errorcodeMap = new HashMap<Class<? extends Exception>, SQLExceptionCode>();

    public static void throwIOException(String msg, Throwable t) throws IOException {
        throw ServerUtil.createIOException(msg, t);
    }

    public static IOException createIOException(String msg, Throwable t) {
        Throwable cause;
        if (t instanceof SQLException && (cause = t.getCause()) instanceof IOException) {
            t = cause;
        }
        if (t instanceof DoNotRetryIOException) {
            return (DoNotRetryIOException)t;
        }
        if (t instanceof IOException) {
            cause = t.getCause();
            if (cause == null || cause instanceof IOException) {
                return (IOException)t;
            }
            return new DoNotRetryIOException(t.getMessage(), cause);
        }
        if (t instanceof SQLException) {
            return new DoNotRetryIOException(ServerUtil.constructSQLErrorMessage((SQLException)t, msg), t);
        }
        SQLExceptionCode code = errorcodeMap.get(t.getClass());
        if (code == null) {
            return new DoNotRetryIOException(msg + ": " + t.getMessage(), t);
        }
        return new DoNotRetryIOException(ServerUtil.constructSQLErrorMessage(code, t, msg), t);
    }

    private static String constructSQLErrorMessage(SQLExceptionCode code, Throwable e, String message) {
        return ServerUtil.constructSQLErrorMessage(code.getErrorCode(), code.getSQLState(), code.getMessage() + " " + e.getMessage() + " " + message);
    }

    private static String constructSQLErrorMessage(SQLException e, String message) {
        return ServerUtil.constructSQLErrorMessage(e.getErrorCode(), e.getSQLState(), e.getMessage() + " " + message);
    }

    private static String constructSQLErrorMessage(int errorCode, String SQLState, String message) {
        return String.format(FORMAT, errorCode, SQLState, message);
    }

    public static SQLException parseServerException(Throwable t) {
        SQLException e = ServerUtil.parseServerExceptionOrNull(t);
        if (e != null) {
            return e;
        }
        return new PhoenixIOException(t);
    }

    public static SQLException parseServerExceptionOrNull(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return ServerUtil.parseRemoteException(t);
    }

    private static SQLException parseRemoteException(Throwable t) {
        Matcher matcher;
        String message = t.getLocalizedMessage();
        if (message != null && (matcher = PATTERN.matcher(t.getLocalizedMessage())).find()) {
            int errorCode = Integer.parseInt(matcher.group(1));
            String sqlState = matcher.group(2);
            return new SQLException(matcher.group(), sqlState, errorCode, t);
        }
        return null;
    }

    static {
        errorcodeMap.put(ArithmeticException.class, SQLExceptionCode.SERVER_ARITHMETIC_ERROR);
    }
}

