/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.ByteUtil;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final byte SPACE_UTF8 = 32;
    private static final int BYTES_1_MASK = 32640;
    private static final int BYTES_2_MASK = 8160;
    private static final int BYTES_3_MASK = 4080;
    private static final int BYTES_4_MASK = 2040;
    public static final byte INVERTED_SPACE_UTF8 = SortOrder.invert(new byte[]{32}, 0, new byte[1], 0, 1)[0];
    public static final char SINGLE_CHAR_WILDCARD = '?';
    public static final char SINGLE_CHAR_LIKE = '_';
    public static final char MULTI_CHAR_WILDCARD = '*';
    public static final char MULTI_CHAR_LIKE = '%';
    public static final String[] LIKE_ESCAPE_SEQS = new String[]{"\\_", "\\%"};
    public static final String[] LIKE_UNESCAPED_SEQS = new String[]{"_", "%"};

    private StringUtil() {
    }

    public static String replaceChar(String value, char ch, CharSequence replacement) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(ch);
        if (i == -1) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value.length() + 16);
        int j = 0;
        while (i != -1) {
            buf.append(value, j, i).append(replacement);
            j = i + 1;
            i = value.indexOf(ch, j);
        }
        if (j < value.length()) {
            buf.append(value, j, value.length());
        }
        return buf.toString();
    }

    public static String replace(String s, String[] src, String[] target) {
        assert (src != null && target != null && src.length > 0 && src.length == target.length);
        if (src.length == 1 && src[0].length() == 1) {
            return StringUtil.replaceChar(s, src[0].charAt(0), target[0]);
        }
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int pos = 0;
        int limit = s.length();
        int lastMatch = 0;
        while (pos < limit) {
            boolean matched = false;
            for (int i = 0; i < src.length; ++i) {
                if (!s.startsWith(src[i], pos) || src[i].length() <= 0) continue;
                sb.append(s.substring(lastMatch, pos)).append(target[i]);
                lastMatch = pos += src[i].length();
                matched = true;
                break;
            }
            if (matched) continue;
            ++pos;
        }
        if (lastMatch == 0) {
            return s;
        }
        sb.append(s.substring(lastMatch));
        return sb.toString();
    }

    public static int getBytesInChar(byte b, SortOrder sortOrder) {
        int c;
        Preconditions.checkNotNull(sortOrder);
        if (sortOrder == SortOrder.DESC) {
            b = SortOrder.invert(b);
        }
        if (((c = b & 0xFF) & 0x7F80) == 0) {
            return 1;
        }
        if ((c & 0x1FE0) == 192) {
            return 2;
        }
        if ((c & 0xFF0) == 224) {
            return 3;
        }
        if ((c & 0x7F8) == 240) {
            return 4;
        }
        throw new RuntimeException("Undecodable byte: " + b);
    }

    public static int calculateUTF8Length(byte[] bytes, int offset, int length, SortOrder sortOrder) throws UnsupportedEncodingException {
        int i = offset;
        int endOffset = offset + length;
        length = 0;
        while (i < endOffset) {
            int charLength = StringUtil.getBytesInChar(bytes[i], sortOrder);
            i += charLength;
            ++length;
        }
        return length;
    }

    public static int getByteLengthForUtf8SubStr(byte[] bytes, int offset, int length, SortOrder sortOrder) throws UnsupportedEncodingException {
        int byteLength = 0;
        while (length > 0 && offset + byteLength < bytes.length) {
            int charLength = StringUtil.getBytesInChar(bytes[offset + byteLength], sortOrder);
            byteLength += charLength;
            --length;
        }
        return byteLength;
    }

    public static boolean hasMultiByteChars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static int getFirstNonBlankCharIdxFromStart(byte[] string, int offset, int length, SortOrder sortOrder) {
        int i;
        byte space;
        byte by = space = sortOrder == SortOrder.ASC ? (byte)32 : (byte)INVERTED_SPACE_UTF8;
        for (i = offset; i < offset + length && string[i] == space; ++i) {
        }
        return i;
    }

    public static int getFirstNonBlankCharIdxFromEnd(byte[] string, int offset, int length, SortOrder sortOrder) {
        int i;
        byte space;
        byte by = space = sortOrder == SortOrder.ASC ? (byte)32 : (byte)INVERTED_SPACE_UTF8;
        for (i = offset + length - 1; i >= offset && string[i] == space; --i) {
        }
        return i;
    }

    public static byte[] toBytes(String input) {
        if (input == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return Bytes.toBytes(input);
    }

    public static String escapeLike(String s) {
        return StringUtil.replace(s, LIKE_UNESCAPED_SEQS, LIKE_ESCAPE_SEQS);
    }

    public static int getUnpaddedCharLength(byte[] b, int offset, int length, SortOrder sortOrder) {
        return StringUtil.getFirstNonBlankCharIdxFromEnd(b, offset, length, sortOrder) - offset + 1;
    }

    public static byte[] padChar(byte[] value, int offset, int length, int paddedLength) {
        byte[] key = new byte[paddedLength];
        System.arraycopy(value, offset, key, 0, length);
        Arrays.fill(key, length, paddedLength, (byte)32);
        return key;
    }

    public static byte[] padChar(byte[] value, Integer byteSize) {
        byte[] newValue = Arrays.copyOf(value, (int)byteSize);
        if (newValue.length > value.length) {
            Arrays.fill(newValue, value.length, newValue.length, (byte)32);
        }
        return newValue;
    }

    public static boolean equals(StringBuilder b1, StringBuilder b2) {
        if (b1.length() != b2.length()) {
            return false;
        }
        for (int i = 0; i < b1.length(); ++i) {
            if (b1.charAt(i) == b2.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

