/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.csv;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.csv.CSVRecord;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.csv.StringToArrayConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUpsertExecutor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CsvUpsertExecutor.class);
    private final String arrayElementSeparator;
    private final Connection conn;
    private final List<PDataType> dataTypes;
    private final List<Function<String, Object>> conversionFunctions;
    private final PreparedStatement preparedStatement;
    private final UpsertListener upsertListener;
    private long upsertCount = 0L;

    public static CsvUpsertExecutor create(PhoenixConnection conn, String tableName, List<ColumnInfo> columnInfoList, UpsertListener upsertListener, String arrayElementSeparator) {
        PreparedStatement preparedStatement = null;
        try {
            String upsertSql = QueryUtil.constructUpsertStatement(tableName, columnInfoList);
            LOG.info("Upserting SQL data with {}", (Object)upsertSql);
            preparedStatement = conn.prepareStatement(upsertSql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return new CsvUpsertExecutor(conn, columnInfoList, preparedStatement, upsertListener, arrayElementSeparator);
    }

    CsvUpsertExecutor(Connection conn, List<ColumnInfo> columnInfoList, PreparedStatement preparedStatement, UpsertListener upsertListener, String arrayElementSeparator) {
        this.conn = conn;
        this.preparedStatement = preparedStatement;
        this.upsertListener = upsertListener;
        this.arrayElementSeparator = arrayElementSeparator;
        this.dataTypes = Lists.newArrayList();
        this.conversionFunctions = Lists.newArrayList();
        for (ColumnInfo columnInfo : columnInfoList) {
            PDataType dataType = PDataType.fromTypeId(columnInfo.getSqlType());
            this.dataTypes.add(dataType);
            this.conversionFunctions.add(this.createConversionFunction(dataType));
        }
    }

    public void execute(Iterable<CSVRecord> csvRecords) {
        for (CSVRecord csvRecord : csvRecords) {
            this.execute(csvRecord);
        }
    }

    void execute(CSVRecord csvRecord) {
        try {
            for (int fieldIndex = 0; fieldIndex < this.conversionFunctions.size(); ++fieldIndex) {
                Object sqlValue = this.conversionFunctions.get(fieldIndex).apply(csvRecord.get(fieldIndex));
                if (sqlValue != null) {
                    this.preparedStatement.setObject(fieldIndex + 1, sqlValue);
                    continue;
                }
                this.preparedStatement.setNull(fieldIndex + 1, this.dataTypes.get(fieldIndex).getSqlType());
            }
            this.preparedStatement.execute();
            this.upsertListener.upsertDone(++this.upsertCount);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error on CSVRecord " + csvRecord, e);
            }
            this.upsertListener.errorOnRecord(csvRecord, e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.preparedStatement.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Function<String, Object> createConversionFunction(PDataType dataType) {
        if (dataType.isArrayType()) {
            return new ArrayDatatypeConversionFunction(new StringToArrayConverter(this.conn, this.arrayElementSeparator, PDataType.fromTypeId(dataType.getSqlType() - 3000)));
        }
        return new SimpleDatatypeConversionFunction(dataType);
    }

    private static class ArrayDatatypeConversionFunction
    implements Function<String, Object> {
        private final StringToArrayConverter arrayConverter;

        private ArrayDatatypeConversionFunction(StringToArrayConverter arrayConverter) {
            this.arrayConverter = arrayConverter;
        }

        @Override
        @Nullable
        public Object apply(@Nullable String input) {
            try {
                return this.arrayConverter.toArray(input);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SimpleDatatypeConversionFunction
    implements Function<String, Object> {
        private final PDataType dataType;

        private SimpleDatatypeConversionFunction(PDataType dataType) {
            this.dataType = dataType;
        }

        @Override
        @Nullable
        public Object apply(@Nullable String input) {
            return this.dataType.toObject(input);
        }
    }

    public static interface UpsertListener {
        public void upsertDone(long var1);

        public void errorOnRecord(CSVRecord var1, String var2);
    }
}

