/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.csv;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.apache.phoenix.schema.PDataType;

class StringToArrayConverter {
    private final Splitter splitter;
    private final Connection conn;
    private final PDataType elementDataType;
    private final ElementConvertFunction elementConvertFunction;

    public StringToArrayConverter(Connection conn, String separatorString, PDataType elementDataType) {
        this.conn = conn;
        this.splitter = Splitter.on(separatorString);
        this.elementDataType = elementDataType;
        this.elementConvertFunction = new ElementConvertFunction(elementDataType);
    }

    public Array toArray(String input) throws SQLException {
        if (input == null || input.isEmpty()) {
            return this.conn.createArrayOf(this.elementDataType.getSqlTypeName(), new Object[0]);
        }
        return this.conn.createArrayOf(this.elementDataType.getSqlTypeName(), Lists.newArrayList(Iterables.transform(this.splitter.split(input), this.elementConvertFunction)).toArray());
    }

    private static class ElementConvertFunction
    implements Function<String, Object> {
        private final PDataType pdataType;

        private ElementConvertFunction(PDataType pdataType) {
            this.pdataType = pdataType;
        }

        @Override
        @Nullable
        public Object apply(@Nullable String input) {
            return this.pdataType.toObject(input);
        }
    }
}

