/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchCallback {
    private static final Method IS_CLOSED_METHOD = DispatchCallback.getMethod(Statement.class, "isClosed");
    private Status status = Status.UNSET;
    private Statement statement;

    public void trackSqlQuery(Statement statement) {
        this.statement = statement;
        this.status = Status.RUNNING;
    }

    public void setToSuccess() {
        this.status = Status.SUCCESS;
    }

    public boolean isSuccess() {
        return Status.SUCCESS == this.status;
    }

    public void setToFailure() {
        this.status = Status.FAILURE;
    }

    public boolean isFailure() {
        return Status.FAILURE == this.status;
    }

    public boolean isRunning() {
        return Status.RUNNING == this.status;
    }

    public void setToCancel() {
        this.status = Status.CANCELED;
    }

    public boolean isCanceled() {
        return Status.CANCELED == this.status;
    }

    public void forceKillSqlQuery() throws SQLException {
        this.setStatus(Status.CANCELED);
        if (null != this.statement && this.status == Status.RUNNING && !DispatchCallback.statementIsClosed(this.statement)) {
            this.statement.cancel();
        }
    }

    private static boolean statementIsClosed(Statement statement) throws SQLException {
        if (IS_CLOSED_METHOD != null) {
            try {
                return (Boolean)IS_CLOSED_METHOD.invoke((Object)statement, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    private static Method getMethod(Class<?> clazz, String name) {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        UNSET,
        RUNNING,
        SUCCESS,
        FAILURE,
        CANCELED;

    }
}

