/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.animation;

import android.opengl.Matrix;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.andresoviedo.app.model3D.animation.JointTransform;
import org.andresoviedo.app.model3D.animation.KeyFrame;
import org.andresoviedo.app.model3D.model.AnimatedModel;
import org.andresoviedo.app.model3D.model.Object3DData;
import org.andresoviedo.app.model3D.services.collada.entities.Joint;
import org.andresoviedo.app.model3D.view.ModelSurfaceView;

public class Animator {
    private ModelSurfaceView parent;
    private float animationTime = 0.0f;
    private boolean play = true;

    public Animator(ModelSurfaceView parent) {
        this.parent = parent;
    }

    public void update(Object3DData obj) {
        if (!this.play) {
            return;
        }
        if (!(obj instanceof AnimatedModel)) {
            return;
        }
        AnimatedModel animatedModel = (AnimatedModel)obj;
        if (animatedModel.getAnimation() == null) {
            return;
        }
        this.initAnimation(animatedModel);
        this.increaseAnimationTime((AnimatedModel)obj);
        Map<String, float[]> currentPose = this.calculateCurrentAnimationPose(animatedModel);
        float[] parentTransform = new float[16];
        Matrix.setIdentityM((float[])parentTransform, (int)0);
        this.applyPoseToJoints(currentPose, animatedModel.getRootJoint(), parentTransform);
    }

    private void initAnimation(AnimatedModel animatedModel) {
        Log.i((String)"Animator", (String)"Init");
        if (animatedModel == null || animatedModel.getAnimation() == null || animatedModel.getAnimation().isInitialized()) {
            return;
        }
        KeyFrame[] keyFrames = animatedModel.getAnimation().getKeyFrames();
        Log.i((String)"Animator", (String)("Initializing " + animatedModel.getId() + ". " + keyFrames.length + " key frames..."));
        for (int i = 0; i < keyFrames.length; ++i) {
            int j = (i + 1) % keyFrames.length;
            KeyFrame keyFramePrevious = keyFrames[i];
            KeyFrame keyFrameNext = keyFrames[j];
            Map<String, JointTransform> jointTransforms = keyFramePrevious.getJointKeyFrames();
            for (Map.Entry<String, JointTransform> transform : jointTransforms.entrySet()) {
                String jointId = transform.getKey();
                if (keyFrameNext.getJointKeyFrames().containsKey(jointId)) continue;
                JointTransform keyFramePreviousTransform = keyFramePrevious.getJointKeyFrames().get(jointId);
                JointTransform keyFrameNextTransform = null;
                KeyFrame keyFrameNextNext = null;
                int k = (j + 1) % keyFrames.length;
                do {
                    keyFrameNextNext = keyFrames[k];
                    keyFrameNextTransform = keyFrameNextNext.getJointKeyFrames().get(jointId);
                    k = (k + 1) % keyFrames.length;
                } while (keyFrameNextTransform == null);
                this.animationTime = keyFrameNext.getTimeStamp();
                float progression = this.calculateProgression(keyFramePrevious, keyFrameNextNext);
                JointTransform missingFrameTransform = JointTransform.interpolate(keyFramePreviousTransform, keyFrameNextTransform, progression);
                keyFrameNext.getJointKeyFrames().put(jointId, missingFrameTransform);
            }
        }
        animatedModel.getAnimation().setInitialized(true);
        Log.i((String)"Animator", (String)("Initialized " + animatedModel.getId() + ". " + keyFrames.length + " key frames"));
    }

    private void increaseAnimationTime(AnimatedModel obj) {
        this.animationTime = (float)((double)this.animationTime + 0.01);
        if (this.animationTime > obj.getAnimation().getLength()) {
            this.animationTime %= obj.getAnimation().getLength();
        }
        double progress = this.animationTime % obj.getAnimation().getLength() / obj.getAnimation().getLength();
        this.parent.onAnimationUpdate(progress);
    }

    private Map<String, float[]> calculateCurrentAnimationPose(AnimatedModel obj) {
        KeyFrame[] frames = this.getPreviousAndNextFrames(obj);
        float progression = this.calculateProgression(frames[0], frames[1]);
        return this.interpolatePoses(frames[0], frames[1], progression);
    }

    private void applyPoseToJoints(Map<String, float[]> currentPose, Joint joint, float[] parentTransform) {
        float[] currentLocalTransform = currentPose.get(joint.name);
        float[] currentTransform = new float[16];
        if (currentLocalTransform == null) {
            currentLocalTransform = new float[16];
            Matrix.setIdentityM((float[])currentLocalTransform, (int)0);
        }
        Matrix.multiplyMM((float[])currentTransform, (int)0, (float[])parentTransform, (int)0, (float[])currentLocalTransform, (int)0);
        for (Joint childJoint : joint.children) {
            this.applyPoseToJoints(currentPose, childJoint, currentTransform);
        }
        float[] animationTransform = new float[16];
        Matrix.multiplyMM((float[])animationTransform, (int)0, (float[])currentTransform, (int)0, (float[])joint.getInverseBindTransform(), (int)0);
        joint.setAnimationTransform(animationTransform);
    }

    private KeyFrame[] getPreviousAndNextFrames(AnimatedModel obj) {
        KeyFrame[] allFrames = obj.getAnimation().getKeyFrames();
        KeyFrame previousFrame = allFrames[0];
        KeyFrame nextFrame = allFrames[0];
        for (int i = 1; i < allFrames.length && !((nextFrame = allFrames[i]).getTimeStamp() > this.animationTime); ++i) {
            previousFrame = allFrames[i];
        }
        return new KeyFrame[]{previousFrame, nextFrame};
    }

    private float calculateProgression(KeyFrame previousFrame, KeyFrame nextFrame) {
        float totalTime = nextFrame.getTimeStamp() - previousFrame.getTimeStamp();
        float currentTime = this.animationTime - previousFrame.getTimeStamp();
        return currentTime / totalTime;
    }

    private Map<String, float[]> interpolatePoses(KeyFrame previousFrame, KeyFrame nextFrame, float progression) {
        HashMap<String, float[]> currentPose = new HashMap<String, float[]>();
        for (String jointName : previousFrame.getJointKeyFrames().keySet()) {
            JointTransform previousTransform = previousFrame.getJointKeyFrames().get(jointName);
            JointTransform nextTransform = nextFrame.getJointKeyFrames().get(jointName);
            JointTransform currentTransform = JointTransform.interpolate(previousTransform, nextTransform, progression);
            currentPose.put(jointName, currentTransform.getLocalTransform());
        }
        return currentPose;
    }

    public void setPlay(boolean play) {
        this.play = play;
    }

    public void setProgress(float progress, Object3DData obj) {
        AnimatedModel animatedObj = (AnimatedModel)obj;
        this.initAnimation(animatedObj);
        Log.i((String)"Progress", (String)"Set");
        if (animatedObj == null || animatedObj.getAnimation() == null) {
            return;
        }
        Log.i((String)"Progress", (String)"not null");
        this.animationTime = animatedObj.getAnimation().getLength() * progress;
        if (this.animationTime > animatedObj.getAnimation().getLength()) {
            this.animationTime %= animatedObj.getAnimation().getLength();
        }
        Map<String, float[]> currentPose = this.calculateCurrentAnimationPose(animatedObj);
        float[] parentTransform = new float[16];
        Matrix.setIdentityM((float[])parentTransform, (int)0);
        this.applyPoseToJoints(currentPose, animatedObj.getRootJoint(), parentTransform);
    }
}

