/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.animation;

import android.opengl.Matrix;
import org.andresoviedo.app.model3D.services.collada.entities.Vector3f;
import org.andresoviedo.app.util.math.Quaternion;

public class JointTransform {
    private final Vector3f position;
    private final Quaternion rotation;

    public JointTransform(Vector3f position, Quaternion rotation) {
        this.position = position;
        this.rotation = rotation;
    }

    public float[] getLocalTransform() {
        float[] matrix = new float[16];
        Matrix.setIdentityM((float[])matrix, (int)0);
        Matrix.translateM((float[])matrix, (int)0, (float[])matrix, (int)0, (float)this.position.x, (float)this.position.y, (float)this.position.z);
        Matrix.multiplyMM((float[])matrix, (int)0, (float[])matrix, (int)0, (float[])this.rotation.toRotationMatrix(), (int)0);
        return matrix;
    }

    protected static JointTransform interpolate(JointTransform frameA, JointTransform frameB, float progression) {
        Vector3f pos = JointTransform.interpolate(frameA.position, frameB.position, progression);
        Quaternion rot = Quaternion.interpolate(frameA.rotation, frameB.rotation, progression);
        return new JointTransform(pos, rot);
    }

    private static Vector3f interpolate(Vector3f start, Vector3f end, float progression) {
        float x = start.x + (end.x - start.x) * progression;
        float y = start.y + (end.y - start.y) * progression;
        float z = start.z + (end.z - start.z) * progression;
        return new Vector3f(x, y, z);
    }
}

