/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.controller;

import android.content.Context;
import android.os.AsyncTask;
import java.net.URL;
import java.util.List;
import org.andresoviedo.app.model3D.model.Object3DBuilder;
import org.andresoviedo.app.model3D.model.Object3DData;

public abstract class LoaderTask
extends AsyncTask<Void, Integer, List<Object3DData>> {
    protected final Context context;
    protected final URL url;
    protected final Object3DBuilder.Callback callback;
    protected Exception error;

    public LoaderTask(Context context, URL url, Object3DBuilder.Callback callback) {
        this.context = context;
        this.url = url;
        this.callback = callback;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected List<Object3DData> doInBackground(Void ... params) {
        try {
            List<Object3DData> data = this.build();
            this.callback.onLoadComplete(data);
            this.build(data);
            return data;
        }
        catch (Exception ex) {
            this.error = ex;
            return null;
        }
    }

    protected abstract List<Object3DData> build() throws Exception;

    protected abstract void build(List<Object3DData> var1) throws Exception;

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
    }

    protected void onPostExecute(List<Object3DData> data) {
        super.onPostExecute(data);
        if (this.error != null) {
            this.callback.onLoadError(this.error);
        } else {
            this.callback.onBuildComplete(data);
        }
    }
}

