/*
 * Decompiled with CFR 0.152.
 */
package org.andresoviedo.app.model3D.controller;

import android.opengl.Matrix;
import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import org.andresoviedo.app.model3D.controller.TouchScreen;
import org.andresoviedo.app.model3D.view.ModelRenderer;
import org.andresoviedo.app.model3D.view.ModelSurfaceView;

public class TouchController {
    private static final String TAG = TouchController.class.getName();
    private static final int TOUCH_STATUS_ZOOMING_CAMERA = 1;
    private static final int TOUCH_STATUS_ROTATING_CAMERA = 4;
    private static final int TOUCH_STATUS_MOVING_WORLD = 5;
    private final ModelSurfaceView view;
    private final ModelRenderer mRenderer;
    int pointerCount = 0;
    float x1 = Float.MIN_VALUE;
    float y1 = Float.MIN_VALUE;
    float x2 = Float.MIN_VALUE;
    float y2 = Float.MIN_VALUE;
    float dx1 = Float.MIN_VALUE;
    float dy1 = Float.MIN_VALUE;
    float dx2 = Float.MIN_VALUE;
    float dy2 = Float.MIN_VALUE;
    float length = Float.MIN_VALUE;
    float previousLength = Float.MIN_VALUE;
    float currentPress1 = Float.MIN_VALUE;
    float currentPress2 = Float.MIN_VALUE;
    float rotation = 0.0f;
    int currentSquare = Integer.MIN_VALUE;
    boolean isOneFixedAndOneMoving = false;
    boolean fingersAreClosing = false;
    boolean isRotating = false;
    boolean gestureChanged = false;
    private boolean moving = false;
    private boolean simpleTouch = false;
    private long lastActionTime;
    private int touchDelay = -2;
    private int touchStatus = -1;
    private float previousX1;
    private float previousY1;
    private float previousX2;
    private float previousY2;
    float[] previousVector = new float[4];
    float[] vector = new float[4];
    float[] rotationVector = new float[4];
    private float previousRotationSquare;

    public TouchController(ModelSurfaceView view, ModelRenderer renderer) {
        this.view = view;
        this.mRenderer = renderer;
    }

    public synchronized boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                if (this.lastActionTime > SystemClock.uptimeMillis() - 250L) {
                    this.simpleTouch = true;
                } else {
                    this.gestureChanged = true;
                    this.touchDelay = 0;
                    this.lastActionTime = SystemClock.uptimeMillis();
                    this.simpleTouch = false;
                }
                this.moving = false;
                break;
            }
            case 0: 
            case 5: 
            case 9: {
                Log.d((String)TAG, (String)"Gesture changed...");
                this.gestureChanged = true;
                this.touchDelay = 0;
                this.lastActionTime = SystemClock.uptimeMillis();
                this.simpleTouch = false;
                break;
            }
            case 2: {
                this.moving = true;
                this.simpleTouch = false;
                ++this.touchDelay;
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unknown state: " + motionEvent.getAction()));
                this.gestureChanged = true;
            }
        }
        this.pointerCount = motionEvent.getPointerCount();
        if (this.pointerCount == 1) {
            this.x1 = motionEvent.getX();
            this.y1 = motionEvent.getY();
            if (this.gestureChanged) {
                Log.d((String)TAG, (String)("x:" + this.x1 + ",y:" + this.y1));
                this.previousX1 = this.x1;
                this.previousY1 = this.y1;
            }
            this.dx1 = this.x1 - this.previousX1;
            this.dy1 = this.y1 - this.previousY1;
        } else if (this.pointerCount == 2) {
            this.x1 = motionEvent.getX(0);
            this.y1 = motionEvent.getY(0);
            this.x2 = motionEvent.getX(1);
            this.y2 = motionEvent.getY(1);
            this.vector[0] = this.x2 - this.x1;
            this.vector[1] = this.y2 - this.y1;
            this.vector[2] = 0.0f;
            this.vector[3] = 1.0f;
            float len = Matrix.length((float)this.vector[0], (float)this.vector[1], (float)this.vector[2]);
            this.vector[0] = this.vector[0] / len;
            this.vector[1] = this.vector[1] / len;
            if (this.gestureChanged) {
                this.previousX1 = this.x1;
                this.previousY1 = this.y1;
                this.previousX2 = this.x2;
                this.previousY2 = this.y2;
                System.arraycopy(this.vector, 0, this.previousVector, 0, this.vector.length);
            }
            this.dx1 = this.x1 - this.previousX1;
            this.dy1 = this.y1 - this.previousY1;
            this.dx2 = this.x2 - this.previousX2;
            this.dy2 = this.y2 - this.previousY2;
            this.rotationVector[0] = this.previousVector[1] * this.vector[2] - this.previousVector[2] * this.vector[1];
            this.rotationVector[1] = this.previousVector[2] * this.vector[0] - this.previousVector[0] * this.vector[2];
            this.rotationVector[2] = this.previousVector[0] * this.vector[1] - this.previousVector[1] * this.vector[0];
            len = Matrix.length((float)this.rotationVector[0], (float)this.rotationVector[1], (float)this.rotationVector[2]);
            this.rotationVector[0] = this.rotationVector[0] / len;
            this.rotationVector[1] = this.rotationVector[1] / len;
            this.rotationVector[2] = this.rotationVector[2] / len;
            this.previousLength = (float)Math.sqrt(Math.pow(this.previousX2 - this.previousX1, 2.0) + Math.pow(this.previousY2 - this.previousY1, 2.0));
            this.length = (float)Math.sqrt(Math.pow(this.x2 - this.x1, 2.0) + Math.pow(this.y2 - this.y1, 2.0));
            this.currentPress1 = motionEvent.getPressure(0);
            this.currentPress2 = motionEvent.getPressure(1);
            this.rotation = 0.0f;
            this.rotation = TouchScreen.getRotation360(motionEvent);
            this.currentSquare = TouchScreen.getSquare(motionEvent);
            if (this.currentSquare == 1 && this.previousRotationSquare == 4.0f) {
                this.rotation = 0.0f;
            } else if (this.currentSquare == 4 && this.previousRotationSquare == 1.0f) {
                this.rotation = 360.0f;
            }
            this.isOneFixedAndOneMoving = this.dx1 + this.dy1 == 0.0f != (this.dx2 + this.dy2 == 0.0f);
            this.fingersAreClosing = !this.isOneFixedAndOneMoving && Math.abs(this.dx1 + this.dx2) < 10.0f && Math.abs(this.dy1 + this.dy2) < 10.0f;
            this.isRotating = !this.isOneFixedAndOneMoving && this.dx1 != 0.0f && this.dy1 != 0.0f && this.dx2 != 0.0f && this.dy2 != 0.0f && this.rotationVector[2] != 0.0f;
        }
        int max = Math.max(this.mRenderer.getWidth(), this.mRenderer.getHeight());
        if (this.touchDelay > 1) {
            if (this.pointerCount != 1 || !(this.currentPress1 > 4.0f)) {
                if (this.pointerCount == 1) {
                    this.touchStatus = 5;
                    this.dx1 = (float)((double)(this.dx1 / (float)max) * Math.PI * 2.0);
                    this.dy1 = (float)((double)(this.dy1 / (float)max) * Math.PI * 2.0);
                    this.mRenderer.getCamera().translateCamera(this.dx1, this.dy1);
                } else if (this.pointerCount == 2) {
                    if (this.fingersAreClosing) {
                        this.touchStatus = 1;
                        float zoomFactor = (this.length - this.previousLength) / (float)max * this.mRenderer.getFar();
                        Log.i((String)TAG, (String)("Zooming '" + zoomFactor + "'..."));
                        this.mRenderer.getCamera().MoveCameraZ(zoomFactor);
                    }
                    if (this.isRotating) {
                        this.touchStatus = 4;
                        Log.i((String)TAG, (String)("Rotating camera '" + Math.signum(this.rotationVector[2]) + "'..."));
                        this.mRenderer.getCamera().Rotate((float)((double)Math.signum(this.rotationVector[2]) / Math.PI) / 4.0f);
                    }
                }
            }
        }
        this.previousX1 = this.x1;
        this.previousY1 = this.y1;
        this.previousX2 = this.x2;
        this.previousY2 = this.y2;
        this.previousRotationSquare = this.currentSquare;
        System.arraycopy(this.vector, 0, this.previousVector, 0, this.vector.length);
        if (this.gestureChanged && this.touchDelay > 1) {
            this.gestureChanged = false;
            Log.v((String)TAG, (String)"Fin");
        }
        this.view.requestRender();
        return true;
    }
}

